/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class OperationOutcome
extends Resource {
    protected List<OperationOutcomeIssueComponent> issue = new ArrayList<OperationOutcomeIssueComponent>();
    private static final long serialVersionUID = 820547604L;

    public List<OperationOutcomeIssueComponent> getIssue() {
        return this.issue;
    }

    public OperationOutcomeIssueComponent addIssue() {
        OperationOutcomeIssueComponent operationOutcomeIssueComponent = new OperationOutcomeIssueComponent();
        this.issue.add(operationOutcomeIssueComponent);
        return operationOutcomeIssueComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("issue", "", "An error, warning or information message that results from a system action.", 0, Integer.MAX_VALUE, this.issue));
    }

    public OperationOutcome copy() {
        OperationOutcome operationOutcome = new OperationOutcome();
        operationOutcome.issue = new ArrayList<OperationOutcomeIssueComponent>();
        for (OperationOutcomeIssueComponent operationOutcomeIssueComponent : this.issue) {
            operationOutcome.issue.add(operationOutcomeIssueComponent.copy());
        }
        return operationOutcome;
    }

    protected OperationOutcome typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OperationOutcome;
    }

    public static class OperationOutcomeIssueComponent
    extends BackboneElement {
        protected Enumeration<IssueSeverity> severity;
        protected Coding type;
        protected StringType details;
        protected List<StringType> location = new ArrayList<StringType>();
        private static final long serialVersionUID = 1582980307L;

        public OperationOutcomeIssueComponent() {
        }

        public OperationOutcomeIssueComponent(Enumeration<IssueSeverity> enumeration) {
            this.severity = enumeration;
        }

        public Enumeration<IssueSeverity> getSeverity() {
            return this.severity;
        }

        public OperationOutcomeIssueComponent setSeverity(Enumeration<IssueSeverity> enumeration) {
            this.severity = enumeration;
            return this;
        }

        public IssueSeverity getSeveritySimple() {
            return this.severity == null ? null : this.severity.getValue();
        }

        public OperationOutcomeIssueComponent setSeveritySimple(IssueSeverity issueSeverity) {
            if (this.severity == null) {
                this.severity = new Enumeration();
            }
            this.severity.setValue(issueSeverity);
            return this;
        }

        public Coding getType() {
            return this.type;
        }

        public OperationOutcomeIssueComponent setType(Coding coding) {
            this.type = coding;
            return this;
        }

        public StringType getDetails() {
            return this.details;
        }

        public OperationOutcomeIssueComponent setDetails(StringType stringType) {
            this.details = stringType;
            return this;
        }

        public String getDetailsSimple() {
            return this.details == null ? null : this.details.getValue();
        }

        public OperationOutcomeIssueComponent setDetailsSimple(String string) {
            if (string == null) {
                this.details = null;
            } else {
                if (this.details == null) {
                    this.details = new StringType();
                }
                this.details.setValue(string);
            }
            return this;
        }

        public List<StringType> getLocation() {
            return this.location;
        }

        public StringType addLocation() {
            StringType stringType = new StringType();
            this.location.add(stringType);
            return stringType;
        }

        public StringType addLocationSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.location.add(stringType);
            return stringType;
        }

        public boolean hasLocationSimple(String string) {
            for (StringType stringType : this.location) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("severity", "code", "Indicates whether the issue indicates a variation from successful processing.", 0, Integer.MAX_VALUE, this.severity));
            list.add(new Property("type", "Coding", "A code indicating the type of error, warning or information message.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("details", "string", "Additional description of the issue.", 0, Integer.MAX_VALUE, this.details));
            list.add(new Property("location", "string", "A simple XPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.", 0, Integer.MAX_VALUE, this.location));
        }

        public OperationOutcomeIssueComponent copy() {
            OperationOutcomeIssueComponent operationOutcomeIssueComponent = new OperationOutcomeIssueComponent();
            operationOutcomeIssueComponent.severity = this.severity == null ? null : this.severity.copy();
            operationOutcomeIssueComponent.type = this.type == null ? null : this.type.copy();
            operationOutcomeIssueComponent.details = this.details == null ? null : this.details.copy();
            operationOutcomeIssueComponent.location = new ArrayList<StringType>();
            for (StringType stringType : this.location) {
                operationOutcomeIssueComponent.location.add(stringType.copy());
            }
            return operationOutcomeIssueComponent;
        }
    }

    public static class IssueSeverityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("fatal".equals(string)) {
                return IssueSeverity.fatal;
            }
            if ("error".equals(string)) {
                return IssueSeverity.error;
            }
            if ("warning".equals(string)) {
                return IssueSeverity.warning;
            }
            if ("information".equals(string)) {
                return IssueSeverity.information;
            }
            throw new Exception("Unknown IssueSeverity code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == IssueSeverity.fatal) {
                return "fatal";
            }
            if (enum_ == IssueSeverity.error) {
                return "error";
            }
            if (enum_ == IssueSeverity.warning) {
                return "warning";
            }
            if (enum_ == IssueSeverity.information) {
                return "information";
            }
            return "?";
        }
    }

    public static enum IssueSeverity {
        fatal,
        error,
        warning,
        information,
        Null;


        public static IssueSeverity fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("fatal".equals(string)) {
                return fatal;
            }
            if ("error".equals(string)) {
                return error;
            }
            if ("warning".equals(string)) {
                return warning;
            }
            if ("information".equals(string)) {
                return information;
            }
            throw new Exception("Unknown IssueSeverity code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case fatal: {
                    return "fatal";
                }
                case error: {
                    return "error";
                }
                case warning: {
                    return "warning";
                }
                case information: {
                    return "information";
                }
            }
            return "?";
        }
    }
}

