/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.Type;

public class Order
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected DateTimeType date;
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected ResourceReference source;
    protected Practitioner sourceTarget;
    protected ResourceReference target;
    protected Resource targetTarget;
    protected Type reason;
    protected ResourceReference authority;
    protected Resource authorityTarget;
    protected OrderWhenComponent when;
    protected List<ResourceReference> detail = new ArrayList<ResourceReference>();
    protected List<Resource> detailTarget = new ArrayList<Resource>();
    private static final long serialVersionUID = 156950294L;

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public Order setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public Order setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Order setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public Order setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public ResourceReference getSource() {
        return this.source;
    }

    public Order setSource(ResourceReference resourceReference) {
        this.source = resourceReference;
        return this;
    }

    public Practitioner getSourceTarget() {
        return this.sourceTarget;
    }

    public Order setSourceTarget(Practitioner practitioner) {
        this.sourceTarget = practitioner;
        return this;
    }

    public ResourceReference getTarget() {
        return this.target;
    }

    public Order setTarget(ResourceReference resourceReference) {
        this.target = resourceReference;
        return this;
    }

    public Resource getTargetTarget() {
        return this.targetTarget;
    }

    public Order setTargetTarget(Resource resource) {
        this.targetTarget = resource;
        return this;
    }

    public Type getReason() {
        return this.reason;
    }

    public Order setReason(Type type) {
        this.reason = type;
        return this;
    }

    public ResourceReference getAuthority() {
        return this.authority;
    }

    public Order setAuthority(ResourceReference resourceReference) {
        this.authority = resourceReference;
        return this;
    }

    public Resource getAuthorityTarget() {
        return this.authorityTarget;
    }

    public Order setAuthorityTarget(Resource resource) {
        this.authorityTarget = resource;
        return this;
    }

    public OrderWhenComponent getWhen() {
        return this.when;
    }

    public Order setWhen(OrderWhenComponent orderWhenComponent) {
        this.when = orderWhenComponent;
        return this;
    }

    public List<ResourceReference> getDetail() {
        return this.detail;
    }

    public ResourceReference addDetail() {
        ResourceReference resourceReference = new ResourceReference();
        this.detail.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getDetailTarget() {
        return this.detailTarget;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifiers assigned to this order by the orderer or by the receiver.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("date", "dateTime", "When the order was made.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("subject", "Resource(Patient)", "Patient this order is about.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("source", "Resource(Practitioner)", "Who initiated the order.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("target", "Resource(Organization|Device|Practitioner)", "Who is intended to fulfill the order.", 0, Integer.MAX_VALUE, this.target));
        list.add(new Property("reason[x]", "CodeableConcept|Resource(Any)", "Text - why the order was made.", 0, Integer.MAX_VALUE, this.reason));
        list.add(new Property("authority", "Resource(Any)", "If required by policy.", 0, Integer.MAX_VALUE, this.authority));
        list.add(new Property("when", "", "When order should be fulfilled.", 0, Integer.MAX_VALUE, this.when));
        list.add(new Property("detail", "Resource(Any)", "What action is being ordered.", 0, Integer.MAX_VALUE, this.detail));
    }

    public Order copy() {
        Order order = new Order();
        order.identifier = new ArrayList<Identifier>();
        for (Identifier type : this.identifier) {
            order.identifier.add(type.copy());
        }
        order.date = this.date == null ? null : this.date.copy();
        order.subject = this.subject == null ? null : this.subject.copy();
        order.source = this.source == null ? null : this.source.copy();
        order.target = this.target == null ? null : this.target.copy();
        order.reason = this.reason == null ? null : this.reason.copy();
        order.authority = this.authority == null ? null : this.authority.copy();
        order.when = this.when == null ? null : this.when.copy();
        order.detail = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.detail) {
            order.detail.add(resourceReference.copy());
        }
        return order;
    }

    protected Order typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Order;
    }

    public static class OrderWhenComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected Schedule schedule;
        private static final long serialVersionUID = -987281180L;

        public CodeableConcept getCode() {
            return this.code;
        }

        public OrderWhenComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public OrderWhenComponent setSchedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Code specifies when request should be done. The code may simply be a priority code.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("schedule", "Schedule", "A formal schedule.", 0, Integer.MAX_VALUE, this.schedule));
        }

        public OrderWhenComponent copy() {
            OrderWhenComponent orderWhenComponent = new OrderWhenComponent();
            orderWhenComponent.code = this.code == null ? null : this.code.copy();
            orderWhenComponent.schedule = this.schedule == null ? null : this.schedule.copy();
            return orderWhenComponent;
        }
    }
}

