/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Order;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class OrderResponse
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference request;
    protected Order requestTarget;
    protected DateTimeType date;
    protected ResourceReference who;
    protected Resource whoTarget;
    protected Type authority;
    protected Enumeration<OrderOutcomeCode> code;
    protected StringType description;
    protected List<ResourceReference> fulfillment = new ArrayList<ResourceReference>();
    protected List<Resource> fulfillmentTarget = new ArrayList<Resource>();
    private static final long serialVersionUID = 1422952117L;

    public OrderResponse() {
    }

    public OrderResponse(ResourceReference resourceReference, Enumeration<OrderOutcomeCode> enumeration) {
        this.request = resourceReference;
        this.code = enumeration;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getRequest() {
        return this.request;
    }

    public OrderResponse setRequest(ResourceReference resourceReference) {
        this.request = resourceReference;
        return this;
    }

    public Order getRequestTarget() {
        return this.requestTarget;
    }

    public OrderResponse setRequestTarget(Order order) {
        this.requestTarget = order;
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public OrderResponse setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public OrderResponse setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public ResourceReference getWho() {
        return this.who;
    }

    public OrderResponse setWho(ResourceReference resourceReference) {
        this.who = resourceReference;
        return this;
    }

    public Resource getWhoTarget() {
        return this.whoTarget;
    }

    public OrderResponse setWhoTarget(Resource resource) {
        this.whoTarget = resource;
        return this;
    }

    public Type getAuthority() {
        return this.authority;
    }

    public OrderResponse setAuthority(Type type) {
        this.authority = type;
        return this;
    }

    public Enumeration<OrderOutcomeCode> getCode() {
        return this.code;
    }

    public OrderResponse setCode(Enumeration<OrderOutcomeCode> enumeration) {
        this.code = enumeration;
        return this;
    }

    public OrderOutcomeCode getCodeSimple() {
        return this.code == null ? null : this.code.getValue();
    }

    public OrderResponse setCodeSimple(OrderOutcomeCode orderOutcomeCode) {
        if (this.code == null) {
            this.code = new Enumeration();
        }
        this.code.setValue(orderOutcomeCode);
        return this;
    }

    public StringType getDescription() {
        return this.description;
    }

    public OrderResponse setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public OrderResponse setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public List<ResourceReference> getFulfillment() {
        return this.fulfillment;
    }

    public ResourceReference addFulfillment() {
        ResourceReference resourceReference = new ResourceReference();
        this.fulfillment.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getFulfillmentTarget() {
        return this.fulfillmentTarget;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifiers assigned to this order. The identifiers are usually assigned by the system responding to the order, but they may be provided or added to by other systems.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("request", "Resource(Order)", "A reference to the order that this is in response to.", 0, Integer.MAX_VALUE, this.request));
        list.add(new Property("date", "dateTime", "The date and time at which this order response was made (created/posted).", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("who", "Resource(Practitioner|Organization|Device)", "The person, organization, or device credited with making the response.", 0, Integer.MAX_VALUE, this.who));
        list.add(new Property("authority[x]", "CodeableConcept|Resource(Any)", "A reference to an authority policy that is the reason for the response. Usually this is used when the order is rejected, to provide a reason for rejection.", 0, Integer.MAX_VALUE, this.authority));
        list.add(new Property("code", "code", "What this response says about the status of the original order.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("description", "string", "Additional description about the response - e.g. a text description provided by a human user when making decisions about the order.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("fulfillment", "Resource(Any)", "Links to resources that provide details of the outcome of performing the order. E.g. Diagnostic Reports in a response that is made to an order that referenced a diagnostic order.", 0, Integer.MAX_VALUE, this.fulfillment));
    }

    public OrderResponse copy() {
        OrderResponse orderResponse = new OrderResponse();
        orderResponse.identifier = new ArrayList<Identifier>();
        for (Identifier type : this.identifier) {
            orderResponse.identifier.add(type.copy());
        }
        orderResponse.request = this.request == null ? null : this.request.copy();
        orderResponse.date = this.date == null ? null : this.date.copy();
        orderResponse.who = this.who == null ? null : this.who.copy();
        orderResponse.authority = this.authority == null ? null : this.authority.copy();
        orderResponse.code = this.code == null ? null : this.code.copy();
        orderResponse.description = this.description == null ? null : this.description.copy();
        orderResponse.fulfillment = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.fulfillment) {
            orderResponse.fulfillment.add(resourceReference.copy());
        }
        return orderResponse;
    }

    protected OrderResponse typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OrderResponse;
    }

    public static class OrderOutcomeCodeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("pending".equals(string)) {
                return OrderOutcomeCode.pending;
            }
            if ("review".equals(string)) {
                return OrderOutcomeCode.review;
            }
            if ("rejected".equals(string)) {
                return OrderOutcomeCode.rejected;
            }
            if ("error".equals(string)) {
                return OrderOutcomeCode.error;
            }
            if ("accepted".equals(string)) {
                return OrderOutcomeCode.accepted;
            }
            if ("cancelled".equals(string)) {
                return OrderOutcomeCode.cancelled;
            }
            if ("replaced".equals(string)) {
                return OrderOutcomeCode.replaced;
            }
            if ("aborted".equals(string)) {
                return OrderOutcomeCode.aborted;
            }
            if ("complete".equals(string)) {
                return OrderOutcomeCode.complete;
            }
            throw new Exception("Unknown OrderOutcomeCode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == OrderOutcomeCode.pending) {
                return "pending";
            }
            if (enum_ == OrderOutcomeCode.review) {
                return "review";
            }
            if (enum_ == OrderOutcomeCode.rejected) {
                return "rejected";
            }
            if (enum_ == OrderOutcomeCode.error) {
                return "error";
            }
            if (enum_ == OrderOutcomeCode.accepted) {
                return "accepted";
            }
            if (enum_ == OrderOutcomeCode.cancelled) {
                return "cancelled";
            }
            if (enum_ == OrderOutcomeCode.replaced) {
                return "replaced";
            }
            if (enum_ == OrderOutcomeCode.aborted) {
                return "aborted";
            }
            if (enum_ == OrderOutcomeCode.complete) {
                return "complete";
            }
            return "?";
        }
    }

    public static enum OrderOutcomeCode {
        pending,
        review,
        rejected,
        error,
        accepted,
        cancelled,
        replaced,
        aborted,
        complete,
        Null;


        public static OrderOutcomeCode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("pending".equals(string)) {
                return pending;
            }
            if ("review".equals(string)) {
                return review;
            }
            if ("rejected".equals(string)) {
                return rejected;
            }
            if ("error".equals(string)) {
                return error;
            }
            if ("accepted".equals(string)) {
                return accepted;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            if ("replaced".equals(string)) {
                return replaced;
            }
            if ("aborted".equals(string)) {
                return aborted;
            }
            if ("complete".equals(string)) {
                return complete;
            }
            throw new Exception("Unknown OrderOutcomeCode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case pending: {
                    return "pending";
                }
                case review: {
                    return "review";
                }
                case rejected: {
                    return "rejected";
                }
                case error: {
                    return "error";
                }
                case accepted: {
                    return "accepted";
                }
                case cancelled: {
                    return "cancelled";
                }
                case replaced: {
                    return "replaced";
                }
                case aborted: {
                    return "aborted";
                }
                case complete: {
                    return "complete";
                }
            }
            return "?";
        }
    }
}

