/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Organization
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected StringType name;
    protected CodeableConcept type;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected List<Address> address = new ArrayList<Address>();
    protected ResourceReference partOf;
    protected Organization partOfTarget;
    protected List<OrganizationContactComponent> contact = new ArrayList<OrganizationContactComponent>();
    protected List<ResourceReference> location = new ArrayList<ResourceReference>();
    protected List<Location> locationTarget = new ArrayList<Location>();
    protected BooleanType active;
    private static final long serialVersionUID = -603382635L;

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public StringType getName() {
        return this.name;
    }

    public Organization setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public Organization setNameSimple(String string) {
        if (string == null) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
        }
        return this;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Organization setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public Address addAddress() {
        Address address = new Address();
        this.address.add(address);
        return address;
    }

    public ResourceReference getPartOf() {
        return this.partOf;
    }

    public Organization setPartOf(ResourceReference resourceReference) {
        this.partOf = resourceReference;
        return this;
    }

    public Organization getPartOfTarget() {
        return this.partOfTarget;
    }

    public Organization setPartOfTarget(Organization organization) {
        this.partOfTarget = organization;
        return this;
    }

    public List<OrganizationContactComponent> getContact() {
        return this.contact;
    }

    public OrganizationContactComponent addContact() {
        OrganizationContactComponent organizationContactComponent = new OrganizationContactComponent();
        this.contact.add(organizationContactComponent);
        return organizationContactComponent;
    }

    public List<ResourceReference> getLocation() {
        return this.location;
    }

    public ResourceReference addLocation() {
        ResourceReference resourceReference = new ResourceReference();
        this.location.add(resourceReference);
        return resourceReference;
    }

    public List<Location> getLocationTarget() {
        return this.locationTarget;
    }

    public Location addLocationTarget() {
        Location location = new Location();
        this.locationTarget.add(location);
        return location;
    }

    public BooleanType getActive() {
        return this.active;
    }

    public Organization setActive(BooleanType booleanType) {
        this.active = booleanType;
        return this;
    }

    public boolean getActiveSimple() {
        return this.active == null ? false : this.active.getValue();
    }

    public Organization setActiveSimple(boolean bl) {
        if (!bl) {
            this.active = null;
        } else {
            if (this.active == null) {
                this.active = new BooleanType();
            }
            this.active.setValue(bl);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier for the organization that is used to identify the organization across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("name", "string", "A name associated with the organization.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("type", "CodeableConcept", "The kind of organization that this is.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("telecom", "Contact", "A contact detail for the organization.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("address", "Address", "An address for the organization.", 0, Integer.MAX_VALUE, this.address));
        list.add(new Property("partOf", "Resource(Organization)", "The organization of which this organization forms a part.", 0, Integer.MAX_VALUE, this.partOf));
        list.add(new Property("contact", "", "Contact for the organization for a certain purpose.", 0, Integer.MAX_VALUE, this.contact));
        list.add(new Property("location", "Resource(Location)", "Location(s) the organization uses to provide services.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("active", "boolean", "Whether the organization's record is still in active use.", 0, Integer.MAX_VALUE, this.active));
    }

    public Organization copy() {
        Organization organization = new Organization();
        organization.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            organization.identifier.add(element.copy());
        }
        organization.name = this.name == null ? null : this.name.copy();
        organization.type = this.type == null ? null : this.type.copy();
        organization.telecom = new ArrayList<Contact>();
        for (Contact contact : this.telecom) {
            organization.telecom.add(contact.copy());
        }
        organization.address = new ArrayList<Address>();
        for (Address address : this.address) {
            organization.address.add(address.copy());
        }
        organization.partOf = this.partOf == null ? null : this.partOf.copy();
        organization.contact = new ArrayList<OrganizationContactComponent>();
        for (OrganizationContactComponent organizationContactComponent : this.contact) {
            organization.contact.add(organizationContactComponent.copy());
        }
        organization.location = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.location) {
            organization.location.add(resourceReference.copy());
        }
        organization.active = this.active == null ? null : this.active.copy();
        return organization;
    }

    protected Organization typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Organization;
    }

    public static class OrganizationContactComponent
    extends BackboneElement {
        protected CodeableConcept purpose;
        protected HumanName name;
        protected List<Contact> telecom = new ArrayList<Contact>();
        protected Address address;
        protected CodeableConcept gender;
        private static final long serialVersionUID = 2147286938L;

        public CodeableConcept getPurpose() {
            return this.purpose;
        }

        public OrganizationContactComponent setPurpose(CodeableConcept codeableConcept) {
            this.purpose = codeableConcept;
            return this;
        }

        public HumanName getName() {
            return this.name;
        }

        public OrganizationContactComponent setName(HumanName humanName) {
            this.name = humanName;
            return this;
        }

        public List<Contact> getTelecom() {
            return this.telecom;
        }

        public Contact addTelecom() {
            Contact contact = new Contact();
            this.telecom.add(contact);
            return contact;
        }

        public Address getAddress() {
            return this.address;
        }

        public OrganizationContactComponent setAddress(Address address) {
            this.address = address;
            return this;
        }

        public CodeableConcept getGender() {
            return this.gender;
        }

        public OrganizationContactComponent setGender(CodeableConcept codeableConcept) {
            this.gender = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, Integer.MAX_VALUE, this.purpose));
            list.add(new Property("name", "HumanName", "A name associated with the contact.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("telecom", "Contact", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
            list.add(new Property("address", "Address", "Visiting or postal addresses for the contact.", 0, Integer.MAX_VALUE, this.address));
            list.add(new Property("gender", "CodeableConcept", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        }

        public OrganizationContactComponent copy() {
            OrganizationContactComponent organizationContactComponent = new OrganizationContactComponent();
            organizationContactComponent.purpose = this.purpose == null ? null : this.purpose.copy();
            organizationContactComponent.name = this.name == null ? null : this.name.copy();
            organizationContactComponent.telecom = new ArrayList<Contact>();
            for (Contact contact : this.telecom) {
                organizationContactComponent.telecom.add(contact.copy());
            }
            organizationContactComponent.address = this.address == null ? null : this.address.copy();
            organizationContactComponent.gender = this.gender == null ? null : this.gender.copy();
            return organizationContactComponent;
        }
    }
}

