/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class Other
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected CodeableConcept code;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference author;
    protected Resource authorTarget;
    protected DateType created;
    private static final long serialVersionUID = -1949730420L;

    public Other() {
    }

    public Other(CodeableConcept codeableConcept) {
        this.code = codeableConcept;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public CodeableConcept getCode() {
        return this.code;
    }

    public Other setCode(CodeableConcept codeableConcept) {
        this.code = codeableConcept;
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Other setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Other setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getAuthor() {
        return this.author;
    }

    public Other setAuthor(ResourceReference resourceReference) {
        this.author = resourceReference;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Other setAuthorTarget(Resource resource) {
        this.authorTarget = resource;
        return this;
    }

    public DateType getCreated() {
        return this.created;
    }

    public Other setCreated(DateType dateType) {
        this.created = dateType;
        return this;
    }

    public DateAndTime getCreatedSimple() {
        return this.created == null ? null : this.created.getValue();
    }

    public Other setCreatedSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateType();
            }
            this.created.setValue(dateAndTime);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier assigned to the resource for business purposes, outside the context of FHIR.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("code", "CodeableConcept", "Identifies the 'type' of resource - equivalent to the resource name for other resources.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("subject", "Resource(Any)", "Identifies the patient, practitioner, device or any other resource that is the 'focus' of this resoruce.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("author", "Resource(Practitioner|Patient|RelatedPerson)", "Indicates who was responsible for creating the resource instance.", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("created", "date", "Identifies when the resource was first created.", 0, Integer.MAX_VALUE, this.created));
    }

    public Other copy() {
        Other other = new Other();
        other.identifier = new ArrayList<Identifier>();
        for (Identifier identifier : this.identifier) {
            other.identifier.add(identifier.copy());
        }
        other.code = this.code == null ? null : this.code.copy();
        other.subject = this.subject == null ? null : this.subject.copy();
        other.author = this.author == null ? null : this.author.copy();
        other.created = this.created == null ? null : this.created.copy();
        return other;
    }

    protected Other typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Other;
    }
}

