/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.Type;

public class Patient
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected List<HumanName> name = new ArrayList<HumanName>();
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected CodeableConcept gender;
    protected DateTimeType birthDate;
    protected Type deceased;
    protected List<Address> address = new ArrayList<Address>();
    protected CodeableConcept maritalStatus;
    protected Type multipleBirth;
    protected List<Attachment> photo = new ArrayList<Attachment>();
    protected List<ContactComponent> contact = new ArrayList<ContactComponent>();
    protected AnimalComponent animal;
    protected List<CodeableConcept> communication = new ArrayList<CodeableConcept>();
    protected List<ResourceReference> careProvider = new ArrayList<ResourceReference>();
    protected List<Resource> careProviderTarget = new ArrayList<Resource>();
    protected ResourceReference managingOrganization;
    protected Organization managingOrganizationTarget;
    protected List<PatientLinkComponent> link = new ArrayList<PatientLinkComponent>();
    protected BooleanType active;
    private static final long serialVersionUID = -19272494L;

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public List<HumanName> getName() {
        return this.name;
    }

    public HumanName addName() {
        HumanName humanName = new HumanName();
        this.name.add(humanName);
        return humanName;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public CodeableConcept getGender() {
        return this.gender;
    }

    public Patient setGender(CodeableConcept codeableConcept) {
        this.gender = codeableConcept;
        return this;
    }

    public DateTimeType getBirthDate() {
        return this.birthDate;
    }

    public Patient setBirthDate(DateTimeType dateTimeType) {
        this.birthDate = dateTimeType;
        return this;
    }

    public DateAndTime getBirthDateSimple() {
        return this.birthDate == null ? null : this.birthDate.getValue();
    }

    public Patient setBirthDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateTimeType();
            }
            this.birthDate.setValue(dateAndTime);
        }
        return this;
    }

    public Type getDeceased() {
        return this.deceased;
    }

    public Patient setDeceased(Type type) {
        this.deceased = type;
        return this;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public Address addAddress() {
        Address address = new Address();
        this.address.add(address);
        return address;
    }

    public CodeableConcept getMaritalStatus() {
        return this.maritalStatus;
    }

    public Patient setMaritalStatus(CodeableConcept codeableConcept) {
        this.maritalStatus = codeableConcept;
        return this;
    }

    public Type getMultipleBirth() {
        return this.multipleBirth;
    }

    public Patient setMultipleBirth(Type type) {
        this.multipleBirth = type;
        return this;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public Attachment addPhoto() {
        Attachment attachment = new Attachment();
        this.photo.add(attachment);
        return attachment;
    }

    public List<ContactComponent> getContact() {
        return this.contact;
    }

    public ContactComponent addContact() {
        ContactComponent contactComponent = new ContactComponent();
        this.contact.add(contactComponent);
        return contactComponent;
    }

    public AnimalComponent getAnimal() {
        return this.animal;
    }

    public Patient setAnimal(AnimalComponent animalComponent) {
        this.animal = animalComponent;
        return this;
    }

    public List<CodeableConcept> getCommunication() {
        return this.communication;
    }

    public CodeableConcept addCommunication() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.communication.add(codeableConcept);
        return codeableConcept;
    }

    public List<ResourceReference> getCareProvider() {
        return this.careProvider;
    }

    public ResourceReference addCareProvider() {
        ResourceReference resourceReference = new ResourceReference();
        this.careProvider.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getCareProviderTarget() {
        return this.careProviderTarget;
    }

    public ResourceReference getManagingOrganization() {
        return this.managingOrganization;
    }

    public Patient setManagingOrganization(ResourceReference resourceReference) {
        this.managingOrganization = resourceReference;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        return this.managingOrganizationTarget;
    }

    public Patient setManagingOrganizationTarget(Organization organization) {
        this.managingOrganizationTarget = organization;
        return this;
    }

    public List<PatientLinkComponent> getLink() {
        return this.link;
    }

    public PatientLinkComponent addLink() {
        PatientLinkComponent patientLinkComponent = new PatientLinkComponent();
        this.link.add(patientLinkComponent);
        return patientLinkComponent;
    }

    public BooleanType getActive() {
        return this.active;
    }

    public Patient setActive(BooleanType booleanType) {
        this.active = booleanType;
        return this;
    }

    public boolean getActiveSimple() {
        return this.active == null ? false : this.active.getValue();
    }

    public Patient setActiveSimple(boolean bl) {
        if (!bl) {
            this.active = null;
        } else {
            if (this.active == null) {
                this.active = new BooleanType();
            }
            this.active.setValue(bl);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "An identifier that applies to this person as a patient.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("name", "HumanName", "A name associated with the individual.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("telecom", "Contact", "A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("gender", "CodeableConcept", "Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        list.add(new Property("birthDate", "dateTime", "The date and time of birth for the individual.", 0, Integer.MAX_VALUE, this.birthDate));
        list.add(new Property("deceased[x]", "boolean|dateTime", "Indicates if the individual is deceased or not.", 0, Integer.MAX_VALUE, this.deceased));
        list.add(new Property("address", "Address", "Addresses for the individual.", 0, Integer.MAX_VALUE, this.address));
        list.add(new Property("maritalStatus", "CodeableConcept", "This field contains a patient's most recent marital (civil) status.", 0, Integer.MAX_VALUE, this.maritalStatus));
        list.add(new Property("multipleBirth[x]", "boolean|integer", "Indicates whether the patient is part of a multiple or indicates the actual birth order.", 0, Integer.MAX_VALUE, this.multipleBirth));
        list.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
        list.add(new Property("contact", "", "A contact party (e.g. guardian, partner, friend) for the patient.", 0, Integer.MAX_VALUE, this.contact));
        list.add(new Property("animal", "", "This element has a value if the patient is an animal.", 0, Integer.MAX_VALUE, this.animal));
        list.add(new Property("communication", "CodeableConcept", "Languages which may be used to communicate with the patient about his or her health.", 0, Integer.MAX_VALUE, this.communication));
        list.add(new Property("careProvider", "Resource(Organization|Practitioner)", "Patient's nominated care provider.", 0, Integer.MAX_VALUE, this.careProvider));
        list.add(new Property("managingOrganization", "Resource(Organization)", "Organization that is the custodian of the patient record.", 0, Integer.MAX_VALUE, this.managingOrganization));
        list.add(new Property("link", "", "Link to another patient resource that concerns the same actual person.", 0, Integer.MAX_VALUE, this.link));
        list.add(new Property("active", "boolean", "Whether this patient record is in active use.", 0, Integer.MAX_VALUE, this.active));
    }

    public Patient copy() {
        Patient patient = new Patient();
        patient.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            patient.identifier.add(element.copy());
        }
        patient.name = new ArrayList<HumanName>();
        for (HumanName humanName : this.name) {
            patient.name.add(humanName.copy());
        }
        patient.telecom = new ArrayList<Contact>();
        for (Contact contact : this.telecom) {
            patient.telecom.add(contact.copy());
        }
        patient.gender = this.gender == null ? null : this.gender.copy();
        patient.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        patient.deceased = this.deceased == null ? null : this.deceased.copy();
        patient.address = new ArrayList<Address>();
        for (Address address : this.address) {
            patient.address.add(address.copy());
        }
        patient.maritalStatus = this.maritalStatus == null ? null : this.maritalStatus.copy();
        patient.multipleBirth = this.multipleBirth == null ? null : this.multipleBirth.copy();
        patient.photo = new ArrayList<Attachment>();
        for (Attachment attachment : this.photo) {
            patient.photo.add(attachment.copy());
        }
        patient.contact = new ArrayList<ContactComponent>();
        for (ContactComponent contactComponent : this.contact) {
            patient.contact.add(contactComponent.copy());
        }
        patient.animal = this.animal == null ? null : this.animal.copy();
        patient.communication = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.communication) {
            patient.communication.add(codeableConcept.copy());
        }
        patient.careProvider = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.careProvider) {
            patient.careProvider.add(resourceReference.copy());
        }
        patient.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        patient.link = new ArrayList<PatientLinkComponent>();
        for (PatientLinkComponent patientLinkComponent : this.link) {
            patient.link.add(patientLinkComponent.copy());
        }
        patient.active = this.active == null ? null : this.active.copy();
        return patient;
    }

    protected Patient typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Patient;
    }

    public static class PatientLinkComponent
    extends BackboneElement {
        protected ResourceReference other;
        protected Patient otherTarget;
        protected Enumeration<LinkType> type;
        private static final long serialVersionUID = 383172000L;

        public PatientLinkComponent() {
        }

        public PatientLinkComponent(ResourceReference resourceReference, Enumeration<LinkType> enumeration) {
            this.other = resourceReference;
            this.type = enumeration;
        }

        public ResourceReference getOther() {
            return this.other;
        }

        public PatientLinkComponent setOther(ResourceReference resourceReference) {
            this.other = resourceReference;
            return this;
        }

        public Patient getOtherTarget() {
            return this.otherTarget;
        }

        public PatientLinkComponent setOtherTarget(Patient patient) {
            this.otherTarget = patient;
            return this;
        }

        public Enumeration<LinkType> getType() {
            return this.type;
        }

        public PatientLinkComponent setType(Enumeration<LinkType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public LinkType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public PatientLinkComponent setTypeSimple(LinkType linkType) {
            if (this.type == null) {
                this.type = new Enumeration();
            }
            this.type.setValue(linkType);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("other", "Resource(Patient)", "The other patient resource that the link refers to.", 0, Integer.MAX_VALUE, this.other));
            list.add(new Property("type", "code", "The type of link between this patient resource and another patient resource.", 0, Integer.MAX_VALUE, this.type));
        }

        public PatientLinkComponent copy() {
            PatientLinkComponent patientLinkComponent = new PatientLinkComponent();
            patientLinkComponent.other = this.other == null ? null : this.other.copy();
            patientLinkComponent.type = this.type == null ? null : this.type.copy();
            return patientLinkComponent;
        }
    }

    public static class AnimalComponent
    extends BackboneElement {
        protected CodeableConcept species;
        protected CodeableConcept breed;
        protected CodeableConcept genderStatus;
        private static final long serialVersionUID = -549738382L;

        public AnimalComponent() {
        }

        public AnimalComponent(CodeableConcept codeableConcept) {
            this.species = codeableConcept;
        }

        public CodeableConcept getSpecies() {
            return this.species;
        }

        public AnimalComponent setSpecies(CodeableConcept codeableConcept) {
            this.species = codeableConcept;
            return this;
        }

        public CodeableConcept getBreed() {
            return this.breed;
        }

        public AnimalComponent setBreed(CodeableConcept codeableConcept) {
            this.breed = codeableConcept;
            return this;
        }

        public CodeableConcept getGenderStatus() {
            return this.genderStatus;
        }

        public AnimalComponent setGenderStatus(CodeableConcept codeableConcept) {
            this.genderStatus = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("species", "CodeableConcept", "Identifies the high level categorization of the kind of animal.", 0, Integer.MAX_VALUE, this.species));
            list.add(new Property("breed", "CodeableConcept", "Identifies the detailed categorization of the kind of animal.", 0, Integer.MAX_VALUE, this.breed));
            list.add(new Property("genderStatus", "CodeableConcept", "Indicates the current state of the animal's reproductive organs.", 0, Integer.MAX_VALUE, this.genderStatus));
        }

        public AnimalComponent copy() {
            AnimalComponent animalComponent = new AnimalComponent();
            animalComponent.species = this.species == null ? null : this.species.copy();
            animalComponent.breed = this.breed == null ? null : this.breed.copy();
            animalComponent.genderStatus = this.genderStatus == null ? null : this.genderStatus.copy();
            return animalComponent;
        }
    }

    public static class ContactComponent
    extends BackboneElement {
        protected List<CodeableConcept> relationship = new ArrayList<CodeableConcept>();
        protected HumanName name;
        protected List<Contact> telecom = new ArrayList<Contact>();
        protected Address address;
        protected CodeableConcept gender;
        protected ResourceReference organization;
        protected Organization organizationTarget;
        private static final long serialVersionUID = -384461371L;

        public List<CodeableConcept> getRelationship() {
            return this.relationship;
        }

        public CodeableConcept addRelationship() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.relationship.add(codeableConcept);
            return codeableConcept;
        }

        public HumanName getName() {
            return this.name;
        }

        public ContactComponent setName(HumanName humanName) {
            this.name = humanName;
            return this;
        }

        public List<Contact> getTelecom() {
            return this.telecom;
        }

        public Contact addTelecom() {
            Contact contact = new Contact();
            this.telecom.add(contact);
            return contact;
        }

        public Address getAddress() {
            return this.address;
        }

        public ContactComponent setAddress(Address address) {
            this.address = address;
            return this;
        }

        public CodeableConcept getGender() {
            return this.gender;
        }

        public ContactComponent setGender(CodeableConcept codeableConcept) {
            this.gender = codeableConcept;
            return this;
        }

        public ResourceReference getOrganization() {
            return this.organization;
        }

        public ContactComponent setOrganization(ResourceReference resourceReference) {
            this.organization = resourceReference;
            return this;
        }

        public Organization getOrganizationTarget() {
            return this.organizationTarget;
        }

        public ContactComponent setOrganizationTarget(Organization organization) {
            this.organizationTarget = organization;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("relationship", "CodeableConcept", "The nature of the relationship between the patient and the contact person.", 0, Integer.MAX_VALUE, this.relationship));
            list.add(new Property("name", "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("telecom", "Contact", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
            list.add(new Property("address", "Address", "Address for the contact person.", 0, Integer.MAX_VALUE, this.address));
            list.add(new Property("gender", "CodeableConcept", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
            list.add(new Property("organization", "Resource(Organization)", "Organization on behalf of which the contact is acting or for which the contact is working.", 0, Integer.MAX_VALUE, this.organization));
        }

        public ContactComponent copy() {
            ContactComponent contactComponent = new ContactComponent();
            contactComponent.relationship = new ArrayList<CodeableConcept>();
            for (CodeableConcept type : this.relationship) {
                contactComponent.relationship.add(type.copy());
            }
            contactComponent.name = this.name == null ? null : this.name.copy();
            contactComponent.telecom = new ArrayList<Contact>();
            for (Contact contact : this.telecom) {
                contactComponent.telecom.add(contact.copy());
            }
            contactComponent.address = this.address == null ? null : this.address.copy();
            contactComponent.gender = this.gender == null ? null : this.gender.copy();
            contactComponent.organization = this.organization == null ? null : this.organization.copy();
            return contactComponent;
        }
    }

    public static class LinkTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("replace".equals(string)) {
                return LinkType.replace;
            }
            if ("refer".equals(string)) {
                return LinkType.refer;
            }
            if ("seealso".equals(string)) {
                return LinkType.seealso;
            }
            throw new Exception("Unknown LinkType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == LinkType.replace) {
                return "replace";
            }
            if (enum_ == LinkType.refer) {
                return "refer";
            }
            if (enum_ == LinkType.seealso) {
                return "seealso";
            }
            return "?";
        }
    }

    public static enum LinkType {
        replace,
        refer,
        seealso,
        Null;


        public static LinkType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("replace".equals(string)) {
                return replace;
            }
            if ("refer".equals(string)) {
                return refer;
            }
            if ("seealso".equals(string)) {
                return seealso;
            }
            throw new Exception("Unknown LinkType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case replace: {
                    return "replace";
                }
                case refer: {
                    return "refer";
                }
                case seealso: {
                    return "seealso";
                }
            }
            return "?";
        }
    }
}

