/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Type;

public class Period
extends Type {
    protected DateTimeType start;
    protected DateTimeType end;
    private static final long serialVersionUID = 649791751L;

    public DateTimeType getStart() {
        return this.start;
    }

    public Period setStart(DateTimeType dateTimeType) {
        this.start = dateTimeType;
        return this;
    }

    public DateAndTime getStartSimple() {
        return this.start == null ? null : this.start.getValue();
    }

    public Period setStartSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.start = null;
        } else {
            if (this.start == null) {
                this.start = new DateTimeType();
            }
            this.start.setValue(dateAndTime);
        }
        return this;
    }

    public DateTimeType getEnd() {
        return this.end;
    }

    public Period setEnd(DateTimeType dateTimeType) {
        this.end = dateTimeType;
        return this;
    }

    public DateAndTime getEndSimple() {
        return this.end == null ? null : this.end.getValue();
    }

    public Period setEndSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.end = null;
        } else {
            if (this.end == null) {
                this.end = new DateTimeType();
            }
            this.end.setValue(dateAndTime);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("start", "dateTime", "The start of the period. The boundary is inclusive.", 0, Integer.MAX_VALUE, this.start));
        list.add(new Property("end", "dateTime", "The end of the period. If the end of the period is missing, it means that the period is ongoing.", 0, Integer.MAX_VALUE, this.end));
    }

    @Override
    public Period copy() {
        Period period = new Period();
        period.start = this.start == null ? null : this.start.copy();
        period.end = this.end == null ? null : this.end.copy();
        return period;
    }

    @Override
    protected Period typedCopy() {
        return this.copy();
    }
}

