/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class Practitioner
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected HumanName name;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected Address address;
    protected CodeableConcept gender;
    protected DateTimeType birthDate;
    protected List<Attachment> photo = new ArrayList<Attachment>();
    protected ResourceReference organization;
    protected Organization organizationTarget;
    protected List<CodeableConcept> role = new ArrayList<CodeableConcept>();
    protected List<CodeableConcept> specialty = new ArrayList<CodeableConcept>();
    protected Period period;
    protected List<ResourceReference> location = new ArrayList<ResourceReference>();
    protected List<Location> locationTarget = new ArrayList<Location>();
    protected List<PractitionerQualificationComponent> qualification = new ArrayList<PractitionerQualificationComponent>();
    protected List<CodeableConcept> communication = new ArrayList<CodeableConcept>();
    private static final long serialVersionUID = -309581095L;

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public HumanName getName() {
        return this.name;
    }

    public Practitioner setName(HumanName humanName) {
        this.name = humanName;
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public Address getAddress() {
        return this.address;
    }

    public Practitioner setAddress(Address address) {
        this.address = address;
        return this;
    }

    public CodeableConcept getGender() {
        return this.gender;
    }

    public Practitioner setGender(CodeableConcept codeableConcept) {
        this.gender = codeableConcept;
        return this;
    }

    public DateTimeType getBirthDate() {
        return this.birthDate;
    }

    public Practitioner setBirthDate(DateTimeType dateTimeType) {
        this.birthDate = dateTimeType;
        return this;
    }

    public DateAndTime getBirthDateSimple() {
        return this.birthDate == null ? null : this.birthDate.getValue();
    }

    public Practitioner setBirthDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateTimeType();
            }
            this.birthDate.setValue(dateAndTime);
        }
        return this;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public Attachment addPhoto() {
        Attachment attachment = new Attachment();
        this.photo.add(attachment);
        return attachment;
    }

    public ResourceReference getOrganization() {
        return this.organization;
    }

    public Practitioner setOrganization(ResourceReference resourceReference) {
        this.organization = resourceReference;
        return this;
    }

    public Organization getOrganizationTarget() {
        return this.organizationTarget;
    }

    public Practitioner setOrganizationTarget(Organization organization) {
        this.organizationTarget = organization;
        return this;
    }

    public List<CodeableConcept> getRole() {
        return this.role;
    }

    public CodeableConcept addRole() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.role.add(codeableConcept);
        return codeableConcept;
    }

    public List<CodeableConcept> getSpecialty() {
        return this.specialty;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.specialty.add(codeableConcept);
        return codeableConcept;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Practitioner setPeriod(Period period) {
        this.period = period;
        return this;
    }

    public List<ResourceReference> getLocation() {
        return this.location;
    }

    public ResourceReference addLocation() {
        ResourceReference resourceReference = new ResourceReference();
        this.location.add(resourceReference);
        return resourceReference;
    }

    public List<Location> getLocationTarget() {
        return this.locationTarget;
    }

    public Location addLocationTarget() {
        Location location = new Location();
        this.locationTarget.add(location);
        return location;
    }

    public List<PractitionerQualificationComponent> getQualification() {
        return this.qualification;
    }

    public PractitionerQualificationComponent addQualification() {
        PractitionerQualificationComponent practitionerQualificationComponent = new PractitionerQualificationComponent();
        this.qualification.add(practitionerQualificationComponent);
        return practitionerQualificationComponent;
    }

    public List<CodeableConcept> getCommunication() {
        return this.communication;
    }

    public CodeableConcept addCommunication() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.communication.add(codeableConcept);
        return codeableConcept;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "An identifier that applies to this person in this role.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("name", "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("telecom", "Contact", "A contact detail for the practitioner, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("address", "Address", "The postal address where the practitioner can be found or visited or to which mail can be delivered.", 0, Integer.MAX_VALUE, this.address));
        list.add(new Property("gender", "CodeableConcept", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        list.add(new Property("birthDate", "dateTime", "The date and time of birth for the practitioner.", 0, Integer.MAX_VALUE, this.birthDate));
        list.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
        list.add(new Property("organization", "Resource(Organization)", "The organization that the practitioner represents.", 0, Integer.MAX_VALUE, this.organization));
        list.add(new Property("role", "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.role));
        list.add(new Property("specialty", "CodeableConcept", "Specific specialty of the practitioner.", 0, Integer.MAX_VALUE, this.specialty));
        list.add(new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, Integer.MAX_VALUE, this.period));
        list.add(new Property("location", "Resource(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("qualification", "", "Qualifications obtained by training and certification.", 0, Integer.MAX_VALUE, this.qualification));
        list.add(new Property("communication", "CodeableConcept", "A language the practitioner is able to use in patient communication.", 0, Integer.MAX_VALUE, this.communication));
    }

    public Practitioner copy() {
        Practitioner practitioner = new Practitioner();
        practitioner.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            practitioner.identifier.add(element.copy());
        }
        practitioner.name = this.name == null ? null : this.name.copy();
        practitioner.telecom = new ArrayList<Contact>();
        for (Contact contact : this.telecom) {
            practitioner.telecom.add(contact.copy());
        }
        practitioner.address = this.address == null ? null : this.address.copy();
        practitioner.gender = this.gender == null ? null : this.gender.copy();
        practitioner.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        practitioner.photo = new ArrayList<Attachment>();
        for (Attachment attachment : this.photo) {
            practitioner.photo.add(attachment.copy());
        }
        practitioner.organization = this.organization == null ? null : this.organization.copy();
        practitioner.role = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.role) {
            practitioner.role.add(codeableConcept.copy());
        }
        practitioner.specialty = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.specialty) {
            practitioner.specialty.add(codeableConcept.copy());
        }
        practitioner.period = this.period == null ? null : this.period.copy();
        practitioner.location = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.location) {
            practitioner.location.add(resourceReference.copy());
        }
        practitioner.qualification = new ArrayList<PractitionerQualificationComponent>();
        for (PractitionerQualificationComponent practitionerQualificationComponent : this.qualification) {
            practitioner.qualification.add(practitionerQualificationComponent.copy());
        }
        practitioner.communication = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.communication) {
            practitioner.communication.add(codeableConcept.copy());
        }
        return practitioner;
    }

    protected Practitioner typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Practitioner;
    }

    public static class PractitionerQualificationComponent
    extends BackboneElement {
        protected CodeableConcept code;
        protected Period period;
        protected ResourceReference issuer;
        protected Organization issuerTarget;
        private static final long serialVersionUID = -878582183L;

        public PractitionerQualificationComponent() {
        }

        public PractitionerQualificationComponent(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
        }

        public CodeableConcept getCode() {
            return this.code;
        }

        public PractitionerQualificationComponent setCode(CodeableConcept codeableConcept) {
            this.code = codeableConcept;
            return this;
        }

        public Period getPeriod() {
            return this.period;
        }

        public PractitionerQualificationComponent setPeriod(Period period) {
            this.period = period;
            return this;
        }

        public ResourceReference getIssuer() {
            return this.issuer;
        }

        public PractitionerQualificationComponent setIssuer(ResourceReference resourceReference) {
            this.issuer = resourceReference;
            return this;
        }

        public Organization getIssuerTarget() {
            return this.issuerTarget;
        }

        public PractitionerQualificationComponent setIssuerTarget(Organization organization) {
            this.issuerTarget = organization;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "CodeableConcept", "Coded representation of the qualification.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("period", "Period", "Period during which the qualification is valid.", 0, Integer.MAX_VALUE, this.period));
            list.add(new Property("issuer", "Resource(Organization)", "Organization that regulates and issues the qualification.", 0, Integer.MAX_VALUE, this.issuer));
        }

        public PractitionerQualificationComponent copy() {
            PractitionerQualificationComponent practitionerQualificationComponent = new PractitionerQualificationComponent();
            practitionerQualificationComponent.code = this.code == null ? null : this.code.copy();
            practitionerQualificationComponent.period = this.period == null ? null : this.period.copy();
            practitionerQualificationComponent.issuer = this.issuer == null ? null : this.issuer.copy();
            return practitionerQualificationComponent;
        }
    }
}

