/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DiagnosticReport;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Procedure
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference subject;
    protected Patient subjectTarget;
    protected CodeableConcept type;
    protected List<CodeableConcept> bodySite = new ArrayList<CodeableConcept>();
    protected List<CodeableConcept> indication = new ArrayList<CodeableConcept>();
    protected List<ProcedurePerformerComponent> performer = new ArrayList<ProcedurePerformerComponent>();
    protected Period date;
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected StringType outcome;
    protected List<ResourceReference> report = new ArrayList<ResourceReference>();
    protected List<DiagnosticReport> reportTarget = new ArrayList<DiagnosticReport>();
    protected List<CodeableConcept> complication = new ArrayList<CodeableConcept>();
    protected StringType followUp;
    protected List<ProcedureRelatedItemComponent> relatedItem = new ArrayList<ProcedureRelatedItemComponent>();
    protected StringType notes;
    private static final long serialVersionUID = 1630894875L;

    public Procedure() {
    }

    public Procedure(ResourceReference resourceReference, CodeableConcept codeableConcept) {
        this.subject = resourceReference;
        this.type = codeableConcept;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Procedure setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Patient getSubjectTarget() {
        return this.subjectTarget;
    }

    public Procedure setSubjectTarget(Patient patient) {
        this.subjectTarget = patient;
        return this;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Procedure setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public List<CodeableConcept> getBodySite() {
        return this.bodySite;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.bodySite.add(codeableConcept);
        return codeableConcept;
    }

    public List<CodeableConcept> getIndication() {
        return this.indication;
    }

    public CodeableConcept addIndication() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.indication.add(codeableConcept);
        return codeableConcept;
    }

    public List<ProcedurePerformerComponent> getPerformer() {
        return this.performer;
    }

    public ProcedurePerformerComponent addPerformer() {
        ProcedurePerformerComponent procedurePerformerComponent = new ProcedurePerformerComponent();
        this.performer.add(procedurePerformerComponent);
        return procedurePerformerComponent;
    }

    public Period getDate() {
        return this.date;
    }

    public Procedure setDate(Period period) {
        this.date = period;
        return this;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public Procedure setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public Procedure setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public StringType getOutcome() {
        return this.outcome;
    }

    public Procedure setOutcome(StringType stringType) {
        this.outcome = stringType;
        return this;
    }

    public String getOutcomeSimple() {
        return this.outcome == null ? null : this.outcome.getValue();
    }

    public Procedure setOutcomeSimple(String string) {
        if (string == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new StringType();
            }
            this.outcome.setValue(string);
        }
        return this;
    }

    public List<ResourceReference> getReport() {
        return this.report;
    }

    public ResourceReference addReport() {
        ResourceReference resourceReference = new ResourceReference();
        this.report.add(resourceReference);
        return resourceReference;
    }

    public List<DiagnosticReport> getReportTarget() {
        return this.reportTarget;
    }

    public DiagnosticReport addReportTarget() {
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        this.reportTarget.add(diagnosticReport);
        return diagnosticReport;
    }

    public List<CodeableConcept> getComplication() {
        return this.complication;
    }

    public CodeableConcept addComplication() {
        CodeableConcept codeableConcept = new CodeableConcept();
        this.complication.add(codeableConcept);
        return codeableConcept;
    }

    public StringType getFollowUp() {
        return this.followUp;
    }

    public Procedure setFollowUp(StringType stringType) {
        this.followUp = stringType;
        return this;
    }

    public String getFollowUpSimple() {
        return this.followUp == null ? null : this.followUp.getValue();
    }

    public Procedure setFollowUpSimple(String string) {
        if (string == null) {
            this.followUp = null;
        } else {
            if (this.followUp == null) {
                this.followUp = new StringType();
            }
            this.followUp.setValue(string);
        }
        return this;
    }

    public List<ProcedureRelatedItemComponent> getRelatedItem() {
        return this.relatedItem;
    }

    public ProcedureRelatedItemComponent addRelatedItem() {
        ProcedureRelatedItemComponent procedureRelatedItemComponent = new ProcedureRelatedItemComponent();
        this.relatedItem.add(procedureRelatedItemComponent);
        return procedureRelatedItemComponent;
    }

    public StringType getNotes() {
        return this.notes;
    }

    public Procedure setNotes(StringType stringType) {
        this.notes = stringType;
        return this;
    }

    public String getNotesSimple() {
        return this.notes == null ? null : this.notes.getValue();
    }

    public Procedure setNotesSimple(String string) {
        if (string == null) {
            this.notes = null;
        } else {
            if (this.notes == null) {
                this.notes = new StringType();
            }
            this.notes.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this procedure that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("subject", "Resource(Patient)", "The person on whom the procedure was performed.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("type", "CodeableConcept", "The specific procedure that is performed. Use text if the exact nature of the procedure can't be coded.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("bodySite", "CodeableConcept", "Detailed and structured anatomical location information. Multiple locations are allowed - e.g. multiple punch biopsies of a lesion.", 0, Integer.MAX_VALUE, this.bodySite));
        list.add(new Property("indication", "CodeableConcept", "The reason why the procedure was performed. This may be due to a Condition, may be coded entity of some type, or may simply be present as text.", 0, Integer.MAX_VALUE, this.indication));
        list.add(new Property("performer", "", "Limited to 'real' people rather than equipment.", 0, Integer.MAX_VALUE, this.performer));
        list.add(new Property("date", "Period", "The dates over which the procedure was performed. Allows a period to support complex procedures that span more that one date, and also allows for the length of the procedure to be captured.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("encounter", "Resource(Encounter)", "The encounter during which the procedure was performed.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("outcome", "string", "What was the outcome of the procedure - did it resolve reasons why the procedure was performed?.", 0, Integer.MAX_VALUE, this.outcome));
        list.add(new Property("report", "Resource(DiagnosticReport)", "This could be a histology result. There could potentially be multiple reports - e.g. if this was a procedure that made multiple biopsies.", 0, Integer.MAX_VALUE, this.report));
        list.add(new Property("complication", "CodeableConcept", "Any complications that occurred during the procedure, or in the immediate post-operative period. These are generally tracked separately from the notes, which typically will describe the procedure itself rather than any 'post procedure' issues.", 0, Integer.MAX_VALUE, this.complication));
        list.add(new Property("followUp", "string", "If the procedure required specific follow up - e.g. removal of sutures. The followup may be represented as a simple note, or potentially could be more complex in which case the CarePlan resource can be used.", 0, Integer.MAX_VALUE, this.followUp));
        list.add(new Property("relatedItem", "", "Procedures may be related to other items such as procedures or medications. For example treating wound dehiscence following a previous procedure.", 0, Integer.MAX_VALUE, this.relatedItem));
        list.add(new Property("notes", "string", "Any other notes about the procedure - e.g. the operative notes.", 0, Integer.MAX_VALUE, this.notes));
    }

    public Procedure copy() {
        Procedure procedure = new Procedure();
        procedure.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            procedure.identifier.add(element.copy());
        }
        procedure.subject = this.subject == null ? null : this.subject.copy();
        procedure.type = this.type == null ? null : this.type.copy();
        procedure.bodySite = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.bodySite) {
            procedure.bodySite.add(codeableConcept.copy());
        }
        procedure.indication = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.indication) {
            procedure.indication.add(codeableConcept.copy());
        }
        procedure.performer = new ArrayList<ProcedurePerformerComponent>();
        for (ProcedurePerformerComponent procedurePerformerComponent : this.performer) {
            procedure.performer.add(procedurePerformerComponent.copy());
        }
        procedure.date = this.date == null ? null : this.date.copy();
        procedure.encounter = this.encounter == null ? null : this.encounter.copy();
        procedure.outcome = this.outcome == null ? null : this.outcome.copy();
        procedure.report = new ArrayList<ResourceReference>();
        for (ResourceReference resourceReference : this.report) {
            procedure.report.add(resourceReference.copy());
        }
        procedure.complication = new ArrayList<CodeableConcept>();
        for (CodeableConcept codeableConcept : this.complication) {
            procedure.complication.add(codeableConcept.copy());
        }
        procedure.followUp = this.followUp == null ? null : this.followUp.copy();
        procedure.relatedItem = new ArrayList<ProcedureRelatedItemComponent>();
        for (ProcedureRelatedItemComponent procedureRelatedItemComponent : this.relatedItem) {
            procedure.relatedItem.add(procedureRelatedItemComponent.copy());
        }
        procedure.notes = this.notes == null ? null : this.notes.copy();
        return procedure;
    }

    protected Procedure typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Procedure;
    }

    public static class ProcedureRelatedItemComponent
    extends BackboneElement {
        protected Enumeration<ProcedureRelationshipType> type;
        protected ResourceReference target;
        protected Resource targetTarget;
        private static final long serialVersionUID = 829932234L;

        public Enumeration<ProcedureRelationshipType> getType() {
            return this.type;
        }

        public ProcedureRelatedItemComponent setType(Enumeration<ProcedureRelationshipType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public ProcedureRelationshipType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ProcedureRelatedItemComponent setTypeSimple(ProcedureRelationshipType procedureRelationshipType) {
            if (procedureRelationshipType == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration();
                }
                this.type.setValue(procedureRelationshipType);
            }
            return this;
        }

        public ResourceReference getTarget() {
            return this.target;
        }

        public ProcedureRelatedItemComponent setTarget(ResourceReference resourceReference) {
            this.target = resourceReference;
            return this;
        }

        public Resource getTargetTarget() {
            return this.targetTarget;
        }

        public ProcedureRelatedItemComponent setTargetTarget(Resource resource) {
            this.targetTarget = resource;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "code", "The nature of the relationship.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("target", "Resource(AdverseReaction|AllergyIntolerance|CarePlan|Condition|DeviceObservationReport|DiagnosticReport|FamilyHistory|ImagingStudy|Immunization|ImmunizationRecommendation|MedicationAdministration|MedicationDispense|MedicationPrescription|MedicationStatement|Observation|Procedure)", "The related item - e.g. a procedure.", 0, Integer.MAX_VALUE, this.target));
        }

        public ProcedureRelatedItemComponent copy() {
            ProcedureRelatedItemComponent procedureRelatedItemComponent = new ProcedureRelatedItemComponent();
            procedureRelatedItemComponent.type = this.type == null ? null : this.type.copy();
            procedureRelatedItemComponent.target = this.target == null ? null : this.target.copy();
            return procedureRelatedItemComponent;
        }
    }

    public static class ProcedurePerformerComponent
    extends BackboneElement {
        protected ResourceReference person;
        protected Practitioner personTarget;
        protected CodeableConcept role;
        private static final long serialVersionUID = -1680776731L;

        public ResourceReference getPerson() {
            return this.person;
        }

        public ProcedurePerformerComponent setPerson(ResourceReference resourceReference) {
            this.person = resourceReference;
            return this;
        }

        public Practitioner getPersonTarget() {
            return this.personTarget;
        }

        public ProcedurePerformerComponent setPersonTarget(Practitioner practitioner) {
            this.personTarget = practitioner;
            return this;
        }

        public CodeableConcept getRole() {
            return this.role;
        }

        public ProcedurePerformerComponent setRole(CodeableConcept codeableConcept) {
            this.role = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("person", "Resource(Practitioner)", "The practitioner who was involved in the procedure.", 0, Integer.MAX_VALUE, this.person));
            list.add(new Property("role", "CodeableConcept", "E.g. surgeon, anaethetist, endoscopist.", 0, Integer.MAX_VALUE, this.role));
        }

        public ProcedurePerformerComponent copy() {
            ProcedurePerformerComponent procedurePerformerComponent = new ProcedurePerformerComponent();
            procedurePerformerComponent.person = this.person == null ? null : this.person.copy();
            procedurePerformerComponent.role = this.role == null ? null : this.role.copy();
            return procedurePerformerComponent;
        }
    }

    public static class ProcedureRelationshipTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("caused-by".equals(string)) {
                return ProcedureRelationshipType.causedby;
            }
            if ("because-of".equals(string)) {
                return ProcedureRelationshipType.becauseof;
            }
            throw new Exception("Unknown ProcedureRelationshipType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ProcedureRelationshipType.causedby) {
                return "caused-by";
            }
            if (enum_ == ProcedureRelationshipType.becauseof) {
                return "because-of";
            }
            return "?";
        }
    }

    public static enum ProcedureRelationshipType {
        causedby,
        becauseof,
        Null;


        public static ProcedureRelationshipType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("caused-by".equals(string)) {
                return causedby;
            }
            if ("because-of".equals(string)) {
                return becauseof;
            }
            throw new Exception("Unknown ProcedureRelationshipType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case causedby: {
                    return "caused-by";
                }
                case becauseof: {
                    return "because-of";
                }
            }
            return "?";
        }
    }
}

