/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;

public class Profile
extends Resource {
    protected StringType identifier;
    protected StringType version;
    protected StringType name;
    protected StringType publisher;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected StringType description;
    protected List<Coding> code = new ArrayList<Coding>();
    protected Enumeration<ResourceProfileStatus> status;
    protected BooleanType experimental;
    protected DateTimeType date;
    protected StringType requirements;
    protected IdType fhirVersion;
    protected List<ProfileMappingComponent> mapping = new ArrayList<ProfileMappingComponent>();
    protected List<ProfileStructureComponent> structure = new ArrayList<ProfileStructureComponent>();
    protected List<ProfileExtensionDefnComponent> extensionDefn = new ArrayList<ProfileExtensionDefnComponent>();
    protected List<ProfileQueryComponent> query = new ArrayList<ProfileQueryComponent>();
    private static final long serialVersionUID = 69212962L;

    public Profile() {
    }

    public Profile(StringType stringType, Enumeration<ResourceProfileStatus> enumeration) {
        this.name = stringType;
        this.status = enumeration;
    }

    public StringType getIdentifier() {
        return this.identifier;
    }

    public Profile setIdentifier(StringType stringType) {
        this.identifier = stringType;
        return this;
    }

    public String getIdentifierSimple() {
        return this.identifier == null ? null : this.identifier.getValue();
    }

    public Profile setIdentifierSimple(String string) {
        if (string == null) {
            this.identifier = null;
        } else {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(string);
        }
        return this;
    }

    public StringType getVersion() {
        return this.version;
    }

    public Profile setVersion(StringType stringType) {
        this.version = stringType;
        return this;
    }

    public String getVersionSimple() {
        return this.version == null ? null : this.version.getValue();
    }

    public Profile setVersionSimple(String string) {
        if (string == null) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(string);
        }
        return this;
    }

    public StringType getName() {
        return this.name;
    }

    public Profile setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public Profile setNameSimple(String string) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(string);
        return this;
    }

    public StringType getPublisher() {
        return this.publisher;
    }

    public Profile setPublisher(StringType stringType) {
        this.publisher = stringType;
        return this;
    }

    public String getPublisherSimple() {
        return this.publisher == null ? null : this.publisher.getValue();
    }

    public Profile setPublisherSimple(String string) {
        if (string == null) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(string);
        }
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public StringType getDescription() {
        return this.description;
    }

    public Profile setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public Profile setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public List<Coding> getCode() {
        return this.code;
    }

    public Coding addCode() {
        Coding coding = new Coding();
        this.code.add(coding);
        return coding;
    }

    public Enumeration<ResourceProfileStatus> getStatus() {
        return this.status;
    }

    public Profile setStatus(Enumeration<ResourceProfileStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ResourceProfileStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Profile setStatusSimple(ResourceProfileStatus resourceProfileStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(resourceProfileStatus);
        return this;
    }

    public BooleanType getExperimental() {
        return this.experimental;
    }

    public Profile setExperimental(BooleanType booleanType) {
        this.experimental = booleanType;
        return this;
    }

    public boolean getExperimentalSimple() {
        return this.experimental == null ? false : this.experimental.getValue();
    }

    public Profile setExperimentalSimple(boolean bl) {
        if (!bl) {
            this.experimental = null;
        } else {
            if (this.experimental == null) {
                this.experimental = new BooleanType();
            }
            this.experimental.setValue(bl);
        }
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public Profile setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public Profile setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public StringType getRequirements() {
        return this.requirements;
    }

    public Profile setRequirements(StringType stringType) {
        this.requirements = stringType;
        return this;
    }

    public String getRequirementsSimple() {
        return this.requirements == null ? null : this.requirements.getValue();
    }

    public Profile setRequirementsSimple(String string) {
        if (string == null) {
            this.requirements = null;
        } else {
            if (this.requirements == null) {
                this.requirements = new StringType();
            }
            this.requirements.setValue(string);
        }
        return this;
    }

    public IdType getFhirVersion() {
        return this.fhirVersion;
    }

    public Profile setFhirVersion(IdType idType) {
        this.fhirVersion = idType;
        return this;
    }

    public String getFhirVersionSimple() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public Profile setFhirVersionSimple(String string) {
        if (string == null) {
            this.fhirVersion = null;
        } else {
            if (this.fhirVersion == null) {
                this.fhirVersion = new IdType();
            }
            this.fhirVersion.setValue(string);
        }
        return this;
    }

    public List<ProfileMappingComponent> getMapping() {
        return this.mapping;
    }

    public ProfileMappingComponent addMapping() {
        ProfileMappingComponent profileMappingComponent = new ProfileMappingComponent();
        this.mapping.add(profileMappingComponent);
        return profileMappingComponent;
    }

    public List<ProfileStructureComponent> getStructure() {
        return this.structure;
    }

    public ProfileStructureComponent addStructure() {
        ProfileStructureComponent profileStructureComponent = new ProfileStructureComponent();
        this.structure.add(profileStructureComponent);
        return profileStructureComponent;
    }

    public List<ProfileExtensionDefnComponent> getExtensionDefn() {
        return this.extensionDefn;
    }

    public ProfileExtensionDefnComponent addExtensionDefn() {
        ProfileExtensionDefnComponent profileExtensionDefnComponent = new ProfileExtensionDefnComponent();
        this.extensionDefn.add(profileExtensionDefnComponent);
        return profileExtensionDefnComponent;
    }

    public List<ProfileQueryComponent> getQuery() {
        return this.query;
    }

    public ProfileQueryComponent addQuery() {
        ProfileQueryComponent profileQueryComponent = new ProfileQueryComponent();
        this.query.add(profileQueryComponent);
        return profileQueryComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "string", "The identifier that is used to identify this profile when it is referenced in a specification, model, design or an instance  (should be globally unique OID, UUID, or URI).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("version", "string", "The identifier that is used to identify this version of the profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        list.add(new Property("name", "string", "A free text natural language name identifying the Profile.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("publisher", "string", "Details of the individual or organization who accepts responsibility for publishing the profile.", 0, Integer.MAX_VALUE, this.publisher));
        list.add(new Property("telecom", "Contact", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("description", "string", "A free text natural language description of the profile and its use.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("code", "Coding", "A set of terms from external terminologies that may be used to assist with indexing and searching of templates.", 0, Integer.MAX_VALUE, this.code));
        list.add(new Property("status", "code", "The status of the profile.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("experimental", "boolean", "This profile was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        list.add(new Property("date", "dateTime", "The date that this version of the profile was published.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("requirements", "string", "The Scope and Usage that this profile was created to meet.", 0, Integer.MAX_VALUE, this.requirements));
        list.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this profile is based.", 0, Integer.MAX_VALUE, this.fhirVersion));
        list.add(new Property("mapping", "", "An external specification that the content is mapped to.", 0, Integer.MAX_VALUE, this.mapping));
        list.add(new Property("structure", "", "A constraint statement about what contents a resource or data type may have.", 0, Integer.MAX_VALUE, this.structure));
        list.add(new Property("extensionDefn", "", "An extension defined as part of the profile.", 0, Integer.MAX_VALUE, this.extensionDefn));
        list.add(new Property("query", "", "Definition of a named query and its parameters and their meaning.", 0, Integer.MAX_VALUE, this.query));
    }

    public Profile copy() {
        Profile profile = new Profile();
        profile.identifier = this.identifier == null ? null : this.identifier.copy();
        profile.version = this.version == null ? null : this.version.copy();
        profile.name = this.name == null ? null : this.name.copy();
        profile.publisher = this.publisher == null ? null : this.publisher.copy();
        profile.telecom = new ArrayList<Contact>();
        for (Contact element : this.telecom) {
            profile.telecom.add(element.copy());
        }
        profile.description = this.description == null ? null : this.description.copy();
        profile.code = new ArrayList<Coding>();
        for (Coding coding : this.code) {
            profile.code.add(coding.copy());
        }
        profile.status = this.status == null ? null : this.status.copy();
        profile.experimental = this.experimental == null ? null : this.experimental.copy();
        profile.date = this.date == null ? null : this.date.copy();
        profile.requirements = this.requirements == null ? null : this.requirements.copy();
        profile.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        profile.mapping = new ArrayList<ProfileMappingComponent>();
        for (ProfileMappingComponent profileMappingComponent : this.mapping) {
            profile.mapping.add(profileMappingComponent.copy());
        }
        profile.structure = new ArrayList<ProfileStructureComponent>();
        for (ProfileStructureComponent profileStructureComponent : this.structure) {
            profile.structure.add(profileStructureComponent.copy());
        }
        profile.extensionDefn = new ArrayList<ProfileExtensionDefnComponent>();
        for (ProfileExtensionDefnComponent profileExtensionDefnComponent : this.extensionDefn) {
            profile.extensionDefn.add(profileExtensionDefnComponent.copy());
        }
        profile.query = new ArrayList<ProfileQueryComponent>();
        for (ProfileQueryComponent profileQueryComponent : this.query) {
            profile.query.add(profileQueryComponent.copy());
        }
        return profile;
    }

    protected Profile typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Profile;
    }

    public static class ProfileQueryComponent
    extends BackboneElement {
        protected StringType name;
        protected StringType documentation;
        protected List<ProfileStructureSearchParamComponent> parameter = new ArrayList<ProfileStructureSearchParamComponent>();
        private static final long serialVersionUID = -816827533L;

        public ProfileQueryComponent() {
        }

        public ProfileQueryComponent(StringType stringType, StringType stringType2) {
            this.name = stringType;
            this.documentation = stringType2;
        }

        public StringType getName() {
            return this.name;
        }

        public ProfileQueryComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ProfileQueryComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ProfileQueryComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ProfileQueryComponent setDocumentationSimple(String string) {
            if (this.documentation == null) {
                this.documentation = new StringType();
            }
            this.documentation.setValue(string);
            return this;
        }

        public List<ProfileStructureSearchParamComponent> getParameter() {
            return this.parameter;
        }

        public ProfileStructureSearchParamComponent addParameter() {
            ProfileStructureSearchParamComponent profileStructureSearchParamComponent = new ProfileStructureSearchParamComponent();
            this.parameter.add(profileStructureSearchParamComponent);
            return profileStructureSearchParamComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "The name of a query, which is used in the URI from Conformance statements declaring use of the query.  Typically this will also be the name for the _query parameter when the query is called, though in some cases it may be aliased by a server to avoid collisions.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("documentation", "string", "Description of the query - the functionality it offers, and considerations about how it functions and to use it.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("parameter", "@Profile.structure.searchParam", "A parameter of a named query.", 0, Integer.MAX_VALUE, this.parameter));
        }

        public ProfileQueryComponent copy() {
            ProfileQueryComponent profileQueryComponent = new ProfileQueryComponent();
            profileQueryComponent.name = this.name == null ? null : this.name.copy();
            profileQueryComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            profileQueryComponent.parameter = new ArrayList<ProfileStructureSearchParamComponent>();
            for (ProfileStructureSearchParamComponent profileStructureSearchParamComponent : this.parameter) {
                profileQueryComponent.parameter.add(profileStructureSearchParamComponent.copy());
            }
            return profileQueryComponent;
        }
    }

    public static class ProfileExtensionDefnComponent
    extends BackboneElement {
        protected CodeType code;
        protected StringType display;
        protected Enumeration<ExtensionContext> contextType;
        protected List<StringType> context = new ArrayList<StringType>();
        protected ElementDefinitionComponent definition;
        private static final long serialVersionUID = 39730526L;

        public ProfileExtensionDefnComponent() {
        }

        public ProfileExtensionDefnComponent(CodeType codeType, Enumeration<ExtensionContext> enumeration, ElementDefinitionComponent elementDefinitionComponent) {
            this.code = codeType;
            this.contextType = enumeration;
            this.definition = elementDefinitionComponent;
        }

        public CodeType getCode() {
            return this.code;
        }

        public ProfileExtensionDefnComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ProfileExtensionDefnComponent setCodeSimple(String string) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(string);
            return this;
        }

        public StringType getDisplay() {
            return this.display;
        }

        public ProfileExtensionDefnComponent setDisplay(StringType stringType) {
            this.display = stringType;
            return this;
        }

        public String getDisplaySimple() {
            return this.display == null ? null : this.display.getValue();
        }

        public ProfileExtensionDefnComponent setDisplaySimple(String string) {
            if (string == null) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(string);
            }
            return this;
        }

        public Enumeration<ExtensionContext> getContextType() {
            return this.contextType;
        }

        public ProfileExtensionDefnComponent setContextType(Enumeration<ExtensionContext> enumeration) {
            this.contextType = enumeration;
            return this;
        }

        public ExtensionContext getContextTypeSimple() {
            return this.contextType == null ? null : this.contextType.getValue();
        }

        public ProfileExtensionDefnComponent setContextTypeSimple(ExtensionContext extensionContext) {
            if (this.contextType == null) {
                this.contextType = new Enumeration();
            }
            this.contextType.setValue(extensionContext);
            return this;
        }

        public List<StringType> getContext() {
            return this.context;
        }

        public StringType addContext() {
            StringType stringType = new StringType();
            this.context.add(stringType);
            return stringType;
        }

        public StringType addContextSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.context.add(stringType);
            return stringType;
        }

        public boolean hasContextSimple(String string) {
            for (StringType stringType : this.context) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public ElementDefinitionComponent getDefinition() {
            return this.definition;
        }

        public ProfileExtensionDefnComponent setDefinition(ElementDefinitionComponent elementDefinitionComponent) {
            this.definition = elementDefinitionComponent;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "code", "A unique code (within the profile) used to identify the extension.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("display", "string", "Defined so that applications can use this name when displaying the value of the extension to the user.", 0, Integer.MAX_VALUE, this.display));
            list.add(new Property("contextType", "code", "Identifies the type of context to which the extension applies.", 0, Integer.MAX_VALUE, this.contextType));
            list.add(new Property("context", "string", "Identifies the types of resource or data type elements to which the extension can be applied.", 0, Integer.MAX_VALUE, this.context));
            list.add(new Property("definition", "@Profile.structure.element.definition", "Definition of the extension and its content.", 0, Integer.MAX_VALUE, this.definition));
        }

        public ProfileExtensionDefnComponent copy() {
            ProfileExtensionDefnComponent profileExtensionDefnComponent = new ProfileExtensionDefnComponent();
            profileExtensionDefnComponent.code = this.code == null ? null : this.code.copy();
            profileExtensionDefnComponent.display = this.display == null ? null : this.display.copy();
            profileExtensionDefnComponent.contextType = this.contextType == null ? null : this.contextType.copy();
            profileExtensionDefnComponent.context = new ArrayList<StringType>();
            for (StringType stringType : this.context) {
                profileExtensionDefnComponent.context.add(stringType.copy());
            }
            profileExtensionDefnComponent.definition = this.definition == null ? null : this.definition.copy();
            return profileExtensionDefnComponent;
        }
    }

    public static class ProfileStructureSearchParamComponent
    extends BackboneElement {
        protected StringType name;
        protected Enumeration<SearchParamType> type;
        protected StringType documentation;
        protected StringType xpath;
        protected List<CodeType> target = new ArrayList<CodeType>();
        private static final long serialVersionUID = -1550477651L;

        public ProfileStructureSearchParamComponent() {
        }

        public ProfileStructureSearchParamComponent(StringType stringType, Enumeration<SearchParamType> enumeration, StringType stringType2) {
            this.name = stringType;
            this.type = enumeration;
            this.documentation = stringType2;
        }

        public StringType getName() {
            return this.name;
        }

        public ProfileStructureSearchParamComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ProfileStructureSearchParamComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public Enumeration<SearchParamType> getType() {
            return this.type;
        }

        public ProfileStructureSearchParamComponent setType(Enumeration<SearchParamType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public SearchParamType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ProfileStructureSearchParamComponent setTypeSimple(SearchParamType searchParamType) {
            if (this.type == null) {
                this.type = new Enumeration();
            }
            this.type.setValue(searchParamType);
            return this;
        }

        public StringType getDocumentation() {
            return this.documentation;
        }

        public ProfileStructureSearchParamComponent setDocumentation(StringType stringType) {
            this.documentation = stringType;
            return this;
        }

        public String getDocumentationSimple() {
            return this.documentation == null ? null : this.documentation.getValue();
        }

        public ProfileStructureSearchParamComponent setDocumentationSimple(String string) {
            if (this.documentation == null) {
                this.documentation = new StringType();
            }
            this.documentation.setValue(string);
            return this;
        }

        public StringType getXpath() {
            return this.xpath;
        }

        public ProfileStructureSearchParamComponent setXpath(StringType stringType) {
            this.xpath = stringType;
            return this;
        }

        public String getXpathSimple() {
            return this.xpath == null ? null : this.xpath.getValue();
        }

        public ProfileStructureSearchParamComponent setXpathSimple(String string) {
            if (string == null) {
                this.xpath = null;
            } else {
                if (this.xpath == null) {
                    this.xpath = new StringType();
                }
                this.xpath.setValue(string);
            }
            return this;
        }

        public List<CodeType> getTarget() {
            return this.target;
        }

        public CodeType addTarget() {
            CodeType codeType = new CodeType();
            this.target.add(codeType);
            return codeType;
        }

        public CodeType addTargetSimple(String string) {
            CodeType codeType = new CodeType();
            codeType.setValue(string);
            this.target.add(codeType);
            return codeType;
        }

        public boolean hasTargetSimple(String string) {
            for (CodeType codeType : this.target) {
                if (!codeType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "The name of the standard or custom search parameter.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("type", "code", "The type of value a search parameter refers to, and how the content is interpreted.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("documentation", "string", "A specification for search parameters. For standard parameters, provides additional information on how the parameter is used in this solution.  For custom parameters, provides a description of what the parameter does.", 0, Integer.MAX_VALUE, this.documentation));
            list.add(new Property("xpath", "string", "An XPath expression that returns a set of elements for the search parameter.", 0, Integer.MAX_VALUE, this.xpath));
            list.add(new Property("target", "code", "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target));
        }

        public ProfileStructureSearchParamComponent copy() {
            ProfileStructureSearchParamComponent profileStructureSearchParamComponent = new ProfileStructureSearchParamComponent();
            profileStructureSearchParamComponent.name = this.name == null ? null : this.name.copy();
            profileStructureSearchParamComponent.type = this.type == null ? null : this.type.copy();
            profileStructureSearchParamComponent.documentation = this.documentation == null ? null : this.documentation.copy();
            profileStructureSearchParamComponent.xpath = this.xpath == null ? null : this.xpath.copy();
            profileStructureSearchParamComponent.target = new ArrayList<CodeType>();
            for (CodeType codeType : this.target) {
                profileStructureSearchParamComponent.target.add(codeType.copy());
            }
            return profileStructureSearchParamComponent;
        }
    }

    public static class ElementDefinitionMappingComponent
    extends BackboneElement {
        protected IdType identity;
        protected StringType map;
        private static final long serialVersionUID = -450627426L;

        public ElementDefinitionMappingComponent() {
        }

        public ElementDefinitionMappingComponent(IdType idType, StringType stringType) {
            this.identity = idType;
            this.map = stringType;
        }

        public IdType getIdentity() {
            return this.identity;
        }

        public ElementDefinitionMappingComponent setIdentity(IdType idType) {
            this.identity = idType;
            return this;
        }

        public String getIdentitySimple() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public ElementDefinitionMappingComponent setIdentitySimple(String string) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(string);
            return this;
        }

        public StringType getMap() {
            return this.map;
        }

        public ElementDefinitionMappingComponent setMap(StringType stringType) {
            this.map = stringType;
            return this;
        }

        public String getMapSimple() {
            return this.map == null ? null : this.map.getValue();
        }

        public ElementDefinitionMappingComponent setMapSimple(String string) {
            if (this.map == null) {
                this.map = new StringType();
            }
            this.map.setValue(string);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identity", "id", "An internal reference to the definition of a mapping.", 0, Integer.MAX_VALUE, this.identity));
            list.add(new Property("map", "string", "Expresses what part of the target specification corresponds to this element.", 0, Integer.MAX_VALUE, this.map));
        }

        public ElementDefinitionMappingComponent copy() {
            ElementDefinitionMappingComponent elementDefinitionMappingComponent = new ElementDefinitionMappingComponent();
            elementDefinitionMappingComponent.identity = this.identity == null ? null : this.identity.copy();
            elementDefinitionMappingComponent.map = this.map == null ? null : this.map.copy();
            return elementDefinitionMappingComponent;
        }
    }

    public static class ElementDefinitionBindingComponent
    extends BackboneElement {
        protected StringType name;
        protected BooleanType isExtensible;
        protected Enumeration<BindingConformance> conformance;
        protected StringType description;
        protected Type reference;
        private static final long serialVersionUID = 1041151319L;

        public ElementDefinitionBindingComponent() {
        }

        public ElementDefinitionBindingComponent(StringType stringType, BooleanType booleanType) {
            this.name = stringType;
            this.isExtensible = booleanType;
        }

        public StringType getName() {
            return this.name;
        }

        public ElementDefinitionBindingComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ElementDefinitionBindingComponent setNameSimple(String string) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(string);
            return this;
        }

        public BooleanType getIsExtensible() {
            return this.isExtensible;
        }

        public ElementDefinitionBindingComponent setIsExtensible(BooleanType booleanType) {
            this.isExtensible = booleanType;
            return this;
        }

        public boolean getIsExtensibleSimple() {
            return this.isExtensible == null ? false : this.isExtensible.getValue();
        }

        public ElementDefinitionBindingComponent setIsExtensibleSimple(boolean bl) {
            if (this.isExtensible == null) {
                this.isExtensible = new BooleanType();
            }
            this.isExtensible.setValue(bl);
            return this;
        }

        public Enumeration<BindingConformance> getConformance() {
            return this.conformance;
        }

        public ElementDefinitionBindingComponent setConformance(Enumeration<BindingConformance> enumeration) {
            this.conformance = enumeration;
            return this;
        }

        public BindingConformance getConformanceSimple() {
            return this.conformance == null ? null : this.conformance.getValue();
        }

        public ElementDefinitionBindingComponent setConformanceSimple(BindingConformance bindingConformance) {
            if (bindingConformance == null) {
                this.conformance = null;
            } else {
                if (this.conformance == null) {
                    this.conformance = new Enumeration();
                }
                this.conformance.setValue(bindingConformance);
            }
            return this;
        }

        public StringType getDescription() {
            return this.description;
        }

        public ElementDefinitionBindingComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public ElementDefinitionBindingComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public Type getReference() {
            return this.reference;
        }

        public ElementDefinitionBindingComponent setReference(Type type) {
            this.reference = type;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "string", "A descriptive name for this - can be useful for generating implementation artifacts.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("isExtensible", "boolean", "If true, then conformant systems may use additional codes or (where the data type permits) text alone to convey concepts not covered by the set of codes identified in the binding.  If false, then conformant systems are constrained to the provided codes alone.", 0, Integer.MAX_VALUE, this.isExtensible));
            list.add(new Property("conformance", "code", "Indicates the degree of conformance expectations associated with this binding.", 0, Integer.MAX_VALUE, this.conformance));
            list.add(new Property("description", "string", "Describes the intended use of this particular set of codes.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("reference[x]", "uri|Resource(ValueSet)", "Points to the value set or external definition that identifies the set of codes to be used.", 0, Integer.MAX_VALUE, this.reference));
        }

        public ElementDefinitionBindingComponent copy() {
            ElementDefinitionBindingComponent elementDefinitionBindingComponent = new ElementDefinitionBindingComponent();
            elementDefinitionBindingComponent.name = this.name == null ? null : this.name.copy();
            elementDefinitionBindingComponent.isExtensible = this.isExtensible == null ? null : this.isExtensible.copy();
            elementDefinitionBindingComponent.conformance = this.conformance == null ? null : this.conformance.copy();
            elementDefinitionBindingComponent.description = this.description == null ? null : this.description.copy();
            elementDefinitionBindingComponent.reference = this.reference == null ? null : this.reference.copy();
            return elementDefinitionBindingComponent;
        }
    }

    public static class ElementDefinitionConstraintComponent
    extends BackboneElement {
        protected IdType key;
        protected StringType name;
        protected Enumeration<ConstraintSeverity> severity;
        protected StringType human;
        protected StringType xpath;
        private static final long serialVersionUID = -1195616532L;

        public ElementDefinitionConstraintComponent() {
        }

        public ElementDefinitionConstraintComponent(IdType idType, Enumeration<ConstraintSeverity> enumeration, StringType stringType, StringType stringType2) {
            this.key = idType;
            this.severity = enumeration;
            this.human = stringType;
            this.xpath = stringType2;
        }

        public IdType getKey() {
            return this.key;
        }

        public ElementDefinitionConstraintComponent setKey(IdType idType) {
            this.key = idType;
            return this;
        }

        public String getKeySimple() {
            return this.key == null ? null : this.key.getValue();
        }

        public ElementDefinitionConstraintComponent setKeySimple(String string) {
            if (this.key == null) {
                this.key = new IdType();
            }
            this.key.setValue(string);
            return this;
        }

        public StringType getName() {
            return this.name;
        }

        public ElementDefinitionConstraintComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ElementDefinitionConstraintComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public Enumeration<ConstraintSeverity> getSeverity() {
            return this.severity;
        }

        public ElementDefinitionConstraintComponent setSeverity(Enumeration<ConstraintSeverity> enumeration) {
            this.severity = enumeration;
            return this;
        }

        public ConstraintSeverity getSeveritySimple() {
            return this.severity == null ? null : this.severity.getValue();
        }

        public ElementDefinitionConstraintComponent setSeveritySimple(ConstraintSeverity constraintSeverity) {
            if (this.severity == null) {
                this.severity = new Enumeration();
            }
            this.severity.setValue(constraintSeverity);
            return this;
        }

        public StringType getHuman() {
            return this.human;
        }

        public ElementDefinitionConstraintComponent setHuman(StringType stringType) {
            this.human = stringType;
            return this;
        }

        public String getHumanSimple() {
            return this.human == null ? null : this.human.getValue();
        }

        public ElementDefinitionConstraintComponent setHumanSimple(String string) {
            if (this.human == null) {
                this.human = new StringType();
            }
            this.human.setValue(string);
            return this;
        }

        public StringType getXpath() {
            return this.xpath;
        }

        public ElementDefinitionConstraintComponent setXpath(StringType stringType) {
            this.xpath = stringType;
            return this;
        }

        public String getXpathSimple() {
            return this.xpath == null ? null : this.xpath.getValue();
        }

        public ElementDefinitionConstraintComponent setXpathSimple(String string) {
            if (this.xpath == null) {
                this.xpath = new StringType();
            }
            this.xpath.setValue(string);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("key", "id", "Allows identification of which elements have their cardinalities impacted by the constraint.  Will not be referenced for constraints that do not affect cardinality.", 0, Integer.MAX_VALUE, this.key));
            list.add(new Property("name", "string", "Used to label the constraint in OCL or in short displays incapable of displaying the full human description.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("severity", "code", "Identifies the impact constraint violation has on the conformance of the instance.", 0, Integer.MAX_VALUE, this.severity));
            list.add(new Property("human", "string", "Text that can be used to describe the constraint in messages identifying that the constraint has been violated.", 0, Integer.MAX_VALUE, this.human));
            list.add(new Property("xpath", "string", "XPath expression of constraint.", 0, Integer.MAX_VALUE, this.xpath));
        }

        public ElementDefinitionConstraintComponent copy() {
            ElementDefinitionConstraintComponent elementDefinitionConstraintComponent = new ElementDefinitionConstraintComponent();
            elementDefinitionConstraintComponent.key = this.key == null ? null : this.key.copy();
            elementDefinitionConstraintComponent.name = this.name == null ? null : this.name.copy();
            elementDefinitionConstraintComponent.severity = this.severity == null ? null : this.severity.copy();
            elementDefinitionConstraintComponent.human = this.human == null ? null : this.human.copy();
            elementDefinitionConstraintComponent.xpath = this.xpath == null ? null : this.xpath.copy();
            return elementDefinitionConstraintComponent;
        }
    }

    public static class TypeRefComponent
    extends BackboneElement {
        protected CodeType code;
        protected UriType profile;
        protected List<Enumeration<ResourceAggregationMode>> aggregation = new ArrayList<Enumeration<ResourceAggregationMode>>();
        private static final long serialVersionUID = -1402455002L;

        public TypeRefComponent() {
        }

        public TypeRefComponent(CodeType codeType) {
            this.code = codeType;
        }

        public CodeType getCode() {
            return this.code;
        }

        public TypeRefComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public TypeRefComponent setCodeSimple(String string) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(string);
            return this;
        }

        public UriType getProfile() {
            return this.profile;
        }

        public TypeRefComponent setProfile(UriType uriType) {
            this.profile = uriType;
            return this;
        }

        public String getProfileSimple() {
            return this.profile == null ? null : this.profile.getValue();
        }

        public TypeRefComponent setProfileSimple(String string) {
            if (string == null) {
                this.profile = null;
            } else {
                if (this.profile == null) {
                    this.profile = new UriType();
                }
                this.profile.setValue(string);
            }
            return this;
        }

        public List<Enumeration<ResourceAggregationMode>> getAggregation() {
            return this.aggregation;
        }

        public Enumeration<ResourceAggregationMode> addAggregation() {
            Enumeration<ResourceAggregationMode> enumeration = new Enumeration<ResourceAggregationMode>();
            this.aggregation.add(enumeration);
            return enumeration;
        }

        public Enumeration<ResourceAggregationMode> addAggregationSimple(ResourceAggregationMode resourceAggregationMode) {
            Enumeration<ResourceAggregationMode> enumeration = new Enumeration<ResourceAggregationMode>();
            enumeration.setValue(resourceAggregationMode);
            this.aggregation.add(enumeration);
            return enumeration;
        }

        public boolean hasAggregationSimple(ResourceAggregationMode resourceAggregationMode) {
            for (Enumeration<ResourceAggregationMode> enumeration : this.aggregation) {
                if (!enumeration.getValue().equals((Object)resourceAggregationMode)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "code", "Name of Data type or Resource.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("profile", "uri", "Identifies a profile that SHALL hold for resources or datatypes referenced as the type of this element. Can be a local reference - to another structure in this profile, or a reference to a structure in another profile.", 0, Integer.MAX_VALUE, this.profile));
            list.add(new Property("aggregation", "code", "If the type is a reference to another resource, how the resource is or can be aggreated - is it a contained resource, or a reference, and if the context is a bundle, is it included in the bundle.", 0, Integer.MAX_VALUE, this.aggregation));
        }

        public TypeRefComponent copy() {
            TypeRefComponent typeRefComponent = new TypeRefComponent();
            typeRefComponent.code = this.code == null ? null : this.code.copy();
            typeRefComponent.profile = this.profile == null ? null : this.profile.copy();
            typeRefComponent.aggregation = new ArrayList<Enumeration<ResourceAggregationMode>>();
            for (Enumeration<ResourceAggregationMode> enumeration : this.aggregation) {
                typeRefComponent.aggregation.add((Enumeration<ResourceAggregationMode>)enumeration.copy());
            }
            return typeRefComponent;
        }
    }

    public static class ElementDefinitionComponent
    extends BackboneElement {
        protected StringType short_;
        protected StringType formal;
        protected StringType comments;
        protected StringType requirements;
        protected List<StringType> synonym = new ArrayList<StringType>();
        protected IntegerType min;
        protected StringType max;
        protected List<TypeRefComponent> type = new ArrayList<TypeRefComponent>();
        protected StringType nameReference;
        protected Type value;
        protected Type example;
        protected IntegerType maxLength;
        protected List<IdType> condition = new ArrayList<IdType>();
        protected List<ElementDefinitionConstraintComponent> constraint = new ArrayList<ElementDefinitionConstraintComponent>();
        protected BooleanType mustSupport;
        protected BooleanType isModifier;
        protected ElementDefinitionBindingComponent binding;
        protected List<ElementDefinitionMappingComponent> mapping = new ArrayList<ElementDefinitionMappingComponent>();
        private static final long serialVersionUID = 321886804L;

        public ElementDefinitionComponent() {
        }

        public ElementDefinitionComponent(StringType stringType, StringType stringType2, IntegerType integerType, StringType stringType3, BooleanType booleanType) {
            this.short_ = stringType;
            this.formal = stringType2;
            this.min = integerType;
            this.max = stringType3;
            this.isModifier = booleanType;
        }

        public StringType getShort() {
            return this.short_;
        }

        public ElementDefinitionComponent setShort(StringType stringType) {
            this.short_ = stringType;
            return this;
        }

        public String getShortSimple() {
            return this.short_ == null ? null : this.short_.getValue();
        }

        public ElementDefinitionComponent setShortSimple(String string) {
            if (this.short_ == null) {
                this.short_ = new StringType();
            }
            this.short_.setValue(string);
            return this;
        }

        public StringType getFormal() {
            return this.formal;
        }

        public ElementDefinitionComponent setFormal(StringType stringType) {
            this.formal = stringType;
            return this;
        }

        public String getFormalSimple() {
            return this.formal == null ? null : this.formal.getValue();
        }

        public ElementDefinitionComponent setFormalSimple(String string) {
            if (this.formal == null) {
                this.formal = new StringType();
            }
            this.formal.setValue(string);
            return this;
        }

        public StringType getComments() {
            return this.comments;
        }

        public ElementDefinitionComponent setComments(StringType stringType) {
            this.comments = stringType;
            return this;
        }

        public String getCommentsSimple() {
            return this.comments == null ? null : this.comments.getValue();
        }

        public ElementDefinitionComponent setCommentsSimple(String string) {
            if (string == null) {
                this.comments = null;
            } else {
                if (this.comments == null) {
                    this.comments = new StringType();
                }
                this.comments.setValue(string);
            }
            return this;
        }

        public StringType getRequirements() {
            return this.requirements;
        }

        public ElementDefinitionComponent setRequirements(StringType stringType) {
            this.requirements = stringType;
            return this;
        }

        public String getRequirementsSimple() {
            return this.requirements == null ? null : this.requirements.getValue();
        }

        public ElementDefinitionComponent setRequirementsSimple(String string) {
            if (string == null) {
                this.requirements = null;
            } else {
                if (this.requirements == null) {
                    this.requirements = new StringType();
                }
                this.requirements.setValue(string);
            }
            return this;
        }

        public List<StringType> getSynonym() {
            return this.synonym;
        }

        public StringType addSynonym() {
            StringType stringType = new StringType();
            this.synonym.add(stringType);
            return stringType;
        }

        public StringType addSynonymSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.synonym.add(stringType);
            return stringType;
        }

        public boolean hasSynonymSimple(String string) {
            for (StringType stringType : this.synonym) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public IntegerType getMin() {
            return this.min;
        }

        public ElementDefinitionComponent setMin(IntegerType integerType) {
            this.min = integerType;
            return this;
        }

        public int getMinSimple() {
            return this.min == null ? null : Integer.valueOf(this.min.getValue());
        }

        public ElementDefinitionComponent setMinSimple(int n) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue(n);
            return this;
        }

        public StringType getMax() {
            return this.max;
        }

        public ElementDefinitionComponent setMax(StringType stringType) {
            this.max = stringType;
            return this;
        }

        public String getMaxSimple() {
            return this.max == null ? null : this.max.getValue();
        }

        public ElementDefinitionComponent setMaxSimple(String string) {
            if (this.max == null) {
                this.max = new StringType();
            }
            this.max.setValue(string);
            return this;
        }

        public List<TypeRefComponent> getType() {
            return this.type;
        }

        public TypeRefComponent addType() {
            TypeRefComponent typeRefComponent = new TypeRefComponent();
            this.type.add(typeRefComponent);
            return typeRefComponent;
        }

        public StringType getNameReference() {
            return this.nameReference;
        }

        public ElementDefinitionComponent setNameReference(StringType stringType) {
            this.nameReference = stringType;
            return this;
        }

        public String getNameReferenceSimple() {
            return this.nameReference == null ? null : this.nameReference.getValue();
        }

        public ElementDefinitionComponent setNameReferenceSimple(String string) {
            if (string == null) {
                this.nameReference = null;
            } else {
                if (this.nameReference == null) {
                    this.nameReference = new StringType();
                }
                this.nameReference.setValue(string);
            }
            return this;
        }

        public Type getValue() {
            return this.value;
        }

        public ElementDefinitionComponent setValue(Type type) {
            this.value = type;
            return this;
        }

        public Type getExample() {
            return this.example;
        }

        public ElementDefinitionComponent setExample(Type type) {
            this.example = type;
            return this;
        }

        public IntegerType getMaxLength() {
            return this.maxLength;
        }

        public ElementDefinitionComponent setMaxLength(IntegerType integerType) {
            this.maxLength = integerType;
            return this;
        }

        public int getMaxLengthSimple() {
            return this.maxLength == null ? null : Integer.valueOf(this.maxLength.getValue());
        }

        public ElementDefinitionComponent setMaxLengthSimple(int n) {
            if (n == -1) {
                this.maxLength = null;
            } else {
                if (this.maxLength == null) {
                    this.maxLength = new IntegerType();
                }
                this.maxLength.setValue(n);
            }
            return this;
        }

        public List<IdType> getCondition() {
            return this.condition;
        }

        public IdType addCondition() {
            IdType idType = new IdType();
            this.condition.add(idType);
            return idType;
        }

        public IdType addConditionSimple(String string) {
            IdType idType = new IdType();
            idType.setValue(string);
            this.condition.add(idType);
            return idType;
        }

        public boolean hasConditionSimple(String string) {
            for (IdType idType : this.condition) {
                if (!idType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public List<ElementDefinitionConstraintComponent> getConstraint() {
            return this.constraint;
        }

        public ElementDefinitionConstraintComponent addConstraint() {
            ElementDefinitionConstraintComponent elementDefinitionConstraintComponent = new ElementDefinitionConstraintComponent();
            this.constraint.add(elementDefinitionConstraintComponent);
            return elementDefinitionConstraintComponent;
        }

        public BooleanType getMustSupport() {
            return this.mustSupport;
        }

        public ElementDefinitionComponent setMustSupport(BooleanType booleanType) {
            this.mustSupport = booleanType;
            return this;
        }

        public boolean getMustSupportSimple() {
            return this.mustSupport == null ? false : this.mustSupport.getValue();
        }

        public ElementDefinitionComponent setMustSupportSimple(boolean bl) {
            if (!bl) {
                this.mustSupport = null;
            } else {
                if (this.mustSupport == null) {
                    this.mustSupport = new BooleanType();
                }
                this.mustSupport.setValue(bl);
            }
            return this;
        }

        public BooleanType getIsModifier() {
            return this.isModifier;
        }

        public ElementDefinitionComponent setIsModifier(BooleanType booleanType) {
            this.isModifier = booleanType;
            return this;
        }

        public boolean getIsModifierSimple() {
            return this.isModifier == null ? false : this.isModifier.getValue();
        }

        public ElementDefinitionComponent setIsModifierSimple(boolean bl) {
            if (this.isModifier == null) {
                this.isModifier = new BooleanType();
            }
            this.isModifier.setValue(bl);
            return this;
        }

        public ElementDefinitionBindingComponent getBinding() {
            return this.binding;
        }

        public ElementDefinitionComponent setBinding(ElementDefinitionBindingComponent elementDefinitionBindingComponent) {
            this.binding = elementDefinitionBindingComponent;
            return this;
        }

        public List<ElementDefinitionMappingComponent> getMapping() {
            return this.mapping;
        }

        public ElementDefinitionMappingComponent addMapping() {
            ElementDefinitionMappingComponent elementDefinitionMappingComponent = new ElementDefinitionMappingComponent();
            this.mapping.add(elementDefinitionMappingComponent);
            return elementDefinitionMappingComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("short", "string", "A concise definition that  is shown in the generated XML format that summarizes profiles (used throughout the specification).", 0, Integer.MAX_VALUE, this.short_));
            list.add(new Property("formal", "string", "The definition SHALL be consistent with the base definition, but convey the meaning of the element in the particular context of use of the resource.", 0, Integer.MAX_VALUE, this.formal));
            list.add(new Property("comments", "string", "Comments about the use of the element, including notes about how to use the data properly, exceptions to proper use, etc.", 0, Integer.MAX_VALUE, this.comments));
            list.add(new Property("requirements", "string", "Explains why this element is needed and why it's been constrained as it has.", 0, Integer.MAX_VALUE, this.requirements));
            list.add(new Property("synonym", "string", "Identifies additional names by which this element might also be known.", 0, Integer.MAX_VALUE, this.synonym));
            list.add(new Property("min", "integer", "The minimum number of times this element SHALL appear in the instance.", 0, Integer.MAX_VALUE, this.min));
            list.add(new Property("max", "string", "The maximum number of times this element is permitted to appear in the instance.", 0, Integer.MAX_VALUE, this.max));
            list.add(new Property("type", "", "The data type or resource that the value of this element is permitted to be.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("nameReference", "string", "Identifies the name of a slice defined elsewhere in the profile whose constraints should be applied to the current element.", 0, Integer.MAX_VALUE, this.nameReference));
            list.add(new Property("value[x]", "*", "Specifies a primitive value that SHALL hold for this element in the instance.", 0, Integer.MAX_VALUE, this.value));
            list.add(new Property("example[x]", "*", "An example value for this element.", 0, Integer.MAX_VALUE, this.example));
            list.add(new Property("maxLength", "integer", "Indicates the shortest length that SHALL be supported by conformant instances without truncation.", 0, Integer.MAX_VALUE, this.maxLength));
            list.add(new Property("condition", "id", "A reference to an invariant that may make additional statements about the cardinality or value in the instance.", 0, Integer.MAX_VALUE, this.condition));
            list.add(new Property("constraint", "", "Formal constraints such as co-occurrence and other constraints that can be computationally evaluated within the context of the instance.", 0, Integer.MAX_VALUE, this.constraint));
            list.add(new Property("mustSupport", "boolean", "If true, conformant resource authors SHALL be capable of providing a value for the element and resource consumers SHALL be capable of extracting and doing something useful with the data element.  If false, the element may be ignored and not supported.", 0, Integer.MAX_VALUE, this.mustSupport));
            list.add(new Property("isModifier", "boolean", "If true, the value of this element affects the interpretation of the element or resource that contains it, and the value of the element cannot be ignored. Typically, this is used for status, negation and qualification codes. The effect of this is that the element cannot be ignored by systems: they SHALL either recognize the element and process it, and/or a pre-determination has been made that it is not relevant to their particular system.", 0, Integer.MAX_VALUE, this.isModifier));
            list.add(new Property("binding", "", "Binds to a value set if this element is coded (code, Coding, CodeableConcept).", 0, Integer.MAX_VALUE, this.binding));
            list.add(new Property("mapping", "", "Identifies a concept from an external specification that roughly corresponds to this element.", 0, Integer.MAX_VALUE, this.mapping));
        }

        public ElementDefinitionComponent copy() {
            ElementDefinitionComponent elementDefinitionComponent = new ElementDefinitionComponent();
            elementDefinitionComponent.short_ = this.short_ == null ? null : this.short_.copy();
            elementDefinitionComponent.formal = this.formal == null ? null : this.formal.copy();
            elementDefinitionComponent.comments = this.comments == null ? null : this.comments.copy();
            elementDefinitionComponent.requirements = this.requirements == null ? null : this.requirements.copy();
            elementDefinitionComponent.synonym = new ArrayList<StringType>();
            for (StringType element : this.synonym) {
                elementDefinitionComponent.synonym.add(element.copy());
            }
            elementDefinitionComponent.min = this.min == null ? null : this.min.copy();
            elementDefinitionComponent.max = this.max == null ? null : this.max.copy();
            elementDefinitionComponent.type = new ArrayList<TypeRefComponent>();
            for (TypeRefComponent typeRefComponent : this.type) {
                elementDefinitionComponent.type.add(typeRefComponent.copy());
            }
            elementDefinitionComponent.nameReference = this.nameReference == null ? null : this.nameReference.copy();
            elementDefinitionComponent.value = this.value == null ? null : this.value.copy();
            elementDefinitionComponent.example = this.example == null ? null : this.example.copy();
            elementDefinitionComponent.maxLength = this.maxLength == null ? null : this.maxLength.copy();
            elementDefinitionComponent.condition = new ArrayList<IdType>();
            for (IdType idType : this.condition) {
                elementDefinitionComponent.condition.add(idType.copy());
            }
            elementDefinitionComponent.constraint = new ArrayList<ElementDefinitionConstraintComponent>();
            for (ElementDefinitionConstraintComponent elementDefinitionConstraintComponent : this.constraint) {
                elementDefinitionComponent.constraint.add(elementDefinitionConstraintComponent.copy());
            }
            elementDefinitionComponent.mustSupport = this.mustSupport == null ? null : this.mustSupport.copy();
            elementDefinitionComponent.isModifier = this.isModifier == null ? null : this.isModifier.copy();
            elementDefinitionComponent.binding = this.binding == null ? null : this.binding.copy();
            elementDefinitionComponent.mapping = new ArrayList<ElementDefinitionMappingComponent>();
            for (ElementDefinitionMappingComponent elementDefinitionMappingComponent : this.mapping) {
                elementDefinitionComponent.mapping.add(elementDefinitionMappingComponent.copy());
            }
            return elementDefinitionComponent;
        }
    }

    public static class ElementSlicingComponent
    extends BackboneElement {
        protected IdType discriminator;
        protected BooleanType ordered;
        protected Enumeration<ResourceSlicingRules> rules;
        private static final long serialVersionUID = -1790222992L;

        public ElementSlicingComponent() {
        }

        public ElementSlicingComponent(IdType idType, BooleanType booleanType, Enumeration<ResourceSlicingRules> enumeration) {
            this.discriminator = idType;
            this.ordered = booleanType;
            this.rules = enumeration;
        }

        public IdType getDiscriminator() {
            return this.discriminator;
        }

        public ElementSlicingComponent setDiscriminator(IdType idType) {
            this.discriminator = idType;
            return this;
        }

        public String getDiscriminatorSimple() {
            return this.discriminator == null ? null : this.discriminator.getValue();
        }

        public ElementSlicingComponent setDiscriminatorSimple(String string) {
            if (this.discriminator == null) {
                this.discriminator = new IdType();
            }
            this.discriminator.setValue(string);
            return this;
        }

        public BooleanType getOrdered() {
            return this.ordered;
        }

        public ElementSlicingComponent setOrdered(BooleanType booleanType) {
            this.ordered = booleanType;
            return this;
        }

        public boolean getOrderedSimple() {
            return this.ordered == null ? false : this.ordered.getValue();
        }

        public ElementSlicingComponent setOrderedSimple(boolean bl) {
            if (this.ordered == null) {
                this.ordered = new BooleanType();
            }
            this.ordered.setValue(bl);
            return this;
        }

        public Enumeration<ResourceSlicingRules> getRules() {
            return this.rules;
        }

        public ElementSlicingComponent setRules(Enumeration<ResourceSlicingRules> enumeration) {
            this.rules = enumeration;
            return this;
        }

        public ResourceSlicingRules getRulesSimple() {
            return this.rules == null ? null : this.rules.getValue();
        }

        public ElementSlicingComponent setRulesSimple(ResourceSlicingRules resourceSlicingRules) {
            if (this.rules == null) {
                this.rules = new Enumeration();
            }
            this.rules.setValue(resourceSlicingRules);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("discriminator", "id", "Designates which child element is used to discriminate between the slices when processing an instance. The value of the child element in the instance SHALL completely distinguish which slice the element in the resource matches based on the allowed values for that element in each of the slices.", 0, Integer.MAX_VALUE, this.discriminator));
            list.add(new Property("ordered", "boolean", "If the matching elements have to occur in the same order as defined in the profile.", 0, Integer.MAX_VALUE, this.ordered));
            list.add(new Property("rules", "code", "Whether additional slices are allowed or not. When the slices are ordered, profile authors can also say that additional slices are only allowed at the end.", 0, Integer.MAX_VALUE, this.rules));
        }

        public ElementSlicingComponent copy() {
            ElementSlicingComponent elementSlicingComponent = new ElementSlicingComponent();
            elementSlicingComponent.discriminator = this.discriminator == null ? null : this.discriminator.copy();
            elementSlicingComponent.ordered = this.ordered == null ? null : this.ordered.copy();
            elementSlicingComponent.rules = this.rules == null ? null : this.rules.copy();
            return elementSlicingComponent;
        }
    }

    public static class ElementComponent
    extends BackboneElement {
        protected StringType path;
        protected List<Enumeration<PropertyRepresentation>> representation = new ArrayList<Enumeration<PropertyRepresentation>>();
        protected StringType name;
        protected ElementSlicingComponent slicing;
        protected ElementDefinitionComponent definition;
        private static final long serialVersionUID = 1070089554L;

        public ElementComponent() {
        }

        public ElementComponent(StringType stringType) {
            this.path = stringType;
        }

        public StringType getPath() {
            return this.path;
        }

        public ElementComponent setPath(StringType stringType) {
            this.path = stringType;
            return this;
        }

        public String getPathSimple() {
            return this.path == null ? null : this.path.getValue();
        }

        public ElementComponent setPathSimple(String string) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(string);
            return this;
        }

        public List<Enumeration<PropertyRepresentation>> getRepresentation() {
            return this.representation;
        }

        public Enumeration<PropertyRepresentation> addRepresentation() {
            Enumeration<PropertyRepresentation> enumeration = new Enumeration<PropertyRepresentation>();
            this.representation.add(enumeration);
            return enumeration;
        }

        public Enumeration<PropertyRepresentation> addRepresentationSimple(PropertyRepresentation propertyRepresentation) {
            Enumeration<PropertyRepresentation> enumeration = new Enumeration<PropertyRepresentation>();
            enumeration.setValue(propertyRepresentation);
            this.representation.add(enumeration);
            return enumeration;
        }

        public boolean hasRepresentationSimple(PropertyRepresentation propertyRepresentation) {
            for (Enumeration<PropertyRepresentation> enumeration : this.representation) {
                if (!enumeration.getValue().equals((Object)propertyRepresentation)) continue;
                return true;
            }
            return false;
        }

        public StringType getName() {
            return this.name;
        }

        public ElementComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ElementComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public ElementSlicingComponent getSlicing() {
            return this.slicing;
        }

        public ElementComponent setSlicing(ElementSlicingComponent elementSlicingComponent) {
            this.slicing = elementSlicingComponent;
            return this;
        }

        public ElementDefinitionComponent getDefinition() {
            return this.definition;
        }

        public ElementComponent setDefinition(ElementDefinitionComponent elementDefinitionComponent) {
            this.definition = elementDefinitionComponent;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("path", "string", "The path identifies the element and is expressed as a '.'-separated list of ancestor elements, beginning with the name of the resource.", 0, Integer.MAX_VALUE, this.path));
            list.add(new Property("representation", "code", "Codes that define how this element is represented in instances, when the deviation varies from the normal case.", 0, Integer.MAX_VALUE, this.representation));
            list.add(new Property("name", "string", "The name of this element definition (to refer to it from other element definitions using Profile.structure.element.definition.nameReference). This is a unique name referring to a specific set of constraints applied to this element. One use of this is to provide a name to different slices of the same element.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("slicing", "", "Indicates that the element is sliced into a set of alternative definitions (there are multiple definitions on a single element in the base resource). The set of slices is any elements that come after this in the element sequence that have the same path, until a shorter path occurs (the shorter path terminates the set).", 0, Integer.MAX_VALUE, this.slicing));
            list.add(new Property("definition", "", "Definition of the content of the element to provide a more specific definition than that contained for the element in the base resource.", 0, Integer.MAX_VALUE, this.definition));
        }

        public ElementComponent copy() {
            ElementComponent elementComponent = new ElementComponent();
            elementComponent.path = this.path == null ? null : this.path.copy();
            elementComponent.representation = new ArrayList<Enumeration<PropertyRepresentation>>();
            for (Enumeration<PropertyRepresentation> enumeration : this.representation) {
                elementComponent.representation.add((Enumeration<PropertyRepresentation>)enumeration.copy());
            }
            elementComponent.name = this.name == null ? null : this.name.copy();
            elementComponent.slicing = this.slicing == null ? null : this.slicing.copy();
            elementComponent.definition = this.definition == null ? null : this.definition.copy();
            return elementComponent;
        }
    }

    public static class ProfileStructureComponent
    extends BackboneElement {
        protected CodeType type;
        protected StringType name;
        protected BooleanType publish;
        protected StringType purpose;
        protected List<ElementComponent> element = new ArrayList<ElementComponent>();
        protected List<ProfileStructureSearchParamComponent> searchParam = new ArrayList<ProfileStructureSearchParamComponent>();
        private static final long serialVersionUID = 1006253436L;

        public ProfileStructureComponent() {
        }

        public ProfileStructureComponent(CodeType codeType) {
            this.type = codeType;
        }

        public CodeType getType() {
            return this.type;
        }

        public ProfileStructureComponent setType(CodeType codeType) {
            this.type = codeType;
            return this;
        }

        public String getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public ProfileStructureComponent setTypeSimple(String string) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(string);
            return this;
        }

        public StringType getName() {
            return this.name;
        }

        public ProfileStructureComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ProfileStructureComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public BooleanType getPublish() {
            return this.publish;
        }

        public ProfileStructureComponent setPublish(BooleanType booleanType) {
            this.publish = booleanType;
            return this;
        }

        public boolean getPublishSimple() {
            return this.publish == null ? false : this.publish.getValue();
        }

        public ProfileStructureComponent setPublishSimple(boolean bl) {
            if (!bl) {
                this.publish = null;
            } else {
                if (this.publish == null) {
                    this.publish = new BooleanType();
                }
                this.publish.setValue(bl);
            }
            return this;
        }

        public StringType getPurpose() {
            return this.purpose;
        }

        public ProfileStructureComponent setPurpose(StringType stringType) {
            this.purpose = stringType;
            return this;
        }

        public String getPurposeSimple() {
            return this.purpose == null ? null : this.purpose.getValue();
        }

        public ProfileStructureComponent setPurposeSimple(String string) {
            if (string == null) {
                this.purpose = null;
            } else {
                if (this.purpose == null) {
                    this.purpose = new StringType();
                }
                this.purpose.setValue(string);
            }
            return this;
        }

        public List<ElementComponent> getElement() {
            return this.element;
        }

        public ElementComponent addElement() {
            ElementComponent elementComponent = new ElementComponent();
            this.element.add(elementComponent);
            return elementComponent;
        }

        public List<ProfileStructureSearchParamComponent> getSearchParam() {
            return this.searchParam;
        }

        public ProfileStructureSearchParamComponent addSearchParam() {
            ProfileStructureSearchParamComponent profileStructureSearchParamComponent = new ProfileStructureSearchParamComponent();
            this.searchParam.add(profileStructureSearchParamComponent);
            return profileStructureSearchParamComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "code", "The Resource or Data type being described.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("name", "string", "The name of this resource constraint statement (to refer to it from other resource constraints - from Profile.structure.element.definition.type.profile).", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("publish", "boolean", "This definition of a profile on a structure is published as a formal statement. Some structural definitions might be defined purely for internal use within the profile, and not intended to be used outside that context.", 0, Integer.MAX_VALUE, this.publish));
            list.add(new Property("purpose", "string", "Human summary: why describe this resource?.", 0, Integer.MAX_VALUE, this.purpose));
            list.add(new Property("element", "", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element));
            list.add(new Property("searchParam", "", "Additional search parameters for implementations to support and/or make use of.", 0, Integer.MAX_VALUE, this.searchParam));
        }

        public ProfileStructureComponent copy() {
            ProfileStructureComponent profileStructureComponent = new ProfileStructureComponent();
            profileStructureComponent.type = this.type == null ? null : this.type.copy();
            profileStructureComponent.name = this.name == null ? null : this.name.copy();
            profileStructureComponent.publish = this.publish == null ? null : this.publish.copy();
            profileStructureComponent.purpose = this.purpose == null ? null : this.purpose.copy();
            profileStructureComponent.element = new ArrayList<ElementComponent>();
            for (ElementComponent backboneElement : this.element) {
                profileStructureComponent.element.add(backboneElement.copy());
            }
            profileStructureComponent.searchParam = new ArrayList<ProfileStructureSearchParamComponent>();
            for (ProfileStructureSearchParamComponent profileStructureSearchParamComponent : this.searchParam) {
                profileStructureComponent.searchParam.add(profileStructureSearchParamComponent.copy());
            }
            return profileStructureComponent;
        }
    }

    public static class ProfileMappingComponent
    extends BackboneElement {
        protected IdType identity;
        protected UriType uri;
        protected StringType name;
        protected StringType comments;
        private static final long serialVersionUID = 299630820L;

        public ProfileMappingComponent() {
        }

        public ProfileMappingComponent(IdType idType) {
            this.identity = idType;
        }

        public IdType getIdentity() {
            return this.identity;
        }

        public ProfileMappingComponent setIdentity(IdType idType) {
            this.identity = idType;
            return this;
        }

        public String getIdentitySimple() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public ProfileMappingComponent setIdentitySimple(String string) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(string);
            return this;
        }

        public UriType getUri() {
            return this.uri;
        }

        public ProfileMappingComponent setUri(UriType uriType) {
            this.uri = uriType;
            return this;
        }

        public String getUriSimple() {
            return this.uri == null ? null : this.uri.getValue();
        }

        public ProfileMappingComponent setUriSimple(String string) {
            if (string == null) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(string);
            }
            return this;
        }

        public StringType getName() {
            return this.name;
        }

        public ProfileMappingComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public ProfileMappingComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public StringType getComments() {
            return this.comments;
        }

        public ProfileMappingComponent setComments(StringType stringType) {
            this.comments = stringType;
            return this;
        }

        public String getCommentsSimple() {
            return this.comments == null ? null : this.comments.getValue();
        }

        public ProfileMappingComponent setCommentsSimple(String string) {
            if (string == null) {
                this.comments = null;
            } else {
                if (this.comments == null) {
                    this.comments = new StringType();
                }
                this.comments.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identity", "id", "An Internal id that is used to identify this mapping set when specific mappings are made.", 0, Integer.MAX_VALUE, this.identity));
            list.add(new Property("uri", "uri", "A URI that identifies the specification that this mapping is expressed to.", 0, Integer.MAX_VALUE, this.uri));
            list.add(new Property("name", "string", "A name for the specification that is being mapped to.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("comments", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, Integer.MAX_VALUE, this.comments));
        }

        public ProfileMappingComponent copy() {
            ProfileMappingComponent profileMappingComponent = new ProfileMappingComponent();
            profileMappingComponent.identity = this.identity == null ? null : this.identity.copy();
            profileMappingComponent.uri = this.uri == null ? null : this.uri.copy();
            profileMappingComponent.name = this.name == null ? null : this.name.copy();
            profileMappingComponent.comments = this.comments == null ? null : this.comments.copy();
            return profileMappingComponent;
        }
    }

    public static class ExtensionContextEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("resource".equals(string)) {
                return ExtensionContext.resource;
            }
            if ("datatype".equals(string)) {
                return ExtensionContext.datatype;
            }
            if ("mapping".equals(string)) {
                return ExtensionContext.mapping;
            }
            if ("extension".equals(string)) {
                return ExtensionContext.extension;
            }
            throw new Exception("Unknown ExtensionContext code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ExtensionContext.resource) {
                return "resource";
            }
            if (enum_ == ExtensionContext.datatype) {
                return "datatype";
            }
            if (enum_ == ExtensionContext.mapping) {
                return "mapping";
            }
            if (enum_ == ExtensionContext.extension) {
                return "extension";
            }
            return "?";
        }
    }

    public static enum ExtensionContext {
        resource,
        datatype,
        mapping,
        extension,
        Null;


        public static ExtensionContext fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("resource".equals(string)) {
                return resource;
            }
            if ("datatype".equals(string)) {
                return datatype;
            }
            if ("mapping".equals(string)) {
                return mapping;
            }
            if ("extension".equals(string)) {
                return extension;
            }
            throw new Exception("Unknown ExtensionContext code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case resource: {
                    return "resource";
                }
                case datatype: {
                    return "datatype";
                }
                case mapping: {
                    return "mapping";
                }
                case extension: {
                    return "extension";
                }
            }
            return "?";
        }
    }

    public static class SearchParamTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("number".equals(string)) {
                return SearchParamType.number;
            }
            if ("date".equals(string)) {
                return SearchParamType.date;
            }
            if ("string".equals(string)) {
                return SearchParamType.string;
            }
            if ("token".equals(string)) {
                return SearchParamType.token;
            }
            if ("reference".equals(string)) {
                return SearchParamType.reference;
            }
            if ("composite".equals(string)) {
                return SearchParamType.composite;
            }
            if ("quantity".equals(string)) {
                return SearchParamType.quantity;
            }
            throw new Exception("Unknown SearchParamType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == SearchParamType.number) {
                return "number";
            }
            if (enum_ == SearchParamType.date) {
                return "date";
            }
            if (enum_ == SearchParamType.string) {
                return "string";
            }
            if (enum_ == SearchParamType.token) {
                return "token";
            }
            if (enum_ == SearchParamType.reference) {
                return "reference";
            }
            if (enum_ == SearchParamType.composite) {
                return "composite";
            }
            if (enum_ == SearchParamType.quantity) {
                return "quantity";
            }
            return "?";
        }
    }

    public static enum SearchParamType {
        number,
        date,
        string,
        token,
        reference,
        composite,
        quantity,
        Null;


        public static SearchParamType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("number".equals(string)) {
                return number;
            }
            if ("date".equals(string)) {
                return date;
            }
            if ("string".equals(string)) {
                return SearchParamType.string;
            }
            if ("token".equals(string)) {
                return token;
            }
            if ("reference".equals(string)) {
                return reference;
            }
            if ("composite".equals(string)) {
                return composite;
            }
            if ("quantity".equals(string)) {
                return quantity;
            }
            throw new Exception("Unknown SearchParamType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case number: {
                    return "number";
                }
                case date: {
                    return "date";
                }
                case string: {
                    return "string";
                }
                case token: {
                    return "token";
                }
                case reference: {
                    return "reference";
                }
                case composite: {
                    return "composite";
                }
                case quantity: {
                    return "quantity";
                }
            }
            return "?";
        }
    }

    public static class BindingConformanceEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("required".equals(string)) {
                return BindingConformance.required;
            }
            if ("preferred".equals(string)) {
                return BindingConformance.preferred;
            }
            if ("example".equals(string)) {
                return BindingConformance.example;
            }
            throw new Exception("Unknown BindingConformance code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == BindingConformance.required) {
                return "required";
            }
            if (enum_ == BindingConformance.preferred) {
                return "preferred";
            }
            if (enum_ == BindingConformance.example) {
                return "example";
            }
            return "?";
        }
    }

    public static enum BindingConformance {
        required,
        preferred,
        example,
        Null;


        public static BindingConformance fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("required".equals(string)) {
                return required;
            }
            if ("preferred".equals(string)) {
                return preferred;
            }
            if ("example".equals(string)) {
                return example;
            }
            throw new Exception("Unknown BindingConformance code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case required: {
                    return "required";
                }
                case preferred: {
                    return "preferred";
                }
                case example: {
                    return "example";
                }
            }
            return "?";
        }
    }

    public static class ConstraintSeverityEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("error".equals(string)) {
                return ConstraintSeverity.error;
            }
            if ("warning".equals(string)) {
                return ConstraintSeverity.warning;
            }
            throw new Exception("Unknown ConstraintSeverity code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ConstraintSeverity.error) {
                return "error";
            }
            if (enum_ == ConstraintSeverity.warning) {
                return "warning";
            }
            return "?";
        }
    }

    public static enum ConstraintSeverity {
        error,
        warning,
        Null;


        public static ConstraintSeverity fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("error".equals(string)) {
                return error;
            }
            if ("warning".equals(string)) {
                return warning;
            }
            throw new Exception("Unknown ConstraintSeverity code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case error: {
                    return "error";
                }
                case warning: {
                    return "warning";
                }
            }
            return "?";
        }
    }

    public static class ResourceAggregationModeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("contained".equals(string)) {
                return ResourceAggregationMode.contained;
            }
            if ("referenced".equals(string)) {
                return ResourceAggregationMode.referenced;
            }
            if ("bundled".equals(string)) {
                return ResourceAggregationMode.bundled;
            }
            throw new Exception("Unknown ResourceAggregationMode code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ResourceAggregationMode.contained) {
                return "contained";
            }
            if (enum_ == ResourceAggregationMode.referenced) {
                return "referenced";
            }
            if (enum_ == ResourceAggregationMode.bundled) {
                return "bundled";
            }
            return "?";
        }
    }

    public static enum ResourceAggregationMode {
        contained,
        referenced,
        bundled,
        Null;


        public static ResourceAggregationMode fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("contained".equals(string)) {
                return contained;
            }
            if ("referenced".equals(string)) {
                return referenced;
            }
            if ("bundled".equals(string)) {
                return bundled;
            }
            throw new Exception("Unknown ResourceAggregationMode code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case contained: {
                    return "contained";
                }
                case referenced: {
                    return "referenced";
                }
                case bundled: {
                    return "bundled";
                }
            }
            return "?";
        }
    }

    public static class ResourceSlicingRulesEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("closed".equals(string)) {
                return ResourceSlicingRules.closed;
            }
            if ("open".equals(string)) {
                return ResourceSlicingRules.open;
            }
            if ("openAtEnd".equals(string)) {
                return ResourceSlicingRules.openAtEnd;
            }
            throw new Exception("Unknown ResourceSlicingRules code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ResourceSlicingRules.closed) {
                return "closed";
            }
            if (enum_ == ResourceSlicingRules.open) {
                return "open";
            }
            if (enum_ == ResourceSlicingRules.openAtEnd) {
                return "openAtEnd";
            }
            return "?";
        }
    }

    public static enum ResourceSlicingRules {
        closed,
        open,
        openAtEnd,
        Null;


        public static ResourceSlicingRules fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("closed".equals(string)) {
                return closed;
            }
            if ("open".equals(string)) {
                return open;
            }
            if ("openAtEnd".equals(string)) {
                return openAtEnd;
            }
            throw new Exception("Unknown ResourceSlicingRules code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case closed: {
                    return "closed";
                }
                case open: {
                    return "open";
                }
                case openAtEnd: {
                    return "openAtEnd";
                }
            }
            return "?";
        }
    }

    public static class PropertyRepresentationEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("xmlAttr".equals(string)) {
                return PropertyRepresentation.xmlAttr;
            }
            throw new Exception("Unknown PropertyRepresentation code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == PropertyRepresentation.xmlAttr) {
                return "xmlAttr";
            }
            return "?";
        }
    }

    public static enum PropertyRepresentation {
        xmlAttr,
        Null;


        public static PropertyRepresentation fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("xmlAttr".equals(string)) {
                return xmlAttr;
            }
            throw new Exception("Unknown PropertyRepresentation code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case xmlAttr: {
                    return "xmlAttr";
                }
            }
            return "?";
        }
    }

    public static class ResourceProfileStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("draft".equals(string)) {
                return ResourceProfileStatus.draft;
            }
            if ("active".equals(string)) {
                return ResourceProfileStatus.active;
            }
            if ("retired".equals(string)) {
                return ResourceProfileStatus.retired;
            }
            throw new Exception("Unknown ResourceProfileStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ResourceProfileStatus.draft) {
                return "draft";
            }
            if (enum_ == ResourceProfileStatus.active) {
                return "active";
            }
            if (enum_ == ResourceProfileStatus.retired) {
                return "retired";
            }
            return "?";
        }
    }

    public static enum ResourceProfileStatus {
        draft,
        active,
        retired,
        Null;


        public static ResourceProfileStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("draft".equals(string)) {
                return draft;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("retired".equals(string)) {
                return retired;
            }
            throw new Exception("Unknown ResourceProfileStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case draft: {
                    return "draft";
                }
                case active: {
                    return "active";
                }
                case retired: {
                    return "retired";
                }
            }
            return "?";
        }
    }
}

