/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class Provenance
extends Resource {
    protected List<ResourceReference> target = new ArrayList<ResourceReference>();
    protected List<Resource> targetTarget = new ArrayList<Resource>();
    protected Period period;
    protected InstantType recorded;
    protected CodeableConcept reason;
    protected ResourceReference location;
    protected Location locationTarget;
    protected List<UriType> policy = new ArrayList<UriType>();
    protected List<ProvenanceAgentComponent> agent = new ArrayList<ProvenanceAgentComponent>();
    protected List<ProvenanceEntityComponent> entity = new ArrayList<ProvenanceEntityComponent>();
    protected StringType integritySignature;
    private static final long serialVersionUID = -5531531L;

    public Provenance() {
    }

    public Provenance(InstantType instantType) {
        this.recorded = instantType;
    }

    public List<ResourceReference> getTarget() {
        return this.target;
    }

    public ResourceReference addTarget() {
        ResourceReference resourceReference = new ResourceReference();
        this.target.add(resourceReference);
        return resourceReference;
    }

    public List<Resource> getTargetTarget() {
        return this.targetTarget;
    }

    public Period getPeriod() {
        return this.period;
    }

    public Provenance setPeriod(Period period) {
        this.period = period;
        return this;
    }

    public InstantType getRecorded() {
        return this.recorded;
    }

    public Provenance setRecorded(InstantType instantType) {
        this.recorded = instantType;
        return this;
    }

    public DateAndTime getRecordedSimple() {
        return this.recorded == null ? null : this.recorded.getValue();
    }

    public Provenance setRecordedSimple(DateAndTime dateAndTime) {
        if (this.recorded == null) {
            this.recorded = new InstantType();
        }
        this.recorded.setValue(dateAndTime);
        return this;
    }

    public CodeableConcept getReason() {
        return this.reason;
    }

    public Provenance setReason(CodeableConcept codeableConcept) {
        this.reason = codeableConcept;
        return this;
    }

    public ResourceReference getLocation() {
        return this.location;
    }

    public Provenance setLocation(ResourceReference resourceReference) {
        this.location = resourceReference;
        return this;
    }

    public Location getLocationTarget() {
        return this.locationTarget;
    }

    public Provenance setLocationTarget(Location location) {
        this.locationTarget = location;
        return this;
    }

    public List<UriType> getPolicy() {
        return this.policy;
    }

    public UriType addPolicy() {
        UriType uriType = new UriType();
        this.policy.add(uriType);
        return uriType;
    }

    public UriType addPolicySimple(String string) {
        UriType uriType = new UriType();
        uriType.setValue(string);
        this.policy.add(uriType);
        return uriType;
    }

    public boolean hasPolicySimple(String string) {
        for (UriType uriType : this.policy) {
            if (!uriType.getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<ProvenanceAgentComponent> getAgent() {
        return this.agent;
    }

    public ProvenanceAgentComponent addAgent() {
        ProvenanceAgentComponent provenanceAgentComponent = new ProvenanceAgentComponent();
        this.agent.add(provenanceAgentComponent);
        return provenanceAgentComponent;
    }

    public List<ProvenanceEntityComponent> getEntity() {
        return this.entity;
    }

    public ProvenanceEntityComponent addEntity() {
        ProvenanceEntityComponent provenanceEntityComponent = new ProvenanceEntityComponent();
        this.entity.add(provenanceEntityComponent);
        return provenanceEntityComponent;
    }

    public StringType getIntegritySignature() {
        return this.integritySignature;
    }

    public Provenance setIntegritySignature(StringType stringType) {
        this.integritySignature = stringType;
        return this;
    }

    public String getIntegritySignatureSimple() {
        return this.integritySignature == null ? null : this.integritySignature.getValue();
    }

    public Provenance setIntegritySignatureSimple(String string) {
        if (string == null) {
            this.integritySignature = null;
        } else {
            if (this.integritySignature == null) {
                this.integritySignature = new StringType();
            }
            this.integritySignature.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("target", "Resource(Any)", "The resource(s) that were generated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity.", 0, Integer.MAX_VALUE, this.target));
        list.add(new Property("period", "Period", "The period during which the activity occurred.", 0, Integer.MAX_VALUE, this.period));
        list.add(new Property("recorded", "instant", "The instant of time at which the activity was recorded.", 0, Integer.MAX_VALUE, this.recorded));
        list.add(new Property("reason", "CodeableConcept", "The reason that the activity was taking place.", 0, Integer.MAX_VALUE, this.reason));
        list.add(new Property("location", "Resource(Location)", "Where the activity occurred, if relevant.", 0, Integer.MAX_VALUE, this.location));
        list.add(new Property("policy", "uri", "Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.", 0, Integer.MAX_VALUE, this.policy));
        list.add(new Property("agent", "", "An agent takes a role in an activity such that the agent can be assigned some degree of responsibility for the activity taking place. An agent can be a person, a piece of software, an inanimate object, an organization, or other entities that may be ascribed responsibility.", 0, Integer.MAX_VALUE, this.agent));
        list.add(new Property("entity", "", "An entity used in this activity.", 0, Integer.MAX_VALUE, this.entity));
        list.add(new Property("integritySignature", "string", "A digital signature on the target resource(s). The signature should match a Provenance.agent.reference in the provenance resource. The signature is only added to support checking cryptographic integrity of the resource, and not to represent workflow and clinical aspects of the signing process, or to support non-repudiation.", 0, Integer.MAX_VALUE, this.integritySignature));
    }

    public Provenance copy() {
        Provenance provenance = new Provenance();
        provenance.target = new ArrayList<ResourceReference>();
        for (ResourceReference element : this.target) {
            provenance.target.add(element.copy());
        }
        provenance.period = this.period == null ? null : this.period.copy();
        provenance.recorded = this.recorded == null ? null : this.recorded.copy();
        provenance.reason = this.reason == null ? null : this.reason.copy();
        provenance.location = this.location == null ? null : this.location.copy();
        provenance.policy = new ArrayList<UriType>();
        for (UriType uriType : this.policy) {
            provenance.policy.add(uriType.copy());
        }
        provenance.agent = new ArrayList<ProvenanceAgentComponent>();
        for (ProvenanceAgentComponent provenanceAgentComponent : this.agent) {
            provenance.agent.add(provenanceAgentComponent.copy());
        }
        provenance.entity = new ArrayList<ProvenanceEntityComponent>();
        for (ProvenanceEntityComponent provenanceEntityComponent : this.entity) {
            provenance.entity.add(provenanceEntityComponent.copy());
        }
        provenance.integritySignature = this.integritySignature == null ? null : this.integritySignature.copy();
        return provenance;
    }

    protected Provenance typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Provenance;
    }

    public static class ProvenanceEntityComponent
    extends BackboneElement {
        protected Enumeration<ProvenanceEntityRole> role;
        protected Coding type;
        protected UriType reference;
        protected StringType display;
        protected ProvenanceAgentComponent agent;
        private static final long serialVersionUID = 1533729633L;

        public ProvenanceEntityComponent() {
        }

        public ProvenanceEntityComponent(Enumeration<ProvenanceEntityRole> enumeration, Coding coding, UriType uriType) {
            this.role = enumeration;
            this.type = coding;
            this.reference = uriType;
        }

        public Enumeration<ProvenanceEntityRole> getRole() {
            return this.role;
        }

        public ProvenanceEntityComponent setRole(Enumeration<ProvenanceEntityRole> enumeration) {
            this.role = enumeration;
            return this;
        }

        public ProvenanceEntityRole getRoleSimple() {
            return this.role == null ? null : this.role.getValue();
        }

        public ProvenanceEntityComponent setRoleSimple(ProvenanceEntityRole provenanceEntityRole) {
            if (this.role == null) {
                this.role = new Enumeration();
            }
            this.role.setValue(provenanceEntityRole);
            return this;
        }

        public Coding getType() {
            return this.type;
        }

        public ProvenanceEntityComponent setType(Coding coding) {
            this.type = coding;
            return this;
        }

        public UriType getReference() {
            return this.reference;
        }

        public ProvenanceEntityComponent setReference(UriType uriType) {
            this.reference = uriType;
            return this;
        }

        public String getReferenceSimple() {
            return this.reference == null ? null : this.reference.getValue();
        }

        public ProvenanceEntityComponent setReferenceSimple(String string) {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(string);
            return this;
        }

        public StringType getDisplay() {
            return this.display;
        }

        public ProvenanceEntityComponent setDisplay(StringType stringType) {
            this.display = stringType;
            return this;
        }

        public String getDisplaySimple() {
            return this.display == null ? null : this.display.getValue();
        }

        public ProvenanceEntityComponent setDisplaySimple(String string) {
            if (string == null) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(string);
            }
            return this;
        }

        public ProvenanceAgentComponent getAgent() {
            return this.agent;
        }

        public ProvenanceEntityComponent setAgent(ProvenanceAgentComponent provenanceAgentComponent) {
            this.agent = provenanceAgentComponent;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("role", "code", "How the entity was used during the activity.", 0, Integer.MAX_VALUE, this.role));
            list.add(new Property("type", "Coding", "The type of the entity. If the entity is a resource, then this is a resource type.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("reference", "uri", "Identity of participant. May be a logical or physical uri and maybe absolute or relative.", 0, Integer.MAX_VALUE, this.reference));
            list.add(new Property("display", "string", "Human-readable description of the entity.", 0, Integer.MAX_VALUE, this.display));
            list.add(new Property("agent", "@Provenance.agent", "The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity.", 0, Integer.MAX_VALUE, this.agent));
        }

        public ProvenanceEntityComponent copy() {
            ProvenanceEntityComponent provenanceEntityComponent = new ProvenanceEntityComponent();
            provenanceEntityComponent.role = this.role == null ? null : this.role.copy();
            provenanceEntityComponent.type = this.type == null ? null : this.type.copy();
            provenanceEntityComponent.reference = this.reference == null ? null : this.reference.copy();
            provenanceEntityComponent.display = this.display == null ? null : this.display.copy();
            provenanceEntityComponent.agent = this.agent == null ? null : this.agent.copy();
            return provenanceEntityComponent;
        }
    }

    public static class ProvenanceAgentComponent
    extends BackboneElement {
        protected Coding role;
        protected Coding type;
        protected UriType reference;
        protected StringType display;
        private static final long serialVersionUID = 14713896L;

        public ProvenanceAgentComponent() {
        }

        public ProvenanceAgentComponent(Coding coding, Coding coding2, UriType uriType) {
            this.role = coding;
            this.type = coding2;
            this.reference = uriType;
        }

        public Coding getRole() {
            return this.role;
        }

        public ProvenanceAgentComponent setRole(Coding coding) {
            this.role = coding;
            return this;
        }

        public Coding getType() {
            return this.type;
        }

        public ProvenanceAgentComponent setType(Coding coding) {
            this.type = coding;
            return this;
        }

        public UriType getReference() {
            return this.reference;
        }

        public ProvenanceAgentComponent setReference(UriType uriType) {
            this.reference = uriType;
            return this;
        }

        public String getReferenceSimple() {
            return this.reference == null ? null : this.reference.getValue();
        }

        public ProvenanceAgentComponent setReferenceSimple(String string) {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(string);
            return this;
        }

        public StringType getDisplay() {
            return this.display;
        }

        public ProvenanceAgentComponent setDisplay(StringType stringType) {
            this.display = stringType;
            return this;
        }

        public String getDisplaySimple() {
            return this.display == null ? null : this.display.getValue();
        }

        public ProvenanceAgentComponent setDisplaySimple(String string) {
            if (string == null) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("role", "Coding", "The role that the participant played.", 0, Integer.MAX_VALUE, this.role));
            list.add(new Property("type", "Coding", "The type of the participant.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("reference", "uri", "Identity of participant. May be a logical or physical uri and maybe absolute or relative.", 0, Integer.MAX_VALUE, this.reference));
            list.add(new Property("display", "string", "Human-readable description of the participant.", 0, Integer.MAX_VALUE, this.display));
        }

        public ProvenanceAgentComponent copy() {
            ProvenanceAgentComponent provenanceAgentComponent = new ProvenanceAgentComponent();
            provenanceAgentComponent.role = this.role == null ? null : this.role.copy();
            provenanceAgentComponent.type = this.type == null ? null : this.type.copy();
            provenanceAgentComponent.reference = this.reference == null ? null : this.reference.copy();
            provenanceAgentComponent.display = this.display == null ? null : this.display.copy();
            return provenanceAgentComponent;
        }
    }

    public static class ProvenanceEntityRoleEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("derivation".equals(string)) {
                return ProvenanceEntityRole.derivation;
            }
            if ("revision".equals(string)) {
                return ProvenanceEntityRole.revision;
            }
            if ("quotation".equals(string)) {
                return ProvenanceEntityRole.quotation;
            }
            if ("source".equals(string)) {
                return ProvenanceEntityRole.source;
            }
            throw new Exception("Unknown ProvenanceEntityRole code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ProvenanceEntityRole.derivation) {
                return "derivation";
            }
            if (enum_ == ProvenanceEntityRole.revision) {
                return "revision";
            }
            if (enum_ == ProvenanceEntityRole.quotation) {
                return "quotation";
            }
            if (enum_ == ProvenanceEntityRole.source) {
                return "source";
            }
            return "?";
        }
    }

    public static enum ProvenanceEntityRole {
        derivation,
        revision,
        quotation,
        source,
        Null;


        public static ProvenanceEntityRole fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("derivation".equals(string)) {
                return derivation;
            }
            if ("revision".equals(string)) {
                return revision;
            }
            if ("quotation".equals(string)) {
                return quotation;
            }
            if ("source".equals(string)) {
                return source;
            }
            throw new Exception("Unknown ProvenanceEntityRole code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case derivation: {
                    return "derivation";
                }
                case revision: {
                    return "revision";
                }
                case quotation: {
                    return "quotation";
                }
                case source: {
                    return "source";
                }
            }
            return "?";
        }
    }
}

