/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;

public class Quantity
extends Type {
    protected DecimalType value;
    protected Enumeration<QuantityComparator> comparator;
    protected StringType units;
    protected UriType system;
    protected CodeType code;
    private static final long serialVersionUID = -483422721L;

    public DecimalType getValue() {
        return this.value;
    }

    public Quantity setValue(DecimalType decimalType) {
        this.value = decimalType;
        return this;
    }

    public BigDecimal getValueSimple() {
        return this.value == null ? null : this.value.getValue();
    }

    public Quantity setValueSimple(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.value = null;
        } else {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            this.value.setValue(bigDecimal);
        }
        return this;
    }

    public Enumeration<QuantityComparator> getComparator() {
        return this.comparator;
    }

    public Quantity setComparator(Enumeration<QuantityComparator> enumeration) {
        this.comparator = enumeration;
        return this;
    }

    public QuantityComparator getComparatorSimple() {
        return this.comparator == null ? null : this.comparator.getValue();
    }

    public Quantity setComparatorSimple(QuantityComparator quantityComparator) {
        if (quantityComparator == null) {
            this.comparator = null;
        } else {
            if (this.comparator == null) {
                this.comparator = new Enumeration();
            }
            this.comparator.setValue(quantityComparator);
        }
        return this;
    }

    public StringType getUnits() {
        return this.units;
    }

    public Quantity setUnits(StringType stringType) {
        this.units = stringType;
        return this;
    }

    public String getUnitsSimple() {
        return this.units == null ? null : this.units.getValue();
    }

    public Quantity setUnitsSimple(String string) {
        if (string == null) {
            this.units = null;
        } else {
            if (this.units == null) {
                this.units = new StringType();
            }
            this.units.setValue(string);
        }
        return this;
    }

    public UriType getSystem() {
        return this.system;
    }

    public Quantity setSystem(UriType uriType) {
        this.system = uriType;
        return this;
    }

    public String getSystemSimple() {
        return this.system == null ? null : this.system.getValue();
    }

    public Quantity setSystemSimple(String string) {
        if (string == null) {
            this.system = null;
        } else {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
        }
        return this;
    }

    public CodeType getCode() {
        return this.code;
    }

    public Quantity setCode(CodeType codeType) {
        this.code = codeType;
        return this;
    }

    public String getCodeSimple() {
        return this.code == null ? null : this.code.getValue();
    }

    public Quantity setCodeSimple(String string) {
        if (string == null) {
            this.code = null;
        } else {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("value", "decimal", "The value of the measured amount. The value includes an implicit precision in the presentation of the value.", 0, Integer.MAX_VALUE, this.value));
        list.add(new Property("comparator", "code", "How the value should be understood and represented - whether the actual value is greater or less than the stated value due to measurement issues. E.g. if the comparator is '<' , then the real value is < stated value.", 0, Integer.MAX_VALUE, this.comparator));
        list.add(new Property("units", "string", "A human-readable form of the units.", 0, Integer.MAX_VALUE, this.units));
        list.add(new Property("system", "uri", "The identification of the system that provides the coded form of the unit.", 0, Integer.MAX_VALUE, this.system));
        list.add(new Property("code", "code", "A computer processable form of the units in some unit representation system.", 0, Integer.MAX_VALUE, this.code));
    }

    @Override
    public Quantity copy() {
        Quantity quantity = new Quantity();
        quantity.value = this.value == null ? null : this.value.copy();
        quantity.comparator = this.comparator == null ? null : this.comparator.copy();
        quantity.units = this.units == null ? null : this.units.copy();
        quantity.system = this.system == null ? null : this.system.copy();
        quantity.code = this.code == null ? null : this.code.copy();
        return quantity;
    }

    @Override
    protected Quantity typedCopy() {
        return this.copy();
    }

    public static class QuantityComparatorEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("<".equals(string)) {
                return QuantityComparator.lessThan;
            }
            if ("<=".equals(string)) {
                return QuantityComparator.lessOrEqual;
            }
            if (">=".equals(string)) {
                return QuantityComparator.greaterOrEqual;
            }
            if (">".equals(string)) {
                return QuantityComparator.greaterThan;
            }
            throw new Exception("Unknown QuantityComparator code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == QuantityComparator.lessThan) {
                return "<";
            }
            if (enum_ == QuantityComparator.lessOrEqual) {
                return "<=";
            }
            if (enum_ == QuantityComparator.greaterOrEqual) {
                return ">=";
            }
            if (enum_ == QuantityComparator.greaterThan) {
                return ">";
            }
            return "?";
        }
    }

    public static enum QuantityComparator {
        lessThan,
        lessOrEqual,
        greaterOrEqual,
        greaterThan,
        Null;


        public static QuantityComparator fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("<".equals(string)) {
                return lessThan;
            }
            if ("<=".equals(string)) {
                return lessOrEqual;
            }
            if (">=".equals(string)) {
                return greaterOrEqual;
            }
            if (">".equals(string)) {
                return greaterThan;
            }
            throw new Exception("Unknown QuantityComparator code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case lessThan: {
                    return "<";
                }
                case lessOrEqual: {
                    return "<=";
                }
                case greaterOrEqual: {
                    return ">=";
                }
                case greaterThan: {
                    return ">";
                }
            }
            return "?";
        }
    }
}

