/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.UriType;

public class Query
extends Resource {
    protected UriType identifier;
    protected List<Extension> parameter = new ArrayList<Extension>();
    protected QueryResponseComponent response;
    private static final long serialVersionUID = 1612122334L;

    public Query() {
    }

    public Query(UriType uriType) {
        this.identifier = uriType;
    }

    public UriType getIdentifier() {
        return this.identifier;
    }

    public Query setIdentifier(UriType uriType) {
        this.identifier = uriType;
        return this;
    }

    public String getIdentifierSimple() {
        return this.identifier == null ? null : this.identifier.getValue();
    }

    public Query setIdentifierSimple(String string) {
        if (this.identifier == null) {
            this.identifier = new UriType();
        }
        this.identifier.setValue(string);
        return this;
    }

    public List<Extension> getParameter() {
        return this.parameter;
    }

    public Extension addParameter() {
        Extension extension = new Extension();
        this.parameter.add(extension);
        return extension;
    }

    public QueryResponseComponent getResponse() {
        return this.response;
    }

    public Query setResponse(QueryResponseComponent queryResponseComponent) {
        this.response = queryResponseComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "uri", "Links query and its response(s).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("parameter", "Extension", "Set of query parameters with values.", 0, Integer.MAX_VALUE, this.parameter));
        list.add(new Property("response", "", "If this is a response to a query.", 0, Integer.MAX_VALUE, this.response));
    }

    public Query copy() {
        Query query = new Query();
        query.identifier = this.identifier == null ? null : this.identifier.copy();
        query.parameter = new ArrayList<Extension>();
        for (Extension extension : this.parameter) {
            query.parameter.add(extension.copy());
        }
        query.response = this.response == null ? null : this.response.copy();
        return query;
    }

    protected Query typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Query;
    }

    public static class QueryResponseComponent
    extends BackboneElement {
        protected UriType identifier;
        protected Enumeration<QueryOutcome> outcome;
        protected IntegerType total;
        protected List<Extension> parameter = new ArrayList<Extension>();
        protected List<Extension> first = new ArrayList<Extension>();
        protected List<Extension> previous = new ArrayList<Extension>();
        protected List<Extension> next = new ArrayList<Extension>();
        protected List<Extension> last = new ArrayList<Extension>();
        protected List<ResourceReference> reference = new ArrayList<ResourceReference>();
        protected List<Resource> referenceTarget = new ArrayList<Resource>();
        private static final long serialVersionUID = -1700337143L;

        public QueryResponseComponent() {
        }

        public QueryResponseComponent(UriType uriType, Enumeration<QueryOutcome> enumeration) {
            this.identifier = uriType;
            this.outcome = enumeration;
        }

        public UriType getIdentifier() {
            return this.identifier;
        }

        public QueryResponseComponent setIdentifier(UriType uriType) {
            this.identifier = uriType;
            return this;
        }

        public String getIdentifierSimple() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public QueryResponseComponent setIdentifierSimple(String string) {
            if (this.identifier == null) {
                this.identifier = new UriType();
            }
            this.identifier.setValue(string);
            return this;
        }

        public Enumeration<QueryOutcome> getOutcome() {
            return this.outcome;
        }

        public QueryResponseComponent setOutcome(Enumeration<QueryOutcome> enumeration) {
            this.outcome = enumeration;
            return this;
        }

        public QueryOutcome getOutcomeSimple() {
            return this.outcome == null ? null : this.outcome.getValue();
        }

        public QueryResponseComponent setOutcomeSimple(QueryOutcome queryOutcome) {
            if (this.outcome == null) {
                this.outcome = new Enumeration();
            }
            this.outcome.setValue(queryOutcome);
            return this;
        }

        public IntegerType getTotal() {
            return this.total;
        }

        public QueryResponseComponent setTotal(IntegerType integerType) {
            this.total = integerType;
            return this;
        }

        public int getTotalSimple() {
            return this.total == null ? null : Integer.valueOf(this.total.getValue());
        }

        public QueryResponseComponent setTotalSimple(int n) {
            if (n == -1) {
                this.total = null;
            } else {
                if (this.total == null) {
                    this.total = new IntegerType();
                }
                this.total.setValue(n);
            }
            return this;
        }

        public List<Extension> getParameter() {
            return this.parameter;
        }

        public Extension addParameter() {
            Extension extension = new Extension();
            this.parameter.add(extension);
            return extension;
        }

        public List<Extension> getFirst() {
            return this.first;
        }

        public Extension addFirst() {
            Extension extension = new Extension();
            this.first.add(extension);
            return extension;
        }

        public List<Extension> getPrevious() {
            return this.previous;
        }

        public Extension addPrevious() {
            Extension extension = new Extension();
            this.previous.add(extension);
            return extension;
        }

        public List<Extension> getNext() {
            return this.next;
        }

        public Extension addNext() {
            Extension extension = new Extension();
            this.next.add(extension);
            return extension;
        }

        public List<Extension> getLast() {
            return this.last;
        }

        public Extension addLast() {
            Extension extension = new Extension();
            this.last.add(extension);
            return extension;
        }

        public List<ResourceReference> getReference() {
            return this.reference;
        }

        public ResourceReference addReference() {
            ResourceReference resourceReference = new ResourceReference();
            this.reference.add(resourceReference);
            return resourceReference;
        }

        public List<Resource> getReferenceTarget() {
            return this.referenceTarget;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "uri", "Links response to source query.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("outcome", "code", "Outcome of processing the query.", 0, Integer.MAX_VALUE, this.outcome));
            list.add(new Property("total", "integer", "Total number of matching records.", 0, Integer.MAX_VALUE, this.total));
            list.add(new Property("parameter", "Extension", "Parameters server used.", 0, Integer.MAX_VALUE, this.parameter));
            list.add(new Property("first", "Extension", "To get first page (if paged).", 0, Integer.MAX_VALUE, this.first));
            list.add(new Property("previous", "Extension", "To get previous page (if paged).", 0, Integer.MAX_VALUE, this.previous));
            list.add(new Property("next", "Extension", "To get next page (if paged).", 0, Integer.MAX_VALUE, this.next));
            list.add(new Property("last", "Extension", "To get last page (if paged).", 0, Integer.MAX_VALUE, this.last));
            list.add(new Property("reference", "Resource(Any)", "Resources that are the results of the search.", 0, Integer.MAX_VALUE, this.reference));
        }

        public QueryResponseComponent copy() {
            QueryResponseComponent queryResponseComponent = new QueryResponseComponent();
            queryResponseComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            queryResponseComponent.outcome = this.outcome == null ? null : this.outcome.copy();
            queryResponseComponent.total = this.total == null ? null : this.total.copy();
            queryResponseComponent.parameter = new ArrayList<Extension>();
            for (Extension element : this.parameter) {
                queryResponseComponent.parameter.add(element.copy());
            }
            queryResponseComponent.first = new ArrayList<Extension>();
            for (Extension extension : this.first) {
                queryResponseComponent.first.add(extension.copy());
            }
            queryResponseComponent.previous = new ArrayList<Extension>();
            for (Extension extension : this.previous) {
                queryResponseComponent.previous.add(extension.copy());
            }
            queryResponseComponent.next = new ArrayList<Extension>();
            for (Extension extension : this.next) {
                queryResponseComponent.next.add(extension.copy());
            }
            queryResponseComponent.last = new ArrayList<Extension>();
            for (Extension extension : this.last) {
                queryResponseComponent.last.add(extension.copy());
            }
            queryResponseComponent.reference = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.reference) {
                queryResponseComponent.reference.add(resourceReference.copy());
            }
            return queryResponseComponent;
        }
    }

    public static class QueryOutcomeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("ok".equals(string)) {
                return QueryOutcome.ok;
            }
            if ("limited".equals(string)) {
                return QueryOutcome.limited;
            }
            if ("refused".equals(string)) {
                return QueryOutcome.refused;
            }
            if ("error".equals(string)) {
                return QueryOutcome.error;
            }
            throw new Exception("Unknown QueryOutcome code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == QueryOutcome.ok) {
                return "ok";
            }
            if (enum_ == QueryOutcome.limited) {
                return "limited";
            }
            if (enum_ == QueryOutcome.refused) {
                return "refused";
            }
            if (enum_ == QueryOutcome.error) {
                return "error";
            }
            return "?";
        }
    }

    public static enum QueryOutcome {
        ok,
        limited,
        refused,
        error,
        Null;


        public static QueryOutcome fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("ok".equals(string)) {
                return ok;
            }
            if ("limited".equals(string)) {
                return limited;
            }
            if ("refused".equals(string)) {
                return refused;
            }
            if ("error".equals(string)) {
                return error;
            }
            throw new Exception("Unknown QueryOutcome code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case ok: {
                    return "ok";
                }
                case limited: {
                    return "limited";
                }
                case refused: {
                    return "refused";
                }
                case error: {
                    return "error";
                }
            }
            return "?";
        }
    }
}

