/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.ValueSet;

public class Questionnaire
extends Resource {
    protected Enumeration<QuestionnaireStatus> status;
    protected DateTimeType authored;
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected ResourceReference author;
    protected Resource authorTarget;
    protected ResourceReference source;
    protected Resource sourceTarget;
    protected CodeableConcept name;
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference encounter;
    protected Encounter encounterTarget;
    protected GroupComponent group;
    private static final long serialVersionUID = -404084379L;

    public Questionnaire() {
    }

    public Questionnaire(Enumeration<QuestionnaireStatus> enumeration, DateTimeType dateTimeType) {
        this.status = enumeration;
        this.authored = dateTimeType;
    }

    public Enumeration<QuestionnaireStatus> getStatus() {
        return this.status;
    }

    public Questionnaire setStatus(Enumeration<QuestionnaireStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public QuestionnaireStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Questionnaire setStatusSimple(QuestionnaireStatus questionnaireStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(questionnaireStatus);
        return this;
    }

    public DateTimeType getAuthored() {
        return this.authored;
    }

    public Questionnaire setAuthored(DateTimeType dateTimeType) {
        this.authored = dateTimeType;
        return this;
    }

    public DateAndTime getAuthoredSimple() {
        return this.authored == null ? null : this.authored.getValue();
    }

    public Questionnaire setAuthoredSimple(DateAndTime dateAndTime) {
        if (this.authored == null) {
            this.authored = new DateTimeType();
        }
        this.authored.setValue(dateAndTime);
        return this;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Questionnaire setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Questionnaire setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public ResourceReference getAuthor() {
        return this.author;
    }

    public Questionnaire setAuthor(ResourceReference resourceReference) {
        this.author = resourceReference;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public Questionnaire setAuthorTarget(Resource resource) {
        this.authorTarget = resource;
        return this;
    }

    public ResourceReference getSource() {
        return this.source;
    }

    public Questionnaire setSource(ResourceReference resourceReference) {
        this.source = resourceReference;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public Questionnaire setSourceTarget(Resource resource) {
        this.sourceTarget = resource;
        return this;
    }

    public CodeableConcept getName() {
        return this.name;
    }

    public Questionnaire setName(CodeableConcept codeableConcept) {
        this.name = codeableConcept;
        return this;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getEncounter() {
        return this.encounter;
    }

    public Questionnaire setEncounter(ResourceReference resourceReference) {
        this.encounter = resourceReference;
        return this;
    }

    public Encounter getEncounterTarget() {
        return this.encounterTarget;
    }

    public Questionnaire setEncounterTarget(Encounter encounter) {
        this.encounterTarget = encounter;
        return this;
    }

    public GroupComponent getGroup() {
        return this.group;
    }

    public Questionnaire setGroup(GroupComponent groupComponent) {
        this.group = groupComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("status", "code", "The lifecycle status of the questionnaire as a whole.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("authored", "dateTime", "The date and/or time that this version of the questionnaire was authored.", 0, Integer.MAX_VALUE, this.authored));
        list.add(new Property("subject", "Resource(Patient|RelatedPerson)", "The subject of the questionnaires: this is the patient that the answers apply to, but this person is not necessarily the source of information.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("author", "Resource(Practitioner|Patient|RelatedPerson)", "Person who received the answers to the questions in the Questionnaire and recorded them in the system.", 0, Integer.MAX_VALUE, this.author));
        list.add(new Property("source", "Resource(Patient|Practitioner|RelatedPerson)", "The person who answered the questions about the subject. Only used when this is not the subject him/herself.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("name", "CodeableConcept", "Structured name for a predefined list of questions this questionnaire is responding to.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("identifier", "Identifier", "This records identifiers associated with this question/answer set that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("encounter", "Resource(Encounter)", "Encounter during which this questionnaire answers were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.", 0, Integer.MAX_VALUE, this.encounter));
        list.add(new Property("group", "", "A group of questions to a possibly similarly grouped set of questions in the questionnaire.", 0, Integer.MAX_VALUE, this.group));
    }

    public Questionnaire copy() {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.status = this.status == null ? null : this.status.copy();
        questionnaire.authored = this.authored == null ? null : this.authored.copy();
        questionnaire.subject = this.subject == null ? null : this.subject.copy();
        questionnaire.author = this.author == null ? null : this.author.copy();
        questionnaire.source = this.source == null ? null : this.source.copy();
        questionnaire.name = this.name == null ? null : this.name.copy();
        questionnaire.identifier = new ArrayList<Identifier>();
        for (Identifier identifier : this.identifier) {
            questionnaire.identifier.add(identifier.copy());
        }
        questionnaire.encounter = this.encounter == null ? null : this.encounter.copy();
        questionnaire.group = this.group == null ? null : this.group.copy();
        return questionnaire;
    }

    protected Questionnaire typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Questionnaire;
    }

    public static class QuestionComponent
    extends BackboneElement {
        protected CodeableConcept name;
        protected StringType text;
        protected Type answer;
        protected List<Coding> choice = new ArrayList<Coding>();
        protected ResourceReference options;
        protected ValueSet optionsTarget;
        protected Type data;
        protected StringType remarks;
        protected List<GroupComponent> group = new ArrayList<GroupComponent>();
        private static final long serialVersionUID = 367238745L;

        public CodeableConcept getName() {
            return this.name;
        }

        public QuestionComponent setName(CodeableConcept codeableConcept) {
            this.name = codeableConcept;
            return this;
        }

        public StringType getText() {
            return this.text;
        }

        public QuestionComponent setText(StringType stringType) {
            this.text = stringType;
            return this;
        }

        public String getTextSimple() {
            return this.text == null ? null : this.text.getValue();
        }

        public QuestionComponent setTextSimple(String string) {
            if (string == null) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(string);
            }
            return this;
        }

        public Type getAnswer() {
            return this.answer;
        }

        public QuestionComponent setAnswer(Type type) {
            this.answer = type;
            return this;
        }

        public List<Coding> getChoice() {
            return this.choice;
        }

        public Coding addChoice() {
            Coding coding = new Coding();
            this.choice.add(coding);
            return coding;
        }

        public ResourceReference getOptions() {
            return this.options;
        }

        public QuestionComponent setOptions(ResourceReference resourceReference) {
            this.options = resourceReference;
            return this;
        }

        public ValueSet getOptionsTarget() {
            return this.optionsTarget;
        }

        public QuestionComponent setOptionsTarget(ValueSet valueSet) {
            this.optionsTarget = valueSet;
            return this;
        }

        public Type getData() {
            return this.data;
        }

        public QuestionComponent setData(Type type) {
            this.data = type;
            return this;
        }

        public StringType getRemarks() {
            return this.remarks;
        }

        public QuestionComponent setRemarks(StringType stringType) {
            this.remarks = stringType;
            return this;
        }

        public String getRemarksSimple() {
            return this.remarks == null ? null : this.remarks.getValue();
        }

        public QuestionComponent setRemarksSimple(String string) {
            if (string == null) {
                this.remarks = null;
            } else {
                if (this.remarks == null) {
                    this.remarks = new StringType();
                }
                this.remarks.setValue(string);
            }
            return this;
        }

        public List<GroupComponent> getGroup() {
            return this.group;
        }

        public GroupComponent addGroup() {
            GroupComponent groupComponent = new GroupComponent();
            this.group.add(groupComponent);
            return groupComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "CodeableConcept", "Structured name for the question that identifies this question within the Questionnaire or Group.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("text", "string", "Text of the question as it is shown to the user.", 0, Integer.MAX_VALUE, this.text));
            list.add(new Property("answer[x]", "decimal|integer|boolean|date|string|dateTime|instant", "Single-valued answer to the question.", 0, Integer.MAX_VALUE, this.answer));
            list.add(new Property("choice", "Coding", "Selections made by the user from the list of options.", 0, Integer.MAX_VALUE, this.choice));
            list.add(new Property("options", "Resource(ValueSet)", "Reference to a valueset containing the possible options.", 0, Integer.MAX_VALUE, this.options));
            list.add(new Property("data[x]", "*", "Structured answer in the form of a FHIR Resource or datatype.", 0, Integer.MAX_VALUE, this.data));
            list.add(new Property("remarks", "string", "The remark contains information about the answer given. This is additional information about the answer the author wishes to convey, but should not be used to contain information that is part of the answer itself.", 0, Integer.MAX_VALUE, this.remarks));
            list.add(new Property("group", "@Questionnaire.group", "Nested group, containing nested question for this question. The order of groups within the question is relevant.", 0, Integer.MAX_VALUE, this.group));
        }

        public QuestionComponent copy() {
            QuestionComponent questionComponent = new QuestionComponent();
            questionComponent.name = this.name == null ? null : this.name.copy();
            questionComponent.text = this.text == null ? null : this.text.copy();
            questionComponent.answer = this.answer == null ? null : this.answer.copy();
            questionComponent.choice = new ArrayList<Coding>();
            for (Coding element : this.choice) {
                questionComponent.choice.add(element.copy());
            }
            questionComponent.options = this.options == null ? null : this.options.copy();
            questionComponent.data = this.data == null ? null : this.data.copy();
            questionComponent.remarks = this.remarks == null ? null : this.remarks.copy();
            questionComponent.group = new ArrayList<GroupComponent>();
            for (GroupComponent groupComponent : this.group) {
                questionComponent.group.add(groupComponent.copy());
            }
            return questionComponent;
        }
    }

    public static class GroupComponent
    extends BackboneElement {
        protected CodeableConcept name;
        protected StringType header;
        protected StringType text;
        protected ResourceReference subject;
        protected Resource subjectTarget;
        protected List<GroupComponent> group = new ArrayList<GroupComponent>();
        protected List<QuestionComponent> question = new ArrayList<QuestionComponent>();
        private static final long serialVersionUID = -2079376999L;

        public CodeableConcept getName() {
            return this.name;
        }

        public GroupComponent setName(CodeableConcept codeableConcept) {
            this.name = codeableConcept;
            return this;
        }

        public StringType getHeader() {
            return this.header;
        }

        public GroupComponent setHeader(StringType stringType) {
            this.header = stringType;
            return this;
        }

        public String getHeaderSimple() {
            return this.header == null ? null : this.header.getValue();
        }

        public GroupComponent setHeaderSimple(String string) {
            if (string == null) {
                this.header = null;
            } else {
                if (this.header == null) {
                    this.header = new StringType();
                }
                this.header.setValue(string);
            }
            return this;
        }

        public StringType getText() {
            return this.text;
        }

        public GroupComponent setText(StringType stringType) {
            this.text = stringType;
            return this;
        }

        public String getTextSimple() {
            return this.text == null ? null : this.text.getValue();
        }

        public GroupComponent setTextSimple(String string) {
            if (string == null) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(string);
            }
            return this;
        }

        public ResourceReference getSubject() {
            return this.subject;
        }

        public GroupComponent setSubject(ResourceReference resourceReference) {
            this.subject = resourceReference;
            return this;
        }

        public Resource getSubjectTarget() {
            return this.subjectTarget;
        }

        public GroupComponent setSubjectTarget(Resource resource) {
            this.subjectTarget = resource;
            return this;
        }

        public List<GroupComponent> getGroup() {
            return this.group;
        }

        public GroupComponent addGroup() {
            GroupComponent groupComponent = new GroupComponent();
            this.group.add(groupComponent);
            return groupComponent;
        }

        public List<QuestionComponent> getQuestion() {
            return this.question;
        }

        public QuestionComponent addQuestion() {
            QuestionComponent questionComponent = new QuestionComponent();
            this.question.add(questionComponent);
            return questionComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("name", "CodeableConcept", "Structured name for a section of a predefined list of questions this questionnaire is responding to.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("header", "string", "Text that is displayed above the contents of the group.", 0, Integer.MAX_VALUE, this.header));
            list.add(new Property("text", "string", "Additional text for the group, used for display purposes.", 0, Integer.MAX_VALUE, this.text));
            list.add(new Property("subject", "Resource(Any)", "More specific subject this section's answers are about, details the subject given in Questionnaire.", 0, Integer.MAX_VALUE, this.subject));
            list.add(new Property("group", "@Questionnaire.group", "A sub-group within a group. The ordering of groups within this group is relevant.", 0, Integer.MAX_VALUE, this.group));
            list.add(new Property("question", "", "Set of questions within this group. The order of questions within the group is relevant.", 0, Integer.MAX_VALUE, this.question));
        }

        public GroupComponent copy() {
            GroupComponent groupComponent = new GroupComponent();
            groupComponent.name = this.name == null ? null : this.name.copy();
            groupComponent.header = this.header == null ? null : this.header.copy();
            groupComponent.text = this.text == null ? null : this.text.copy();
            groupComponent.subject = this.subject == null ? null : this.subject.copy();
            groupComponent.group = new ArrayList<GroupComponent>();
            for (GroupComponent backboneElement : this.group) {
                groupComponent.group.add(backboneElement.copy());
            }
            groupComponent.question = new ArrayList<QuestionComponent>();
            for (QuestionComponent questionComponent : this.question) {
                groupComponent.question.add(questionComponent.copy());
            }
            return groupComponent;
        }
    }

    public static class QuestionnaireStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("draft".equals(string)) {
                return QuestionnaireStatus.draft;
            }
            if ("published".equals(string)) {
                return QuestionnaireStatus.published;
            }
            if ("retired".equals(string)) {
                return QuestionnaireStatus.retired;
            }
            if ("in progress".equals(string)) {
                return QuestionnaireStatus.inProgress;
            }
            if ("completed".equals(string)) {
                return QuestionnaireStatus.completed;
            }
            if ("amended".equals(string)) {
                return QuestionnaireStatus.amended;
            }
            throw new Exception("Unknown QuestionnaireStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == QuestionnaireStatus.draft) {
                return "draft";
            }
            if (enum_ == QuestionnaireStatus.published) {
                return "published";
            }
            if (enum_ == QuestionnaireStatus.retired) {
                return "retired";
            }
            if (enum_ == QuestionnaireStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == QuestionnaireStatus.completed) {
                return "completed";
            }
            if (enum_ == QuestionnaireStatus.amended) {
                return "amended";
            }
            return "?";
        }
    }

    public static enum QuestionnaireStatus {
        draft,
        published,
        retired,
        inProgress,
        completed,
        amended,
        Null;


        public static QuestionnaireStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("draft".equals(string)) {
                return draft;
            }
            if ("published".equals(string)) {
                return published;
            }
            if ("retired".equals(string)) {
                return retired;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("completed".equals(string)) {
                return completed;
            }
            if ("amended".equals(string)) {
                return amended;
            }
            throw new Exception("Unknown QuestionnaireStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case draft: {
                    return "draft";
                }
                case published: {
                    return "published";
                }
                case retired: {
                    return "retired";
                }
                case inProgress: {
                    return "in progress";
                }
                case completed: {
                    return "completed";
                }
                case amended: {
                    return "amended";
                }
            }
            return "?";
        }
    }
}

