/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class RelatedPerson
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected CodeableConcept relationship;
    protected HumanName name;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected CodeableConcept gender;
    protected Address address;
    protected List<Attachment> photo = new ArrayList<Attachment>();
    private static final long serialVersionUID = -995377560L;

    public RelatedPerson() {
    }

    public RelatedPerson(ResourceReference resourceReference) {
        this.patient = resourceReference;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public RelatedPerson setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public RelatedPerson setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public CodeableConcept getRelationship() {
        return this.relationship;
    }

    public RelatedPerson setRelationship(CodeableConcept codeableConcept) {
        this.relationship = codeableConcept;
        return this;
    }

    public HumanName getName() {
        return this.name;
    }

    public RelatedPerson setName(HumanName humanName) {
        this.name = humanName;
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public CodeableConcept getGender() {
        return this.gender;
    }

    public RelatedPerson setGender(CodeableConcept codeableConcept) {
        this.gender = codeableConcept;
        return this;
    }

    public Address getAddress() {
        return this.address;
    }

    public RelatedPerson setAddress(Address address) {
        this.address = address;
        return this;
    }

    public List<Attachment> getPhoto() {
        return this.photo;
    }

    public Attachment addPhoto() {
        Attachment attachment = new Attachment();
        this.photo.add(attachment);
        return attachment;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Identifier for a person within a particular scope.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("patient", "Resource(Patient)", "The patient this person is related to.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("relationship", "CodeableConcept", "The nature of the relationship between a patient and the related person.", 0, Integer.MAX_VALUE, this.relationship));
        list.add(new Property("name", "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("telecom", "Contact", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("gender", "CodeableConcept", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        list.add(new Property("address", "Address", "Address where the related person can be contacted or visited.", 0, Integer.MAX_VALUE, this.address));
        list.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
    }

    public RelatedPerson copy() {
        RelatedPerson relatedPerson = new RelatedPerson();
        relatedPerson.identifier = new ArrayList<Identifier>();
        for (Identifier type : this.identifier) {
            relatedPerson.identifier.add(type.copy());
        }
        relatedPerson.patient = this.patient == null ? null : this.patient.copy();
        relatedPerson.relationship = this.relationship == null ? null : this.relationship.copy();
        relatedPerson.name = this.name == null ? null : this.name.copy();
        relatedPerson.telecom = new ArrayList<Contact>();
        for (Contact contact : this.telecom) {
            relatedPerson.telecom.add(contact.copy());
        }
        relatedPerson.gender = this.gender == null ? null : this.gender.copy();
        relatedPerson.address = this.address == null ? null : this.address.copy();
        relatedPerson.photo = new ArrayList<Attachment>();
        for (Attachment attachment : this.photo) {
            relatedPerson.photo.add(attachment.copy());
        }
        return relatedPerson;
    }

    protected RelatedPerson typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RelatedPerson;
    }
}

