/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.List;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class ResourceReference
extends Type {
    protected StringType reference;
    protected StringType display;
    private static final long serialVersionUID = 22777321L;

    public StringType getReference() {
        return this.reference;
    }

    public ResourceReference setReference(StringType stringType) {
        this.reference = stringType;
        return this;
    }

    public String getReferenceSimple() {
        return this.reference == null ? null : this.reference.getValue();
    }

    public ResourceReference setReferenceSimple(String string) {
        if (string == null) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new StringType();
            }
            this.reference.setValue(string);
        }
        return this;
    }

    public StringType getDisplay() {
        return this.display;
    }

    public ResourceReference setDisplay(StringType stringType) {
        this.display = stringType;
        return this;
    }

    public String getDisplaySimple() {
        return this.display == null ? null : this.display.getValue();
    }

    public ResourceReference setDisplaySimple(String string) {
        if (string == null) {
            this.display = null;
        } else {
            if (this.display == null) {
                this.display = new StringType();
            }
            this.display.setValue(string);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("reference", "string", "A reference to a location at which the other resource is found. The reference may a relative reference, in which case it is relative to the service base URL, or an absolute URL that resolves to the location where the resource is found. The reference may be version specific or not. If the reference is not to a FHIR RESTful server, then it should be assumed to be version specific. Internal fragment references (start with '#') refer to contained resources.", 0, Integer.MAX_VALUE, this.reference));
        list.add(new Property("display", "string", "Plain text narrative that identifies the resource in addition to the resource reference.", 0, Integer.MAX_VALUE, this.display));
    }

    @Override
    public ResourceReference copy() {
        ResourceReference resourceReference = new ResourceReference();
        resourceReference.reference = this.reference == null ? null : this.reference.copy();
        resourceReference.display = this.display == null ? null : this.display.copy();
        return resourceReference;
    }

    @Override
    protected ResourceReference typedCopy() {
        return this.copy();
    }
}

