/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ResourceUtilities {
    public static boolean isAnError(OperationOutcome operationOutcome) {
        for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
            if (operationOutcomeIssueComponent.getSeveritySimple() == OperationOutcome.IssueSeverity.error) {
                return true;
            }
            if (operationOutcomeIssueComponent.getSeveritySimple() != OperationOutcome.IssueSeverity.fatal) continue;
            return true;
        }
        return false;
    }

    public static String getErrorDescription(OperationOutcome operationOutcome) {
        if (operationOutcome.getText() != null && operationOutcome.getText().getDiv() != null) {
            return new XhtmlComposer().composePlainText(operationOutcome.getText().getDiv());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
            if (operationOutcomeIssueComponent.getSeveritySimple() == OperationOutcome.IssueSeverity.error) {
                stringBuilder.append("Error:" + operationOutcomeIssueComponent.getDetailsSimple() + "\r\n");
                continue;
            }
            if (operationOutcomeIssueComponent.getSeveritySimple() == OperationOutcome.IssueSeverity.fatal) {
                stringBuilder.append("Fatal:" + operationOutcomeIssueComponent.getDetailsSimple() + "\r\n");
                continue;
            }
            if (operationOutcomeIssueComponent.getSeveritySimple() == OperationOutcome.IssueSeverity.warning) {
                stringBuilder.append("Warning:" + operationOutcomeIssueComponent.getDetailsSimple() + "\r\n");
                continue;
            }
            if (operationOutcomeIssueComponent.getSeveritySimple() != OperationOutcome.IssueSeverity.information) continue;
            stringBuilder.append("Information:" + operationOutcomeIssueComponent.getDetailsSimple() + "\r\n");
        }
        return stringBuilder.toString();
    }
}

