/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;

public class SampledData
extends Type {
    protected Quantity origin;
    protected DecimalType period;
    protected DecimalType factor;
    protected DecimalType lowerLimit;
    protected DecimalType upperLimit;
    protected IntegerType dimensions;
    protected StringType data;
    private static final long serialVersionUID = 173820410L;

    public SampledData() {
    }

    public SampledData(Quantity quantity, DecimalType decimalType, IntegerType integerType, StringType stringType) {
        this.origin = quantity;
        this.period = decimalType;
        this.dimensions = integerType;
        this.data = stringType;
    }

    public Quantity getOrigin() {
        return this.origin;
    }

    public SampledData setOrigin(Quantity quantity) {
        this.origin = quantity;
        return this;
    }

    public DecimalType getPeriod() {
        return this.period;
    }

    public SampledData setPeriod(DecimalType decimalType) {
        this.period = decimalType;
        return this;
    }

    public BigDecimal getPeriodSimple() {
        return this.period == null ? null : this.period.getValue();
    }

    public SampledData setPeriodSimple(BigDecimal bigDecimal) {
        if (this.period == null) {
            this.period = new DecimalType();
        }
        this.period.setValue(bigDecimal);
        return this;
    }

    public DecimalType getFactor() {
        return this.factor;
    }

    public SampledData setFactor(DecimalType decimalType) {
        this.factor = decimalType;
        return this;
    }

    public BigDecimal getFactorSimple() {
        return this.factor == null ? null : this.factor.getValue();
    }

    public SampledData setFactorSimple(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.factor = null;
        } else {
            if (this.factor == null) {
                this.factor = new DecimalType();
            }
            this.factor.setValue(bigDecimal);
        }
        return this;
    }

    public DecimalType getLowerLimit() {
        return this.lowerLimit;
    }

    public SampledData setLowerLimit(DecimalType decimalType) {
        this.lowerLimit = decimalType;
        return this;
    }

    public BigDecimal getLowerLimitSimple() {
        return this.lowerLimit == null ? null : this.lowerLimit.getValue();
    }

    public SampledData setLowerLimitSimple(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.lowerLimit = null;
        } else {
            if (this.lowerLimit == null) {
                this.lowerLimit = new DecimalType();
            }
            this.lowerLimit.setValue(bigDecimal);
        }
        return this;
    }

    public DecimalType getUpperLimit() {
        return this.upperLimit;
    }

    public SampledData setUpperLimit(DecimalType decimalType) {
        this.upperLimit = decimalType;
        return this;
    }

    public BigDecimal getUpperLimitSimple() {
        return this.upperLimit == null ? null : this.upperLimit.getValue();
    }

    public SampledData setUpperLimitSimple(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.upperLimit = null;
        } else {
            if (this.upperLimit == null) {
                this.upperLimit = new DecimalType();
            }
            this.upperLimit.setValue(bigDecimal);
        }
        return this;
    }

    public IntegerType getDimensions() {
        return this.dimensions;
    }

    public SampledData setDimensions(IntegerType integerType) {
        this.dimensions = integerType;
        return this;
    }

    public int getDimensionsSimple() {
        return this.dimensions == null ? null : Integer.valueOf(this.dimensions.getValue());
    }

    public SampledData setDimensionsSimple(int n) {
        if (this.dimensions == null) {
            this.dimensions = new IntegerType();
        }
        this.dimensions.setValue(n);
        return this;
    }

    public StringType getData() {
        return this.data;
    }

    public SampledData setData(StringType stringType) {
        this.data = stringType;
        return this;
    }

    public String getDataSimple() {
        return this.data == null ? null : this.data.getValue();
    }

    public SampledData setDataSimple(String string) {
        if (this.data == null) {
            this.data = new StringType();
        }
        this.data.setValue(string);
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("origin", "Quantity", "The base quantity that a measured value of zero represents. In addition, this provides the units of the entire measurement series.", 0, Integer.MAX_VALUE, this.origin));
        list.add(new Property("period", "decimal", "The length of time between sampling times, measured in milliseconds.", 0, Integer.MAX_VALUE, this.period));
        list.add(new Property("factor", "decimal", "A correction factor that is applied to the sampled data points before they are added to the origin.", 0, Integer.MAX_VALUE, this.factor));
        list.add(new Property("lowerLimit", "decimal", "The lower limit of detection of the measured points. This is needed if any of the data points have the value 'L' (lower than detection limit).", 0, Integer.MAX_VALUE, this.lowerLimit));
        list.add(new Property("upperLimit", "decimal", "The upper limit of detection of the measured points. This is needed if any of the data points have the value 'U' (higher than detection limit).", 0, Integer.MAX_VALUE, this.upperLimit));
        list.add(new Property("dimensions", "integer", "The number of sample points at each time point. If this value is greater than one, then the dimensions will be interlaced - all the sample points for a point in time will be recorded at once.", 0, Integer.MAX_VALUE, this.dimensions));
        list.add(new Property("data", "string", "A series of data points which are decimal values separated by a single space (character u20). The special values 'E' (error), 'L' (below detection limit) and 'U' (above detection limit) can also be used in place of a decimal value.", 0, Integer.MAX_VALUE, this.data));
    }

    @Override
    public SampledData copy() {
        SampledData sampledData = new SampledData();
        sampledData.origin = this.origin == null ? null : this.origin.copy();
        sampledData.period = this.period == null ? null : this.period.copy();
        sampledData.factor = this.factor == null ? null : this.factor.copy();
        sampledData.lowerLimit = this.lowerLimit == null ? null : this.lowerLimit.copy();
        sampledData.upperLimit = this.upperLimit == null ? null : this.upperLimit.copy();
        sampledData.dimensions = this.dimensions == null ? null : this.dimensions.copy();
        sampledData.data = this.data == null ? null : this.data.copy();
        return sampledData;
    }

    @Override
    protected SampledData typedCopy() {
        return this.copy();
    }
}

