/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Type;

public class Schedule
extends Type {
    protected List<Period> event = new ArrayList<Period>();
    protected ScheduleRepeatComponent repeat;
    private static final long serialVersionUID = -537139777L;

    public List<Period> getEvent() {
        return this.event;
    }

    public Period addEvent() {
        Period period = new Period();
        this.event.add(period);
        return period;
    }

    public ScheduleRepeatComponent getRepeat() {
        return this.repeat;
    }

    public Schedule setRepeat(ScheduleRepeatComponent scheduleRepeatComponent) {
        this.repeat = scheduleRepeatComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("event", "Period", "Identifies specific time periods when the event should occur.", 0, Integer.MAX_VALUE, this.event));
        list.add(new Property("repeat", "", "Identifies a repeating pattern to the intended time periods.", 0, Integer.MAX_VALUE, this.repeat));
    }

    @Override
    public Schedule copy() {
        Schedule schedule = new Schedule();
        schedule.event = new ArrayList<Period>();
        for (Period period : this.event) {
            schedule.event.add(period.copy());
        }
        schedule.repeat = this.repeat == null ? null : this.repeat.copy();
        return schedule;
    }

    @Override
    protected Schedule typedCopy() {
        return this.copy();
    }

    public static class ScheduleRepeatComponent
    extends Element {
        protected IntegerType frequency;
        protected Enumeration<EventTiming> when;
        protected DecimalType duration;
        protected Enumeration<UnitsOfTime> units;
        protected IntegerType count;
        protected DateTimeType end;
        private static final long serialVersionUID = -615844988L;

        public ScheduleRepeatComponent() {
        }

        public ScheduleRepeatComponent(DecimalType decimalType, Enumeration<UnitsOfTime> enumeration) {
            this.duration = decimalType;
            this.units = enumeration;
        }

        public IntegerType getFrequency() {
            return this.frequency;
        }

        public ScheduleRepeatComponent setFrequency(IntegerType integerType) {
            this.frequency = integerType;
            return this;
        }

        public int getFrequencySimple() {
            return this.frequency == null ? null : Integer.valueOf(this.frequency.getValue());
        }

        public ScheduleRepeatComponent setFrequencySimple(int n) {
            if (n == -1) {
                this.frequency = null;
            } else {
                if (this.frequency == null) {
                    this.frequency = new IntegerType();
                }
                this.frequency.setValue(n);
            }
            return this;
        }

        public Enumeration<EventTiming> getWhen() {
            return this.when;
        }

        public ScheduleRepeatComponent setWhen(Enumeration<EventTiming> enumeration) {
            this.when = enumeration;
            return this;
        }

        public EventTiming getWhenSimple() {
            return this.when == null ? null : this.when.getValue();
        }

        public ScheduleRepeatComponent setWhenSimple(EventTiming eventTiming) {
            if (eventTiming == null) {
                this.when = null;
            } else {
                if (this.when == null) {
                    this.when = new Enumeration();
                }
                this.when.setValue(eventTiming);
            }
            return this;
        }

        public DecimalType getDuration() {
            return this.duration;
        }

        public ScheduleRepeatComponent setDuration(DecimalType decimalType) {
            this.duration = decimalType;
            return this;
        }

        public BigDecimal getDurationSimple() {
            return this.duration == null ? null : this.duration.getValue();
        }

        public ScheduleRepeatComponent setDurationSimple(BigDecimal bigDecimal) {
            if (this.duration == null) {
                this.duration = new DecimalType();
            }
            this.duration.setValue(bigDecimal);
            return this;
        }

        public Enumeration<UnitsOfTime> getUnits() {
            return this.units;
        }

        public ScheduleRepeatComponent setUnits(Enumeration<UnitsOfTime> enumeration) {
            this.units = enumeration;
            return this;
        }

        public UnitsOfTime getUnitsSimple() {
            return this.units == null ? null : this.units.getValue();
        }

        public ScheduleRepeatComponent setUnitsSimple(UnitsOfTime unitsOfTime) {
            if (this.units == null) {
                this.units = new Enumeration();
            }
            this.units.setValue(unitsOfTime);
            return this;
        }

        public IntegerType getCount() {
            return this.count;
        }

        public ScheduleRepeatComponent setCount(IntegerType integerType) {
            this.count = integerType;
            return this;
        }

        public int getCountSimple() {
            return this.count == null ? null : Integer.valueOf(this.count.getValue());
        }

        public ScheduleRepeatComponent setCountSimple(int n) {
            if (n == -1) {
                this.count = null;
            } else {
                if (this.count == null) {
                    this.count = new IntegerType();
                }
                this.count.setValue(n);
            }
            return this;
        }

        public DateTimeType getEnd() {
            return this.end;
        }

        public ScheduleRepeatComponent setEnd(DateTimeType dateTimeType) {
            this.end = dateTimeType;
            return this;
        }

        public DateAndTime getEndSimple() {
            return this.end == null ? null : this.end.getValue();
        }

        public ScheduleRepeatComponent setEndSimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.end = null;
            } else {
                if (this.end == null) {
                    this.end = new DateTimeType();
                }
                this.end.setValue(dateAndTime);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("frequency", "integer", "Indicates how often the event should occur.", 0, Integer.MAX_VALUE, this.frequency));
            list.add(new Property("when", "code", "Identifies the occurrence of daily life that determines timing.", 0, Integer.MAX_VALUE, this.when));
            list.add(new Property("duration", "decimal", "How long each repetition should last.", 0, Integer.MAX_VALUE, this.duration));
            list.add(new Property("units", "code", "The units of time for the duration.", 0, Integer.MAX_VALUE, this.units));
            list.add(new Property("count", "integer", "A total count of the desired number of repetitions.", 0, Integer.MAX_VALUE, this.count));
            list.add(new Property("end", "dateTime", "When to stop repeating the schedule.", 0, Integer.MAX_VALUE, this.end));
        }

        public ScheduleRepeatComponent copy() {
            ScheduleRepeatComponent scheduleRepeatComponent = new ScheduleRepeatComponent();
            scheduleRepeatComponent.frequency = this.frequency == null ? null : this.frequency.copy();
            scheduleRepeatComponent.when = this.when == null ? null : this.when.copy();
            scheduleRepeatComponent.duration = this.duration == null ? null : this.duration.copy();
            scheduleRepeatComponent.units = this.units == null ? null : this.units.copy();
            scheduleRepeatComponent.count = this.count == null ? null : this.count.copy();
            scheduleRepeatComponent.end = this.end == null ? null : this.end.copy();
            return scheduleRepeatComponent;
        }
    }

    public static class UnitsOfTimeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("s".equals(string)) {
                return UnitsOfTime.s;
            }
            if ("min".equals(string)) {
                return UnitsOfTime.min;
            }
            if ("h".equals(string)) {
                return UnitsOfTime.h;
            }
            if ("d".equals(string)) {
                return UnitsOfTime.d;
            }
            if ("wk".equals(string)) {
                return UnitsOfTime.wk;
            }
            if ("mo".equals(string)) {
                return UnitsOfTime.mo;
            }
            if ("a".equals(string)) {
                return UnitsOfTime.a;
            }
            throw new Exception("Unknown UnitsOfTime code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == UnitsOfTime.s) {
                return "s";
            }
            if (enum_ == UnitsOfTime.min) {
                return "min";
            }
            if (enum_ == UnitsOfTime.h) {
                return "h";
            }
            if (enum_ == UnitsOfTime.d) {
                return "d";
            }
            if (enum_ == UnitsOfTime.wk) {
                return "wk";
            }
            if (enum_ == UnitsOfTime.mo) {
                return "mo";
            }
            if (enum_ == UnitsOfTime.a) {
                return "a";
            }
            return "?";
        }
    }

    public static enum UnitsOfTime {
        s,
        min,
        h,
        d,
        wk,
        mo,
        a,
        Null;


        public static UnitsOfTime fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("s".equals(string)) {
                return s;
            }
            if ("min".equals(string)) {
                return min;
            }
            if ("h".equals(string)) {
                return h;
            }
            if ("d".equals(string)) {
                return d;
            }
            if ("wk".equals(string)) {
                return wk;
            }
            if ("mo".equals(string)) {
                return mo;
            }
            if ("a".equals(string)) {
                return a;
            }
            throw new Exception("Unknown UnitsOfTime code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case s: {
                    return "s";
                }
                case min: {
                    return "min";
                }
                case h: {
                    return "h";
                }
                case d: {
                    return "d";
                }
                case wk: {
                    return "wk";
                }
                case mo: {
                    return "mo";
                }
                case a: {
                    return "a";
                }
            }
            return "?";
        }
    }

    public static class EventTimingEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("HS".equals(string)) {
                return EventTiming.hS;
            }
            if ("WAKE".equals(string)) {
                return EventTiming.wAKE;
            }
            if ("AC".equals(string)) {
                return EventTiming.aC;
            }
            if ("ACM".equals(string)) {
                return EventTiming.aCM;
            }
            if ("ACD".equals(string)) {
                return EventTiming.aCD;
            }
            if ("ACV".equals(string)) {
                return EventTiming.aCV;
            }
            if ("PC".equals(string)) {
                return EventTiming.pC;
            }
            if ("PCM".equals(string)) {
                return EventTiming.pCM;
            }
            if ("PCD".equals(string)) {
                return EventTiming.pCD;
            }
            if ("PCV".equals(string)) {
                return EventTiming.pCV;
            }
            throw new Exception("Unknown EventTiming code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == EventTiming.hS) {
                return "HS";
            }
            if (enum_ == EventTiming.wAKE) {
                return "WAKE";
            }
            if (enum_ == EventTiming.aC) {
                return "AC";
            }
            if (enum_ == EventTiming.aCM) {
                return "ACM";
            }
            if (enum_ == EventTiming.aCD) {
                return "ACD";
            }
            if (enum_ == EventTiming.aCV) {
                return "ACV";
            }
            if (enum_ == EventTiming.pC) {
                return "PC";
            }
            if (enum_ == EventTiming.pCM) {
                return "PCM";
            }
            if (enum_ == EventTiming.pCD) {
                return "PCD";
            }
            if (enum_ == EventTiming.pCV) {
                return "PCV";
            }
            return "?";
        }
    }

    public static enum EventTiming {
        hS,
        wAKE,
        aC,
        aCM,
        aCD,
        aCV,
        pC,
        pCM,
        pCD,
        pCV,
        Null;


        public static EventTiming fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("HS".equals(string)) {
                return hS;
            }
            if ("WAKE".equals(string)) {
                return wAKE;
            }
            if ("AC".equals(string)) {
                return aC;
            }
            if ("ACM".equals(string)) {
                return aCM;
            }
            if ("ACD".equals(string)) {
                return aCD;
            }
            if ("ACV".equals(string)) {
                return aCV;
            }
            if ("PC".equals(string)) {
                return pC;
            }
            if ("PCM".equals(string)) {
                return pCM;
            }
            if ("PCD".equals(string)) {
                return pCD;
            }
            if ("PCV".equals(string)) {
                return pCV;
            }
            throw new Exception("Unknown EventTiming code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case hS: {
                    return "HS";
                }
                case wAKE: {
                    return "WAKE";
                }
                case aC: {
                    return "AC";
                }
                case aCM: {
                    return "ACM";
                }
                case aCD: {
                    return "ACD";
                }
                case aCV: {
                    return "ACV";
                }
                case pC: {
                    return "PC";
                }
                case pCM: {
                    return "PCM";
                }
                case pCD: {
                    return "PCD";
                }
                case pCV: {
                    return "PCV";
                }
            }
            return "?";
        }
    }
}

