/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class SecurityEvent
extends Resource {
    protected SecurityEventEventComponent event;
    protected List<SecurityEventParticipantComponent> participant = new ArrayList<SecurityEventParticipantComponent>();
    protected SecurityEventSourceComponent source;
    protected List<SecurityEventObjectComponent> object = new ArrayList<SecurityEventObjectComponent>();
    private static final long serialVersionUID = -216029818L;

    public SecurityEvent() {
    }

    public SecurityEvent(SecurityEventEventComponent securityEventEventComponent, SecurityEventSourceComponent securityEventSourceComponent) {
        this.event = securityEventEventComponent;
        this.source = securityEventSourceComponent;
    }

    public SecurityEventEventComponent getEvent() {
        return this.event;
    }

    public SecurityEvent setEvent(SecurityEventEventComponent securityEventEventComponent) {
        this.event = securityEventEventComponent;
        return this;
    }

    public List<SecurityEventParticipantComponent> getParticipant() {
        return this.participant;
    }

    public SecurityEventParticipantComponent addParticipant() {
        SecurityEventParticipantComponent securityEventParticipantComponent = new SecurityEventParticipantComponent();
        this.participant.add(securityEventParticipantComponent);
        return securityEventParticipantComponent;
    }

    public SecurityEventSourceComponent getSource() {
        return this.source;
    }

    public SecurityEvent setSource(SecurityEventSourceComponent securityEventSourceComponent) {
        this.source = securityEventSourceComponent;
        return this;
    }

    public List<SecurityEventObjectComponent> getObject() {
        return this.object;
    }

    public SecurityEventObjectComponent addObject() {
        SecurityEventObjectComponent securityEventObjectComponent = new SecurityEventObjectComponent();
        this.object.add(securityEventObjectComponent);
        return securityEventObjectComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("event", "", "Identifies the name, action type, time, and disposition of the audited event.", 0, Integer.MAX_VALUE, this.event));
        list.add(new Property("participant", "", "A person, a hardware device or software process.", 0, Integer.MAX_VALUE, this.participant));
        list.add(new Property("source", "", "Application systems and processes.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("object", "", "Specific instances of data or objects that have been accessed.", 0, Integer.MAX_VALUE, this.object));
    }

    public SecurityEvent copy() {
        SecurityEvent securityEvent = new SecurityEvent();
        securityEvent.event = this.event == null ? null : this.event.copy();
        securityEvent.participant = new ArrayList<SecurityEventParticipantComponent>();
        for (SecurityEventParticipantComponent backboneElement : this.participant) {
            securityEvent.participant.add(backboneElement.copy());
        }
        securityEvent.source = this.source == null ? null : this.source.copy();
        securityEvent.object = new ArrayList<SecurityEventObjectComponent>();
        for (SecurityEventObjectComponent securityEventObjectComponent : this.object) {
            securityEvent.object.add(securityEventObjectComponent.copy());
        }
        return securityEvent;
    }

    protected SecurityEvent typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SecurityEvent;
    }

    public static class SecurityEventObjectDetailComponent
    extends BackboneElement {
        protected StringType type;
        protected Base64BinaryType value;
        private static final long serialVersionUID = 11139504L;

        public SecurityEventObjectDetailComponent() {
        }

        public SecurityEventObjectDetailComponent(StringType stringType, Base64BinaryType base64BinaryType) {
            this.type = stringType;
            this.value = base64BinaryType;
        }

        public StringType getType() {
            return this.type;
        }

        public SecurityEventObjectDetailComponent setType(StringType stringType) {
            this.type = stringType;
            return this;
        }

        public String getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public SecurityEventObjectDetailComponent setTypeSimple(String string) {
            if (this.type == null) {
                this.type = new StringType();
            }
            this.type.setValue(string);
            return this;
        }

        public Base64BinaryType getValue() {
            return this.value;
        }

        public SecurityEventObjectDetailComponent setValue(Base64BinaryType base64BinaryType) {
            this.value = base64BinaryType;
            return this;
        }

        public byte[] getValueSimple() {
            return this.value == null ? null : this.value.getValue();
        }

        public SecurityEventObjectDetailComponent setValueSimple(byte[] byArray) {
            if (this.value == null) {
                this.value = new Base64BinaryType();
            }
            this.value.setValue(byArray);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "string", "Name of the property.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("value", "base64Binary", "Property value.", 0, Integer.MAX_VALUE, this.value));
        }

        public SecurityEventObjectDetailComponent copy() {
            SecurityEventObjectDetailComponent securityEventObjectDetailComponent = new SecurityEventObjectDetailComponent();
            securityEventObjectDetailComponent.type = this.type == null ? null : this.type.copy();
            securityEventObjectDetailComponent.value = this.value == null ? null : this.value.copy();
            return securityEventObjectDetailComponent;
        }
    }

    public static class SecurityEventObjectComponent
    extends BackboneElement {
        protected Identifier identifier;
        protected ResourceReference reference;
        protected Resource referenceTarget;
        protected Enumeration<ObjectType> type;
        protected Enumeration<ObjectRole> role;
        protected Enumeration<ObjectLifecycle> lifecycle;
        protected CodeableConcept sensitivity;
        protected StringType name;
        protected StringType description;
        protected Base64BinaryType query;
        protected List<SecurityEventObjectDetailComponent> detail = new ArrayList<SecurityEventObjectDetailComponent>();
        private static final long serialVersionUID = -876364505L;

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public SecurityEventObjectComponent setIdentifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public ResourceReference getReference() {
            return this.reference;
        }

        public SecurityEventObjectComponent setReference(ResourceReference resourceReference) {
            this.reference = resourceReference;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public SecurityEventObjectComponent setReferenceTarget(Resource resource) {
            this.referenceTarget = resource;
            return this;
        }

        public Enumeration<ObjectType> getType() {
            return this.type;
        }

        public SecurityEventObjectComponent setType(Enumeration<ObjectType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public ObjectType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public SecurityEventObjectComponent setTypeSimple(ObjectType objectType) {
            if (objectType == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration();
                }
                this.type.setValue(objectType);
            }
            return this;
        }

        public Enumeration<ObjectRole> getRole() {
            return this.role;
        }

        public SecurityEventObjectComponent setRole(Enumeration<ObjectRole> enumeration) {
            this.role = enumeration;
            return this;
        }

        public ObjectRole getRoleSimple() {
            return this.role == null ? null : this.role.getValue();
        }

        public SecurityEventObjectComponent setRoleSimple(ObjectRole objectRole) {
            if (objectRole == null) {
                this.role = null;
            } else {
                if (this.role == null) {
                    this.role = new Enumeration();
                }
                this.role.setValue(objectRole);
            }
            return this;
        }

        public Enumeration<ObjectLifecycle> getLifecycle() {
            return this.lifecycle;
        }

        public SecurityEventObjectComponent setLifecycle(Enumeration<ObjectLifecycle> enumeration) {
            this.lifecycle = enumeration;
            return this;
        }

        public ObjectLifecycle getLifecycleSimple() {
            return this.lifecycle == null ? null : this.lifecycle.getValue();
        }

        public SecurityEventObjectComponent setLifecycleSimple(ObjectLifecycle objectLifecycle) {
            if (objectLifecycle == null) {
                this.lifecycle = null;
            } else {
                if (this.lifecycle == null) {
                    this.lifecycle = new Enumeration();
                }
                this.lifecycle.setValue(objectLifecycle);
            }
            return this;
        }

        public CodeableConcept getSensitivity() {
            return this.sensitivity;
        }

        public SecurityEventObjectComponent setSensitivity(CodeableConcept codeableConcept) {
            this.sensitivity = codeableConcept;
            return this;
        }

        public StringType getName() {
            return this.name;
        }

        public SecurityEventObjectComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public SecurityEventObjectComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public StringType getDescription() {
            return this.description;
        }

        public SecurityEventObjectComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public SecurityEventObjectComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public Base64BinaryType getQuery() {
            return this.query;
        }

        public SecurityEventObjectComponent setQuery(Base64BinaryType base64BinaryType) {
            this.query = base64BinaryType;
            return this;
        }

        public byte[] getQuerySimple() {
            return this.query == null ? null : this.query.getValue();
        }

        public SecurityEventObjectComponent setQuerySimple(byte[] byArray) {
            if (byArray == null) {
                this.query = null;
            } else {
                if (this.query == null) {
                    this.query = new Base64BinaryType();
                }
                this.query.setValue(byArray);
            }
            return this;
        }

        public List<SecurityEventObjectDetailComponent> getDetail() {
            return this.detail;
        }

        public SecurityEventObjectDetailComponent addDetail() {
            SecurityEventObjectDetailComponent securityEventObjectDetailComponent = new SecurityEventObjectDetailComponent();
            this.detail.add(securityEventObjectDetailComponent);
            return securityEventObjectDetailComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "Identifier", "Identifies a specific instance of the participant object. The reference should always be version specific.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("reference", "Resource(Any)", "Identifies a specific instance of the participant object. The reference should always be version specific.", 0, Integer.MAX_VALUE, this.reference));
            list.add(new Property("type", "code", "Object type being audited.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("role", "code", "Code representing the functional application role of Participant Object being audited.", 0, Integer.MAX_VALUE, this.role));
            list.add(new Property("lifecycle", "code", "Identifier for the data life-cycle stage for the participant object.", 0, Integer.MAX_VALUE, this.lifecycle));
            list.add(new Property("sensitivity", "CodeableConcept", "Denotes policy-defined sensitivity for the Participant Object ID such as VIP, HIV status, mental health status or similar topics.", 0, Integer.MAX_VALUE, this.sensitivity));
            list.add(new Property("name", "string", "An instance-specific descriptor of the Participant Object ID audited, such as a person's name.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("description", "string", "Text that describes the object in more detail.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("query", "base64Binary", "The actual query for a query-type participant object.", 0, Integer.MAX_VALUE, this.query));
            list.add(new Property("detail", "", "Additional Information about the Object.", 0, Integer.MAX_VALUE, this.detail));
        }

        public SecurityEventObjectComponent copy() {
            SecurityEventObjectComponent securityEventObjectComponent = new SecurityEventObjectComponent();
            securityEventObjectComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            securityEventObjectComponent.reference = this.reference == null ? null : this.reference.copy();
            securityEventObjectComponent.type = this.type == null ? null : this.type.copy();
            securityEventObjectComponent.role = this.role == null ? null : this.role.copy();
            securityEventObjectComponent.lifecycle = this.lifecycle == null ? null : this.lifecycle.copy();
            securityEventObjectComponent.sensitivity = this.sensitivity == null ? null : this.sensitivity.copy();
            securityEventObjectComponent.name = this.name == null ? null : this.name.copy();
            securityEventObjectComponent.description = this.description == null ? null : this.description.copy();
            securityEventObjectComponent.query = this.query == null ? null : this.query.copy();
            securityEventObjectComponent.detail = new ArrayList<SecurityEventObjectDetailComponent>();
            for (SecurityEventObjectDetailComponent securityEventObjectDetailComponent : this.detail) {
                securityEventObjectComponent.detail.add(securityEventObjectDetailComponent.copy());
            }
            return securityEventObjectComponent;
        }
    }

    public static class SecurityEventSourceComponent
    extends BackboneElement {
        protected StringType site;
        protected StringType identifier;
        protected List<Coding> type = new ArrayList<Coding>();
        private static final long serialVersionUID = 1938527187L;

        public SecurityEventSourceComponent() {
        }

        public SecurityEventSourceComponent(StringType stringType) {
            this.identifier = stringType;
        }

        public StringType getSite() {
            return this.site;
        }

        public SecurityEventSourceComponent setSite(StringType stringType) {
            this.site = stringType;
            return this;
        }

        public String getSiteSimple() {
            return this.site == null ? null : this.site.getValue();
        }

        public SecurityEventSourceComponent setSiteSimple(String string) {
            if (string == null) {
                this.site = null;
            } else {
                if (this.site == null) {
                    this.site = new StringType();
                }
                this.site.setValue(string);
            }
            return this;
        }

        public StringType getIdentifier() {
            return this.identifier;
        }

        public SecurityEventSourceComponent setIdentifier(StringType stringType) {
            this.identifier = stringType;
            return this;
        }

        public String getIdentifierSimple() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public SecurityEventSourceComponent setIdentifierSimple(String string) {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(string);
            return this;
        }

        public List<Coding> getType() {
            return this.type;
        }

        public Coding addType() {
            Coding coding = new Coding();
            this.type.add(coding);
            return coding;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("site", "string", "Logical source location within the healthcare enterprise network.", 0, Integer.MAX_VALUE, this.site));
            list.add(new Property("identifier", "string", "Identifier of the source where the event originated.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("type", "Coding", "Code specifying the type of source where event originated.", 0, Integer.MAX_VALUE, this.type));
        }

        public SecurityEventSourceComponent copy() {
            SecurityEventSourceComponent securityEventSourceComponent = new SecurityEventSourceComponent();
            securityEventSourceComponent.site = this.site == null ? null : this.site.copy();
            securityEventSourceComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            securityEventSourceComponent.type = new ArrayList<Coding>();
            for (Coding coding : this.type) {
                securityEventSourceComponent.type.add(coding.copy());
            }
            return securityEventSourceComponent;
        }
    }

    public static class SecurityEventParticipantNetworkComponent
    extends BackboneElement {
        protected StringType identifier;
        protected Enumeration<NetworkType> type;
        private static final long serialVersionUID = -1946856025L;

        public StringType getIdentifier() {
            return this.identifier;
        }

        public SecurityEventParticipantNetworkComponent setIdentifier(StringType stringType) {
            this.identifier = stringType;
            return this;
        }

        public String getIdentifierSimple() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public SecurityEventParticipantNetworkComponent setIdentifierSimple(String string) {
            if (string == null) {
                this.identifier = null;
            } else {
                if (this.identifier == null) {
                    this.identifier = new StringType();
                }
                this.identifier.setValue(string);
            }
            return this;
        }

        public Enumeration<NetworkType> getType() {
            return this.type;
        }

        public SecurityEventParticipantNetworkComponent setType(Enumeration<NetworkType> enumeration) {
            this.type = enumeration;
            return this;
        }

        public NetworkType getTypeSimple() {
            return this.type == null ? null : this.type.getValue();
        }

        public SecurityEventParticipantNetworkComponent setTypeSimple(NetworkType networkType) {
            if (networkType == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration();
                }
                this.type.setValue(networkType);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "string", "An identifier for the network access point of the user device for the audit event.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("type", "code", "An identifier for the type of network access point that originated the audit event.", 0, Integer.MAX_VALUE, this.type));
        }

        public SecurityEventParticipantNetworkComponent copy() {
            SecurityEventParticipantNetworkComponent securityEventParticipantNetworkComponent = new SecurityEventParticipantNetworkComponent();
            securityEventParticipantNetworkComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            securityEventParticipantNetworkComponent.type = this.type == null ? null : this.type.copy();
            return securityEventParticipantNetworkComponent;
        }
    }

    public static class SecurityEventParticipantComponent
    extends BackboneElement {
        protected List<CodeableConcept> role = new ArrayList<CodeableConcept>();
        protected ResourceReference reference;
        protected Resource referenceTarget;
        protected StringType userId;
        protected StringType altId;
        protected StringType name;
        protected BooleanType requestor;
        protected Coding media;
        protected SecurityEventParticipantNetworkComponent network;
        private static final long serialVersionUID = 410004357L;

        public SecurityEventParticipantComponent() {
        }

        public SecurityEventParticipantComponent(BooleanType booleanType) {
            this.requestor = booleanType;
        }

        public List<CodeableConcept> getRole() {
            return this.role;
        }

        public CodeableConcept addRole() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.role.add(codeableConcept);
            return codeableConcept;
        }

        public ResourceReference getReference() {
            return this.reference;
        }

        public SecurityEventParticipantComponent setReference(ResourceReference resourceReference) {
            this.reference = resourceReference;
            return this;
        }

        public Resource getReferenceTarget() {
            return this.referenceTarget;
        }

        public SecurityEventParticipantComponent setReferenceTarget(Resource resource) {
            this.referenceTarget = resource;
            return this;
        }

        public StringType getUserId() {
            return this.userId;
        }

        public SecurityEventParticipantComponent setUserId(StringType stringType) {
            this.userId = stringType;
            return this;
        }

        public String getUserIdSimple() {
            return this.userId == null ? null : this.userId.getValue();
        }

        public SecurityEventParticipantComponent setUserIdSimple(String string) {
            if (string == null) {
                this.userId = null;
            } else {
                if (this.userId == null) {
                    this.userId = new StringType();
                }
                this.userId.setValue(string);
            }
            return this;
        }

        public StringType getAltId() {
            return this.altId;
        }

        public SecurityEventParticipantComponent setAltId(StringType stringType) {
            this.altId = stringType;
            return this;
        }

        public String getAltIdSimple() {
            return this.altId == null ? null : this.altId.getValue();
        }

        public SecurityEventParticipantComponent setAltIdSimple(String string) {
            if (string == null) {
                this.altId = null;
            } else {
                if (this.altId == null) {
                    this.altId = new StringType();
                }
                this.altId.setValue(string);
            }
            return this;
        }

        public StringType getName() {
            return this.name;
        }

        public SecurityEventParticipantComponent setName(StringType stringType) {
            this.name = stringType;
            return this;
        }

        public String getNameSimple() {
            return this.name == null ? null : this.name.getValue();
        }

        public SecurityEventParticipantComponent setNameSimple(String string) {
            if (string == null) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(string);
            }
            return this;
        }

        public BooleanType getRequestor() {
            return this.requestor;
        }

        public SecurityEventParticipantComponent setRequestor(BooleanType booleanType) {
            this.requestor = booleanType;
            return this;
        }

        public boolean getRequestorSimple() {
            return this.requestor == null ? false : this.requestor.getValue();
        }

        public SecurityEventParticipantComponent setRequestorSimple(boolean bl) {
            if (this.requestor == null) {
                this.requestor = new BooleanType();
            }
            this.requestor.setValue(bl);
            return this;
        }

        public Coding getMedia() {
            return this.media;
        }

        public SecurityEventParticipantComponent setMedia(Coding coding) {
            this.media = coding;
            return this;
        }

        public SecurityEventParticipantNetworkComponent getNetwork() {
            return this.network;
        }

        public SecurityEventParticipantComponent setNetwork(SecurityEventParticipantNetworkComponent securityEventParticipantNetworkComponent) {
            this.network = securityEventParticipantNetworkComponent;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("role", "CodeableConcept", "Specification of the role(s) the user plays when performing the event. Usually the codes used in this element are local codes defined by the role-based access control security system used in the local context.", 0, Integer.MAX_VALUE, this.role));
            list.add(new Property("reference", "Resource(Practitioner|Patient|Device)", "Direct reference to a resource that identifies the participant.", 0, Integer.MAX_VALUE, this.reference));
            list.add(new Property("userId", "string", "Unique identifier for the user actively participating in the event.", 0, Integer.MAX_VALUE, this.userId));
            list.add(new Property("altId", "string", "Alternative Participant Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g., single sign-on), if available.", 0, Integer.MAX_VALUE, this.altId));
            list.add(new Property("name", "string", "Human-meaningful name for the user.", 0, Integer.MAX_VALUE, this.name));
            list.add(new Property("requestor", "boolean", "Indicator that the user is or is not the requestor, or initiator, for the event being audited.", 0, Integer.MAX_VALUE, this.requestor));
            list.add(new Property("media", "Coding", "Type of media involved. Used when the event is about exporting/importing onto media.", 0, Integer.MAX_VALUE, this.media));
            list.add(new Property("network", "", "Logical network location for application activity, if the activity has a network location.", 0, Integer.MAX_VALUE, this.network));
        }

        public SecurityEventParticipantComponent copy() {
            SecurityEventParticipantComponent securityEventParticipantComponent = new SecurityEventParticipantComponent();
            securityEventParticipantComponent.role = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.role) {
                securityEventParticipantComponent.role.add(codeableConcept.copy());
            }
            securityEventParticipantComponent.reference = this.reference == null ? null : this.reference.copy();
            securityEventParticipantComponent.userId = this.userId == null ? null : this.userId.copy();
            securityEventParticipantComponent.altId = this.altId == null ? null : this.altId.copy();
            securityEventParticipantComponent.name = this.name == null ? null : this.name.copy();
            securityEventParticipantComponent.requestor = this.requestor == null ? null : this.requestor.copy();
            securityEventParticipantComponent.media = this.media == null ? null : this.media.copy();
            securityEventParticipantComponent.network = this.network == null ? null : this.network.copy();
            return securityEventParticipantComponent;
        }
    }

    public static class SecurityEventEventComponent
    extends BackboneElement {
        protected CodeableConcept type;
        protected List<CodeableConcept> subtype = new ArrayList<CodeableConcept>();
        protected Enumeration<SecurityEventAction> action;
        protected InstantType dateTime;
        protected Enumeration<SecurityEventOutcome> outcome;
        protected StringType outcomeDesc;
        private static final long serialVersionUID = -456797046L;

        public SecurityEventEventComponent() {
        }

        public SecurityEventEventComponent(CodeableConcept codeableConcept, InstantType instantType) {
            this.type = codeableConcept;
            this.dateTime = instantType;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public SecurityEventEventComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public List<CodeableConcept> getSubtype() {
            return this.subtype;
        }

        public CodeableConcept addSubtype() {
            CodeableConcept codeableConcept = new CodeableConcept();
            this.subtype.add(codeableConcept);
            return codeableConcept;
        }

        public Enumeration<SecurityEventAction> getAction() {
            return this.action;
        }

        public SecurityEventEventComponent setAction(Enumeration<SecurityEventAction> enumeration) {
            this.action = enumeration;
            return this;
        }

        public SecurityEventAction getActionSimple() {
            return this.action == null ? null : this.action.getValue();
        }

        public SecurityEventEventComponent setActionSimple(SecurityEventAction securityEventAction) {
            if (securityEventAction == null) {
                this.action = null;
            } else {
                if (this.action == null) {
                    this.action = new Enumeration();
                }
                this.action.setValue(securityEventAction);
            }
            return this;
        }

        public InstantType getDateTime() {
            return this.dateTime;
        }

        public SecurityEventEventComponent setDateTime(InstantType instantType) {
            this.dateTime = instantType;
            return this;
        }

        public DateAndTime getDateTimeSimple() {
            return this.dateTime == null ? null : this.dateTime.getValue();
        }

        public SecurityEventEventComponent setDateTimeSimple(DateAndTime dateAndTime) {
            if (this.dateTime == null) {
                this.dateTime = new InstantType();
            }
            this.dateTime.setValue(dateAndTime);
            return this;
        }

        public Enumeration<SecurityEventOutcome> getOutcome() {
            return this.outcome;
        }

        public SecurityEventEventComponent setOutcome(Enumeration<SecurityEventOutcome> enumeration) {
            this.outcome = enumeration;
            return this;
        }

        public SecurityEventOutcome getOutcomeSimple() {
            return this.outcome == null ? null : this.outcome.getValue();
        }

        public SecurityEventEventComponent setOutcomeSimple(SecurityEventOutcome securityEventOutcome) {
            if (securityEventOutcome == null) {
                this.outcome = null;
            } else {
                if (this.outcome == null) {
                    this.outcome = new Enumeration();
                }
                this.outcome.setValue(securityEventOutcome);
            }
            return this;
        }

        public StringType getOutcomeDesc() {
            return this.outcomeDesc;
        }

        public SecurityEventEventComponent setOutcomeDesc(StringType stringType) {
            this.outcomeDesc = stringType;
            return this;
        }

        public String getOutcomeDescSimple() {
            return this.outcomeDesc == null ? null : this.outcomeDesc.getValue();
        }

        public SecurityEventEventComponent setOutcomeDescSimple(String string) {
            if (string == null) {
                this.outcomeDesc = null;
            } else {
                if (this.outcomeDesc == null) {
                    this.outcomeDesc = new StringType();
                }
                this.outcomeDesc.setValue(string);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("type", "CodeableConcept", "Identifier for a family of the event.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("subtype", "CodeableConcept", "Identifier for the category of event.", 0, Integer.MAX_VALUE, this.subtype));
            list.add(new Property("action", "code", "Indicator for type of action performed during the event that generated the audit.", 0, Integer.MAX_VALUE, this.action));
            list.add(new Property("dateTime", "instant", "The time when the event occurred on the source.", 0, Integer.MAX_VALUE, this.dateTime));
            list.add(new Property("outcome", "code", "Indicates whether the event succeeded or failed.", 0, Integer.MAX_VALUE, this.outcome));
            list.add(new Property("outcomeDesc", "string", "A free text description of the outcome of the event.", 0, Integer.MAX_VALUE, this.outcomeDesc));
        }

        public SecurityEventEventComponent copy() {
            SecurityEventEventComponent securityEventEventComponent = new SecurityEventEventComponent();
            securityEventEventComponent.type = this.type == null ? null : this.type.copy();
            securityEventEventComponent.subtype = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.subtype) {
                securityEventEventComponent.subtype.add(codeableConcept.copy());
            }
            securityEventEventComponent.action = this.action == null ? null : this.action.copy();
            securityEventEventComponent.dateTime = this.dateTime == null ? null : this.dateTime.copy();
            securityEventEventComponent.outcome = this.outcome == null ? null : this.outcome.copy();
            securityEventEventComponent.outcomeDesc = this.outcomeDesc == null ? null : this.outcomeDesc.copy();
            return securityEventEventComponent;
        }
    }

    public static class ObjectLifecycleEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("1".equals(string)) {
                return ObjectLifecycle._1;
            }
            if ("2".equals(string)) {
                return ObjectLifecycle._2;
            }
            if ("3".equals(string)) {
                return ObjectLifecycle._3;
            }
            if ("4".equals(string)) {
                return ObjectLifecycle._4;
            }
            if ("5".equals(string)) {
                return ObjectLifecycle._5;
            }
            if ("6".equals(string)) {
                return ObjectLifecycle._6;
            }
            if ("7".equals(string)) {
                return ObjectLifecycle._7;
            }
            if ("8".equals(string)) {
                return ObjectLifecycle._8;
            }
            if ("9".equals(string)) {
                return ObjectLifecycle._9;
            }
            if ("10".equals(string)) {
                return ObjectLifecycle._10;
            }
            if ("11".equals(string)) {
                return ObjectLifecycle._11;
            }
            if ("12".equals(string)) {
                return ObjectLifecycle._12;
            }
            if ("13".equals(string)) {
                return ObjectLifecycle._13;
            }
            if ("14".equals(string)) {
                return ObjectLifecycle._14;
            }
            if ("15".equals(string)) {
                return ObjectLifecycle._15;
            }
            throw new Exception("Unknown ObjectLifecycle code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ObjectLifecycle._1) {
                return "1";
            }
            if (enum_ == ObjectLifecycle._2) {
                return "2";
            }
            if (enum_ == ObjectLifecycle._3) {
                return "3";
            }
            if (enum_ == ObjectLifecycle._4) {
                return "4";
            }
            if (enum_ == ObjectLifecycle._5) {
                return "5";
            }
            if (enum_ == ObjectLifecycle._6) {
                return "6";
            }
            if (enum_ == ObjectLifecycle._7) {
                return "7";
            }
            if (enum_ == ObjectLifecycle._8) {
                return "8";
            }
            if (enum_ == ObjectLifecycle._9) {
                return "9";
            }
            if (enum_ == ObjectLifecycle._10) {
                return "10";
            }
            if (enum_ == ObjectLifecycle._11) {
                return "11";
            }
            if (enum_ == ObjectLifecycle._12) {
                return "12";
            }
            if (enum_ == ObjectLifecycle._13) {
                return "13";
            }
            if (enum_ == ObjectLifecycle._14) {
                return "14";
            }
            if (enum_ == ObjectLifecycle._15) {
                return "15";
            }
            return "?";
        }
    }

    public static enum ObjectLifecycle {
        _1,
        _2,
        _3,
        _4,
        _5,
        _6,
        _7,
        _8,
        _9,
        _10,
        _11,
        _12,
        _13,
        _14,
        _15,
        Null;


        public static ObjectLifecycle fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("1".equals(string)) {
                return _1;
            }
            if ("2".equals(string)) {
                return _2;
            }
            if ("3".equals(string)) {
                return _3;
            }
            if ("4".equals(string)) {
                return _4;
            }
            if ("5".equals(string)) {
                return _5;
            }
            if ("6".equals(string)) {
                return _6;
            }
            if ("7".equals(string)) {
                return _7;
            }
            if ("8".equals(string)) {
                return _8;
            }
            if ("9".equals(string)) {
                return _9;
            }
            if ("10".equals(string)) {
                return _10;
            }
            if ("11".equals(string)) {
                return _11;
            }
            if ("12".equals(string)) {
                return _12;
            }
            if ("13".equals(string)) {
                return _13;
            }
            if ("14".equals(string)) {
                return _14;
            }
            if ("15".equals(string)) {
                return _15;
            }
            throw new Exception("Unknown ObjectLifecycle code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case _1: {
                    return "1";
                }
                case _2: {
                    return "2";
                }
                case _3: {
                    return "3";
                }
                case _4: {
                    return "4";
                }
                case _5: {
                    return "5";
                }
                case _6: {
                    return "6";
                }
                case _7: {
                    return "7";
                }
                case _8: {
                    return "8";
                }
                case _9: {
                    return "9";
                }
                case _10: {
                    return "10";
                }
                case _11: {
                    return "11";
                }
                case _12: {
                    return "12";
                }
                case _13: {
                    return "13";
                }
                case _14: {
                    return "14";
                }
                case _15: {
                    return "15";
                }
            }
            return "?";
        }
    }

    public static class ObjectRoleEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("1".equals(string)) {
                return ObjectRole._1;
            }
            if ("2".equals(string)) {
                return ObjectRole._2;
            }
            if ("3".equals(string)) {
                return ObjectRole._3;
            }
            if ("4".equals(string)) {
                return ObjectRole._4;
            }
            if ("5".equals(string)) {
                return ObjectRole._5;
            }
            if ("6".equals(string)) {
                return ObjectRole._6;
            }
            if ("7".equals(string)) {
                return ObjectRole._7;
            }
            if ("8".equals(string)) {
                return ObjectRole._8;
            }
            if ("9".equals(string)) {
                return ObjectRole._9;
            }
            if ("10".equals(string)) {
                return ObjectRole._10;
            }
            if ("11".equals(string)) {
                return ObjectRole._11;
            }
            if ("12".equals(string)) {
                return ObjectRole._12;
            }
            if ("13".equals(string)) {
                return ObjectRole._13;
            }
            if ("14".equals(string)) {
                return ObjectRole._14;
            }
            if ("15".equals(string)) {
                return ObjectRole._15;
            }
            if ("16".equals(string)) {
                return ObjectRole._16;
            }
            if ("17".equals(string)) {
                return ObjectRole._17;
            }
            if ("18".equals(string)) {
                return ObjectRole._18;
            }
            if ("19".equals(string)) {
                return ObjectRole._19;
            }
            if ("20".equals(string)) {
                return ObjectRole._20;
            }
            if ("21".equals(string)) {
                return ObjectRole._21;
            }
            if ("22".equals(string)) {
                return ObjectRole._22;
            }
            if ("23".equals(string)) {
                return ObjectRole._23;
            }
            if ("24".equals(string)) {
                return ObjectRole._24;
            }
            throw new Exception("Unknown ObjectRole code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ObjectRole._1) {
                return "1";
            }
            if (enum_ == ObjectRole._2) {
                return "2";
            }
            if (enum_ == ObjectRole._3) {
                return "3";
            }
            if (enum_ == ObjectRole._4) {
                return "4";
            }
            if (enum_ == ObjectRole._5) {
                return "5";
            }
            if (enum_ == ObjectRole._6) {
                return "6";
            }
            if (enum_ == ObjectRole._7) {
                return "7";
            }
            if (enum_ == ObjectRole._8) {
                return "8";
            }
            if (enum_ == ObjectRole._9) {
                return "9";
            }
            if (enum_ == ObjectRole._10) {
                return "10";
            }
            if (enum_ == ObjectRole._11) {
                return "11";
            }
            if (enum_ == ObjectRole._12) {
                return "12";
            }
            if (enum_ == ObjectRole._13) {
                return "13";
            }
            if (enum_ == ObjectRole._14) {
                return "14";
            }
            if (enum_ == ObjectRole._15) {
                return "15";
            }
            if (enum_ == ObjectRole._16) {
                return "16";
            }
            if (enum_ == ObjectRole._17) {
                return "17";
            }
            if (enum_ == ObjectRole._18) {
                return "18";
            }
            if (enum_ == ObjectRole._19) {
                return "19";
            }
            if (enum_ == ObjectRole._20) {
                return "20";
            }
            if (enum_ == ObjectRole._21) {
                return "21";
            }
            if (enum_ == ObjectRole._22) {
                return "22";
            }
            if (enum_ == ObjectRole._23) {
                return "23";
            }
            if (enum_ == ObjectRole._24) {
                return "24";
            }
            return "?";
        }
    }

    public static enum ObjectRole {
        _1,
        _2,
        _3,
        _4,
        _5,
        _6,
        _7,
        _8,
        _9,
        _10,
        _11,
        _12,
        _13,
        _14,
        _15,
        _16,
        _17,
        _18,
        _19,
        _20,
        _21,
        _22,
        _23,
        _24,
        Null;


        public static ObjectRole fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("1".equals(string)) {
                return _1;
            }
            if ("2".equals(string)) {
                return _2;
            }
            if ("3".equals(string)) {
                return _3;
            }
            if ("4".equals(string)) {
                return _4;
            }
            if ("5".equals(string)) {
                return _5;
            }
            if ("6".equals(string)) {
                return _6;
            }
            if ("7".equals(string)) {
                return _7;
            }
            if ("8".equals(string)) {
                return _8;
            }
            if ("9".equals(string)) {
                return _9;
            }
            if ("10".equals(string)) {
                return _10;
            }
            if ("11".equals(string)) {
                return _11;
            }
            if ("12".equals(string)) {
                return _12;
            }
            if ("13".equals(string)) {
                return _13;
            }
            if ("14".equals(string)) {
                return _14;
            }
            if ("15".equals(string)) {
                return _15;
            }
            if ("16".equals(string)) {
                return _16;
            }
            if ("17".equals(string)) {
                return _17;
            }
            if ("18".equals(string)) {
                return _18;
            }
            if ("19".equals(string)) {
                return _19;
            }
            if ("20".equals(string)) {
                return _20;
            }
            if ("21".equals(string)) {
                return _21;
            }
            if ("22".equals(string)) {
                return _22;
            }
            if ("23".equals(string)) {
                return _23;
            }
            if ("24".equals(string)) {
                return _24;
            }
            throw new Exception("Unknown ObjectRole code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case _1: {
                    return "1";
                }
                case _2: {
                    return "2";
                }
                case _3: {
                    return "3";
                }
                case _4: {
                    return "4";
                }
                case _5: {
                    return "5";
                }
                case _6: {
                    return "6";
                }
                case _7: {
                    return "7";
                }
                case _8: {
                    return "8";
                }
                case _9: {
                    return "9";
                }
                case _10: {
                    return "10";
                }
                case _11: {
                    return "11";
                }
                case _12: {
                    return "12";
                }
                case _13: {
                    return "13";
                }
                case _14: {
                    return "14";
                }
                case _15: {
                    return "15";
                }
                case _16: {
                    return "16";
                }
                case _17: {
                    return "17";
                }
                case _18: {
                    return "18";
                }
                case _19: {
                    return "19";
                }
                case _20: {
                    return "20";
                }
                case _21: {
                    return "21";
                }
                case _22: {
                    return "22";
                }
                case _23: {
                    return "23";
                }
                case _24: {
                    return "24";
                }
            }
            return "?";
        }
    }

    public static class ObjectTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("1".equals(string)) {
                return ObjectType._1;
            }
            if ("2".equals(string)) {
                return ObjectType._2;
            }
            if ("3".equals(string)) {
                return ObjectType._3;
            }
            if ("4".equals(string)) {
                return ObjectType._4;
            }
            throw new Exception("Unknown ObjectType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ObjectType._1) {
                return "1";
            }
            if (enum_ == ObjectType._2) {
                return "2";
            }
            if (enum_ == ObjectType._3) {
                return "3";
            }
            if (enum_ == ObjectType._4) {
                return "4";
            }
            return "?";
        }
    }

    public static enum ObjectType {
        _1,
        _2,
        _3,
        _4,
        Null;


        public static ObjectType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("1".equals(string)) {
                return _1;
            }
            if ("2".equals(string)) {
                return _2;
            }
            if ("3".equals(string)) {
                return _3;
            }
            if ("4".equals(string)) {
                return _4;
            }
            throw new Exception("Unknown ObjectType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case _1: {
                    return "1";
                }
                case _2: {
                    return "2";
                }
                case _3: {
                    return "3";
                }
                case _4: {
                    return "4";
                }
            }
            return "?";
        }
    }

    public static class NetworkTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("1".equals(string)) {
                return NetworkType._1;
            }
            if ("2".equals(string)) {
                return NetworkType._2;
            }
            if ("3".equals(string)) {
                return NetworkType._3;
            }
            if ("4".equals(string)) {
                return NetworkType._4;
            }
            if ("5".equals(string)) {
                return NetworkType._5;
            }
            throw new Exception("Unknown NetworkType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == NetworkType._1) {
                return "1";
            }
            if (enum_ == NetworkType._2) {
                return "2";
            }
            if (enum_ == NetworkType._3) {
                return "3";
            }
            if (enum_ == NetworkType._4) {
                return "4";
            }
            if (enum_ == NetworkType._5) {
                return "5";
            }
            return "?";
        }
    }

    public static enum NetworkType {
        _1,
        _2,
        _3,
        _4,
        _5,
        Null;


        public static NetworkType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("1".equals(string)) {
                return _1;
            }
            if ("2".equals(string)) {
                return _2;
            }
            if ("3".equals(string)) {
                return _3;
            }
            if ("4".equals(string)) {
                return _4;
            }
            if ("5".equals(string)) {
                return _5;
            }
            throw new Exception("Unknown NetworkType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case _1: {
                    return "1";
                }
                case _2: {
                    return "2";
                }
                case _3: {
                    return "3";
                }
                case _4: {
                    return "4";
                }
                case _5: {
                    return "5";
                }
            }
            return "?";
        }
    }

    public static class SecurityEventOutcomeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("0".equals(string)) {
                return SecurityEventOutcome._0;
            }
            if ("4".equals(string)) {
                return SecurityEventOutcome._4;
            }
            if ("8".equals(string)) {
                return SecurityEventOutcome._8;
            }
            if ("12".equals(string)) {
                return SecurityEventOutcome._12;
            }
            throw new Exception("Unknown SecurityEventOutcome code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == SecurityEventOutcome._0) {
                return "0";
            }
            if (enum_ == SecurityEventOutcome._4) {
                return "4";
            }
            if (enum_ == SecurityEventOutcome._8) {
                return "8";
            }
            if (enum_ == SecurityEventOutcome._12) {
                return "12";
            }
            return "?";
        }
    }

    public static enum SecurityEventOutcome {
        _0,
        _4,
        _8,
        _12,
        Null;


        public static SecurityEventOutcome fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("0".equals(string)) {
                return _0;
            }
            if ("4".equals(string)) {
                return _4;
            }
            if ("8".equals(string)) {
                return _8;
            }
            if ("12".equals(string)) {
                return _12;
            }
            throw new Exception("Unknown SecurityEventOutcome code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case _0: {
                    return "0";
                }
                case _4: {
                    return "4";
                }
                case _8: {
                    return "8";
                }
                case _12: {
                    return "12";
                }
            }
            return "?";
        }
    }

    public static class SecurityEventActionEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("C".equals(string)) {
                return SecurityEventAction.C;
            }
            if ("R".equals(string)) {
                return SecurityEventAction.R;
            }
            if ("U".equals(string)) {
                return SecurityEventAction.U;
            }
            if ("D".equals(string)) {
                return SecurityEventAction.D;
            }
            if ("E".equals(string)) {
                return SecurityEventAction.E;
            }
            throw new Exception("Unknown SecurityEventAction code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == SecurityEventAction.C) {
                return "C";
            }
            if (enum_ == SecurityEventAction.R) {
                return "R";
            }
            if (enum_ == SecurityEventAction.U) {
                return "U";
            }
            if (enum_ == SecurityEventAction.D) {
                return "D";
            }
            if (enum_ == SecurityEventAction.E) {
                return "E";
            }
            return "?";
        }
    }

    public static enum SecurityEventAction {
        C,
        R,
        U,
        D,
        E,
        Null;


        public static SecurityEventAction fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("C".equals(string)) {
                return C;
            }
            if ("R".equals(string)) {
                return R;
            }
            if ("U".equals(string)) {
                return U;
            }
            if ("D".equals(string)) {
                return D;
            }
            if ("E".equals(string)) {
                return E;
            }
            throw new Exception("Unknown SecurityEventAction code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case C: {
                    return "C";
                }
                case R: {
                    return "R";
                }
                case U: {
                    return "U";
                }
                case D: {
                    return "D";
                }
                case E: {
                    return "E";
                }
            }
            return "?";
        }
    }
}

