/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.Type;

public class Specimen
extends Resource {
    protected List<Identifier> identifier = new ArrayList<Identifier>();
    protected CodeableConcept type;
    protected List<SpecimenSourceComponent> source = new ArrayList<SpecimenSourceComponent>();
    protected ResourceReference subject;
    protected Resource subjectTarget;
    protected Identifier accessionIdentifier;
    protected DateTimeType receivedTime;
    protected SpecimenCollectionComponent collection;
    protected List<SpecimenTreatmentComponent> treatment = new ArrayList<SpecimenTreatmentComponent>();
    protected List<SpecimenContainerComponent> container = new ArrayList<SpecimenContainerComponent>();
    private static final long serialVersionUID = 1171226212L;

    public Specimen() {
    }

    public Specimen(ResourceReference resourceReference, SpecimenCollectionComponent specimenCollectionComponent) {
        this.subject = resourceReference;
        this.collection = specimenCollectionComponent;
    }

    public List<Identifier> getIdentifier() {
        return this.identifier;
    }

    public Identifier addIdentifier() {
        Identifier identifier = new Identifier();
        this.identifier.add(identifier);
        return identifier;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Specimen setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public List<SpecimenSourceComponent> getSource() {
        return this.source;
    }

    public SpecimenSourceComponent addSource() {
        SpecimenSourceComponent specimenSourceComponent = new SpecimenSourceComponent();
        this.source.add(specimenSourceComponent);
        return specimenSourceComponent;
    }

    public ResourceReference getSubject() {
        return this.subject;
    }

    public Specimen setSubject(ResourceReference resourceReference) {
        this.subject = resourceReference;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Specimen setSubjectTarget(Resource resource) {
        this.subjectTarget = resource;
        return this;
    }

    public Identifier getAccessionIdentifier() {
        return this.accessionIdentifier;
    }

    public Specimen setAccessionIdentifier(Identifier identifier) {
        this.accessionIdentifier = identifier;
        return this;
    }

    public DateTimeType getReceivedTime() {
        return this.receivedTime;
    }

    public Specimen setReceivedTime(DateTimeType dateTimeType) {
        this.receivedTime = dateTimeType;
        return this;
    }

    public DateAndTime getReceivedTimeSimple() {
        return this.receivedTime == null ? null : this.receivedTime.getValue();
    }

    public Specimen setReceivedTimeSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.receivedTime = null;
        } else {
            if (this.receivedTime == null) {
                this.receivedTime = new DateTimeType();
            }
            this.receivedTime.setValue(dateAndTime);
        }
        return this;
    }

    public SpecimenCollectionComponent getCollection() {
        return this.collection;
    }

    public Specimen setCollection(SpecimenCollectionComponent specimenCollectionComponent) {
        this.collection = specimenCollectionComponent;
        return this;
    }

    public List<SpecimenTreatmentComponent> getTreatment() {
        return this.treatment;
    }

    public SpecimenTreatmentComponent addTreatment() {
        SpecimenTreatmentComponent specimenTreatmentComponent = new SpecimenTreatmentComponent();
        this.treatment.add(specimenTreatmentComponent);
        return specimenTreatmentComponent;
    }

    public List<SpecimenContainerComponent> getContainer() {
        return this.container;
    }

    public SpecimenContainerComponent addContainer() {
        SpecimenContainerComponent specimenContainerComponent = new SpecimenContainerComponent();
        this.container.add(specimenContainerComponent);
        return specimenContainerComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "Identifier", "Id for specimen.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("type", "CodeableConcept", "Kind of material that forms the specimen.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("source", "", "Parent specimen from which the focal specimen was a component.", 0, Integer.MAX_VALUE, this.source));
        list.add(new Property("subject", "Resource(Patient|Group|Device|Substance)", "Where the specimen came from. This may be the patient(s) or from the environment or  a device.", 0, Integer.MAX_VALUE, this.subject));
        list.add(new Property("accessionIdentifier", "Identifier", "The identifier assigned by the lab when accessioning specimen(s). This is not necessarily the same as the specimen identifier, depending on local lab procedures.", 0, Integer.MAX_VALUE, this.accessionIdentifier));
        list.add(new Property("receivedTime", "dateTime", "Time when specimen was received for processing or testing.", 0, Integer.MAX_VALUE, this.receivedTime));
        list.add(new Property("collection", "", "Details concerning the specimen collection.", 0, Integer.MAX_VALUE, this.collection));
        list.add(new Property("treatment", "", "Details concerning treatment and processing steps for the specimen.", 0, Integer.MAX_VALUE, this.treatment));
        list.add(new Property("container", "", "The container holding the specimen.  The recursive nature of containers; i.e. blood in tube in tray in rack is not addressed here.", 0, Integer.MAX_VALUE, this.container));
    }

    public Specimen copy() {
        Specimen specimen = new Specimen();
        specimen.identifier = new ArrayList<Identifier>();
        for (Identifier element : this.identifier) {
            specimen.identifier.add(element.copy());
        }
        specimen.type = this.type == null ? null : this.type.copy();
        specimen.source = new ArrayList<SpecimenSourceComponent>();
        for (SpecimenSourceComponent specimenSourceComponent : this.source) {
            specimen.source.add(specimenSourceComponent.copy());
        }
        specimen.subject = this.subject == null ? null : this.subject.copy();
        specimen.accessionIdentifier = this.accessionIdentifier == null ? null : this.accessionIdentifier.copy();
        specimen.receivedTime = this.receivedTime == null ? null : this.receivedTime.copy();
        specimen.collection = this.collection == null ? null : this.collection.copy();
        specimen.treatment = new ArrayList<SpecimenTreatmentComponent>();
        for (SpecimenTreatmentComponent specimenTreatmentComponent : this.treatment) {
            specimen.treatment.add(specimenTreatmentComponent.copy());
        }
        specimen.container = new ArrayList<SpecimenContainerComponent>();
        for (SpecimenContainerComponent specimenContainerComponent : this.container) {
            specimen.container.add(specimenContainerComponent.copy());
        }
        return specimen;
    }

    protected Specimen typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Specimen;
    }

    public static class SpecimenContainerComponent
    extends BackboneElement {
        protected List<Identifier> identifier = new ArrayList<Identifier>();
        protected StringType description;
        protected CodeableConcept type;
        protected Quantity capacity;
        protected Quantity specimenQuantity;
        protected ResourceReference additive;
        protected Substance additiveTarget;
        private static final long serialVersionUID = 794189367L;

        public List<Identifier> getIdentifier() {
            return this.identifier;
        }

        public Identifier addIdentifier() {
            Identifier identifier = new Identifier();
            this.identifier.add(identifier);
            return identifier;
        }

        public StringType getDescription() {
            return this.description;
        }

        public SpecimenContainerComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public SpecimenContainerComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public SpecimenContainerComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public Quantity getCapacity() {
            return this.capacity;
        }

        public SpecimenContainerComponent setCapacity(Quantity quantity) {
            this.capacity = quantity;
            return this;
        }

        public Quantity getSpecimenQuantity() {
            return this.specimenQuantity;
        }

        public SpecimenContainerComponent setSpecimenQuantity(Quantity quantity) {
            this.specimenQuantity = quantity;
            return this;
        }

        public ResourceReference getAdditive() {
            return this.additive;
        }

        public SpecimenContainerComponent setAdditive(ResourceReference resourceReference) {
            this.additive = resourceReference;
            return this;
        }

        public Substance getAdditiveTarget() {
            return this.additiveTarget;
        }

        public SpecimenContainerComponent setAdditiveTarget(Substance substance) {
            this.additiveTarget = substance;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "Identifier", "Id for container. There may be multiple; a manufacturer's bar code, lab assigned identifier, etc. The container ID may differ from the specimen id in some circumstances.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("description", "string", "Textual description of the container.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("type", "CodeableConcept", "The type of container associated with the specimen (e.g. slide, aliquot, etc).", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("capacity", "Quantity", "The capacity (volume or other measure) the container may contain.", 0, Integer.MAX_VALUE, this.capacity));
            list.add(new Property("specimenQuantity", "Quantity", "The quantity of specimen in the container; may be volume, dimensions, or other appropriate measurements, depending on the specimen type.", 0, Integer.MAX_VALUE, this.specimenQuantity));
            list.add(new Property("additive", "Resource(Substance)", "Additive associated with the container.", 0, Integer.MAX_VALUE, this.additive));
        }

        public SpecimenContainerComponent copy() {
            SpecimenContainerComponent specimenContainerComponent = new SpecimenContainerComponent();
            specimenContainerComponent.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                specimenContainerComponent.identifier.add(identifier.copy());
            }
            specimenContainerComponent.description = this.description == null ? null : this.description.copy();
            specimenContainerComponent.type = this.type == null ? null : this.type.copy();
            specimenContainerComponent.capacity = this.capacity == null ? null : this.capacity.copy();
            specimenContainerComponent.specimenQuantity = this.specimenQuantity == null ? null : this.specimenQuantity.copy();
            specimenContainerComponent.additive = this.additive == null ? null : this.additive.copy();
            return specimenContainerComponent;
        }
    }

    public static class SpecimenTreatmentComponent
    extends BackboneElement {
        protected StringType description;
        protected CodeableConcept procedure;
        protected List<ResourceReference> additive = new ArrayList<ResourceReference>();
        protected List<Substance> additiveTarget = new ArrayList<Substance>();
        private static final long serialVersionUID = 349457190L;

        public StringType getDescription() {
            return this.description;
        }

        public SpecimenTreatmentComponent setDescription(StringType stringType) {
            this.description = stringType;
            return this;
        }

        public String getDescriptionSimple() {
            return this.description == null ? null : this.description.getValue();
        }

        public SpecimenTreatmentComponent setDescriptionSimple(String string) {
            if (string == null) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(string);
            }
            return this;
        }

        public CodeableConcept getProcedure() {
            return this.procedure;
        }

        public SpecimenTreatmentComponent setProcedure(CodeableConcept codeableConcept) {
            this.procedure = codeableConcept;
            return this;
        }

        public List<ResourceReference> getAdditive() {
            return this.additive;
        }

        public ResourceReference addAdditive() {
            ResourceReference resourceReference = new ResourceReference();
            this.additive.add(resourceReference);
            return resourceReference;
        }

        public List<Substance> getAdditiveTarget() {
            return this.additiveTarget;
        }

        public Substance addAdditiveTarget() {
            Substance substance = new Substance();
            this.additiveTarget.add(substance);
            return substance;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("description", "string", "Textual description of procedure.", 0, Integer.MAX_VALUE, this.description));
            list.add(new Property("procedure", "CodeableConcept", "A coded value specifying the procedure used to process the specimen.", 0, Integer.MAX_VALUE, this.procedure));
            list.add(new Property("additive", "Resource(Substance)", "Material used in the processing step.", 0, Integer.MAX_VALUE, this.additive));
        }

        public SpecimenTreatmentComponent copy() {
            SpecimenTreatmentComponent specimenTreatmentComponent = new SpecimenTreatmentComponent();
            specimenTreatmentComponent.description = this.description == null ? null : this.description.copy();
            specimenTreatmentComponent.procedure = this.procedure == null ? null : this.procedure.copy();
            specimenTreatmentComponent.additive = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.additive) {
                specimenTreatmentComponent.additive.add(resourceReference.copy());
            }
            return specimenTreatmentComponent;
        }
    }

    public static class SpecimenCollectionComponent
    extends BackboneElement {
        protected ResourceReference collector;
        protected Practitioner collectorTarget;
        protected List<StringType> comment = new ArrayList<StringType>();
        protected Type collected;
        protected Quantity quantity;
        protected CodeableConcept method;
        protected CodeableConcept sourceSite;
        private static final long serialVersionUID = -850785324L;

        public ResourceReference getCollector() {
            return this.collector;
        }

        public SpecimenCollectionComponent setCollector(ResourceReference resourceReference) {
            this.collector = resourceReference;
            return this;
        }

        public Practitioner getCollectorTarget() {
            return this.collectorTarget;
        }

        public SpecimenCollectionComponent setCollectorTarget(Practitioner practitioner) {
            this.collectorTarget = practitioner;
            return this;
        }

        public List<StringType> getComment() {
            return this.comment;
        }

        public StringType addComment() {
            StringType stringType = new StringType();
            this.comment.add(stringType);
            return stringType;
        }

        public StringType addCommentSimple(String string) {
            StringType stringType = new StringType();
            stringType.setValue(string);
            this.comment.add(stringType);
            return stringType;
        }

        public boolean hasCommentSimple(String string) {
            for (StringType stringType : this.comment) {
                if (!stringType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public Type getCollected() {
            return this.collected;
        }

        public SpecimenCollectionComponent setCollected(Type type) {
            this.collected = type;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public SpecimenCollectionComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public CodeableConcept getMethod() {
            return this.method;
        }

        public SpecimenCollectionComponent setMethod(CodeableConcept codeableConcept) {
            this.method = codeableConcept;
            return this;
        }

        public CodeableConcept getSourceSite() {
            return this.sourceSite;
        }

        public SpecimenCollectionComponent setSourceSite(CodeableConcept codeableConcept) {
            this.sourceSite = codeableConcept;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("collector", "Resource(Practitioner)", "Person who collected the specimen.", 0, Integer.MAX_VALUE, this.collector));
            list.add(new Property("comment", "string", "To communicate any details or issues encountered during the specimen collection procedure.", 0, Integer.MAX_VALUE, this.comment));
            list.add(new Property("collected[x]", "dateTime|Period", "Time when specimen was collected from subject - the physiologically relevant time.", 0, Integer.MAX_VALUE, this.collected));
            list.add(new Property("quantity", "Quantity", "The quantity of specimen collected; for instance the volume of a blood sample, or the physical measurement of an anatomic pathology sample.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("method", "CodeableConcept", "A coded value specifying the technique that is used to perform the procedure.", 0, Integer.MAX_VALUE, this.method));
            list.add(new Property("sourceSite", "CodeableConcept", "Anatomical location from which the specimen should be collected (if subject is a patient). This element is not used for environmental specimens.", 0, Integer.MAX_VALUE, this.sourceSite));
        }

        public SpecimenCollectionComponent copy() {
            SpecimenCollectionComponent specimenCollectionComponent = new SpecimenCollectionComponent();
            specimenCollectionComponent.collector = this.collector == null ? null : this.collector.copy();
            specimenCollectionComponent.comment = new ArrayList<StringType>();
            for (StringType stringType : this.comment) {
                specimenCollectionComponent.comment.add(stringType.copy());
            }
            specimenCollectionComponent.collected = this.collected == null ? null : this.collected.copy();
            specimenCollectionComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            specimenCollectionComponent.method = this.method == null ? null : this.method.copy();
            specimenCollectionComponent.sourceSite = this.sourceSite == null ? null : this.sourceSite.copy();
            return specimenCollectionComponent;
        }
    }

    public static class SpecimenSourceComponent
    extends BackboneElement {
        protected Enumeration<HierarchicalRelationshipType> relationship;
        protected List<ResourceReference> target = new ArrayList<ResourceReference>();
        protected List<Specimen> targetTarget = new ArrayList<Specimen>();
        private static final long serialVersionUID = 118968671L;

        public SpecimenSourceComponent() {
        }

        public SpecimenSourceComponent(Enumeration<HierarchicalRelationshipType> enumeration) {
            this.relationship = enumeration;
        }

        public Enumeration<HierarchicalRelationshipType> getRelationship() {
            return this.relationship;
        }

        public SpecimenSourceComponent setRelationship(Enumeration<HierarchicalRelationshipType> enumeration) {
            this.relationship = enumeration;
            return this;
        }

        public HierarchicalRelationshipType getRelationshipSimple() {
            return this.relationship == null ? null : this.relationship.getValue();
        }

        public SpecimenSourceComponent setRelationshipSimple(HierarchicalRelationshipType hierarchicalRelationshipType) {
            if (this.relationship == null) {
                this.relationship = new Enumeration();
            }
            this.relationship.setValue(hierarchicalRelationshipType);
            return this;
        }

        public List<ResourceReference> getTarget() {
            return this.target;
        }

        public ResourceReference addTarget() {
            ResourceReference resourceReference = new ResourceReference();
            this.target.add(resourceReference);
            return resourceReference;
        }

        public List<Specimen> getTargetTarget() {
            return this.targetTarget;
        }

        public Specimen addTargetTarget() {
            Specimen specimen = new Specimen();
            this.targetTarget.add(specimen);
            return specimen;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("relationship", "code", "Whether this relationship is to a parent or to a child.", 0, Integer.MAX_VALUE, this.relationship));
            list.add(new Property("target", "Resource(Specimen)", "The specimen resource that is the target of this relationship.", 0, Integer.MAX_VALUE, this.target));
        }

        public SpecimenSourceComponent copy() {
            SpecimenSourceComponent specimenSourceComponent = new SpecimenSourceComponent();
            specimenSourceComponent.relationship = this.relationship == null ? null : this.relationship.copy();
            specimenSourceComponent.target = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.target) {
                specimenSourceComponent.target.add(resourceReference.copy());
            }
            return specimenSourceComponent;
        }
    }

    public static class HierarchicalRelationshipTypeEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("parent".equals(string)) {
                return HierarchicalRelationshipType.parent;
            }
            if ("child".equals(string)) {
                return HierarchicalRelationshipType.child;
            }
            throw new Exception("Unknown HierarchicalRelationshipType code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == HierarchicalRelationshipType.parent) {
                return "parent";
            }
            if (enum_ == HierarchicalRelationshipType.child) {
                return "child";
            }
            return "?";
        }
    }

    public static enum HierarchicalRelationshipType {
        parent,
        child,
        Null;


        public static HierarchicalRelationshipType fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("parent".equals(string)) {
                return parent;
            }
            if ("child".equals(string)) {
                return child;
            }
            throw new Exception("Unknown HierarchicalRelationshipType code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case parent: {
                    return "parent";
                }
                case child: {
                    return "child";
                }
            }
            return "?";
        }
    }
}

