/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;

public class Substance
extends Resource {
    protected CodeableConcept type;
    protected StringType description;
    protected SubstanceInstanceComponent instance;
    protected List<SubstanceIngredientComponent> ingredient = new ArrayList<SubstanceIngredientComponent>();
    private static final long serialVersionUID = -1024152127L;

    public Substance() {
    }

    public Substance(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
    }

    public CodeableConcept getType() {
        return this.type;
    }

    public Substance setType(CodeableConcept codeableConcept) {
        this.type = codeableConcept;
        return this;
    }

    public StringType getDescription() {
        return this.description;
    }

    public Substance setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public Substance setDescriptionSimple(String string) {
        if (string == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(string);
        }
        return this;
    }

    public SubstanceInstanceComponent getInstance() {
        return this.instance;
    }

    public Substance setInstance(SubstanceInstanceComponent substanceInstanceComponent) {
        this.instance = substanceInstanceComponent;
        return this;
    }

    public List<SubstanceIngredientComponent> getIngredient() {
        return this.ingredient;
    }

    public SubstanceIngredientComponent addIngredient() {
        SubstanceIngredientComponent substanceIngredientComponent = new SubstanceIngredientComponent();
        this.ingredient.add(substanceIngredientComponent);
        return substanceIngredientComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("type", "CodeableConcept", "A code (or set of codes) that identify this substance.", 0, Integer.MAX_VALUE, this.type));
        list.add(new Property("description", "string", "A description of the substance - its appearance, handling requirements, and other usage notes.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("instance", "", "Substance may be used to describe a kind of substance, or a specific package/container of the substance: an instance.", 0, Integer.MAX_VALUE, this.instance));
        list.add(new Property("ingredient", "", "A substance can be composed of other substances.", 0, Integer.MAX_VALUE, this.ingredient));
    }

    public Substance copy() {
        Substance substance = new Substance();
        substance.type = this.type == null ? null : this.type.copy();
        substance.description = this.description == null ? null : this.description.copy();
        substance.instance = this.instance == null ? null : this.instance.copy();
        substance.ingredient = new ArrayList<SubstanceIngredientComponent>();
        for (SubstanceIngredientComponent substanceIngredientComponent : this.ingredient) {
            substance.ingredient.add(substanceIngredientComponent.copy());
        }
        return substance;
    }

    protected Substance typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Substance;
    }

    public static class SubstanceIngredientComponent
    extends BackboneElement {
        protected Ratio quantity;
        protected ResourceReference substance;
        protected Substance substanceTarget;
        private static final long serialVersionUID = 1192860668L;

        public SubstanceIngredientComponent() {
        }

        public SubstanceIngredientComponent(ResourceReference resourceReference) {
            this.substance = resourceReference;
        }

        public Ratio getQuantity() {
            return this.quantity;
        }

        public SubstanceIngredientComponent setQuantity(Ratio ratio) {
            this.quantity = ratio;
            return this;
        }

        public ResourceReference getSubstance() {
            return this.substance;
        }

        public SubstanceIngredientComponent setSubstance(ResourceReference resourceReference) {
            this.substance = resourceReference;
            return this;
        }

        public Substance getSubstanceTarget() {
            return this.substanceTarget;
        }

        public SubstanceIngredientComponent setSubstanceTarget(Substance substance) {
            this.substanceTarget = substance;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("quantity", "Ratio", "The amount of the ingredient in the substance - a concentration ratio.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("substance", "Resource(Substance)", "Another substance that is a component of this substance.", 0, Integer.MAX_VALUE, this.substance));
        }

        public SubstanceIngredientComponent copy() {
            SubstanceIngredientComponent substanceIngredientComponent = new SubstanceIngredientComponent();
            substanceIngredientComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            substanceIngredientComponent.substance = this.substance == null ? null : this.substance.copy();
            return substanceIngredientComponent;
        }
    }

    public static class SubstanceInstanceComponent
    extends BackboneElement {
        protected Identifier identifier;
        protected DateTimeType expiry;
        protected Quantity quantity;
        private static final long serialVersionUID = -1474380480L;

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public SubstanceInstanceComponent setIdentifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public DateTimeType getExpiry() {
            return this.expiry;
        }

        public SubstanceInstanceComponent setExpiry(DateTimeType dateTimeType) {
            this.expiry = dateTimeType;
            return this;
        }

        public DateAndTime getExpirySimple() {
            return this.expiry == null ? null : this.expiry.getValue();
        }

        public SubstanceInstanceComponent setExpirySimple(DateAndTime dateAndTime) {
            if (dateAndTime == null) {
                this.expiry = null;
            } else {
                if (this.expiry == null) {
                    this.expiry = new DateTimeType();
                }
                this.expiry.setValue(dateAndTime);
            }
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public SubstanceInstanceComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "Identifier", "Identifier associated with the package/container (usually a label affixed directly).", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("expiry", "dateTime", "When the substance is no longer valid to use. For some substances, a single arbitrary date is used for expiry.", 0, Integer.MAX_VALUE, this.expiry));
            list.add(new Property("quantity", "Quantity", "The amount of the substance.", 0, Integer.MAX_VALUE, this.quantity));
        }

        public SubstanceInstanceComponent copy() {
            SubstanceInstanceComponent substanceInstanceComponent = new SubstanceInstanceComponent();
            substanceInstanceComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            substanceInstanceComponent.expiry = this.expiry == null ? null : this.expiry.copy();
            substanceInstanceComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            return substanceInstanceComponent;
        }
    }
}

