/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.ResourceType;

public class Supply
extends Resource {
    protected CodeableConcept kind;
    protected Identifier identifier;
    protected Enumeration<ValuesetSupplyStatus> status;
    protected ResourceReference orderedItem;
    protected Resource orderedItemTarget;
    protected ResourceReference patient;
    protected Patient patientTarget;
    protected List<SupplyDispenseComponent> dispense = new ArrayList<SupplyDispenseComponent>();
    private static final long serialVersionUID = 487202825L;

    public CodeableConcept getKind() {
        return this.kind;
    }

    public Supply setKind(CodeableConcept codeableConcept) {
        this.kind = codeableConcept;
        return this;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public Supply setIdentifier(Identifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public Enumeration<ValuesetSupplyStatus> getStatus() {
        return this.status;
    }

    public Supply setStatus(Enumeration<ValuesetSupplyStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ValuesetSupplyStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public Supply setStatusSimple(ValuesetSupplyStatus valuesetSupplyStatus) {
        if (valuesetSupplyStatus == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration();
            }
            this.status.setValue(valuesetSupplyStatus);
        }
        return this;
    }

    public ResourceReference getOrderedItem() {
        return this.orderedItem;
    }

    public Supply setOrderedItem(ResourceReference resourceReference) {
        this.orderedItem = resourceReference;
        return this;
    }

    public Resource getOrderedItemTarget() {
        return this.orderedItemTarget;
    }

    public Supply setOrderedItemTarget(Resource resource) {
        this.orderedItemTarget = resource;
        return this;
    }

    public ResourceReference getPatient() {
        return this.patient;
    }

    public Supply setPatient(ResourceReference resourceReference) {
        this.patient = resourceReference;
        return this;
    }

    public Patient getPatientTarget() {
        return this.patientTarget;
    }

    public Supply setPatientTarget(Patient patient) {
        this.patientTarget = patient;
        return this;
    }

    public List<SupplyDispenseComponent> getDispense() {
        return this.dispense;
    }

    public SupplyDispenseComponent addDispense() {
        SupplyDispenseComponent supplyDispenseComponent = new SupplyDispenseComponent();
        this.dispense.add(supplyDispenseComponent);
        return supplyDispenseComponent;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("kind", "CodeableConcept", "Category of supply, e.g.  central, non-stock, etc. This is used to support work flows associated with the supply process.", 0, Integer.MAX_VALUE, this.kind));
        list.add(new Property("identifier", "Identifier", "Unique identifier for this supply request.", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("status", "code", "Status of the supply request.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("orderedItem", "Resource(Medication|Substance|Device)", "The item that is requested to be supplied.", 0, Integer.MAX_VALUE, this.orderedItem));
        list.add(new Property("patient", "Resource(Patient)", "A link to a resource representing the person whom the ordered item is for.", 0, Integer.MAX_VALUE, this.patient));
        list.add(new Property("dispense", "", "Indicates the details of the dispense event such as the days supply and quantity of a supply dispensed.", 0, Integer.MAX_VALUE, this.dispense));
    }

    public Supply copy() {
        Supply supply = new Supply();
        supply.kind = this.kind == null ? null : this.kind.copy();
        supply.identifier = this.identifier == null ? null : this.identifier.copy();
        supply.status = this.status == null ? null : this.status.copy();
        supply.orderedItem = this.orderedItem == null ? null : this.orderedItem.copy();
        supply.patient = this.patient == null ? null : this.patient.copy();
        supply.dispense = new ArrayList<SupplyDispenseComponent>();
        for (SupplyDispenseComponent supplyDispenseComponent : this.dispense) {
            supply.dispense.add(supplyDispenseComponent.copy());
        }
        return supply;
    }

    protected Supply typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Supply;
    }

    public static class SupplyDispenseComponent
    extends BackboneElement {
        protected Identifier identifier;
        protected Enumeration<ValuesetSupplyDispenseStatus> status;
        protected CodeableConcept type;
        protected Quantity quantity;
        protected ResourceReference suppliedItem;
        protected Resource suppliedItemTarget;
        protected ResourceReference supplier;
        protected Practitioner supplierTarget;
        protected Period whenPrepared;
        protected Period whenHandedOver;
        protected ResourceReference destination;
        protected Location destinationTarget;
        protected List<ResourceReference> receiver = new ArrayList<ResourceReference>();
        protected List<Practitioner> receiverTarget = new ArrayList<Practitioner>();
        private static final long serialVersionUID = 1248640970L;

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public SupplyDispenseComponent setIdentifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public Enumeration<ValuesetSupplyDispenseStatus> getStatus() {
            return this.status;
        }

        public SupplyDispenseComponent setStatus(Enumeration<ValuesetSupplyDispenseStatus> enumeration) {
            this.status = enumeration;
            return this;
        }

        public ValuesetSupplyDispenseStatus getStatusSimple() {
            return this.status == null ? null : this.status.getValue();
        }

        public SupplyDispenseComponent setStatusSimple(ValuesetSupplyDispenseStatus valuesetSupplyDispenseStatus) {
            if (valuesetSupplyDispenseStatus == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration();
                }
                this.status.setValue(valuesetSupplyDispenseStatus);
            }
            return this;
        }

        public CodeableConcept getType() {
            return this.type;
        }

        public SupplyDispenseComponent setType(CodeableConcept codeableConcept) {
            this.type = codeableConcept;
            return this;
        }

        public Quantity getQuantity() {
            return this.quantity;
        }

        public SupplyDispenseComponent setQuantity(Quantity quantity) {
            this.quantity = quantity;
            return this;
        }

        public ResourceReference getSuppliedItem() {
            return this.suppliedItem;
        }

        public SupplyDispenseComponent setSuppliedItem(ResourceReference resourceReference) {
            this.suppliedItem = resourceReference;
            return this;
        }

        public Resource getSuppliedItemTarget() {
            return this.suppliedItemTarget;
        }

        public SupplyDispenseComponent setSuppliedItemTarget(Resource resource) {
            this.suppliedItemTarget = resource;
            return this;
        }

        public ResourceReference getSupplier() {
            return this.supplier;
        }

        public SupplyDispenseComponent setSupplier(ResourceReference resourceReference) {
            this.supplier = resourceReference;
            return this;
        }

        public Practitioner getSupplierTarget() {
            return this.supplierTarget;
        }

        public SupplyDispenseComponent setSupplierTarget(Practitioner practitioner) {
            this.supplierTarget = practitioner;
            return this;
        }

        public Period getWhenPrepared() {
            return this.whenPrepared;
        }

        public SupplyDispenseComponent setWhenPrepared(Period period) {
            this.whenPrepared = period;
            return this;
        }

        public Period getWhenHandedOver() {
            return this.whenHandedOver;
        }

        public SupplyDispenseComponent setWhenHandedOver(Period period) {
            this.whenHandedOver = period;
            return this;
        }

        public ResourceReference getDestination() {
            return this.destination;
        }

        public SupplyDispenseComponent setDestination(ResourceReference resourceReference) {
            this.destination = resourceReference;
            return this;
        }

        public Location getDestinationTarget() {
            return this.destinationTarget;
        }

        public SupplyDispenseComponent setDestinationTarget(Location location) {
            this.destinationTarget = location;
            return this;
        }

        public List<ResourceReference> getReceiver() {
            return this.receiver;
        }

        public ResourceReference addReceiver() {
            ResourceReference resourceReference = new ResourceReference();
            this.receiver.add(resourceReference);
            return resourceReference;
        }

        public List<Practitioner> getReceiverTarget() {
            return this.receiverTarget;
        }

        public Practitioner addReceiverTarget() {
            Practitioner practitioner = new Practitioner();
            this.receiverTarget.add(practitioner);
            return practitioner;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "Identifier", "Identifier assigned by the dispensing facility when the dispense occurs.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("status", "code", "A code specifying the state of the dispense event.", 0, Integer.MAX_VALUE, this.status));
            list.add(new Property("type", "CodeableConcept", "Indicates the type of dispensing event that is performed. Examples include: Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.", 0, Integer.MAX_VALUE, this.type));
            list.add(new Property("quantity", "Quantity", "The amount of supply that has been dispensed. Includes unit of measure.", 0, Integer.MAX_VALUE, this.quantity));
            list.add(new Property("suppliedItem", "Resource(Medication|Substance|Device)", "Identifies the medication or substance being dispensed. This is either a link to a resource representing the details of the medication or substance or a simple attribute carrying a code that identifies the medication from a known list of medications.", 0, Integer.MAX_VALUE, this.suppliedItem));
            list.add(new Property("supplier", "Resource(Practitioner)", "The individual responsible for dispensing the medication.", 0, Integer.MAX_VALUE, this.supplier));
            list.add(new Property("whenPrepared", "Period", "The time the dispense event occurred.", 0, Integer.MAX_VALUE, this.whenPrepared));
            list.add(new Property("whenHandedOver", "Period", "The time the dispensed item was sent or handed to the patient (or agent).", 0, Integer.MAX_VALUE, this.whenHandedOver));
            list.add(new Property("destination", "Resource(Location)", "Identification of the facility/location where the Supply was shipped to, as part of the dispense event.", 0, Integer.MAX_VALUE, this.destination));
            list.add(new Property("receiver", "Resource(Practitioner)", "Identifies the person who picked up the Supply.", 0, Integer.MAX_VALUE, this.receiver));
        }

        public SupplyDispenseComponent copy() {
            SupplyDispenseComponent supplyDispenseComponent = new SupplyDispenseComponent();
            supplyDispenseComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            supplyDispenseComponent.status = this.status == null ? null : this.status.copy();
            supplyDispenseComponent.type = this.type == null ? null : this.type.copy();
            supplyDispenseComponent.quantity = this.quantity == null ? null : this.quantity.copy();
            supplyDispenseComponent.suppliedItem = this.suppliedItem == null ? null : this.suppliedItem.copy();
            supplyDispenseComponent.supplier = this.supplier == null ? null : this.supplier.copy();
            supplyDispenseComponent.whenPrepared = this.whenPrepared == null ? null : this.whenPrepared.copy();
            supplyDispenseComponent.whenHandedOver = this.whenHandedOver == null ? null : this.whenHandedOver.copy();
            supplyDispenseComponent.destination = this.destination == null ? null : this.destination.copy();
            supplyDispenseComponent.receiver = new ArrayList<ResourceReference>();
            for (ResourceReference resourceReference : this.receiver) {
                supplyDispenseComponent.receiver.add(resourceReference.copy());
            }
            return supplyDispenseComponent;
        }
    }

    public static class ValuesetSupplyDispenseStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("in progress".equals(string)) {
                return ValuesetSupplyDispenseStatus.inProgress;
            }
            if ("dispensed".equals(string)) {
                return ValuesetSupplyDispenseStatus.dispensed;
            }
            if ("abandoned".equals(string)) {
                return ValuesetSupplyDispenseStatus.abandoned;
            }
            throw new Exception("Unknown ValuesetSupplyDispenseStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ValuesetSupplyDispenseStatus.inProgress) {
                return "in progress";
            }
            if (enum_ == ValuesetSupplyDispenseStatus.dispensed) {
                return "dispensed";
            }
            if (enum_ == ValuesetSupplyDispenseStatus.abandoned) {
                return "abandoned";
            }
            return "?";
        }
    }

    public static enum ValuesetSupplyDispenseStatus {
        inProgress,
        dispensed,
        abandoned,
        Null;


        public static ValuesetSupplyDispenseStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("in progress".equals(string)) {
                return inProgress;
            }
            if ("dispensed".equals(string)) {
                return dispensed;
            }
            if ("abandoned".equals(string)) {
                return abandoned;
            }
            throw new Exception("Unknown ValuesetSupplyDispenseStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case inProgress: {
                    return "in progress";
                }
                case dispensed: {
                    return "dispensed";
                }
                case abandoned: {
                    return "abandoned";
                }
            }
            return "?";
        }
    }

    public static class ValuesetSupplyStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("requested".equals(string)) {
                return ValuesetSupplyStatus.requested;
            }
            if ("dispensed".equals(string)) {
                return ValuesetSupplyStatus.dispensed;
            }
            if ("received".equals(string)) {
                return ValuesetSupplyStatus.received;
            }
            if ("failed".equals(string)) {
                return ValuesetSupplyStatus.failed;
            }
            if ("cancelled".equals(string)) {
                return ValuesetSupplyStatus.cancelled;
            }
            throw new Exception("Unknown ValuesetSupplyStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ValuesetSupplyStatus.requested) {
                return "requested";
            }
            if (enum_ == ValuesetSupplyStatus.dispensed) {
                return "dispensed";
            }
            if (enum_ == ValuesetSupplyStatus.received) {
                return "received";
            }
            if (enum_ == ValuesetSupplyStatus.failed) {
                return "failed";
            }
            if (enum_ == ValuesetSupplyStatus.cancelled) {
                return "cancelled";
            }
            return "?";
        }
    }

    public static enum ValuesetSupplyStatus {
        requested,
        dispensed,
        received,
        failed,
        cancelled,
        Null;


        public static ValuesetSupplyStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("requested".equals(string)) {
                return requested;
            }
            if ("dispensed".equals(string)) {
                return dispensed;
            }
            if ("received".equals(string)) {
                return received;
            }
            if ("failed".equals(string)) {
                return failed;
            }
            if ("cancelled".equals(string)) {
                return cancelled;
            }
            throw new Exception("Unknown ValuesetSupplyStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case requested: {
                    return "requested";
                }
                case dispensed: {
                    return "dispensed";
                }
                case received: {
                    return "received";
                }
                case failed: {
                    return "failed";
                }
                case cancelled: {
                    return "cancelled";
                }
            }
            return "?";
        }
    }
}

