/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.model;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.EnumFactory;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceType;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;

public class ValueSet
extends Resource {
    protected StringType identifier;
    protected StringType version;
    protected StringType name;
    protected StringType publisher;
    protected List<Contact> telecom = new ArrayList<Contact>();
    protected StringType description;
    protected StringType copyright;
    protected Enumeration<ValuesetStatus> status;
    protected BooleanType experimental;
    protected BooleanType extensible;
    protected DateTimeType date;
    protected ValueSetDefineComponent define;
    protected ValueSetComposeComponent compose;
    protected ValueSetExpansionComponent expansion;
    private static final long serialVersionUID = -767228467L;

    public ValueSet() {
    }

    public ValueSet(StringType stringType, StringType stringType2, Enumeration<ValuesetStatus> enumeration) {
        this.name = stringType;
        this.description = stringType2;
        this.status = enumeration;
    }

    public StringType getIdentifier() {
        return this.identifier;
    }

    public ValueSet setIdentifier(StringType stringType) {
        this.identifier = stringType;
        return this;
    }

    public String getIdentifierSimple() {
        return this.identifier == null ? null : this.identifier.getValue();
    }

    public ValueSet setIdentifierSimple(String string) {
        if (string == null) {
            this.identifier = null;
        } else {
            if (this.identifier == null) {
                this.identifier = new StringType();
            }
            this.identifier.setValue(string);
        }
        return this;
    }

    public StringType getVersion() {
        return this.version;
    }

    public ValueSet setVersion(StringType stringType) {
        this.version = stringType;
        return this;
    }

    public String getVersionSimple() {
        return this.version == null ? null : this.version.getValue();
    }

    public ValueSet setVersionSimple(String string) {
        if (string == null) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(string);
        }
        return this;
    }

    public StringType getName() {
        return this.name;
    }

    public ValueSet setName(StringType stringType) {
        this.name = stringType;
        return this;
    }

    public String getNameSimple() {
        return this.name == null ? null : this.name.getValue();
    }

    public ValueSet setNameSimple(String string) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(string);
        return this;
    }

    public StringType getPublisher() {
        return this.publisher;
    }

    public ValueSet setPublisher(StringType stringType) {
        this.publisher = stringType;
        return this;
    }

    public String getPublisherSimple() {
        return this.publisher == null ? null : this.publisher.getValue();
    }

    public ValueSet setPublisherSimple(String string) {
        if (string == null) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(string);
        }
        return this;
    }

    public List<Contact> getTelecom() {
        return this.telecom;
    }

    public Contact addTelecom() {
        Contact contact = new Contact();
        this.telecom.add(contact);
        return contact;
    }

    public StringType getDescription() {
        return this.description;
    }

    public ValueSet setDescription(StringType stringType) {
        this.description = stringType;
        return this;
    }

    public String getDescriptionSimple() {
        return this.description == null ? null : this.description.getValue();
    }

    public ValueSet setDescriptionSimple(String string) {
        if (this.description == null) {
            this.description = new StringType();
        }
        this.description.setValue(string);
        return this;
    }

    public StringType getCopyright() {
        return this.copyright;
    }

    public ValueSet setCopyright(StringType stringType) {
        this.copyright = stringType;
        return this;
    }

    public String getCopyrightSimple() {
        return this.copyright == null ? null : this.copyright.getValue();
    }

    public ValueSet setCopyrightSimple(String string) {
        if (string == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(string);
        }
        return this;
    }

    public Enumeration<ValuesetStatus> getStatus() {
        return this.status;
    }

    public ValueSet setStatus(Enumeration<ValuesetStatus> enumeration) {
        this.status = enumeration;
        return this;
    }

    public ValuesetStatus getStatusSimple() {
        return this.status == null ? null : this.status.getValue();
    }

    public ValueSet setStatusSimple(ValuesetStatus valuesetStatus) {
        if (this.status == null) {
            this.status = new Enumeration();
        }
        this.status.setValue(valuesetStatus);
        return this;
    }

    public BooleanType getExperimental() {
        return this.experimental;
    }

    public ValueSet setExperimental(BooleanType booleanType) {
        this.experimental = booleanType;
        return this;
    }

    public boolean getExperimentalSimple() {
        return this.experimental == null ? false : this.experimental.getValue();
    }

    public ValueSet setExperimentalSimple(boolean bl) {
        if (!bl) {
            this.experimental = null;
        } else {
            if (this.experimental == null) {
                this.experimental = new BooleanType();
            }
            this.experimental.setValue(bl);
        }
        return this;
    }

    public BooleanType getExtensible() {
        return this.extensible;
    }

    public ValueSet setExtensible(BooleanType booleanType) {
        this.extensible = booleanType;
        return this;
    }

    public boolean getExtensibleSimple() {
        return this.extensible == null ? false : this.extensible.getValue();
    }

    public ValueSet setExtensibleSimple(boolean bl) {
        if (!bl) {
            this.extensible = null;
        } else {
            if (this.extensible == null) {
                this.extensible = new BooleanType();
            }
            this.extensible.setValue(bl);
        }
        return this;
    }

    public DateTimeType getDate() {
        return this.date;
    }

    public ValueSet setDate(DateTimeType dateTimeType) {
        this.date = dateTimeType;
        return this;
    }

    public DateAndTime getDateSimple() {
        return this.date == null ? null : this.date.getValue();
    }

    public ValueSet setDateSimple(DateAndTime dateAndTime) {
        if (dateAndTime == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(dateAndTime);
        }
        return this;
    }

    public ValueSetDefineComponent getDefine() {
        return this.define;
    }

    public ValueSet setDefine(ValueSetDefineComponent valueSetDefineComponent) {
        this.define = valueSetDefineComponent;
        return this;
    }

    public ValueSetComposeComponent getCompose() {
        return this.compose;
    }

    public ValueSet setCompose(ValueSetComposeComponent valueSetComposeComponent) {
        this.compose = valueSetComposeComponent;
        return this;
    }

    public ValueSetExpansionComponent getExpansion() {
        return this.expansion;
    }

    public ValueSet setExpansion(ValueSetExpansionComponent valueSetExpansionComponent) {
        this.expansion = valueSetExpansionComponent;
        return this;
    }

    @Override
    protected void listChildren(List<Property> list) {
        super.listChildren(list);
        list.add(new Property("identifier", "string", "The identifier that is used to identify this value set when it is referenced in a specification, model, design or an instance (should be globally unique OID, UUID, or URI).", 0, Integer.MAX_VALUE, this.identifier));
        list.add(new Property("version", "string", "The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp.", 0, Integer.MAX_VALUE, this.version));
        list.add(new Property("name", "string", "A free text natural language name describing the value set.", 0, Integer.MAX_VALUE, this.name));
        list.add(new Property("publisher", "string", "The name of the individual or organization that published the value set.", 0, Integer.MAX_VALUE, this.publisher));
        list.add(new Property("telecom", "Contact", "Contacts of the publisher to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        list.add(new Property("description", "string", "A free text natural language description of the use of the value set - reason for definition, conditions of use, etc.", 0, Integer.MAX_VALUE, this.description));
        list.add(new Property("copyright", "string", "A copyright statement relating to the value set and/or its contents.", 0, Integer.MAX_VALUE, this.copyright));
        list.add(new Property("status", "code", "The status of the value set.", 0, Integer.MAX_VALUE, this.status));
        list.add(new Property("experimental", "boolean", "This valueset was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, Integer.MAX_VALUE, this.experimental));
        list.add(new Property("extensible", "boolean", "Whether this is intended to be used with an extensible binding or not.", 0, Integer.MAX_VALUE, this.extensible));
        list.add(new Property("date", "dateTime", "The date that the value set status was last changed.", 0, Integer.MAX_VALUE, this.date));
        list.add(new Property("define", "", "When value set defines its own codes.", 0, Integer.MAX_VALUE, this.define));
        list.add(new Property("compose", "", "When value set includes codes from elsewhere.", 0, Integer.MAX_VALUE, this.compose));
        list.add(new Property("expansion", "", "When value set is an expansion.", 0, Integer.MAX_VALUE, this.expansion));
    }

    public ValueSet copy() {
        ValueSet valueSet = new ValueSet();
        valueSet.identifier = this.identifier == null ? null : this.identifier.copy();
        valueSet.version = this.version == null ? null : this.version.copy();
        valueSet.name = this.name == null ? null : this.name.copy();
        valueSet.publisher = this.publisher == null ? null : this.publisher.copy();
        valueSet.telecom = new ArrayList<Contact>();
        for (Contact contact : this.telecom) {
            valueSet.telecom.add(contact.copy());
        }
        valueSet.description = this.description == null ? null : this.description.copy();
        valueSet.copyright = this.copyright == null ? null : this.copyright.copy();
        valueSet.status = this.status == null ? null : this.status.copy();
        valueSet.experimental = this.experimental == null ? null : this.experimental.copy();
        valueSet.extensible = this.extensible == null ? null : this.extensible.copy();
        valueSet.date = this.date == null ? null : this.date.copy();
        valueSet.define = this.define == null ? null : this.define.copy();
        valueSet.compose = this.compose == null ? null : this.compose.copy();
        valueSet.expansion = this.expansion == null ? null : this.expansion.copy();
        return valueSet;
    }

    protected ValueSet typedCopy() {
        return this.copy();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ValueSet;
    }

    public static class ValueSetExpansionContainsComponent
    extends BackboneElement {
        protected UriType system;
        protected CodeType code;
        protected StringType display;
        protected List<ValueSetExpansionContainsComponent> contains = new ArrayList<ValueSetExpansionContainsComponent>();
        private static final long serialVersionUID = 1346310636L;

        public UriType getSystem() {
            return this.system;
        }

        public ValueSetExpansionContainsComponent setSystem(UriType uriType) {
            this.system = uriType;
            return this;
        }

        public String getSystemSimple() {
            return this.system == null ? null : this.system.getValue();
        }

        public ValueSetExpansionContainsComponent setSystemSimple(String string) {
            if (string == null) {
                this.system = null;
            } else {
                if (this.system == null) {
                    this.system = new UriType();
                }
                this.system.setValue(string);
            }
            return this;
        }

        public CodeType getCode() {
            return this.code;
        }

        public ValueSetExpansionContainsComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ValueSetExpansionContainsComponent setCodeSimple(String string) {
            if (string == null) {
                this.code = null;
            } else {
                if (this.code == null) {
                    this.code = new CodeType();
                }
                this.code.setValue(string);
            }
            return this;
        }

        public StringType getDisplay() {
            return this.display;
        }

        public ValueSetExpansionContainsComponent setDisplay(StringType stringType) {
            this.display = stringType;
            return this;
        }

        public String getDisplaySimple() {
            return this.display == null ? null : this.display.getValue();
        }

        public ValueSetExpansionContainsComponent setDisplaySimple(String string) {
            if (string == null) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(string);
            }
            return this;
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            return this.contains;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent valueSetExpansionContainsComponent = new ValueSetExpansionContainsComponent();
            this.contains.add(valueSetExpansionContainsComponent);
            return valueSetExpansionContainsComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("system", "uri", "System value for the code.", 0, Integer.MAX_VALUE, this.system));
            list.add(new Property("code", "code", "Code - if blank, this is not a choosable code.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("display", "string", "User display for the concept.", 0, Integer.MAX_VALUE, this.display));
            list.add(new Property("contains", "@ValueSet.expansion.contains", "Codes contained in this concept.", 0, Integer.MAX_VALUE, this.contains));
        }

        public ValueSetExpansionContainsComponent copy() {
            ValueSetExpansionContainsComponent valueSetExpansionContainsComponent = new ValueSetExpansionContainsComponent();
            valueSetExpansionContainsComponent.system = this.system == null ? null : this.system.copy();
            valueSetExpansionContainsComponent.code = this.code == null ? null : this.code.copy();
            valueSetExpansionContainsComponent.display = this.display == null ? null : this.display.copy();
            valueSetExpansionContainsComponent.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent2 : this.contains) {
                valueSetExpansionContainsComponent.contains.add(valueSetExpansionContainsComponent2.copy());
            }
            return valueSetExpansionContainsComponent;
        }
    }

    public static class ValueSetExpansionComponent
    extends BackboneElement {
        protected Identifier identifier;
        protected InstantType timestamp;
        protected List<ValueSetExpansionContainsComponent> contains = new ArrayList<ValueSetExpansionContainsComponent>();
        private static final long serialVersionUID = 1886819543L;

        public ValueSetExpansionComponent() {
        }

        public ValueSetExpansionComponent(InstantType instantType) {
            this.timestamp = instantType;
        }

        public Identifier getIdentifier() {
            return this.identifier;
        }

        public ValueSetExpansionComponent setIdentifier(Identifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public InstantType getTimestamp() {
            return this.timestamp;
        }

        public ValueSetExpansionComponent setTimestamp(InstantType instantType) {
            this.timestamp = instantType;
            return this;
        }

        public DateAndTime getTimestampSimple() {
            return this.timestamp == null ? null : this.timestamp.getValue();
        }

        public ValueSetExpansionComponent setTimestampSimple(DateAndTime dateAndTime) {
            if (this.timestamp == null) {
                this.timestamp = new InstantType();
            }
            this.timestamp.setValue(dateAndTime);
            return this;
        }

        public List<ValueSetExpansionContainsComponent> getContains() {
            return this.contains;
        }

        public ValueSetExpansionContainsComponent addContains() {
            ValueSetExpansionContainsComponent valueSetExpansionContainsComponent = new ValueSetExpansionContainsComponent();
            this.contains.add(valueSetExpansionContainsComponent);
            return valueSetExpansionContainsComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("identifier", "Identifier", "An identifier that uniquely identifies this expansion of the valueset. Systems may re-use the same identifier as long as the expansion and the definition remain the same, but are not required to do so.", 0, Integer.MAX_VALUE, this.identifier));
            list.add(new Property("timestamp", "instant", "Time valueset expansion happened.", 0, Integer.MAX_VALUE, this.timestamp));
            list.add(new Property("contains", "", "Codes in the value set.", 0, Integer.MAX_VALUE, this.contains));
        }

        public ValueSetExpansionComponent copy() {
            ValueSetExpansionComponent valueSetExpansionComponent = new ValueSetExpansionComponent();
            valueSetExpansionComponent.identifier = this.identifier == null ? null : this.identifier.copy();
            valueSetExpansionComponent.timestamp = this.timestamp == null ? null : this.timestamp.copy();
            valueSetExpansionComponent.contains = new ArrayList<ValueSetExpansionContainsComponent>();
            for (ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.contains) {
                valueSetExpansionComponent.contains.add(valueSetExpansionContainsComponent.copy());
            }
            return valueSetExpansionComponent;
        }
    }

    public static class ConceptSetFilterComponent
    extends BackboneElement {
        protected CodeType property;
        protected Enumeration<FilterOperator> op;
        protected CodeType value;
        private static final long serialVersionUID = 1985515000L;

        public ConceptSetFilterComponent() {
        }

        public ConceptSetFilterComponent(CodeType codeType, Enumeration<FilterOperator> enumeration, CodeType codeType2) {
            this.property = codeType;
            this.op = enumeration;
            this.value = codeType2;
        }

        public CodeType getProperty() {
            return this.property;
        }

        public ConceptSetFilterComponent setProperty(CodeType codeType) {
            this.property = codeType;
            return this;
        }

        public String getPropertySimple() {
            return this.property == null ? null : this.property.getValue();
        }

        public ConceptSetFilterComponent setPropertySimple(String string) {
            if (this.property == null) {
                this.property = new CodeType();
            }
            this.property.setValue(string);
            return this;
        }

        public Enumeration<FilterOperator> getOp() {
            return this.op;
        }

        public ConceptSetFilterComponent setOp(Enumeration<FilterOperator> enumeration) {
            this.op = enumeration;
            return this;
        }

        public FilterOperator getOpSimple() {
            return this.op == null ? null : this.op.getValue();
        }

        public ConceptSetFilterComponent setOpSimple(FilterOperator filterOperator) {
            if (this.op == null) {
                this.op = new Enumeration();
            }
            this.op.setValue(filterOperator);
            return this;
        }

        public CodeType getValue() {
            return this.value;
        }

        public ConceptSetFilterComponent setValue(CodeType codeType) {
            this.value = codeType;
            return this;
        }

        public String getValueSimple() {
            return this.value == null ? null : this.value.getValue();
        }

        public ConceptSetFilterComponent setValueSimple(String string) {
            if (this.value == null) {
                this.value = new CodeType();
            }
            this.value.setValue(string);
            return this;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("property", "code", "A code that identifies a property defined in the code system.", 0, Integer.MAX_VALUE, this.property));
            list.add(new Property("op", "code", "The kind of operation to perform as a part of the filter criteria.", 0, Integer.MAX_VALUE, this.op));
            list.add(new Property("value", "code", "The match value may be either a code defined by the system, or a string value which is used a regex match on the literal string of the property value.", 0, Integer.MAX_VALUE, this.value));
        }

        public ConceptSetFilterComponent copy() {
            ConceptSetFilterComponent conceptSetFilterComponent = new ConceptSetFilterComponent();
            conceptSetFilterComponent.property = this.property == null ? null : this.property.copy();
            conceptSetFilterComponent.op = this.op == null ? null : this.op.copy();
            conceptSetFilterComponent.value = this.value == null ? null : this.value.copy();
            return conceptSetFilterComponent;
        }
    }

    public static class ConceptSetComponent
    extends BackboneElement {
        protected UriType system;
        protected StringType version;
        protected List<CodeType> code = new ArrayList<CodeType>();
        protected List<ConceptSetFilterComponent> filter = new ArrayList<ConceptSetFilterComponent>();
        private static final long serialVersionUID = -1360238143L;

        public ConceptSetComponent() {
        }

        public ConceptSetComponent(UriType uriType) {
            this.system = uriType;
        }

        public UriType getSystem() {
            return this.system;
        }

        public ConceptSetComponent setSystem(UriType uriType) {
            this.system = uriType;
            return this;
        }

        public String getSystemSimple() {
            return this.system == null ? null : this.system.getValue();
        }

        public ConceptSetComponent setSystemSimple(String string) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
            return this;
        }

        public StringType getVersion() {
            return this.version;
        }

        public ConceptSetComponent setVersion(StringType stringType) {
            this.version = stringType;
            return this;
        }

        public String getVersionSimple() {
            return this.version == null ? null : this.version.getValue();
        }

        public ConceptSetComponent setVersionSimple(String string) {
            if (string == null) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(string);
            }
            return this;
        }

        public List<CodeType> getCode() {
            return this.code;
        }

        public CodeType addCode() {
            CodeType codeType = new CodeType();
            this.code.add(codeType);
            return codeType;
        }

        public CodeType addCodeSimple(String string) {
            CodeType codeType = new CodeType();
            codeType.setValue(string);
            this.code.add(codeType);
            return codeType;
        }

        public boolean hasCodeSimple(String string) {
            for (CodeType codeType : this.code) {
                if (!codeType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public List<ConceptSetFilterComponent> getFilter() {
            return this.filter;
        }

        public ConceptSetFilterComponent addFilter() {
            ConceptSetFilterComponent conceptSetFilterComponent = new ConceptSetFilterComponent();
            this.filter.add(conceptSetFilterComponent);
            return conceptSetFilterComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("system", "uri", "The code system from which the selected codes come from.", 0, Integer.MAX_VALUE, this.system));
            list.add(new Property("version", "string", "The version of the code system that the codes are selected from.", 0, Integer.MAX_VALUE, this.version));
            list.add(new Property("code", "code", "Specifies a code or concept to be included or excluded. The list of codes is considered ordered, though the order may not have any particular significance.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("filter", "", "Select concepts by specify a matching criteria based on the properties (including relationships) defined by the system. If multiple filters are specified, they SHALL all be true.", 0, Integer.MAX_VALUE, this.filter));
        }

        public ConceptSetComponent copy() {
            ConceptSetComponent conceptSetComponent = new ConceptSetComponent();
            conceptSetComponent.system = this.system == null ? null : this.system.copy();
            conceptSetComponent.version = this.version == null ? null : this.version.copy();
            conceptSetComponent.code = new ArrayList<CodeType>();
            for (CodeType element : this.code) {
                conceptSetComponent.code.add(element.copy());
            }
            conceptSetComponent.filter = new ArrayList<ConceptSetFilterComponent>();
            for (ConceptSetFilterComponent conceptSetFilterComponent : this.filter) {
                conceptSetComponent.filter.add(conceptSetFilterComponent.copy());
            }
            return conceptSetComponent;
        }
    }

    public static class ValueSetComposeComponent
    extends BackboneElement {
        protected List<UriType> import_ = new ArrayList<UriType>();
        protected List<ConceptSetComponent> include = new ArrayList<ConceptSetComponent>();
        protected List<ConceptSetComponent> exclude = new ArrayList<ConceptSetComponent>();
        private static final long serialVersionUID = 1784534855L;

        public List<UriType> getImport() {
            return this.import_;
        }

        public UriType addImport() {
            UriType uriType = new UriType();
            this.import_.add(uriType);
            return uriType;
        }

        public UriType addImportSimple(String string) {
            UriType uriType = new UriType();
            uriType.setValue(string);
            this.import_.add(uriType);
            return uriType;
        }

        public boolean hasImportSimple(String string) {
            for (UriType uriType : this.import_) {
                if (!uriType.getValue().equals(string)) continue;
                return true;
            }
            return false;
        }

        public List<ConceptSetComponent> getInclude() {
            return this.include;
        }

        public ConceptSetComponent addInclude() {
            ConceptSetComponent conceptSetComponent = new ConceptSetComponent();
            this.include.add(conceptSetComponent);
            return conceptSetComponent;
        }

        public List<ConceptSetComponent> getExclude() {
            return this.exclude;
        }

        public ConceptSetComponent addExclude() {
            ConceptSetComponent conceptSetComponent = new ConceptSetComponent();
            this.exclude.add(conceptSetComponent);
            return conceptSetComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("import", "uri", "Includes the contents of the referenced value set as a part of the contents of this value set.", 0, Integer.MAX_VALUE, this.import_));
            list.add(new Property("include", "", "Include one or more codes from a code system.", 0, Integer.MAX_VALUE, this.include));
            list.add(new Property("exclude", "@ValueSet.compose.include", "Exclude one or more codes from the value set.", 0, Integer.MAX_VALUE, this.exclude));
        }

        public ValueSetComposeComponent copy() {
            ValueSetComposeComponent valueSetComposeComponent = new ValueSetComposeComponent();
            valueSetComposeComponent.import_ = new ArrayList<UriType>();
            for (UriType element : this.import_) {
                valueSetComposeComponent.import_.add(element.copy());
            }
            valueSetComposeComponent.include = new ArrayList<ConceptSetComponent>();
            for (ConceptSetComponent conceptSetComponent : this.include) {
                valueSetComposeComponent.include.add(conceptSetComponent.copy());
            }
            valueSetComposeComponent.exclude = new ArrayList<ConceptSetComponent>();
            for (ConceptSetComponent conceptSetComponent : this.exclude) {
                valueSetComposeComponent.exclude.add(conceptSetComponent.copy());
            }
            return valueSetComposeComponent;
        }
    }

    public static class ValueSetDefineConceptComponent
    extends BackboneElement {
        protected CodeType code;
        protected BooleanType abstract_;
        protected StringType display;
        protected StringType definition;
        protected List<ValueSetDefineConceptComponent> concept = new ArrayList<ValueSetDefineConceptComponent>();
        private static final long serialVersionUID = -1870725379L;

        public ValueSetDefineConceptComponent() {
        }

        public ValueSetDefineConceptComponent(CodeType codeType) {
            this.code = codeType;
        }

        public CodeType getCode() {
            return this.code;
        }

        public ValueSetDefineConceptComponent setCode(CodeType codeType) {
            this.code = codeType;
            return this;
        }

        public String getCodeSimple() {
            return this.code == null ? null : this.code.getValue();
        }

        public ValueSetDefineConceptComponent setCodeSimple(String string) {
            if (this.code == null) {
                this.code = new CodeType();
            }
            this.code.setValue(string);
            return this;
        }

        public BooleanType getAbstract() {
            return this.abstract_;
        }

        public ValueSetDefineConceptComponent setAbstract(BooleanType booleanType) {
            this.abstract_ = booleanType;
            return this;
        }

        public boolean getAbstractSimple() {
            return this.abstract_ == null ? false : this.abstract_.getValue();
        }

        public ValueSetDefineConceptComponent setAbstractSimple(boolean bl) {
            if (!bl) {
                this.abstract_ = null;
            } else {
                if (this.abstract_ == null) {
                    this.abstract_ = new BooleanType();
                }
                this.abstract_.setValue(bl);
            }
            return this;
        }

        public StringType getDisplay() {
            return this.display;
        }

        public ValueSetDefineConceptComponent setDisplay(StringType stringType) {
            this.display = stringType;
            return this;
        }

        public String getDisplaySimple() {
            return this.display == null ? null : this.display.getValue();
        }

        public ValueSetDefineConceptComponent setDisplaySimple(String string) {
            if (string == null) {
                this.display = null;
            } else {
                if (this.display == null) {
                    this.display = new StringType();
                }
                this.display.setValue(string);
            }
            return this;
        }

        public StringType getDefinition() {
            return this.definition;
        }

        public ValueSetDefineConceptComponent setDefinition(StringType stringType) {
            this.definition = stringType;
            return this;
        }

        public String getDefinitionSimple() {
            return this.definition == null ? null : this.definition.getValue();
        }

        public ValueSetDefineConceptComponent setDefinitionSimple(String string) {
            if (string == null) {
                this.definition = null;
            } else {
                if (this.definition == null) {
                    this.definition = new StringType();
                }
                this.definition.setValue(string);
            }
            return this;
        }

        public List<ValueSetDefineConceptComponent> getConcept() {
            return this.concept;
        }

        public ValueSetDefineConceptComponent addConcept() {
            ValueSetDefineConceptComponent valueSetDefineConceptComponent = new ValueSetDefineConceptComponent();
            this.concept.add(valueSetDefineConceptComponent);
            return valueSetDefineConceptComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("code", "code", "Code that identifies concept.", 0, Integer.MAX_VALUE, this.code));
            list.add(new Property("abstract", "boolean", "If this code is not for use as a real concept.", 0, Integer.MAX_VALUE, this.abstract_));
            list.add(new Property("display", "string", "Text to Display to the user.", 0, Integer.MAX_VALUE, this.display));
            list.add(new Property("definition", "string", "The formal definition of the concept. Formal definitions are not required, because of the prevalence of legacy systems without them, but they are highly recommended, as without them there is no formal meaning associated with the concept.", 0, Integer.MAX_VALUE, this.definition));
            list.add(new Property("concept", "@ValueSet.define.concept", "Child Concepts (is-a / contains).", 0, Integer.MAX_VALUE, this.concept));
        }

        public ValueSetDefineConceptComponent copy() {
            ValueSetDefineConceptComponent valueSetDefineConceptComponent = new ValueSetDefineConceptComponent();
            valueSetDefineConceptComponent.code = this.code == null ? null : this.code.copy();
            valueSetDefineConceptComponent.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
            valueSetDefineConceptComponent.display = this.display == null ? null : this.display.copy();
            valueSetDefineConceptComponent.definition = this.definition == null ? null : this.definition.copy();
            valueSetDefineConceptComponent.concept = new ArrayList<ValueSetDefineConceptComponent>();
            for (ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : this.concept) {
                valueSetDefineConceptComponent.concept.add(valueSetDefineConceptComponent2.copy());
            }
            return valueSetDefineConceptComponent;
        }
    }

    public static class ValueSetDefineComponent
    extends BackboneElement {
        protected UriType system;
        protected StringType version;
        protected BooleanType caseSensitive;
        protected List<ValueSetDefineConceptComponent> concept = new ArrayList<ValueSetDefineConceptComponent>();
        private static final long serialVersionUID = 819436673L;

        public ValueSetDefineComponent() {
        }

        public ValueSetDefineComponent(UriType uriType) {
            this.system = uriType;
        }

        public UriType getSystem() {
            return this.system;
        }

        public ValueSetDefineComponent setSystem(UriType uriType) {
            this.system = uriType;
            return this;
        }

        public String getSystemSimple() {
            return this.system == null ? null : this.system.getValue();
        }

        public ValueSetDefineComponent setSystemSimple(String string) {
            if (this.system == null) {
                this.system = new UriType();
            }
            this.system.setValue(string);
            return this;
        }

        public StringType getVersion() {
            return this.version;
        }

        public ValueSetDefineComponent setVersion(StringType stringType) {
            this.version = stringType;
            return this;
        }

        public String getVersionSimple() {
            return this.version == null ? null : this.version.getValue();
        }

        public ValueSetDefineComponent setVersionSimple(String string) {
            if (string == null) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(string);
            }
            return this;
        }

        public BooleanType getCaseSensitive() {
            return this.caseSensitive;
        }

        public ValueSetDefineComponent setCaseSensitive(BooleanType booleanType) {
            this.caseSensitive = booleanType;
            return this;
        }

        public boolean getCaseSensitiveSimple() {
            return this.caseSensitive == null ? false : this.caseSensitive.getValue();
        }

        public ValueSetDefineComponent setCaseSensitiveSimple(boolean bl) {
            if (!bl) {
                this.caseSensitive = null;
            } else {
                if (this.caseSensitive == null) {
                    this.caseSensitive = new BooleanType();
                }
                this.caseSensitive.setValue(bl);
            }
            return this;
        }

        public List<ValueSetDefineConceptComponent> getConcept() {
            return this.concept;
        }

        public ValueSetDefineConceptComponent addConcept() {
            ValueSetDefineConceptComponent valueSetDefineConceptComponent = new ValueSetDefineConceptComponent();
            this.concept.add(valueSetDefineConceptComponent);
            return valueSetDefineConceptComponent;
        }

        @Override
        protected void listChildren(List<Property> list) {
            super.listChildren(list);
            list.add(new Property("system", "uri", "URI to identify the code system.", 0, Integer.MAX_VALUE, this.system));
            list.add(new Property("version", "string", "The version of this code system that defines the codes. Note that the version is optional because a well maintained code system does not suffer from versioning, and therefore the version does not need to be maintained. However many code systems are not well maintained, and the version needs to be defined and tracked.", 0, Integer.MAX_VALUE, this.version));
            list.add(new Property("caseSensitive", "boolean", "If code comparison is case sensitive when codes within this system are compared to each other.", 0, Integer.MAX_VALUE, this.caseSensitive));
            list.add(new Property("concept", "", "Concepts in the code system.", 0, Integer.MAX_VALUE, this.concept));
        }

        public ValueSetDefineComponent copy() {
            ValueSetDefineComponent valueSetDefineComponent = new ValueSetDefineComponent();
            valueSetDefineComponent.system = this.system == null ? null : this.system.copy();
            valueSetDefineComponent.version = this.version == null ? null : this.version.copy();
            valueSetDefineComponent.caseSensitive = this.caseSensitive == null ? null : this.caseSensitive.copy();
            valueSetDefineComponent.concept = new ArrayList<ValueSetDefineConceptComponent>();
            for (ValueSetDefineConceptComponent valueSetDefineConceptComponent : this.concept) {
                valueSetDefineComponent.concept.add(valueSetDefineConceptComponent.copy());
            }
            return valueSetDefineComponent;
        }
    }

    public static class FilterOperatorEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("=".equals(string)) {
                return FilterOperator.equal;
            }
            if ("is-a".equals(string)) {
                return FilterOperator.isa;
            }
            if ("is-not-a".equals(string)) {
                return FilterOperator.isnota;
            }
            if ("regex".equals(string)) {
                return FilterOperator.regex;
            }
            if ("in".equals(string)) {
                return FilterOperator.in;
            }
            if ("not in".equals(string)) {
                return FilterOperator.notIn;
            }
            throw new Exception("Unknown FilterOperator code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == FilterOperator.equal) {
                return "=";
            }
            if (enum_ == FilterOperator.isa) {
                return "is-a";
            }
            if (enum_ == FilterOperator.isnota) {
                return "is-not-a";
            }
            if (enum_ == FilterOperator.regex) {
                return "regex";
            }
            if (enum_ == FilterOperator.in) {
                return "in";
            }
            if (enum_ == FilterOperator.notIn) {
                return "not in";
            }
            return "?";
        }
    }

    public static enum FilterOperator {
        equal,
        isa,
        isnota,
        regex,
        in,
        notIn,
        Null;


        public static FilterOperator fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("=".equals(string)) {
                return equal;
            }
            if ("is-a".equals(string)) {
                return isa;
            }
            if ("is-not-a".equals(string)) {
                return isnota;
            }
            if ("regex".equals(string)) {
                return regex;
            }
            if ("in".equals(string)) {
                return in;
            }
            if ("not in".equals(string)) {
                return notIn;
            }
            throw new Exception("Unknown FilterOperator code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case equal: {
                    return "=";
                }
                case isa: {
                    return "is-a";
                }
                case isnota: {
                    return "is-not-a";
                }
                case regex: {
                    return "regex";
                }
                case in: {
                    return "in";
                }
                case notIn: {
                    return "not in";
                }
            }
            return "?";
        }
    }

    public static class ValuesetStatusEnumFactory
    implements EnumFactory {
        @Override
        public Enum<?> fromCode(String string) throws Exception {
            if ((string == null || "".equals(string)) && (string == null || "".equals(string))) {
                return null;
            }
            if ("draft".equals(string)) {
                return ValuesetStatus.draft;
            }
            if ("active".equals(string)) {
                return ValuesetStatus.active;
            }
            if ("retired".equals(string)) {
                return ValuesetStatus.retired;
            }
            throw new Exception("Unknown ValuesetStatus code '" + string + "'");
        }

        @Override
        public String toCode(Enum<?> enum_) throws Exception {
            if (enum_ == ValuesetStatus.draft) {
                return "draft";
            }
            if (enum_ == ValuesetStatus.active) {
                return "active";
            }
            if (enum_ == ValuesetStatus.retired) {
                return "retired";
            }
            return "?";
        }
    }

    public static enum ValuesetStatus {
        draft,
        active,
        retired,
        Null;


        public static ValuesetStatus fromCode(String string) throws Exception {
            if (string == null || "".equals(string)) {
                return null;
            }
            if ("draft".equals(string)) {
                return draft;
            }
            if ("active".equals(string)) {
                return active;
            }
            if ("retired".equals(string)) {
                return retired;
            }
            throw new Exception("Unknown ValuesetStatus code '" + string + "'");
        }

        public String toCode() {
            switch (this) {
                case draft: {
                    return "draft";
                }
                case active: {
                    return "active";
                }
                case retired: {
                    return "retired";
                }
            }
            return "?";
        }
    }
}

