/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hl7.fhir.instance.formats.ResourceOrFeed;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.MedicationPrescription;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Resource;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AtomParserTest {
    private File file = null;
    private XmlParser parser = null;
    private String basePath = null;
    private String filepathResourceNotPretty;
    private String filepathResourcePretty;
    private String filepathFeedNotPretty;
    private String filepathFeedPretty;
    private String itemPath;
    private String filepathFurore1NotPretty;
    private String filepathFurore1Pretty;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        System.out.println(new File(".").getCanonicalPath());
        this.basePath = new File(".").getCanonicalPath().replaceAll(Pattern.quote("build" + File.separator) + ".*", Matcher.quoteReplacement("build" + File.separator + "tests" + File.separator + "fixtures" + File.separator));
        this.filepathResourceNotPretty = this.basePath + "containedResource_notpretty.xml";
        this.filepathResourcePretty = this.basePath + "containedResource_pretty.xml";
        this.filepathFeedNotPretty = this.basePath + "containedFeed_notpretty.xml";
        this.filepathFeedPretty = this.basePath + "containedFeed_pretty.xml";
        this.itemPath = this.basePath + "diagnosticreport-feed.xml";
        this.filepathFurore1NotPretty = this.basePath + "FuroreHistory15_noformat.xml";
        this.filepathFurore1Pretty = this.basePath + "FuroreHistory15_pretty.xml";
        this.parser = new XmlParser();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testItem() {
        ResourceOrFeed resourceOrFeed = this.parseFile(this.itemPath);
        Resource resource = resourceOrFeed.getResource();
        Assert.assertTrue((resource != null ? 1 : 0) != 0);
    }

    @Test
    public void testResourceNotPretty() {
        ResourceOrFeed resourceOrFeed = this.parseFile(this.filepathResourceNotPretty);
        MedicationPrescription medicationPrescription = (MedicationPrescription)resourceOrFeed.getResource();
        System.out.println("|" + (Object)((Object)medicationPrescription.getStatusSimple()) + "|");
        Assert.assertTrue((boolean)medicationPrescription.getStatusSimple().toString().equals("active"));
    }

    @Test
    public void testResourcePretty() {
        ResourceOrFeed resourceOrFeed = this.parseFile(this.filepathResourcePretty);
        MedicationPrescription medicationPrescription = (MedicationPrescription)resourceOrFeed.getResource();
        System.out.println("|" + (Object)((Object)medicationPrescription.getStatusSimple()) + "|");
        Assert.assertTrue((boolean)medicationPrescription.getStatusSimple().toString().equals("active"));
    }

    @Test
    public void testFeedNotPretty() {
        ResourceOrFeed resourceOrFeed = this.parseFile(this.filepathFeedNotPretty);
        MedicationPrescription medicationPrescription = (MedicationPrescription)resourceOrFeed.getFeed().getEntryList().get(0).getResource();
        System.out.println("|" + (Object)((Object)medicationPrescription.getStatusSimple()) + "|");
        Assert.assertTrue((boolean)medicationPrescription.getStatusSimple().toString().equals("active"));
    }

    @Test
    public void testFeedPretty() {
        ResourceOrFeed resourceOrFeed = this.parseFile(this.filepathFeedPretty);
        MedicationPrescription medicationPrescription = (MedicationPrescription)resourceOrFeed.getFeed().getEntryList().get(0).getResource();
        System.out.println("|" + (Object)((Object)medicationPrescription.getStatusSimple()) + "|");
        Assert.assertTrue((boolean)medicationPrescription.getStatusSimple().toString().equals("active"));
    }

    @Test
    public void testFurorePretty() {
        try {
            ResourceOrFeed resourceOrFeed = this.parseFile(this.filepathFurore1Pretty);
            AtomFeed atomFeed = resourceOrFeed.getFeed();
            Assert.assertTrue((atomFeed.getEntryList().size() == 3 ? 1 : 0) != 0);
            for (AtomEntry<? extends Resource> object2 : atomFeed.getEntryList()) {
                Assert.assertTrue((boolean)(object2.getResource() instanceof Patient));
            }
            Patient patient = (Patient)atomFeed.getEntryList().get(0).getResource();
            Assert.assertTrue((boolean)patient.getName().get(0).getFamily().get(0).getValue().equalsIgnoreCase("Fox"));
            Patient patient2 = (Patient)atomFeed.getEntryList().get(1).getResource();
            Assert.assertTrue((boolean)patient2.getName().get(0).getFamily().get(0).getValue().equalsIgnoreCase("Fox"));
            Patient patient3 = (Patient)atomFeed.getEntryList().get(2).getResource();
            Assert.assertTrue((boolean)patient3.getName().get(0).getFamily().get(0).getValue().equalsIgnoreCase("Garrett"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testFuroreNotPretty() {
        try {
            ResourceOrFeed resourceOrFeed = this.parseFile(this.filepathFurore1NotPretty);
            Assert.assertTrue((resourceOrFeed.getFeed() != null || resourceOrFeed.getResource() != null ? 1 : 0) != 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    private ResourceOrFeed parseFile(String string) {
        try {
            this.file = new File(string);
            return this.parseFile(this.file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)"Error Thrown");
            return null;
        }
    }

    private ResourceOrFeed parseFile(File file) throws FileNotFoundException, Exception {
        System.out.println(file.getName());
        FileInputStream fileInputStream = new FileInputStream(file);
        ResourceOrFeed resourceOrFeed = this.parser.parseGeneral(fileInputStream);
        Assert.assertTrue((boolean)true);
        return resourceOrFeed;
    }
}

