/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.test;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.instance.client.ClientUtils;
import org.hl7.fhir.instance.client.EFhirClientException;
import org.hl7.fhir.instance.client.FHIRClient;
import org.hl7.fhir.instance.client.FHIRSimpleClient;
import org.hl7.fhir.instance.client.ResourceAddress;
import org.hl7.fhir.instance.client.ResourceFormat;
import org.hl7.fhir.instance.model.AdverseReaction;
import org.hl7.fhir.instance.model.AtomCategory;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FHIRSimpleClientTest {
    private static String connectUrl = null;
    private static String userAgent = null;
    private static DateAndTime testDateAndTime = null;
    private FHIRClient testClient;
    private String testPatientId;
    private String testPatientVersion;
    private boolean logResource = true;
    private boolean useProxy = true;

    private static void configureForFurore() {
        connectUrl = "http://spark.furore.com/fhir/";
        userAgent = "Spark.Service";
    }

    private static void configureForHealthIntersection() {
        connectUrl = "http://fhir.healthintersections.com.au/open";
        userAgent = "Reference Server";
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        FHIRSimpleClientTest.configureForHealthIntersection();
        testDateAndTime = new DateAndTime("2008-08-08");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.testClient = new FHIRSimpleClient();
        this.testClient.initialize(connectUrl);
        if (this.useProxy) {
            ((FHIRSimpleClient)this.testClient).configureProxy("127.0.0.1", 8888);
        }
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFHIRSimpleClient() {
        try {
            FHIRSimpleClient fHIRSimpleClient = new FHIRSimpleClient();
            fHIRSimpleClient.initialize(connectUrl);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testGetConformanceStatement() {
        try {
            this.testClient.setPreferredResourceFormat(ResourceFormat.RESOURCE_XML);
            Conformance conformance = this.testClient.getConformanceStatement();
            Assert.assertEquals((Object)userAgent, (Object)conformance.getSoftware().getName().getValue());
            this.printResourceToSystemOut(conformance, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testGetConformanceStatementWithOptionsJson() {
        try {
            this.testClient.setPreferredResourceFormat(ResourceFormat.RESOURCE_JSON);
            Conformance conformance = this.testClient.getConformanceStatement(true);
            Assert.assertEquals((Object)userAgent, (Object)conformance.getSoftware().getName().getValue());
            this.printResourceToSystemOut(conformance, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testGetConformanceStatementWithOptionsXml() {
        try {
            this.testClient.setPreferredResourceFormat(ResourceFormat.RESOURCE_XML);
            Conformance conformance = this.testClient.getConformanceStatement(true);
            Assert.assertEquals((Object)userAgent, (Object)conformance.getSoftware().getName().getValue());
            this.printResourceToSystemOut(conformance, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testGetConformanceStatementWithGetXml() {
        try {
            this.testClient.setPreferredResourceFormat(ResourceFormat.RESOURCE_XML);
            Conformance conformance = this.testClient.getConformanceStatement(false);
            Assert.assertEquals((Object)userAgent, (Object)conformance.getSoftware().getName().getValue());
            this.printResourceToSystemOut(conformance, false);
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testGetConformanceStatementWithGetJson() {
        try {
            this.testClient.setPreferredResourceFormat(ResourceFormat.RESOURCE_JSON);
            Conformance conformance = this.testClient.getConformanceStatement(false);
            Assert.assertEquals((Object)userAgent, (Object)conformance.getSoftware().getName().getValue());
            this.printResourceToSystemOut(conformance, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)exception.getMessage());
        }
    }

    @Test
    public void testRead() {
        this.loadPatientResource();
        AtomEntry<Patient> atomEntry = this.testClient.read(Patient.class, this.testPatientId);
        this.assertEqualDate(atomEntry.getResource().getBirthDate().getValue(), testDateAndTime);
        Assert.assertEquals((long)2L, (long)atomEntry.getTags().size());
        this.unloadPatientResource();
    }

    @Test
    public void testVread() {
        try {
            this.loadPatientResource();
            AtomEntry<Patient> atomEntry = this.testClient.vread(Patient.class, this.testPatientId, this.testPatientVersion);
            this.assertEqualDate(atomEntry.getResource().getBirthDate().getValue(), testDateAndTime);
            Assert.assertEquals((long)2L, (long)atomEntry.getTags().size());
            this.unloadPatientResource();
        }
        catch (EFhirClientException eFhirClientException) {
            List<OperationOutcome> list = eFhirClientException.getServerErrors();
            for (OperationOutcome operationOutcome : list) {
                for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
                    System.out.println(operationOutcomeIssueComponent.getDetailsSimple());
                }
            }
            eFhirClientException.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testUpdate() {
        try {
            this.loadPatientResource();
            AtomEntry<Patient> atomEntry = this.testClient.read(Patient.class, this.testPatientId);
            String string = this.getEntryVersion(atomEntry);
            DateTimeType dateTimeType = new DateTimeType();
            dateTimeType.setValue(new DateAndTime("2002-09-09"));
            atomEntry.getResource().setBirthDate(dateTimeType);
            AtomEntry<Patient> atomEntry2 = this.testClient.update(Patient.class, atomEntry.getResource(), this.testPatientId);
            if (atomEntry2.getResource() == null) {
                atomEntry2 = this.testClient.read(Patient.class, this.testPatientId);
            }
            String string2 = this.getEntryId(atomEntry2);
            String string3 = this.getResourceType(atomEntry2);
            String string4 = this.getEntryVersion(atomEntry2);
            Assert.assertEquals((Object)string2, (Object)this.testPatientId);
            Assert.assertEquals((Object)"Patient", (Object)string3);
            Assert.assertEquals((long)(Integer.parseInt(string) + 1), (long)Integer.parseInt(string4));
            AtomEntry<Patient> atomEntry3 = this.testClient.read(Patient.class, this.testPatientId);
            this.assertEqualDate(new DateAndTime("2002-09-09"), atomEntry3.getResource().getBirthDateSimple());
            this.unloadPatientResource();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testCreate() {
        Patient patient = this.buildPatient();
        AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
        if (atomEntry.getResource() != null) {
            Assert.assertEquals((long)0L, (long)atomEntry.getResource().getIssue().size());
        }
        String string = this.getEntryId(atomEntry);
        String string2 = this.getResourceType(atomEntry);
        String string3 = this.getEntryVersion(atomEntry);
        Assert.assertEquals((Object)"Patient", (Object)string2);
        Assert.assertNotNull((Object)string);
        Assert.assertNotNull((Object)string3);
    }

    @Test
    public void testDelete() {
        Patient patient = this.buildPatient();
        AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
        boolean bl = this.testClient.delete(Patient.class, this.getEntryId(atomEntry));
        Assert.assertTrue((boolean)bl);
    }

    @Test
    public void testValidate() {
        try {
            this.loadPatientResource();
            Patient patient = this.testClient.read(Patient.class, this.testPatientId).getResource();
            DateTimeType dateTimeType = new DateTimeType();
            dateTimeType.setValue(new DateAndTime("2009-08-08"));
            patient.setBirthDate(dateTimeType);
            AtomEntry<OperationOutcome> atomEntry = this.testClient.validate(Patient.class, patient, this.testPatientId);
            Assert.assertTrue((atomEntry.getResource().getIssue().size() == 0 ? 1 : 0) != 0);
            this.unloadPatientResource();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGetHistoryForResourceWithId() {
        this.loadPatientResource();
        Patient patient = this.testClient.read(Patient.class, this.testPatientId).getResource();
        this.testClient.update(Patient.class, patient, this.testPatientId);
        this.testClient.update(Patient.class, patient, this.testPatientId);
        AtomFeed atomFeed = this.testClient.history(Patient.class, this.testPatientId);
        Assert.assertNotNull((Object)atomFeed);
        Assert.assertEquals((long)3L, (long)atomFeed.getEntryList().size());
    }

    @Test
    public void testGetHistoryForResourcesOfTypeSinceCalendarDate() {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(12, -10);
            Patient patient = this.buildPatient();
            AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
            this.testClient.update(Patient.class, patient, this.getEntryId(atomEntry));
            AtomFeed atomFeed = this.testClient.history(calendar, Patient.class);
            Assert.assertNotNull((Object)atomFeed);
            Assert.assertTrue((atomFeed.getEntryList().size() > 0 ? 1 : 0) != 0);
            this.testClient.delete(Patient.class, this.getEntryId(atomEntry));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testHistoryForAllResourceTypes() throws Exception {
        DateAndTime dateAndTime = DateAndTime.now();
        Calendar calendar = dateAndTime.toCalendar();
        calendar.add(10, -24);
        dateAndTime = new DateAndTime(calendar);
        AtomFeed atomFeed = this.testClient.history(dateAndTime);
        Assert.assertNotNull((Object)atomFeed);
        Assert.assertTrue((atomFeed.getEntryList().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testHistoryForAllResourceTypesWithCount() throws Exception {
        DateAndTime dateAndTime = DateAndTime.now();
        this.testClient.setMaximumRecordCount(5);
        Calendar calendar = dateAndTime.toCalendar();
        calendar.add(10, -24);
        dateAndTime = new DateAndTime(calendar);
        AtomFeed atomFeed = this.testClient.history(dateAndTime);
        Assert.assertNotNull((Object)atomFeed);
        System.out.println(atomFeed.getEntryList().size());
        Assert.assertTrue((atomFeed.getEntryList().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetHistoryForResourceWithIdSinceCalendarDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -10);
        Patient patient = this.buildPatient();
        AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, this.buildPatient());
        this.testClient.update(Patient.class, patient, this.getEntryId(atomEntry));
        this.testClient.update(Patient.class, patient, this.getEntryId(atomEntry));
        AtomFeed atomFeed = this.testClient.history(calendar, Patient.class, this.getEntryId(atomEntry));
        Assert.assertNotNull((Object)atomFeed);
        Assert.assertEquals((long)3L, (long)atomFeed.getEntryList().size());
        this.testClient.delete(Patient.class, this.getEntryId(atomEntry));
    }

    @Test
    public void testSearchForSingleResource() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("_count", "50");
        hashMap.put("gender", "F");
        hashMap.put("birthdate", "2008-08-08");
        AtomFeed atomFeed = this.testClient.search(Patient.class, hashMap);
        Assert.assertTrue((atomFeed != null ? 1 : 0) != 0);
        System.out.println(atomFeed.getEntryList().size());
        Assert.assertTrue((atomFeed.getEntryList().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSearchPatientByGivenName() {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = "Jsuis_" + System.currentTimeMillis();
            String string2 = "Malade";
            String string3 = string + " " + string2;
            hashMap.put("given", string);
            Patient patient = this.buildPatient(string3, string, string2);
            AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
            AtomFeed atomFeed = this.testClient.search(Patient.class, hashMap);
            int n = atomFeed.getEntryList().size();
            System.out.println(n);
            Assert.assertTrue((n == 1 ? 1 : 0) != 0);
            this.testClient.delete(Patient.class, this.getEntryId(atomEntry));
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testTransactionSuccess() {
        try {
            Patient patient = this.buildPatient();
            AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
            patient.setBirthDateSimple(new DateAndTime("1966-01-10"));
            ResourceReference resourceReference = new ResourceReference();
            AtomEntry<Patient> atomEntry2 = new AtomEntry<Patient>();
            atomEntry2.setResource(patient);
            atomEntry2.setId(this.getEntryPath(atomEntry));
            atomEntry2.getLinks().put("self", atomEntry.getLinks().get("self"));
            resourceReference.setReferenceSimple(this.getEntryPath(atomEntry));
            AdverseReaction adverseReaction = new AdverseReaction();
            adverseReaction.setSubject(resourceReference);
            adverseReaction.setDateSimple(new DateAndTime("2013-01-10"));
            adverseReaction.setDidNotOccurFlagSimple(false);
            AtomEntry<OperationOutcome> atomEntry3 = this.testClient.create(AdverseReaction.class, adverseReaction);
            AtomEntry<AdverseReaction> atomEntry4 = new AtomEntry<AdverseReaction>();
            atomEntry4.setResource(adverseReaction);
            atomEntry4.setId(this.getEntryPath(atomEntry3));
            atomEntry4.getLinks().put("self", atomEntry3.getLinks().get("self"));
            AtomFeed atomFeed = new AtomFeed();
            atomFeed.getEntryList().add(atomEntry2);
            atomFeed.getEntryList().add(atomEntry4);
            System.out.println(new String(ClientUtils.getFeedAsByteArray(atomFeed, false, false)));
            AtomFeed atomFeed2 = this.testClient.transaction(atomFeed);
            Assert.assertNotNull((Object)atomFeed2);
            assert (atomFeed2.getEntryList().get(0).getResource() instanceof Patient);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSimpleTransaction1() {
        try {
            Patient patient = this.buildPatient();
            AtomFeed atomFeed = new AtomFeed();
            AtomEntry<Patient> atomEntry = new AtomEntry<Patient>();
            atomEntry.setId("cid:Patient/temp1");
            atomEntry.setResource(patient);
            atomFeed.getEntryList().add(atomEntry);
            AtomFeed atomFeed2 = null;
            try {
                atomFeed2 = this.testClient.transaction(atomFeed);
            }
            catch (EFhirClientException eFhirClientException) {
                eFhirClientException.printStackTrace();
                Assert.fail();
            }
            Assert.assertNotNull((Object)atomFeed2);
            Assert.assertEquals((long)1L, (long)atomFeed2.getEntryList().size());
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testSimpleTransaction2() {
        try {
            Patient patient = this.buildPatient();
            AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
            patient.setBirthDateSimple(new DateAndTime("1966-01-10"));
            AtomFeed atomFeed = new AtomFeed();
            AtomEntry<Patient> atomEntry2 = new AtomEntry<Patient>();
            atomEntry2.getLinks().put("self", atomEntry.getLinks().get("self"));
            atomEntry2.setId(this.getEntryPath(atomEntry));
            atomEntry2.setResource(patient);
            atomFeed.getEntryList().add(atomEntry2);
            AtomFeed atomFeed2 = null;
            try {
                atomFeed2 = this.testClient.transaction(atomFeed);
            }
            catch (EFhirClientException eFhirClientException) {
                eFhirClientException.printStackTrace();
                Assert.fail();
            }
            Assert.assertNotNull((Object)atomFeed2);
            Assert.assertEquals((long)1L, (long)atomFeed2.getEntryList().size());
            this.testClient.delete(Patient.class, this.getEntryId(atomEntry));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testTransactionError() {
        try {
            Patient patient = this.buildPatient();
            AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient);
            patient.setBirthDateSimple(new DateAndTime("1966-01-10"));
            AtomFeed atomFeed = new AtomFeed();
            AtomEntry<Patient> atomEntry2 = new AtomEntry<Patient>();
            atomEntry2.getLinks().put("self", atomEntry.getLinks().get("self"));
            atomEntry2.setId(this.getEntryId(atomEntry));
            atomEntry2.setResource(patient);
            atomFeed.getEntryList().add(atomEntry2);
            atomFeed.getEntryList().add(atomEntry2);
            AtomFeed atomFeed2 = null;
            try {
                atomFeed2 = this.testClient.transaction(atomFeed);
            }
            catch (EFhirClientException eFhirClientException) {
                Assert.assertEquals((long)1L, (long)eFhirClientException.getServerErrors().size());
            }
            if (atomFeed2 != null) {
                Assert.fail();
            }
            this.testClient.delete(Patient.class, this.getEntryId(atomEntry));
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testGetAllTags() {
        List<AtomCategory> list = this.testClient.getAllTags();
        Assert.assertTrue((list != null && list.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAllTagsForResourceType() {
        List<AtomCategory> list = this.testClient.getAllTagsForResourceType(Patient.class);
        Assert.assertTrue((list != null && list.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTagsForResource() {
        this.loadPatientResource();
        List<AtomCategory> list = this.testClient.getTagsForResource(Patient.class, this.testPatientId);
        Assert.assertTrue((list != null && list.size() > 0 ? 1 : 0) != 0);
        this.unloadPatientResource();
    }

    @Test
    public void testGetTagsForResourceVersion() {
        this.loadPatientResource();
        List<AtomCategory> list = this.testClient.getTagsForResourceVersion(Patient.class, this.testPatientId, this.testPatientVersion);
        Assert.assertTrue((list != null && list.size() > 0 ? 1 : 0) != 0);
        this.unloadPatientResource();
    }

    @Test
    public void testCreateTagsForResource() {
        this.loadPatientResource();
        ArrayList<AtomCategory> arrayList = new ArrayList<AtomCategory>();
        arrayList.add(new AtomCategory("http://scheme.com", "http://term.com", "Some good ole term"));
        this.testClient.createTags(arrayList, Patient.class, this.testPatientId);
        this.unloadPatientResource();
    }

    @Test
    public void testCreateTagsForResourceVersion() {
        this.loadPatientResource();
        ArrayList<AtomCategory> arrayList = new ArrayList<AtomCategory>();
        arrayList.add(new AtomCategory("http://scheme.com", "http://term.com", "Some good ole term"));
        this.testClient.createTags(arrayList, Patient.class, this.testPatientId, this.testPatientVersion);
        this.unloadPatientResource();
    }

    private CodeableConcept createCodeableConcept(String string, String string2, String string3) {
        CodeableConcept codeableConcept = new CodeableConcept();
        Coding coding = codeableConcept.addCoding();
        coding.setCodeSimple(string);
        coding.setSystemSimple(string2);
        coding.setDisplaySimple(string3);
        return codeableConcept;
    }

    private Condition buildCondition(AtomEntry<Patient> atomEntry) {
        CodeableConcept codeableConcept = this.createCodeableConcept("29530003", "http://snomed.info/id", "Fungal granuloma (disorder)");
        return this.buildCondition(atomEntry, codeableConcept);
    }

    private Condition buildCondition(AtomEntry<Patient> atomEntry, CodeableConcept codeableConcept) {
        Condition condition = null;
        try {
            condition = new Condition();
            ResourceReference resourceReference = new ResourceReference();
            resourceReference.setReferenceSimple("patient/@" + this.getEntryId(atomEntry));
            condition.setSubject(resourceReference);
            condition.setCode(codeableConcept);
            condition.setStatusSimple(Condition.ConditionStatus.confirmed);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        return condition;
    }

    private Patient buildPatient() {
        return this.buildPatient("Jsuis Malade", "Jsuis", "Malade");
    }

    private Patient buildPatient(String string, String string2, String string3) {
        Patient patient = new Patient();
        try {
            HumanName humanName = patient.addName();
            humanName.setTextSimple(string);
            humanName.addGivenSimple(string2);
            humanName.addFamilySimple(string3);
            DateTimeType dateTimeType = new DateTimeType();
            dateTimeType.setValue(new DateAndTime("2008-08-08"));
            patient.setBirthDate(dateTimeType);
            CodeType codeType = new CodeType();
            codeType.setValue("F");
            Coding coding = new Coding();
            coding.setCode(codeType);
            coding.setSystemSimple("http://hl7.org/fhir/v3/AdministrativeGender");
            CodeableConcept codeableConcept = new CodeableConcept();
            codeableConcept.getCoding().add(coding);
            patient.setGender(codeableConcept);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            Assert.fail();
        }
        return patient;
    }

    private void loadPatientResource() {
        Patient patient = this.buildPatient();
        List<AtomCategory> list = this.generateCategoryHeader();
        AtomEntry<OperationOutcome> atomEntry = this.testClient.create(Patient.class, patient, list);
        this.testPatientId = this.getEntryId(atomEntry);
        this.testPatientVersion = this.getEntryVersion(atomEntry);
    }

    private List<AtomCategory> generateCategoryHeader() {
        ArrayList<AtomCategory> arrayList = new ArrayList<AtomCategory>();
        arrayList.add(new AtomCategory("http://client/scheme", "http://client/scheme/tag/123", "tag 123"));
        arrayList.add(new AtomCategory("http://client/scheme", "http://client/scheme/tag/456", "tag 456"));
        return arrayList;
    }

    private void unloadPatientResource() {
        this.testClient.delete(Patient.class, this.testPatientId);
    }

    private <T extends Resource> ResourceAddress.ResourceVersionedIdentifier getAtomEntryLink(AtomEntry<T> atomEntry, String string) {
        return ResourceAddress.parseCreateLocation(atomEntry.getLinks().get(string));
    }

    private <T extends Resource> ResourceAddress.ResourceVersionedIdentifier getAtomEntrySelfLink(AtomEntry<T> atomEntry) {
        return this.getAtomEntryLink(atomEntry, "self");
    }

    private <T extends Resource> String getEntryId(AtomEntry<T> atomEntry) {
        return this.getAtomEntrySelfLink(atomEntry).getId();
    }

    private <T extends Resource> String getEntryVersion(AtomEntry<T> atomEntry) {
        return this.getAtomEntrySelfLink(atomEntry).getVersion();
    }

    private <T extends Resource> String getResourceType(AtomEntry<T> atomEntry) {
        return this.getAtomEntrySelfLink(atomEntry).getResourceType();
    }

    private <T extends Resource> String getEntryPath(AtomEntry<T> atomEntry) {
        return this.getAtomEntrySelfLink(atomEntry).getResourcePath();
    }

    private <T extends Resource> String getResourceId(AtomEntry<T> atomEntry) {
        return this.getAtomEntrySelfLink(atomEntry).getId();
    }

    private <T extends Resource> void printResourceToSystemOut(T t, boolean bl) {
        if (this.logResource) {
            System.out.println(new String(ClientUtils.getResourceAsByteArray(t, true, bl)));
        }
    }

    private void assertEqualDate(DateAndTime dateAndTime, DateAndTime dateAndTime2) {
        Assert.assertEquals((long)dateAndTime2.getYear(), (long)dateAndTime.getYear());
        Assert.assertEquals((long)dateAndTime2.getMonth(), (long)dateAndTime.getMonth());
        Assert.assertEquals((long)dateAndTime2.getDay(), (long)dateAndTime.getDay());
    }
}

