/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.test;

import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import org.hl7.fhir.instance.client.ResourceAddress;
import org.hl7.fhir.instance.model.Patient;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResourceAddressTest {
    private String basePath = "http://fhir.healthintersections.com.au/open";
    private String fullNonVersionedPath = "http://fhir.healthintersections.com.au/open/Patient/318";
    private String fullVersionedPath = "http://fhir.healthintersections.com.au/open/Patient/318/_history/1";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testParseCreateLocation() {
        ResourceAddress.ResourceVersionedIdentifier resourceVersionedIdentifier = ResourceAddress.parseCreateLocation(this.fullVersionedPath);
        Assert.assertEquals((Object)this.basePath, (Object)resourceVersionedIdentifier.getServiceRoot());
        Assert.assertEquals((Object)"Patient", (Object)resourceVersionedIdentifier.getResourceType());
        Assert.assertEquals((Object)"318", (Object)resourceVersionedIdentifier.getId());
        Assert.assertEquals((Object)"1", (Object)resourceVersionedIdentifier.getVersionId());
        Assert.assertEquals((Object)this.fullNonVersionedPath, (Object)resourceVersionedIdentifier.getResourcePath());
    }

    @Test
    public void testBuildURIValidURLNoEndSlash() {
        try {
            Assert.assertEquals((Object)new URI(this.basePath + "/"), (Object)ResourceAddress.buildAbsoluteURI(this.basePath));
        }
        catch (Exception exception) {
            Assert.fail((String)"Error validating URI");
        }
    }

    @Test
    public void testBuildURIInvalidScheme() {
        try {
            ResourceAddress.buildAbsoluteURI("urn://hl7connect.healthintersections.com.au/svc/fhir");
            Assert.fail((String)"Should not be here as scheme is invalid");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testBuildURIMissingHost() {
        try {
            ResourceAddress.buildAbsoluteURI("http:///svc/fhir");
            Assert.fail((String)"Should not be here as host is missing");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testBuildURIValidURLEndSlash() {
        try {
            Assert.assertEquals((Object)new URI("http://hl7connect.healthintersections.com.au/svc/fhir/"), (Object)ResourceAddress.buildAbsoluteURI("http://hl7connect.healthintersections.com.au/svc/fhir/"));
        }
        catch (Exception exception) {
            Assert.fail((String)"Error validating URI");
        }
    }

    @Test
    public void testBuildURIInvalueURL() {
        try {
            ResourceAddress.buildAbsoluteURI("I am an invalid URI");
            Assert.fail((String)"Assertion: Should not get to this point");
        }
        catch (Exception exception) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void buildRelativePathFromResource() {
        Patient patient = new Patient();
        String string = ResourceAddress.buildRelativePathFromResource(patient);
        Assert.assertEquals((Object)"patient/", (Object)string);
    }

    @Test
    public void buildRelativePathFromResourceWithId() {
        Patient patient = new Patient();
        String string = ResourceAddress.buildRelativePathFromResource(patient, "23");
        Assert.assertEquals((Object)"patient/@23", (Object)string);
    }

    @Test
    public void buildRelativePathFromResourceType() {
        Patient patient = new Patient();
        String string = ResourceAddress.buildRelativePathFromResourceType(patient.getResourceType());
        Assert.assertEquals((Object)"patient/", (Object)string);
    }

    @Test
    public void buildRelativePathFromResourceTypeWithId() {
        Patient patient = new Patient();
        String string = ResourceAddress.buildRelativePathFromResourceType(patient.getResourceType(), "23");
        Assert.assertEquals((Object)"patient/@23", (Object)string);
    }

    @Test
    public void testAppendHttpParameter() {
        try {
            URI uRI = new URI("http://some.server.com:9090/path/to/file?param1=1&param2=2");
            URI uRI2 = ResourceAddress.appendHttpParameter(uRI, "param3", "3");
            System.out.println(uRI2);
            Assert.assertTrue((boolean)uRI2.toString().equals("http://some.server.com:9090/path/to/file?param1=1&param2=2&param3=3"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testAppendHttpParameters() {
        try {
            URI uRI = new URI("http://some.server.com:9090/path/to/file");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("param1", "1");
            hashMap.put("param2", "2");
            URI uRI2 = ResourceAddress.appendHttpParameters(uRI, hashMap);
            System.out.println(uRI2);
            Assert.assertTrue((boolean)uRI2.toString().equals("http://some.server.com:9090/path/to/file?param1=1&param2=2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testGetCalendarDateInIsoFormat() {
        String string = ResourceAddress.getCalendarDateInIsoTimeFormat(Calendar.getInstance());
        System.out.println(string);
    }
}

