/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.hl7.fhir.instance.formats.JsonComposer;
import org.hl7.fhir.instance.formats.JsonParser;
import org.hl7.fhir.instance.formats.ParserBase;
import org.hl7.fhir.instance.formats.ResourceOrFeed;
import org.hl7.fhir.instance.formats.XmlComposer;
import org.hl7.fhir.instance.formats.XmlParser;

public class ResourceTest {
    private File source;
    private boolean json;

    public File getSource() {
        return this.source;
    }

    public void setSource(File file) {
        this.source = file;
    }

    public void test() throws Exception {
        ParserBase parserBase = this.isJson() ? new JsonParser() : new XmlParser(false);
        ResourceOrFeed resourceOrFeed = parserBase.parseGeneral(new FileInputStream(this.source));
        FileOutputStream fileOutputStream = new FileOutputStream(this.source.getAbsoluteFile() + ".out.json");
        JsonComposer jsonComposer = new JsonComposer();
        if (resourceOrFeed.getFeed() != null) {
            jsonComposer.compose((OutputStream)fileOutputStream, resourceOrFeed.getFeed(), true);
        } else {
            jsonComposer.compose((OutputStream)fileOutputStream, resourceOrFeed.getResource(), true);
        }
        JsonParser jsonParser = new JsonParser();
        resourceOrFeed = jsonParser.parseGeneral(new FileInputStream(this.source.getAbsoluteFile() + ".out.json"));
        fileOutputStream = new FileOutputStream(this.source.getAbsoluteFile() + ".out.xml");
        if (resourceOrFeed.getFeed() != null) {
            XmlComposer xmlComposer = new XmlComposer();
            xmlComposer.compose((OutputStream)fileOutputStream, resourceOrFeed.getFeed(), true);
        } else {
            XmlComposer xmlComposer = new XmlComposer();
            xmlComposer.compose((OutputStream)fileOutputStream, resourceOrFeed.getResource(), true);
        }
    }

    public boolean isJson() {
        return this.json;
    }

    public void setJson(boolean bl) {
        this.json = bl;
    }
}

