/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.test;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.hl7.fhir.instance.formats.JsonComposer;
import org.hl7.fhir.instance.formats.JsonParser;
import org.hl7.fhir.instance.formats.ResourceOrFeed;
import org.hl7.fhir.instance.formats.XmlComposer;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ToolsHelper {
    public static void main(String[] stringArray) {
        block8: {
            try {
                ToolsHelper toolsHelper = new ToolsHelper();
                if (stringArray[0].equals("round")) {
                    toolsHelper.executeRoundTrip(stringArray);
                    break block8;
                }
                if (stringArray[0].equals("json")) {
                    toolsHelper.executeJson(stringArray);
                    break block8;
                }
                if (stringArray[0].equals("version")) {
                    toolsHelper.executeVersion(stringArray);
                    break block8;
                }
                if (stringArray[0].equals("fragments")) {
                    toolsHelper.executeFragments(stringArray);
                    break block8;
                }
                throw new Exception("Unknown command '" + stringArray[0] + "'");
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                    TextFile.stringToFile(throwable.toString(), stringArray[1] + ".err");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    protected XmlPullParser loadXml(InputStream inputStream) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setNamespaceAware(true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput((InputStream)bufferedInputStream, "UTF-8");
        xmlPullParser.next();
        return xmlPullParser;
    }

    protected int nextNoWhitespace(XmlPullParser xmlPullParser) throws Exception {
        int n = xmlPullParser.getEventType();
        while (n == 4 && xmlPullParser.isWhitespace()) {
            n = xmlPullParser.next();
        }
        return n;
    }

    public void executeFragments(String[] stringArray) throws Exception {
        try {
            CSFile cSFile = new CSFile(stringArray[1]);
            CSFile cSFile2 = new CSFile(stringArray[2]);
            if (!cSFile.exists()) {
                throw new Exception("Source File \"" + cSFile.getAbsolutePath() + "\" not found");
            }
            XmlPullParser xmlPullParser = this.loadXml(new FileInputStream(cSFile));
            this.nextNoWhitespace(xmlPullParser);
            if (!xmlPullParser.getName().equals("tests")) {
                throw new Exception("Unable to parse file - starts with " + xmlPullParser.getName());
            }
            xmlPullParser.next();
            this.nextNoWhitespace(xmlPullParser);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<results>\r\n");
            int n = 0;
            while (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("test")) {
                String string = xmlPullParser.getAttributeValue(null, "id");
                String string2 = xmlPullParser.getAttributeValue(null, "type");
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                XmlParser xmlParser = new XmlParser();
                try {
                    xmlParser.parseFragment(xmlPullParser, string2);
                    stringBuilder.append("<result id=\"" + string + "\" outcome=\"ok\"/>\r\n");
                    this.nextNoWhitespace(xmlPullParser);
                }
                catch (Exception exception) {
                    stringBuilder.append("<result id=\"" + string + "\" outcome=\"error\" msg=\"" + Utilities.escapeXml(exception.getMessage()) + "\"/>\r\n");
                    ++n;
                }
                while (xmlPullParser.getEventType() != 3 || !xmlPullParser.getName().equals("pre")) {
                    xmlPullParser.next();
                }
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
                xmlPullParser.next();
                this.nextNoWhitespace(xmlPullParser);
            }
            stringBuilder.append("</results>\r\n");
            System.out.println("done (fail = " + Integer.toString(n) + ")");
            TextFile.stringToFile(stringBuilder.toString(), stringArray[2]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TextFile.stringToFile(exception.getMessage(), stringArray[2]);
        }
    }

    public void executeRoundTrip(String[] stringArray) throws Exception {
        CSFile cSFile = new CSFile(stringArray[1]);
        CSFile cSFile2 = new CSFile(stringArray[2]);
        if (!cSFile.exists()) {
            throw new Exception("Source File \"" + cSFile.getAbsolutePath() + "\" not found");
        }
        CSFileInputStream cSFileInputStream = new CSFileInputStream(cSFile);
        XmlParser xmlParser = new XmlParser();
        JsonParser jsonParser = new JsonParser();
        ResourceOrFeed resourceOrFeed = xmlParser.parseGeneral(cSFileInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (resourceOrFeed.getFeed() != null) {
            new JsonComposer().compose((OutputStream)byteArrayOutputStream, resourceOrFeed.getFeed(), true);
            resourceOrFeed = jsonParser.parseGeneral(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            new XmlComposer().compose((OutputStream)new FileOutputStream(cSFile2), resourceOrFeed.getFeed(), true);
        } else {
            new JsonComposer().compose((OutputStream)byteArrayOutputStream, resourceOrFeed.getResource(), true);
            resourceOrFeed = jsonParser.parseGeneral(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            new XmlComposer().compose((OutputStream)new FileOutputStream(cSFile2), resourceOrFeed.getResource(), true);
        }
    }

    public String executeJson(String[] stringArray) throws Exception {
        CSFile cSFile = new CSFile(stringArray[1]);
        CSFile cSFile2 = new CSFile(stringArray[2]);
        CSFile cSFile3 = new CSFile(stringArray[2] + ".tmp");
        if (!cSFile.exists()) {
            throw new Exception("Source File \"" + cSFile.getAbsolutePath() + "\" not found");
        }
        CSFileInputStream cSFileInputStream = new CSFileInputStream(cSFile);
        XmlParser xmlParser = new XmlParser();
        ResourceOrFeed resourceOrFeed = xmlParser.parseGeneral(cSFileInputStream);
        JsonComposer jsonComposer = new JsonComposer();
        if (resourceOrFeed.getFeed() != null) {
            jsonComposer.compose((OutputStream)new FileOutputStream(cSFile2), resourceOrFeed.getFeed(), false);
            jsonComposer.compose((OutputStream)new FileOutputStream(cSFile3), resourceOrFeed.getFeed(), true);
        } else {
            jsonComposer.compose((OutputStream)new FileOutputStream(cSFile2), resourceOrFeed.getResource(), false);
            jsonComposer.compose((OutputStream)new FileOutputStream(cSFile3), resourceOrFeed.getResource(), true);
        }
        return TextFile.fileToString(cSFile3.getAbsolutePath());
    }

    private void executeVersion(String[] stringArray) throws Exception {
        TextFile.stringToFile("0.81:0.0.82", stringArray[1]);
    }
}

