/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.client.FHIRClient;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Composition;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Duration;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Property;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.ConceptLocator;
import org.hl7.fhir.instance.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class NarrativeGenerator {
    private String prefix;
    private ConceptLocator conceptLocator;
    private Map<String, AtomEntry<ValueSet>> codeSystems;
    private Map<String, AtomEntry<ValueSet>> valueSets;
    private Map<String, AtomEntry<ConceptMap>> maps;
    private FHIRClient client;
    private Map<String, Profile> profiles;

    public NarrativeGenerator(String string, ConceptLocator conceptLocator, Map<String, AtomEntry<ValueSet>> map, Map<String, AtomEntry<ValueSet>> map2, Map<String, AtomEntry<ConceptMap>> map3, Map<String, Profile> map4, FHIRClient fHIRClient) {
        this.prefix = string;
        this.conceptLocator = conceptLocator;
        this.codeSystems = map;
        this.valueSets = map2;
        this.maps = map3;
        this.profiles = map4;
        this.client = fHIRClient;
    }

    public void generate(Resource resource) throws Exception {
        if (resource instanceof ConceptMap) {
            this.generate((ConceptMap)resource);
        } else if (resource instanceof ValueSet) {
            this.generate((ValueSet)resource);
        } else if (resource instanceof OperationOutcome) {
            this.generate((OperationOutcome)resource);
        } else if (resource instanceof Conformance) {
            this.generate((Conformance)resource);
        } else if (this.profiles.containsKey(resource.getResourceType().toString())) {
            this.generateByProfile(resource, this.profiles.get(resource.getResourceType().toString()));
        }
    }

    private void generateByProfile(Resource resource, Profile profile) throws Exception {
        if (resource.hasModifierExtensions()) {
            throw new Exception("Unable to generate narrative for resource of type " + resource.getResourceType().toString() + " because it has modifier extensions");
        }
        Profile.ProfileStructureComponent profileStructureComponent = this.getByName(profile, resource.getResourceType().toString());
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "div");
        xhtmlNode.addTag("p").addTag("b").addText("Generated Narrative");
        try {
            this.generateByProfile(resource, resource, profileStructureComponent.getElement(), profileStructureComponent.getElement().get(0), this.getChildrenForPath(profileStructureComponent.getElement(), resource.getResourceType().toString()), xhtmlNode, resource.getResourceType().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            xhtmlNode.addTag("p").addTag("b").setAttribute("style", "color: maroon").addText("Exception generating Narrative: " + exception.getMessage());
        }
        this.inject(resource, xhtmlNode, Narrative.NarrativeStatus.generated);
    }

    private void generateByProfile(Resource resource, Element element, List<Profile.ElementComponent> list, Profile.ElementComponent elementComponent, List<Profile.ElementComponent> list2, XhtmlNode xhtmlNode, String string) throws Exception {
        if (list2.isEmpty()) {
            this.renderLeaf(resource, element, elementComponent, xhtmlNode, false);
        } else {
            for (Property property : element.children()) {
                Object object;
                Profile.ElementComponent elementComponent2;
                if (!property.hasValues() || this.exemptFromRendering(elementComponent2 = this.getElementDefinition(list2, string + "." + property.getName()))) continue;
                List<Profile.ElementComponent> list3 = this.getChildrenForPath(list, string + "." + property.getName());
                if (property.getValues().size() <= 0 || elementComponent2 == null) continue;
                if (this.isPrimitive(elementComponent2)) {
                    object = xhtmlNode.addTag("p");
                    ((XhtmlNode)object).addTag("b").addText(property.getName());
                    ((XhtmlNode)object).addText(": ");
                    if (this.renderAsList(elementComponent2) && property.getValues().size() > 1) {
                        XhtmlNode bl = xhtmlNode.addTag("ul");
                        for (Element element2 : property.getValues()) {
                            this.renderLeaf(resource, element2, elementComponent2, bl.addTag("li"), false);
                        }
                        continue;
                    }
                    boolean bl = true;
                    for (Element element2 : property.getValues()) {
                        boolean bl2;
                        if (bl2) {
                            bl2 = false;
                        } else {
                            ((XhtmlNode)object).addText(", ");
                        }
                        this.renderLeaf(resource, element2, elementComponent2, (XhtmlNode)object, false);
                    }
                    continue;
                }
                if (this.canDoTable(list3)) {
                    xhtmlNode.addTag("h3").addText(Utilities.capitalize(Utilities.camelCase(Utilities.pluralizeMe(property.getName()))));
                    object = xhtmlNode.addTag("table").setAttribute("class", "grid");
                    this.addColumnHeadings(((XhtmlNode)object).addTag("tr"), list3);
                    for (Element element3 : property.getValues()) {
                        if (element3 == null) continue;
                        this.addColumnValues(resource, ((XhtmlNode)object).addTag("tr"), list3, element3);
                    }
                    continue;
                }
                for (Element element4 : property.getValues()) {
                    if (element4 == null) continue;
                    XhtmlNode xhtmlNode2 = xhtmlNode.addTag("blockquote");
                    xhtmlNode2.addTag("p").addTag("b").addText(property.getName());
                    this.generateByProfile(resource, element4, list, elementComponent2, list3, xhtmlNode2, string + "." + property.getName());
                }
            }
        }
    }

    private boolean exemptFromRendering(Profile.ElementComponent elementComponent) {
        if (elementComponent == null) {
            return true;
        }
        if ("Composition.subject".equals(elementComponent.getPathSimple())) {
            return true;
        }
        return "Composition.section".equals(elementComponent.getPathSimple());
    }

    private boolean renderAsList(Profile.ElementComponent elementComponent) {
        String string;
        return elementComponent.getDefinition().getType().size() == 1 && ((string = elementComponent.getDefinition().getType().get(0).getCodeSimple()).equals("Address") || string.equals("ResourceReference"));
    }

    private void addColumnHeadings(XhtmlNode xhtmlNode, List<Profile.ElementComponent> list) {
        for (Profile.ElementComponent elementComponent : list) {
            xhtmlNode.addTag("td").addTag("b").addText(Utilities.capitalize(this.tail(elementComponent.getPathSimple())));
        }
    }

    private void addColumnValues(Resource resource, XhtmlNode xhtmlNode, List<Profile.ElementComponent> list, Element element) throws Exception {
        for (Profile.ElementComponent elementComponent : list) {
            Property property = element.getChildByName(elementComponent.getPathSimple().substring(elementComponent.getPathSimple().lastIndexOf(".") + 1));
            if (property.getValues().size() == 0 || property.getValues().get(0) == null) {
                xhtmlNode.addTag("td").addText(" ");
                continue;
            }
            this.renderLeaf(resource, property.getValues().get(0), elementComponent, xhtmlNode.addTag("td"), false);
        }
    }

    private String tail(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    private boolean canDoTable(List<Profile.ElementComponent> list) {
        boolean bl = true;
        for (Profile.ElementComponent elementComponent : list) {
            if (this.isPrimitive(elementComponent)) continue;
            return false;
        }
        return bl;
    }

    private boolean isPrimitive(Profile.ElementComponent elementComponent) {
        return !elementComponent.getDefinition().getType().isEmpty();
    }

    private Profile.ElementComponent getElementDefinition(List<Profile.ElementComponent> list, String string) {
        for (Profile.ElementComponent elementComponent : list) {
            if (!elementComponent.getPathSimple().equals(string)) continue;
            return elementComponent;
        }
        return null;
    }

    private void renderLeaf(Resource resource, Element element, Profile.ElementComponent elementComponent, XhtmlNode xhtmlNode, boolean bl) throws Exception {
        if (element == null) {
            return;
        }
        if (element instanceof StringType) {
            xhtmlNode.addText(((StringType)element).getValue());
        } else if (element instanceof CodeType) {
            xhtmlNode.addText(((CodeType)element).getValue());
        } else if (element instanceof IdType) {
            xhtmlNode.addText(((IdType)element).getValue());
        } else if (element instanceof Extension) {
            xhtmlNode.addText("Extensions: Todo");
        } else if (element instanceof InstantType) {
            xhtmlNode.addText(((InstantType)element).getValue().toHumanDisplay());
        } else if (element instanceof DateTimeType) {
            xhtmlNode.addText(((DateTimeType)element).getValue().toHumanDisplay());
        } else if (element instanceof DateType) {
            xhtmlNode.addText(((DateType)element).getValue().toHumanDisplay());
        } else if (element instanceof Enumeration) {
            xhtmlNode.addText(((Enum)((Enumeration)element).getValue()).toString());
        } else if (element instanceof BooleanType) {
            xhtmlNode.addText(((BooleanType)element).getValue().toString());
        } else if (element instanceof CodeableConcept) {
            this.renderCodeableConcept((CodeableConcept)element, xhtmlNode);
        } else if (element instanceof Coding) {
            this.renderCoding((Coding)element, xhtmlNode);
        } else if (element instanceof Identifier) {
            this.renderIdentifier((Identifier)element, xhtmlNode);
        } else if (element instanceof IntegerType) {
            xhtmlNode.addText(Integer.toString(((IntegerType)element).getValue()));
        } else if (element instanceof DecimalType) {
            xhtmlNode.addText(((DecimalType)element).getValue().toString());
        } else if (element instanceof HumanName) {
            this.renderHumanName((HumanName)element, xhtmlNode);
        } else if (element instanceof Address) {
            this.renderAddress((Address)element, xhtmlNode);
        } else if (element instanceof Contact) {
            this.renderContact((Contact)element, xhtmlNode);
        } else if (element instanceof UriType) {
            this.renderUri((UriType)element, xhtmlNode);
        } else if (element instanceof Schedule) {
            this.renderSchedule((Schedule)element, xhtmlNode);
        } else if (element instanceof Quantity || element instanceof Duration) {
            this.renderQuantity((Quantity)element, xhtmlNode);
        } else if (element instanceof Ratio) {
            this.renderQuantity(((Ratio)element).getNumerator(), xhtmlNode);
            xhtmlNode.addText("/");
            this.renderQuantity(((Ratio)element).getDenominator(), xhtmlNode);
        } else if (element instanceof Period) {
            Period period = (Period)element;
            xhtmlNode.addText(period.getStart() == null ? "??" : period.getStartSimple().toHumanDisplay());
            xhtmlNode.addText(" --> ");
            xhtmlNode.addText(period.getEnd() == null ? "(ongoing)" : period.getEndSimple().toHumanDisplay());
        } else if (element instanceof ResourceReference) {
            ResourceReference resourceReference = (ResourceReference)element;
            if (resourceReference.getDisplay() != null) {
                xhtmlNode.addText(resourceReference.getDisplaySimple());
            } else if (resourceReference.getReference() != null) {
                String string;
                ResourceWithReference resourceWithReference = this.resolveReference(resource, resourceReference.getReferenceSimple());
                String string2 = string = resourceWithReference == null ? resourceReference.getReferenceSimple() : this.getDisplayForResource(resourceWithReference.getResource());
                if (resourceReference.getReferenceSimple().startsWith("#")) {
                    xhtmlNode.addText(string);
                } else if (resourceWithReference != null) {
                    xhtmlNode.addTag("a").attribute("href", resourceWithReference.getReference()).addText(string);
                } else {
                    xhtmlNode.addTag("a").attribute("href", resourceReference.getReferenceSimple()).addText(string);
                }
            } else {
                xhtmlNode.addText("??");
            }
        } else if (!(element instanceof Attachment)) {
            throw new Exception("type " + element.getClass().getName() + " not handled yet");
        }
    }

    private boolean displayLeaf(Resource resource, Element element, Profile.ElementComponent elementComponent, StringBuilder stringBuilder, String string) throws Exception {
        if (element == null) {
            return false;
        }
        if (string.endsWith("[x]")) {
            string = string.substring(0, string.length() - 3);
        }
        if (element instanceof StringType) {
            stringBuilder.append(string + ": " + ((StringType)element).getValue());
            return true;
        }
        if (element instanceof CodeType) {
            stringBuilder.append(string + ": " + ((CodeType)element).getValue());
            return true;
        }
        if (element instanceof IdType) {
            stringBuilder.append(string + ": " + ((IdType)element).getValue());
            return true;
        }
        if (element instanceof DateTimeType) {
            stringBuilder.append(string + ": " + ((DateTimeType)element).getValue().toHumanDisplay());
            return true;
        }
        if (element instanceof InstantType) {
            stringBuilder.append(string + ": " + ((InstantType)element).getValue().toHumanDisplay());
            return true;
        }
        if (element instanceof Extension) {
            stringBuilder.append("Extensions: todo");
            return true;
        }
        if (element instanceof DateType) {
            stringBuilder.append(string + ": " + ((DateType)element).getValue().toHumanDisplay());
            return true;
        }
        if (element instanceof Enumeration) {
            stringBuilder.append(((Enum)((Enumeration)element).getValue()).toString());
            return true;
        }
        if (element instanceof BooleanType) {
            if (((BooleanType)element).getValue().booleanValue()) {
                stringBuilder.append(string);
                return true;
            }
        } else {
            if (element instanceof CodeableConcept) {
                stringBuilder.append(this.displayCodeableConcept((CodeableConcept)element));
                return true;
            }
            if (element instanceof Coding) {
                stringBuilder.append(this.displayCoding((Coding)element));
                return true;
            }
            if (element instanceof IntegerType) {
                stringBuilder.append(Integer.toString(((IntegerType)element).getValue()));
                return true;
            }
            if (element instanceof DecimalType) {
                stringBuilder.append(((DecimalType)element).getValue().toString());
                return true;
            }
            if (element instanceof Identifier) {
                stringBuilder.append(this.displayIdentifier((Identifier)element));
                return true;
            }
            if (element instanceof HumanName) {
                stringBuilder.append(this.displayHumanName((HumanName)element));
                return true;
            }
            if (element instanceof Address) {
                stringBuilder.append(this.displayAddress((Address)element));
                return true;
            }
            if (element instanceof Contact) {
                stringBuilder.append(this.displayContact((Contact)element));
                return true;
            }
            if (element instanceof Schedule) {
                stringBuilder.append(this.displaySchedule((Schedule)element));
                return true;
            }
            if (element instanceof Quantity || element instanceof Duration) {
                stringBuilder.append(this.displayQuantity((Quantity)element));
                return true;
            }
            if (element instanceof Ratio) {
                stringBuilder.append(this.displayQuantity(((Ratio)element).getNumerator()));
                stringBuilder.append("/");
                stringBuilder.append(this.displayQuantity(((Ratio)element).getDenominator()));
                return true;
            }
            if (element instanceof Period) {
                Period period = (Period)element;
                stringBuilder.append(string + ": " + this.displayPeriod(period));
                return true;
            }
            if (element instanceof ResourceReference) {
                ResourceReference resourceReference = (ResourceReference)element;
                if (resourceReference.getDisplay() != null) {
                    stringBuilder.append(resourceReference.getDisplaySimple());
                } else if (resourceReference.getReference() != null) {
                    ResourceWithReference resourceWithReference = this.resolveReference(resource, resourceReference.getReferenceSimple());
                    stringBuilder.append(resourceWithReference == null ? resourceReference.getReferenceSimple() : this.getDisplayForResource(resourceWithReference.getResource()));
                } else {
                    stringBuilder.append("??");
                }
                return true;
            }
            if (!(element instanceof Attachment)) {
                throw new Exception("type " + element.getClass().getName() + " not handled yet");
            }
        }
        return false;
    }

    private String displayPeriod(Period period) {
        String string = period.getStart() == null ? "??" : period.getStartSimple().toHumanDisplay();
        string = string + " --> ";
        return string + (period.getEnd() == null ? "(ongoing)" : period.getEndSimple().toHumanDisplay());
    }

    private String getDisplayForResource(Resource resource) throws Exception {
        Profile profile;
        Object object;
        if (resource.getText() != null && resource.getText().getDiv() != null) {
            object = resource.getText().getDiv();
            if (((XhtmlNode)object).allChildrenAreText()) {
                return ((XhtmlNode)object).allText();
            }
            if (((XhtmlNode)object).getChildNodes().size() == 1 && ((XhtmlNode)object).getChildNodes().get(0).allChildrenAreText()) {
                return ((XhtmlNode)object).getChildNodes().get(0).allText();
            }
        }
        if ((profile = this.profiles.get(object = resource.getResourceType().toString())) == null) {
            return "unknown resource " + (String)object;
        }
        Profile.ProfileStructureComponent profileStructureComponent = profile.getStructure().get(0);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        boolean bl2 = false;
        for (Property property : resource.children()) {
            Profile.ElementComponent elementComponent = this.getElementDefinition(profileStructureComponent.getElement(), (String)object + "." + property.getName());
            if (property.getValues().size() <= 0 || property.getValues().get(0) == null || elementComponent == null || !this.isPrimitive(elementComponent) || !this.includeInSummary(elementComponent)) continue;
            if (bl) {
                bl = false;
            } else if (bl2) {
                stringBuilder.append("; ");
            }
            boolean bl3 = true;
            bl2 = false;
            for (Element element : property.getValues()) {
                if (bl3) {
                    bl3 = false;
                } else if (bl2) {
                    stringBuilder.append(", ");
                }
                bl2 = this.displayLeaf(resource, element, elementComponent, stringBuilder, property.getName()) || bl2;
            }
        }
        return stringBuilder.toString();
    }

    private boolean includeInSummary(Profile.ElementComponent elementComponent) {
        String string;
        if (elementComponent.getDefinition().getIsModifierSimple()) {
            return true;
        }
        if (elementComponent.getDefinition().getMustSupportSimple()) {
            return true;
        }
        return elementComponent.getDefinition().getType().size() != 1 || !(string = elementComponent.getDefinition().getType().get(0).getCodeSimple()).equals("Address") && !string.equals("Contact") && !string.equals("ResourceReference") && !string.equals("Uri");
    }

    private ResourceWithReference resolveReference(Resource resource, String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("#")) {
            for (Resource resource2 : resource.getContained()) {
                if (!resource2.getXmlId().equals(string.substring(1))) continue;
                return new ResourceWithReference(null, resource2);
            }
            return null;
        }
        if (this.client == null) {
            return null;
        }
        AtomEntry atomEntry = this.client.read(null, string);
        if (atomEntry == null) {
            return null;
        }
        return new ResourceWithReference(atomEntry.getLinks().get("self"), (Resource)atomEntry.getResource());
    }

    private void renderCodeableConcept(CodeableConcept codeableConcept, XhtmlNode xhtmlNode) {
        Object object;
        String string = codeableConcept.getTextSimple();
        if (Utilities.noString(string)) {
            for (Coding object2 : codeableConcept.getCoding()) {
                if (object2.getDisplay() == null) continue;
                string = object2.getDisplaySimple();
                break;
            }
        }
        if (Utilities.noString(string)) {
            Coding coding;
            object = codeableConcept.getCoding().iterator();
            while (object.hasNext() && ((coding = (Coding)object.next()).getCode() == null || coding.getSystem() == null || Utilities.noString(string = this.lookupCode(coding.getSystemSimple(), coding.getCodeSimple())))) {
            }
        }
        if (Utilities.noString(string)) {
            string = codeableConcept.getCoding().isEmpty() ? "" : codeableConcept.getCoding().get(0).getCodeSimple();
        }
        object = new CommaSeparatedStringBuilder();
        for (Coding coding : codeableConcept.getCoding()) {
            if (coding.getCode() == null || coding.getSystem() == null) continue;
            ((CommaSeparatedStringBuilder)object).append("{" + coding.getSystemSimple() + " " + coding.getCodeSimple() + "}");
        }
        xhtmlNode.addTag("span").setAttribute("title", "Codes: " + ((CommaSeparatedStringBuilder)object).toString()).addText(string);
    }

    private void renderCoding(Coding coding, XhtmlNode xhtmlNode) {
        String string = "";
        if (coding.getDisplay() != null) {
            string = coding.getDisplaySimple();
        }
        if (Utilities.noString(string)) {
            string = this.lookupCode(coding.getSystemSimple(), coding.getCodeSimple());
        }
        if (Utilities.noString(string)) {
            string = coding.getCodeSimple();
        }
        xhtmlNode.addTag("span").setAttribute("title", "{" + coding.getSystemSimple() + " " + coding.getCodeSimple() + "}").addText(string);
    }

    private String lookupCode(String string, String string2) {
        ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = this.codeSystems.containsKey(string) ? this.findCode(string2, this.codeSystems.get(string).getResource().getDefine().getConcept()) : this.conceptLocator.locate(string, string2);
        if (valueSetDefineConceptComponent != null && valueSetDefineConceptComponent.getDisplay() != null) {
            return valueSetDefineConceptComponent.getDisplaySimple();
        }
        return string2;
    }

    private ValueSet.ValueSetDefineConceptComponent findCode(String string, List<ValueSet.ValueSetDefineConceptComponent> list) {
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : list) {
            if (string.equals(valueSetDefineConceptComponent.getCodeSimple())) {
                return valueSetDefineConceptComponent;
            }
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 = this.findCode(string, valueSetDefineConceptComponent.getConcept());
            if (valueSetDefineConceptComponent2 == null) continue;
            return valueSetDefineConceptComponent2;
        }
        return null;
    }

    private String displayCodeableConcept(CodeableConcept codeableConcept) {
        String string = codeableConcept.getTextSimple();
        if (Utilities.noString(string)) {
            for (Coding coding : codeableConcept.getCoding()) {
                if (coding.getDisplay() == null) continue;
                string = coding.getDisplaySimple();
                break;
            }
        }
        if (Utilities.noString(string)) {
            for (Coding coding : codeableConcept.getCoding()) {
                if (coding.getCode() != null && coding.getSystem() != null && !Utilities.noString(string = this.lookupCode(coding.getSystemSimple(), coding.getCodeSimple()))) break;
            }
        }
        if (Utilities.noString(string)) {
            string = codeableConcept.getCoding().isEmpty() ? "" : codeableConcept.getCoding().get(0).getCodeSimple();
        }
        return string;
    }

    private String displayCoding(Coding coding) {
        String string = "";
        if (coding.getDisplay() != null) {
            string = coding.getDisplaySimple();
        }
        if (Utilities.noString(string)) {
            string = this.lookupCode(coding.getSystemSimple(), coding.getCodeSimple());
        }
        if (Utilities.noString(string)) {
            string = coding.getCodeSimple();
        }
        return string;
    }

    private void renderIdentifier(Identifier identifier, XhtmlNode xhtmlNode) {
        xhtmlNode.addText(this.displayIdentifier(identifier));
    }

    private void renderSchedule(Schedule schedule, XhtmlNode xhtmlNode) {
        xhtmlNode.addText(this.displaySchedule(schedule));
    }

    private void renderQuantity(Quantity quantity, XhtmlNode xhtmlNode) {
        xhtmlNode.addText(this.displayQuantity(quantity));
    }

    private void renderHumanName(HumanName humanName, XhtmlNode xhtmlNode) {
        xhtmlNode.addText(this.displayHumanName(humanName));
    }

    private void renderAddress(Address address, XhtmlNode xhtmlNode) {
        xhtmlNode.addText(this.displayAddress(address));
    }

    private void renderContact(Contact contact, XhtmlNode xhtmlNode) {
        xhtmlNode.addText(this.displayContact(contact));
    }

    private void renderUri(UriType uriType, XhtmlNode xhtmlNode) {
        xhtmlNode.addTag("a").setAttribute("href", uriType.getValue()).addText(uriType.getValue());
    }

    private String displayQuantity(Quantity quantity) {
        StringBuilder stringBuilder = new StringBuilder();
        if (quantity.getComparator() != null) {
            stringBuilder.append(quantity.getComparatorSimple().toCode());
        }
        stringBuilder.append(quantity.getValueSimple().toString());
        stringBuilder.append(" ");
        if (quantity.getUnits() != null) {
            stringBuilder.append(quantity.getUnitsSimple());
        } else {
            stringBuilder.append(quantity.getCodeSimple());
        }
        return stringBuilder.toString();
    }

    private String displaySchedule(Schedule schedule) {
        if (schedule.getEvent().size() > 1 || schedule.getRepeat() == null && !schedule.getEvent().isEmpty()) {
            CommaSeparatedStringBuilder commaSeparatedStringBuilder = new CommaSeparatedStringBuilder();
            for (Period period : schedule.getEvent()) {
                commaSeparatedStringBuilder.append(this.displayPeriod(period));
            }
            return commaSeparatedStringBuilder.toString();
        }
        if (schedule.getRepeat() != null) {
            Schedule.ScheduleRepeatComponent scheduleRepeatComponent = schedule.getRepeat();
            StringBuilder stringBuilder = new StringBuilder();
            if (schedule.getEvent().size() == 1) {
                stringBuilder.append("Starting " + this.displayPeriod(schedule.getEvent().get(0)) + ", ");
            }
            if (scheduleRepeatComponent.getWhen() != null) {
                stringBuilder.append(scheduleRepeatComponent.getDurationSimple().toString() + " " + this.displayTimeUnits(scheduleRepeatComponent.getUnitsSimple()));
                stringBuilder.append(" ");
                stringBuilder.append(this.displayEventCode(scheduleRepeatComponent.getWhenSimple()));
            } else {
                if (scheduleRepeatComponent.getFrequencySimple() == 1) {
                    stringBuilder.append("Once per ");
                } else {
                    stringBuilder.append(Integer.toString(scheduleRepeatComponent.getFrequencySimple()) + " per ");
                }
                stringBuilder.append(scheduleRepeatComponent.getDurationSimple().toString() + " " + this.displayTimeUnits(scheduleRepeatComponent.getUnitsSimple()));
                if (scheduleRepeatComponent.getCount() != null) {
                    stringBuilder.append(" " + Integer.toString(scheduleRepeatComponent.getCountSimple()) + " times");
                } else if (scheduleRepeatComponent.getEnd() != null) {
                    stringBuilder.append(" until " + scheduleRepeatComponent.getEndSimple().toHumanDisplay());
                }
            }
            return stringBuilder.toString();
        }
        return "??";
    }

    private Object displayEventCode(Schedule.EventTiming eventTiming) {
        switch (eventTiming) {
            case aC: {
                return "before meals";
            }
            case aCD: {
                return "before lunch";
            }
            case aCM: {
                return "before breakfast";
            }
            case aCV: {
                return "before dinner";
            }
            case hS: {
                return "before sleeping";
            }
            case pC: {
                return "after meals";
            }
            case pCD: {
                return "after lunch";
            }
            case pCM: {
                return "after breakfast";
            }
            case pCV: {
                return "after dinner";
            }
            case wAKE: {
                return "after waking";
            }
        }
        return "??";
    }

    private String displayTimeUnits(Schedule.UnitsOfTime unitsOfTime) {
        switch (unitsOfTime) {
            case a: {
                return "years";
            }
            case d: {
                return "days";
            }
            case h: {
                return "hours";
            }
            case min: {
                return "minutes";
            }
            case mo: {
                return "months";
            }
            case s: {
                return "seconds";
            }
            case wk: {
                return "weeks";
            }
        }
        return "??";
    }

    private String displayHumanName(HumanName humanName) {
        StringBuilder stringBuilder = new StringBuilder();
        if (humanName.getText() != null) {
            stringBuilder.append(humanName.getTextSimple());
        } else {
            for (StringType stringType : humanName.getGiven()) {
                stringBuilder.append(stringType.getValue());
                stringBuilder.append(" ");
            }
            for (StringType stringType : humanName.getFamily()) {
                stringBuilder.append(stringType.getValue());
                stringBuilder.append(" ");
            }
        }
        if (humanName.getUseSimple() != null && humanName.getUseSimple() != HumanName.NameUse.usual) {
            stringBuilder.append("(" + humanName.getUseSimple().toString() + ")");
        }
        return stringBuilder.toString();
    }

    private String displayAddress(Address address) {
        StringBuilder stringBuilder = new StringBuilder();
        if (address.getText() != null) {
            stringBuilder.append(address.getTextSimple());
        } else {
            for (StringType stringType : address.getLine()) {
                stringBuilder.append(stringType.getValue());
                stringBuilder.append(" ");
            }
            if (address.getCity() != null) {
                stringBuilder.append(address.getCitySimple());
                stringBuilder.append(" ");
            }
            if (address.getState() != null) {
                stringBuilder.append(address.getStateSimple());
                stringBuilder.append(" ");
            }
            if (address.getZip() != null) {
                stringBuilder.append(address.getZipSimple());
                stringBuilder.append(" ");
            }
            if (address.getCountry() != null) {
                stringBuilder.append(address.getCountrySimple());
                stringBuilder.append(" ");
            }
        }
        if (address.getUseSimple() != null) {
            stringBuilder.append("(" + address.getUseSimple().toString() + ")");
        }
        return stringBuilder.toString();
    }

    private String displayContact(Contact contact) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.describeSystem(contact.getSystemSimple()));
        if (Utilities.noString(contact.getValueSimple())) {
            stringBuilder.append("-unknown-");
        } else {
            stringBuilder.append(contact.getValueSimple());
        }
        if (contact.getUseSimple() != null) {
            stringBuilder.append("(" + contact.getUseSimple().toString() + ")");
        }
        return stringBuilder.toString();
    }

    private Object describeSystem(Contact.ContactSystem contactSystem) {
        if (contactSystem == null) {
            return "";
        }
        switch (contactSystem) {
            case phone: {
                return "ph: ";
            }
            case fax: {
                return "fax: ";
            }
        }
        return "";
    }

    private String displayIdentifier(Identifier identifier) {
        String string;
        String string2 = string = Utilities.noString(identifier.getValueSimple()) ? "??" : identifier.getValueSimple();
        if (!Utilities.noString(identifier.getLabelSimple())) {
            string = identifier.getLabelSimple() + " = " + string;
        }
        if (identifier.getUse() != null) {
            string = string + " (" + identifier.getUseSimple().toString() + ")";
        }
        return string;
    }

    private List<Profile.ElementComponent> getChildrenForPath(List<Profile.ElementComponent> list, String string) {
        for (Profile.ElementComponent object : list) {
            if (!object.getPathSimple().equals(string) || object.getDefinition().getNameReference() == null) continue;
            string = object.getDefinition().getNameReferenceSimple();
        }
        ArrayList arrayList = new ArrayList();
        for (Profile.ElementComponent elementComponent : list) {
            if (!elementComponent.getPathSimple().startsWith(string + ".") || elementComponent.getPathSimple().substring(string.length() + 1).contains(".") || elementComponent.getPathSimple().endsWith(".extension") || elementComponent.getPathSimple().endsWith(".modifierExtension")) continue;
            arrayList.add(elementComponent);
        }
        return arrayList;
    }

    private Profile.ProfileStructureComponent getByName(Profile profile, String string) throws Exception {
        for (Profile.ProfileStructureComponent profileStructureComponent : profile.getStructure()) {
            if (!profileStructureComponent.getTypeSimple().equals(string)) continue;
            return profileStructureComponent;
        }
        throw new Exception("unable to find entry point for " + string);
    }

    public void generate(ConceptMap conceptMap) throws Exception {
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "div");
        xhtmlNode.addTag("h2").addText(conceptMap.getNameSimple() + " (" + conceptMap.getIdentifierSimple() + ")");
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("p");
        xhtmlNode2.addText("Mapping from ");
        this.AddVsRef(conceptMap.getSource().getReferenceSimple(), xhtmlNode2);
        xhtmlNode2.addText(" to ");
        this.AddVsRef(conceptMap.getTarget().getReferenceSimple(), xhtmlNode2);
        xhtmlNode2 = xhtmlNode.addTag("p");
        if (conceptMap.getExperimentalSimple()) {
            xhtmlNode2.addText(Utilities.capitalize(conceptMap.getStatusSimple().toString()) + " (not intended for production usage). ");
        } else {
            xhtmlNode2.addText(Utilities.capitalize(conceptMap.getStatusSimple().toString()) + ". ");
        }
        xhtmlNode2.addText("Published on " + conceptMap.getDateSimple().toHumanDisplay() + " by " + conceptMap.getPublisherSimple());
        if (!conceptMap.getTelecom().isEmpty()) {
            xhtmlNode2.addText(" (");
            boolean bl = true;
            for (Contact contact : conceptMap.getTelecom()) {
                if (bl) {
                    bl = false;
                } else {
                    xhtmlNode2.addText(", ");
                }
                this.addTelecom(xhtmlNode2, contact);
            }
            xhtmlNode2.addText(")");
        }
        xhtmlNode2.addText(". ");
        xhtmlNode2.addText(conceptMap.getCopyrightSimple());
        if (!Utilities.noString(conceptMap.getDescriptionSimple())) {
            xhtmlNode.addTag("p").addText(conceptMap.getDescriptionSimple());
        }
        xhtmlNode.addTag("br");
        if (!conceptMap.getConcept().isEmpty()) {
            Object object;
            String string;
            ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent = conceptMap.getConcept().get(0);
            String string2 = conceptMapConceptComponent.getSystemSimple();
            boolean bl = false;
            boolean bl2 = conceptMapConceptComponent.getMap().size() == 1;
            HashMap hashMap = new HashMap();
            hashMap.put("code", new HashSet());
            HashMap hashMap2 = new HashMap();
            hashMap2.put("code", new HashSet());
            if (bl2) {
                string = conceptMapConceptComponent.getMap().get(0).getSystemSimple();
                for (ConceptMap.ConceptMapConceptComponent object32 : conceptMap.getConcept()) {
                    boolean bl3 = bl2 = bl2 && string2.equals(object32.getSystemSimple()) && object32.getMap().size() == 1 && string.equals(object32.getMap().get(0).getSystemSimple()) && object32.getDependsOn().isEmpty() && object32.getMap().get(0).getProduct().isEmpty();
                    if (object32.getSystemSimple() != null) {
                        ((HashSet)hashMap.get("code")).add(object32.getSystemSimple());
                    }
                    for (ConceptMap.OtherConceptComponent otherConceptComponent : object32.getDependsOn()) {
                        if (!hashMap.containsKey(otherConceptComponent.getConceptSimple())) {
                            hashMap.put(otherConceptComponent.getConceptSimple(), new HashSet());
                        }
                        ((HashSet)hashMap.get(otherConceptComponent.getConceptSimple())).add(otherConceptComponent.getSystemSimple());
                    }
                    for (ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent : object32.getMap()) {
                        boolean bl4 = bl = bl || !Utilities.noString(conceptMapConceptMapComponent.getCommentsSimple());
                        if (conceptMapConceptMapComponent.getSystemSimple() != null) {
                            ((HashSet)hashMap2.get("code")).add(conceptMapConceptMapComponent.getSystemSimple());
                        }
                        for (ConceptMap.OtherConceptComponent otherConceptComponent : conceptMapConceptMapComponent.getProduct()) {
                            if (!hashMap2.containsKey(otherConceptComponent.getConceptSimple())) {
                                hashMap2.put(otherConceptComponent.getConceptSimple(), new HashSet());
                            }
                            ((HashSet)hashMap2.get(otherConceptComponent.getConceptSimple())).add(otherConceptComponent.getSystemSimple());
                        }
                    }
                }
            }
            if (bl2) {
                object = xhtmlNode.addTag("table").setAttribute("class", "grid");
                XhtmlNode xhtmlNode3 = ((XhtmlNode)object).addTag("tr");
                xhtmlNode3.addTag("td").addTag("b").addText("Source Code");
                xhtmlNode3.addTag("td").addTag("b").addText("Equivalence");
                xhtmlNode3.addTag("td").addTag("b").addText("Destination Code");
                if (bl) {
                    xhtmlNode3.addTag("td").addTag("b").addText("Comments");
                }
                for (ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent2 : conceptMap.getConcept()) {
                    XhtmlNode xhtmlNode4 = ((XhtmlNode)object).addTag("tr");
                    XhtmlNode xhtmlNode5 = xhtmlNode4.addTag("td");
                    xhtmlNode5.addText(conceptMapConceptComponent2.getCodeSimple());
                    string = this.getDisplayForConcept(conceptMapConceptComponent2.getSystemSimple(), conceptMapConceptComponent2.getCodeSimple());
                    if (string != null) {
                        xhtmlNode5.addText(" (" + string + ")");
                    }
                    ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent = conceptMapConceptComponent2.getMap().get(0);
                    xhtmlNode4.addTag("td").addText(conceptMapConceptMapComponent.getEquivalenceSimple().toString());
                    XhtmlNode xhtmlNode6 = xhtmlNode4.addTag("td");
                    xhtmlNode6.addText(conceptMapConceptMapComponent.getCodeSimple());
                    string = this.getDisplayForConcept(conceptMapConceptMapComponent.getSystemSimple(), conceptMapConceptMapComponent.getCodeSimple());
                    if (string != null) {
                        xhtmlNode6.addText(" (" + string + ")");
                    }
                    if (!bl) continue;
                    xhtmlNode4.addTag("td").addText(conceptMapConceptMapComponent.getCommentsSimple());
                }
            } else {
                object = xhtmlNode.addTag("table").setAttribute("class", "grid");
                XhtmlNode xhtmlNode7 = ((XhtmlNode)object).addTag("tr");
                xhtmlNode7.addTag("td").setAttribute("colspan", Integer.toString(hashMap.size())).addTag("b").addText("Source Concept");
                xhtmlNode7.addTag("td").addTag("b").addText("Equivalence");
                xhtmlNode7.addTag("td").setAttribute("colspan", Integer.toString(hashMap2.size())).addTag("b").addText("Destination Concept");
                if (bl) {
                    xhtmlNode7.addTag("td").addTag("b").addText("Comments");
                }
                XhtmlNode xhtmlNode8 = ((XhtmlNode)object).addTag("tr");
                if (((HashSet)hashMap.get("code")).size() == 1) {
                    xhtmlNode8.addTag("td").addTag("b").addText("Code " + ((HashSet)hashMap.get("code")).toString() + "");
                } else {
                    xhtmlNode8.addTag("td").addTag("b").addText("Code");
                }
                for (String string3 : hashMap.keySet()) {
                    if (string3.equals("code")) continue;
                    if (((HashSet)hashMap.get(string3)).size() == 1) {
                        xhtmlNode8.addTag("td").addTag("b").addText(this.getDescForConcept(string3) + " " + ((HashSet)hashMap.get(string3)).toString());
                        continue;
                    }
                    xhtmlNode8.addTag("td").addTag("b").addText(this.getDescForConcept(string3));
                }
                xhtmlNode8.addTag("td");
                if (((HashSet)hashMap2.get("code")).size() == 1) {
                    xhtmlNode8.addTag("td").addTag("b").addText("Code " + ((HashSet)hashMap2.get("code")).toString());
                } else {
                    xhtmlNode8.addTag("td").addTag("b").addText("Code");
                }
                for (String string4 : hashMap2.keySet()) {
                    if (string4.equals("code")) continue;
                    if (((HashSet)hashMap2.get(string4)).size() == 1) {
                        xhtmlNode8.addTag("td").addTag("b").addText(this.getDescForConcept(string4) + " " + ((HashSet)hashMap2.get(string4)).toString() + "");
                        continue;
                    }
                    xhtmlNode8.addTag("td").addTag("b").addText(this.getDescForConcept(string4));
                }
                if (bl) {
                    xhtmlNode8.addTag("td");
                }
                for (ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent3 : conceptMap.getConcept()) {
                    Object object22;
                    XhtmlNode xhtmlNode9 = ((XhtmlNode)object).addTag("tr");
                    Object object3 = xhtmlNode9.addTag("td");
                    if (((HashSet)hashMap.get("code")).size() == 1) {
                        ((XhtmlNode)object3).addText(conceptMapConceptComponent3.getCodeSimple());
                    } else {
                        ((XhtmlNode)object3).addText(conceptMapConceptComponent3.getSystemSimple() + " / " + conceptMapConceptComponent3.getCodeSimple());
                    }
                    string = this.getDisplayForConcept(conceptMapConceptComponent3.getSystemSimple(), conceptMapConceptComponent3.getCodeSimple());
                    if (string != null) {
                        ((XhtmlNode)object3).addText(" (" + string + ")");
                    }
                    for (Object object22 : hashMap.keySet()) {
                        if (((String)object22).equals("code")) continue;
                        object3 = xhtmlNode9.addTag("td");
                        ((XhtmlNode)object3).addText(this.getCode(conceptMapConceptComponent3.getDependsOn(), (String)object22, ((HashSet)hashMap.get(object22)).size() != 1));
                        string = this.getDisplay(conceptMapConceptComponent3.getDependsOn(), (String)object22);
                        if (string == null) continue;
                        ((XhtmlNode)object3).addText(" (" + string + ")");
                    }
                    ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent = conceptMapConceptComponent3.getMap().get(0);
                    xhtmlNode9.addTag("td").addText(conceptMapConceptMapComponent.getEquivalenceSimple().toString());
                    object3 = xhtmlNode9.addTag("td");
                    if (((HashSet)hashMap2.get("code")).size() == 1) {
                        ((XhtmlNode)object3).addText(conceptMapConceptMapComponent.getCodeSimple());
                    } else {
                        ((XhtmlNode)object3).addText(conceptMapConceptMapComponent.getSystemSimple() + " / " + conceptMapConceptMapComponent.getCodeSimple());
                    }
                    string = this.getDisplayForConcept(conceptMapConceptMapComponent.getSystemSimple(), conceptMapConceptMapComponent.getCodeSimple());
                    if (string != null) {
                        ((XhtmlNode)object3).addText(" (" + string + ")");
                    }
                    object22 = hashMap2.keySet().iterator();
                    while (object22.hasNext()) {
                        String string5 = (String)object22.next();
                        if (string5.equals("code")) continue;
                        object3 = xhtmlNode9.addTag("td");
                        ((XhtmlNode)object3).addText(this.getCode(conceptMapConceptMapComponent.getProduct(), string5, ((HashSet)hashMap2.get(string5)).size() != 1));
                        string = this.getDisplay(conceptMapConceptMapComponent.getProduct(), string5);
                        if (string == null) continue;
                        ((XhtmlNode)object3).addText(" (" + string + ")");
                    }
                    if (!bl) continue;
                    xhtmlNode9.addTag("td").addText(conceptMapConceptMapComponent.getCommentsSimple());
                }
            }
        }
        this.inject(conceptMap, xhtmlNode, Narrative.NarrativeStatus.generated);
    }

    private void inject(Resource resource, XhtmlNode xhtmlNode, Narrative.NarrativeStatus narrativeStatus) {
        if (resource.getText() == null) {
            resource.setText(new Narrative());
        }
        if (resource.getText().getDiv() == null || resource.getText().getDiv().getChildNodes().isEmpty()) {
            resource.getText().setDiv(xhtmlNode);
            resource.getText().setStatusSimple(narrativeStatus);
        } else {
            XhtmlNode xhtmlNode2 = resource.getText().getDiv();
            xhtmlNode2.addTag("hr");
            xhtmlNode2.getChildNodes().addAll(xhtmlNode.getChildNodes());
        }
    }

    private String getDisplay(List<ConceptMap.OtherConceptComponent> list, String string) {
        for (ConceptMap.OtherConceptComponent otherConceptComponent : list) {
            if (!string.equals(otherConceptComponent.getConceptSimple())) continue;
            return this.getDisplayForConcept(otherConceptComponent.getSystemSimple(), otherConceptComponent.getCodeSimple());
        }
        return null;
    }

    private String getDisplayForConcept(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.codeSystems.containsKey(string)) {
            ValueSet valueSet = this.codeSystems.get(string).getResource();
            return this.getDisplayForConcept(string2, valueSet.getDefine().getConcept(), valueSet.getDefine().getCaseSensitiveSimple());
        }
        if (this.conceptLocator != null) {
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = this.conceptLocator.locate(string, string2);
            return valueSetDefineConceptComponent == null ? null : valueSetDefineConceptComponent.getDisplaySimple();
        }
        return null;
    }

    private String getDisplayForConcept(String string, List<ValueSet.ValueSetDefineConceptComponent> list, boolean bl) {
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : list) {
            if (bl && string.equals(valueSetDefineConceptComponent.getCodeSimple()) || !bl && string.equalsIgnoreCase(valueSetDefineConceptComponent.getCodeSimple())) {
                return valueSetDefineConceptComponent.getDisplaySimple();
            }
            String string2 = this.getDisplayForConcept(string, valueSetDefineConceptComponent.getConcept(), bl);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private String getDescForConcept(String string) {
        if (string.startsWith("http://hl7.org/fhir/v2/element/")) {
            return "v2 " + string.substring("http://hl7.org/fhir/v2/element/".length());
        }
        return string;
    }

    private String getCode(List<ConceptMap.OtherConceptComponent> list, String string, boolean bl) {
        for (ConceptMap.OtherConceptComponent otherConceptComponent : list) {
            if (!string.equals(otherConceptComponent.getConceptSimple())) continue;
            if (bl) {
                return otherConceptComponent.getSystemSimple() + " / " + otherConceptComponent.getCodeSimple();
            }
            return otherConceptComponent.getCodeSimple();
        }
        return null;
    }

    private void addTelecom(XhtmlNode xhtmlNode, Contact contact) {
        if (contact.getSystemSimple() == Contact.ContactSystem.phone) {
            xhtmlNode.addText("Phone: " + contact.getValueSimple());
        } else if (contact.getSystemSimple() == Contact.ContactSystem.fax) {
            xhtmlNode.addText("Fax: " + contact.getValueSimple());
        } else if (contact.getSystemSimple() == Contact.ContactSystem.email) {
            xhtmlNode.addTag("a").setAttribute("href", "mailto:" + contact.getValueSimple()).addText(contact.getValueSimple());
        } else if (contact.getSystemSimple() == Contact.ContactSystem.url) {
            if (contact.getValueSimple().length() > 30) {
                xhtmlNode.addTag("a").setAttribute("href", contact.getValueSimple()).addText(contact.getValueSimple().substring(0, 30) + "...");
            } else {
                xhtmlNode.addTag("a").setAttribute("href", contact.getValueSimple()).addText(contact.getValueSimple());
            }
        }
    }

    public void generate(ValueSet valueSet) throws Exception {
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "div");
        if (valueSet.getExpansion() != null) {
            if (valueSet.getDefine() == null && valueSet.getCompose() == null) {
                this.generateExpansion(xhtmlNode, valueSet);
            } else {
                throw new Exception("Error: should not encounter value set expansion at this point");
            }
        }
        boolean bl = false;
        if (valueSet.getDefine() != null) {
            bl = this.generateDefinition(xhtmlNode, valueSet);
        }
        if (valueSet.getCompose() != null) {
            bl = this.generateComposition(xhtmlNode, valueSet) || bl;
        }
        this.inject(valueSet, xhtmlNode, bl ? Narrative.NarrativeStatus.extensions : Narrative.NarrativeStatus.generated);
    }

    private boolean generateExpansion(XhtmlNode xhtmlNode, ValueSet valueSet) {
        Object object;
        AtomEntry<ConceptMap> atomEntry2;
        boolean bl = false;
        HashMap<ConceptMap, String> hashMap = new HashMap<ConceptMap, String>();
        for (AtomEntry<ConceptMap> atomEntry2 : this.maps.values()) {
            if (!atomEntry2.getResource().getSource().getReferenceSimple().equals(valueSet.getIdentifierSimple())) continue;
            object = "";
            if (this.valueSets.containsKey(((ConceptMap)atomEntry2.getResource()).getTarget().getReferenceSimple())) {
                object = this.valueSets.get(((ConceptMap)atomEntry2.getResource()).getTarget().getReferenceSimple()).getLinks().get("path");
            }
            hashMap.put((ConceptMap)atomEntry2.getResource(), (String)object);
        }
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("h3");
        xhtmlNode2.addText(valueSet.getDescriptionSimple());
        if (valueSet.getCopyright() != null) {
            this.generateCopyright(xhtmlNode, valueSet);
        }
        atomEntry2 = xhtmlNode.addTag("table");
        object = ((XhtmlNode)((Object)atomEntry2)).addTag("tr");
        ((XhtmlNode)object).addTag("td").addTag("b").addText("Code");
        ((XhtmlNode)object).addTag("td").addTag("b").addText("System");
        ((XhtmlNode)object).addTag("td").addTag("b").addText("Display");
        this.addMapHeaders((XhtmlNode)object, hashMap);
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : valueSet.getExpansion().getContains()) {
            this.addExpansionRowToTable((XhtmlNode)((Object)atomEntry2), valueSetExpansionContainsComponent, 0, hashMap);
        }
        return bl;
    }

    private boolean generateDefinition(XhtmlNode xhtmlNode, ValueSet valueSet) {
        Object object;
        AtomEntry<ConceptMap> atomEntry2;
        boolean bl = false;
        HashMap<ConceptMap, String> hashMap = new HashMap<ConceptMap, String>();
        for (AtomEntry<ConceptMap> atomEntry2 : this.maps.values()) {
            if (!atomEntry2.getResource().getSource().getReferenceSimple().equals(valueSet.getIdentifierSimple())) continue;
            object = "";
            if (this.valueSets.containsKey(((ConceptMap)atomEntry2.getResource()).getTarget().getReferenceSimple())) {
                object = this.valueSets.get(((ConceptMap)atomEntry2.getResource()).getTarget().getReferenceSimple()).getLinks().get("path");
            }
            hashMap.put((ConceptMap)atomEntry2.getResource(), (String)object);
        }
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("h2");
        xhtmlNode2.addText(valueSet.getNameSimple());
        atomEntry2 = xhtmlNode.addTag("p");
        this.smartAddText((XhtmlNode)((Object)atomEntry2), valueSet.getDescriptionSimple());
        if (valueSet.getCopyright() != null) {
            this.generateCopyright(xhtmlNode, valueSet);
        }
        atomEntry2 = xhtmlNode.addTag("p");
        ((XhtmlNode)((Object)atomEntry2)).addText("This value set defines its own terms in the system " + valueSet.getDefine().getSystemSimple());
        object = xhtmlNode.addTag("table");
        boolean bl2 = false;
        boolean bl3 = false;
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSet.getDefine().getConcept()) {
            bl2 = bl2 || this.conceptsHaveComments(valueSetDefineConceptComponent);
            bl3 = bl3 || this.conceptsHaveDeprecated(valueSetDefineConceptComponent);
        }
        this.addMapHeaders(this.addTableHeaderRowStandard((XhtmlNode)object, bl2, bl3), hashMap);
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSet.getDefine().getConcept()) {
            bl = this.addDefineRowToTable((XhtmlNode)object, valueSetDefineConceptComponent, 0, bl2, bl3, hashMap) || bl;
        }
        return bl;
    }

    private void addMapHeaders(XhtmlNode xhtmlNode, Map<ConceptMap, String> map) {
        for (ConceptMap conceptMap : map.keySet()) {
            XhtmlNode xhtmlNode2 = xhtmlNode.addTag("td");
            XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("b");
            XhtmlNode xhtmlNode4 = xhtmlNode3.addTag("a");
            xhtmlNode4.setAttribute("href", this.prefix + map.get(conceptMap));
            xhtmlNode4.addText(conceptMap.getDescriptionSimple());
        }
    }

    private void smartAddText(XhtmlNode xhtmlNode, String string) {
        String[] stringArray = string.split("\\r\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                xhtmlNode.addTag("br");
            }
            xhtmlNode.addText(stringArray[i]);
        }
    }

    private boolean conceptsHaveComments(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        if (ToolingExtensions.hasComment(valueSetDefineConceptComponent)) {
            return true;
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
            if (!this.conceptsHaveComments(valueSetDefineConceptComponent2)) continue;
            return true;
        }
        return false;
    }

    private boolean conceptsHaveDeprecated(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        if (ToolingExtensions.hasDeprecated(valueSetDefineConceptComponent)) {
            return true;
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
            if (!this.conceptsHaveDeprecated(valueSetDefineConceptComponent2)) continue;
            return true;
        }
        return false;
    }

    private void generateCopyright(XhtmlNode xhtmlNode, ValueSet valueSet) {
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("p");
        xhtmlNode2.addTag("b").addText("Copyright Statement:");
        this.smartAddText(xhtmlNode2, " " + valueSet.getCopyrightSimple());
    }

    private XhtmlNode addTableHeaderRowStandard(XhtmlNode xhtmlNode, boolean bl, boolean bl2) {
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("tr");
        XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("td");
        XhtmlNode xhtmlNode4 = xhtmlNode3.addTag("b");
        xhtmlNode4.addText("Code");
        xhtmlNode3 = xhtmlNode2.addTag("td");
        xhtmlNode4 = xhtmlNode3.addTag("b");
        xhtmlNode4.addText("Display");
        xhtmlNode3 = xhtmlNode2.addTag("td");
        xhtmlNode4 = xhtmlNode3.addTag("b");
        xhtmlNode4.addText("Definition");
        if (bl2) {
            xhtmlNode2.addTag("td").addTag("b").addText("Deprecated");
        }
        if (bl) {
            xhtmlNode2.addTag("td").addTag("b").addText("Comments");
        }
        return xhtmlNode2;
    }

    private void addExpansionRowToTable(XhtmlNode xhtmlNode, ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent, int n, Map<ConceptMap, String> map) {
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("tr");
        XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("td");
        String string = Utilities.padLeft("", '.', n * 2);
        xhtmlNode3.addText(string);
        AtomEntry<ValueSet> atomEntry = this.codeSystems.get(valueSetExpansionContainsComponent.getSystemSimple());
        if (atomEntry == null) {
            xhtmlNode3.addText(valueSetExpansionContainsComponent.getCodeSimple());
        } else {
            Iterator<ValueSet.ValueSetExpansionContainsComponent> iterator = xhtmlNode3.addTag("a");
            ((XhtmlNode)((Object)iterator)).addText(valueSetExpansionContainsComponent.getCodeSimple());
            ((XhtmlNode)((Object)iterator)).setAttribute("href", this.prefix + this.getCsRef(atomEntry) + "#" + Utilities.nmtokenize(valueSetExpansionContainsComponent.getCodeSimple()));
        }
        xhtmlNode3 = xhtmlNode2.addTag("td");
        xhtmlNode3.addText(valueSetExpansionContainsComponent.getSystemSimple());
        xhtmlNode3 = xhtmlNode2.addTag("td");
        if (valueSetExpansionContainsComponent.getDisplaySimple() != null) {
            xhtmlNode3.addText(valueSetExpansionContainsComponent.getDisplaySimple());
        }
        for (ConceptMap backboneElement : map.keySet()) {
            xhtmlNode3 = xhtmlNode2.addTag("td");
            List<ConceptMap.ConceptMapConceptMapComponent> list = this.findMappingsForCode(valueSetExpansionContainsComponent.getCodeSimple(), backboneElement);
            boolean bl = true;
            for (ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent : list) {
                if (!bl) {
                    xhtmlNode3.addTag("br");
                }
                bl = false;
                XhtmlNode xhtmlNode4 = xhtmlNode3.addTag("span");
                xhtmlNode4.setAttribute("title", conceptMapConceptMapComponent.getEquivalenceSimple().toString());
                xhtmlNode4.addText(this.getCharForEquivalence(conceptMapConceptMapComponent));
                XhtmlNode xhtmlNode5 = xhtmlNode3.addTag("a");
                xhtmlNode5.setAttribute("href", this.prefix + map.get(backboneElement) + "#" + conceptMapConceptMapComponent.getCodeSimple());
                xhtmlNode5.addText(conceptMapConceptMapComponent.getCodeSimple());
                if (Utilities.noString(conceptMapConceptMapComponent.getCommentsSimple())) continue;
                xhtmlNode3.addTag("i").addText("(" + conceptMapConceptMapComponent.getCommentsSimple() + ")");
            }
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent2 : valueSetExpansionContainsComponent.getContains()) {
            this.addExpansionRowToTable(xhtmlNode, valueSetExpansionContainsComponent2, n + 1, map);
        }
    }

    private boolean addDefineRowToTable(XhtmlNode xhtmlNode, ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent, int n, boolean bl, boolean bl2, Map<ConceptMap, String> map) {
        boolean bl3 = false;
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("tr");
        XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("td");
        String string = Utilities.padLeft("", '.', n * 2);
        xhtmlNode3.addText(string);
        xhtmlNode3.addText(valueSetDefineConceptComponent.getCodeSimple());
        XhtmlNode xhtmlNode4 = xhtmlNode3.addTag("a");
        xhtmlNode4.setAttribute("name", Utilities.nmtokenize(valueSetDefineConceptComponent.getCodeSimple()));
        xhtmlNode4.addText(" ");
        xhtmlNode3 = xhtmlNode2.addTag("td");
        if (valueSetDefineConceptComponent.getDisplaySimple() != null) {
            xhtmlNode3.addText(valueSetDefineConceptComponent.getDisplaySimple());
        }
        xhtmlNode3 = xhtmlNode2.addTag("td");
        if (valueSetDefineConceptComponent.getDefinitionSimple() != null) {
            this.smartAddText(xhtmlNode3, valueSetDefineConceptComponent.getDefinitionSimple());
        }
        if (bl2) {
            xhtmlNode3 = xhtmlNode2.addTag("td");
            string = ToolingExtensions.getDeprecated(valueSetDefineConceptComponent);
            if (string != null) {
                this.smartAddText(xhtmlNode3, string);
                bl3 = true;
            }
        }
        if (bl) {
            xhtmlNode3 = xhtmlNode2.addTag("td");
            string = ToolingExtensions.getComment(valueSetDefineConceptComponent);
            if (string != null) {
                this.smartAddText(xhtmlNode3, string);
                bl3 = true;
            }
        }
        for (ConceptMap element : map.keySet()) {
            xhtmlNode3 = xhtmlNode2.addTag("td");
            List<ConceptMap.ConceptMapConceptMapComponent> list = this.findMappingsForCode(valueSetDefineConceptComponent.getCodeSimple(), element);
            boolean bl4 = true;
            for (ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent : list) {
                if (!bl4) {
                    xhtmlNode3.addTag("br");
                }
                bl4 = false;
                XhtmlNode xhtmlNode5 = xhtmlNode3.addTag("span");
                xhtmlNode5.setAttribute("title", conceptMapConceptMapComponent.getEquivalenceSimple().toString());
                xhtmlNode5.addText(this.getCharForEquivalence(conceptMapConceptMapComponent));
                xhtmlNode4 = xhtmlNode3.addTag("a");
                xhtmlNode4.setAttribute("href", this.prefix + map.get(element) + "#" + conceptMapConceptMapComponent.getCodeSimple());
                xhtmlNode4.addText(conceptMapConceptMapComponent.getCodeSimple());
                if (Utilities.noString(conceptMapConceptMapComponent.getCommentsSimple())) continue;
                xhtmlNode3.addTag("i").addText("(" + conceptMapConceptMapComponent.getCommentsSimple() + ")");
            }
        }
        for (CodeType codeType : ToolingExtensions.getSubsumes(valueSetDefineConceptComponent)) {
            bl3 = true;
            xhtmlNode2 = xhtmlNode.addTag("tr");
            xhtmlNode3 = xhtmlNode2.addTag("td");
            string = Utilities.padLeft("", '.', n * 2);
            xhtmlNode3.addText(string);
            xhtmlNode4 = xhtmlNode3.addTag("a");
            xhtmlNode4.setAttribute("href", "#" + Utilities.nmtokenize(codeType.getValue()));
            xhtmlNode4.addText(valueSetDefineConceptComponent.getCodeSimple());
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
            bl3 = this.addDefineRowToTable(xhtmlNode, valueSetDefineConceptComponent2, n + 1, bl, bl2, map) || bl3;
        }
        return bl3;
    }

    private String getCharForEquivalence(ConceptMap.ConceptMapConceptMapComponent conceptMapConceptMapComponent) {
        switch (conceptMapConceptMapComponent.getEquivalenceSimple()) {
            case equal: {
                return "=";
            }
            case equivalent: {
                return "~";
            }
            case wider: {
                return "<";
            }
            case narrower: {
                return ">";
            }
            case inexact: {
                return "><";
            }
            case unmatched: {
                return "-";
            }
            case disjoint: {
                return "!=";
            }
        }
        return "?";
    }

    private List<ConceptMap.ConceptMapConceptMapComponent> findMappingsForCode(String string, ConceptMap conceptMap) {
        ArrayList<ConceptMap.ConceptMapConceptMapComponent> arrayList = new ArrayList<ConceptMap.ConceptMapConceptMapComponent>();
        for (ConceptMap.ConceptMapConceptComponent conceptMapConceptComponent : conceptMap.getConcept()) {
            if (!conceptMapConceptComponent.getCodeSimple().equals(string)) continue;
            arrayList.addAll(conceptMapConceptComponent.getMap());
        }
        return arrayList;
    }

    private boolean generateComposition(XhtmlNode xhtmlNode, ValueSet valueSet) throws Exception {
        XhtmlNode xhtmlNode2;
        XhtmlNode xhtmlNode3;
        boolean bl = false;
        if (valueSet.getDefine() == null) {
            xhtmlNode3 = xhtmlNode.addTag("h2");
            xhtmlNode3.addText(valueSet.getNameSimple());
            xhtmlNode2 = xhtmlNode.addTag("p");
            this.smartAddText(xhtmlNode2, valueSet.getDescriptionSimple());
            if (valueSet.getCopyright() != null) {
                this.generateCopyright(xhtmlNode, valueSet);
            }
            xhtmlNode2 = xhtmlNode.addTag("p");
            xhtmlNode2.addText("This value set includes codes defined in other code systems, using the following rules:");
        } else {
            xhtmlNode3 = xhtmlNode.addTag("p");
            xhtmlNode3.addText("In addition, this value set includes codes defined in other code systems, using the following rules:");
        }
        xhtmlNode3 = xhtmlNode.addTag("ul");
        for (UriType element : valueSet.getCompose().getImport()) {
            xhtmlNode2 = xhtmlNode3.addTag("li");
            xhtmlNode2.addText("Import all the codes that are part of ");
            this.AddVsRef(element.getValue(), xhtmlNode2);
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : valueSet.getCompose().getInclude()) {
            bl = this.genInclude(xhtmlNode3, conceptSetComponent, "Include") || bl;
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : valueSet.getCompose().getExclude()) {
            bl = this.genInclude(xhtmlNode3, conceptSetComponent, "Exclude") || bl;
        }
        return bl;
    }

    private void AddVsRef(String string, XhtmlNode xhtmlNode) {
        AtomEntry<ValueSet> atomEntry = this.valueSets.get(string);
        if (atomEntry == null) {
            atomEntry = this.codeSystems.get(string);
        }
        if (atomEntry != null) {
            String string2 = atomEntry.getLinks().get("path");
            XhtmlNode xhtmlNode2 = xhtmlNode.addTag("a");
            xhtmlNode2.setAttribute("href", this.prefix + string2.replace("\\", "/"));
            xhtmlNode2.addText(string);
        } else if (string.equals("http://snomed.info/sct") || string.equals("http://snomed.info/id")) {
            XhtmlNode xhtmlNode3 = xhtmlNode.addTag("a");
            xhtmlNode3.setAttribute("href", string);
            xhtmlNode3.addText("SNOMED-CT");
        } else {
            xhtmlNode.addText(string);
        }
    }

    private boolean genInclude(XhtmlNode xhtmlNode, ValueSet.ConceptSetComponent conceptSetComponent, String string) throws Exception {
        boolean bl = false;
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("li");
        AtomEntry<ValueSet> atomEntry = this.codeSystems.get(conceptSetComponent.getSystemSimple());
        if (conceptSetComponent.getCode().size() == 0 && conceptSetComponent.getFilter().size() == 0) {
            xhtmlNode2.addText(string + " all codes defined in ");
            this.addCsRef(conceptSetComponent, xhtmlNode2, atomEntry);
        } else {
            if (conceptSetComponent.getCode().size() > 0) {
                xhtmlNode2.addText(string + " these codes as defined in ");
                this.addCsRef(conceptSetComponent, xhtmlNode2, atomEntry);
                XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("table");
                boolean bl2 = false;
                for (CodeType codeType : conceptSetComponent.getCode()) {
                    bl2 = bl2 || codeType.hasExtension("http://hl7.org/fhir/Profile/tools-extensions#comment");
                }
                if (bl2) {
                    bl = true;
                }
                this.addTableHeaderRowStandard(xhtmlNode3, bl2, false);
                for (CodeType codeType : conceptSetComponent.getCode()) {
                    XhtmlNode xhtmlNode4 = xhtmlNode3.addTag("tr");
                    xhtmlNode4.addTag("td").addText(codeType.getValue());
                    ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = this.getConceptForCode(atomEntry, codeType.getValue(), conceptSetComponent.getSystemSimple());
                    XhtmlNode xhtmlNode5 = xhtmlNode4.addTag("td");
                    if (codeType.hasExtension("http://hl7.org/fhir/Profile/tools-extensions#display")) {
                        xhtmlNode5.addText(ToolingExtensions.readStringExtension(codeType, "http://hl7.org/fhir/Profile/tools-extensions#display"));
                    } else if (valueSetDefineConceptComponent != null && !Utilities.noString(valueSetDefineConceptComponent.getDisplaySimple())) {
                        xhtmlNode5.addText(valueSetDefineConceptComponent.getDisplaySimple());
                    }
                    xhtmlNode5 = xhtmlNode4.addTag("td");
                    if (codeType.hasExtension("http://hl7.org/fhir/Profile/tools-extensions#definition")) {
                        this.smartAddText(xhtmlNode5, ToolingExtensions.readStringExtension(codeType, "http://hl7.org/fhir/Profile/tools-extensions#definition"));
                    } else if (valueSetDefineConceptComponent != null && !Utilities.noString(valueSetDefineConceptComponent.getDefinitionSimple())) {
                        this.smartAddText(xhtmlNode5, valueSetDefineConceptComponent.getDefinitionSimple());
                    }
                    if (!codeType.hasExtension("http://hl7.org/fhir/Profile/tools-extensions#comment")) continue;
                    this.smartAddText(xhtmlNode4.addTag("td"), "Note: " + ToolingExtensions.readStringExtension(codeType, "http://hl7.org/fhir/Profile/tools-extensions#comment"));
                }
            }
            for (ValueSet.ConceptSetFilterComponent conceptSetFilterComponent : conceptSetComponent.getFilter()) {
                xhtmlNode2.addText(string + " codes from ");
                this.addCsRef(conceptSetComponent, xhtmlNode2, atomEntry);
                xhtmlNode2.addText(" where " + conceptSetFilterComponent.getPropertySimple() + " " + this.describe(conceptSetFilterComponent.getOpSimple()) + " ");
                if (atomEntry != null && this.codeExistsInValueSet(atomEntry, conceptSetFilterComponent.getValueSimple())) {
                    XhtmlNode xhtmlNode6 = xhtmlNode2.addTag("a");
                    xhtmlNode6.addText(conceptSetFilterComponent.getValueSimple());
                    xhtmlNode6.setAttribute("href", this.prefix + this.getCsRef(atomEntry) + "#" + Utilities.nmtokenize(conceptSetFilterComponent.getValueSimple()));
                    continue;
                }
                xhtmlNode2.addText(conceptSetFilterComponent.getValueSimple());
            }
        }
        return bl;
    }

    private String describe(ValueSet.FilterOperator filterOperator) {
        switch (filterOperator) {
            case equal: {
                return " = ";
            }
            case isa: {
                return " is-a ";
            }
            case isnota: {
                return " is-not-a ";
            }
            case regex: {
                return " matches (by regex) ";
            }
        }
        return null;
    }

    private <T extends Resource> ValueSet.ValueSetDefineConceptComponent getConceptForCode(AtomEntry<T> atomEntry, String string, String string2) {
        if (atomEntry == null) {
            if (this.conceptLocator != null) {
                return this.conceptLocator.locate(string2, string);
            }
            return null;
        }
        ValueSet valueSet = (ValueSet)atomEntry.getResource();
        if (valueSet.getDefine() == null) {
            return null;
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSet.getDefine().getConcept()) {
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 = this.getConceptForCode(valueSetDefineConceptComponent, string);
            if (valueSetDefineConceptComponent2 == null) continue;
            return valueSetDefineConceptComponent2;
        }
        return null;
    }

    private ValueSet.ValueSetDefineConceptComponent getConceptForCode(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent, String string) {
        if (string.equals(valueSetDefineConceptComponent.getCodeSimple())) {
            return valueSetDefineConceptComponent;
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent3 = this.getConceptForCode(valueSetDefineConceptComponent2, string);
            if (valueSetDefineConceptComponent3 == null) continue;
            return valueSetDefineConceptComponent3;
        }
        return null;
    }

    private <T extends Resource> void addCsRef(ValueSet.ConceptSetComponent conceptSetComponent, XhtmlNode xhtmlNode, AtomEntry<T> atomEntry) {
        String string = null;
        if (atomEntry != null) {
            atomEntry.getLinks().get("path");
            if (Utilities.noString(string)) {
                string = atomEntry.getLinks().get("self");
            }
        }
        if (atomEntry != null && string != null) {
            if (!Utilities.noString(this.prefix) && string.startsWith("http://hl7.org/fhir/")) {
                string = string.substring(20) + "/index.html";
            }
            XhtmlNode xhtmlNode2 = xhtmlNode.addTag("a");
            xhtmlNode2.setAttribute("href", this.prefix + string.replace("\\", "/"));
            xhtmlNode2.addText(conceptSetComponent.getSystemSimple().toString());
        } else {
            xhtmlNode.addText(conceptSetComponent.getSystemSimple().toString());
        }
    }

    private <T extends Resource> String getCsRef(AtomEntry<T> atomEntry) {
        String string = atomEntry.getLinks().get("path");
        if (Utilities.noString(string)) {
            string = atomEntry.getLinks().get("self");
        }
        return string.replace("\\", "/");
    }

    private <T extends Resource> boolean codeExistsInValueSet(AtomEntry<T> atomEntry, String string) {
        ValueSet valueSet = (ValueSet)atomEntry.getResource();
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSet.getDefine().getConcept()) {
            if (!this.inConcept(string, valueSetDefineConceptComponent)) continue;
            return true;
        }
        return false;
    }

    private boolean inConcept(String string, ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        if (valueSetDefineConceptComponent.getCodeSimple() != null && valueSetDefineConceptComponent.getCodeSimple().equals(string)) {
            return true;
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
            if (!this.inConcept(string, valueSetDefineConceptComponent2)) continue;
            return true;
        }
        return false;
    }

    public void generate(OperationOutcome operationOutcome) throws Exception {
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "div");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        for (OperationOutcome.OperationOutcomeIssueComponent object : operationOutcome.getIssue()) {
            bl3 = bl3 && object.getSeveritySimple() != OperationOutcome.IssueSeverity.information;
            bl = bl || object.hasExtension("http://hl7.org/fhir/Profile/tools-extensions#issue-source");
            bl2 = bl2 || object.getType() != null;
        }
        if (bl3) {
            xhtmlNode.addTag("p").addText("All OK");
        }
        if (operationOutcome.getIssue().size() > 0) {
            XhtmlNode xhtmlNode2 = xhtmlNode.addTag("table");
            xhtmlNode2.setAttribute("class", "grid");
            XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("tr");
            xhtmlNode3.addTag("td").addTag("b").addText("Severity");
            xhtmlNode3.addTag("td").addTag("b").addText("Location");
            xhtmlNode3.addTag("td").addTag("b").addText("Details");
            if (bl2) {
                xhtmlNode3.addTag("td").addTag("b").addText("Type");
            }
            if (bl) {
                xhtmlNode3.addTag("td").addTag("b").addText("Source");
            }
            for (OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent : operationOutcome.getIssue()) {
                XhtmlNode xhtmlNode4 = xhtmlNode2.addTag("tr");
                xhtmlNode4.addTag("td").addText(operationOutcomeIssueComponent.getSeverity().toString());
                XhtmlNode xhtmlNode5 = xhtmlNode4.addTag("td");
                boolean bl4 = false;
                for (StringType stringType : operationOutcomeIssueComponent.getLocation()) {
                    if (bl4) {
                        xhtmlNode5.addText(", ");
                    } else {
                        bl4 = true;
                    }
                    xhtmlNode5.addText(stringType.getValue());
                }
                this.smartAddText(xhtmlNode4.addTag("td"), operationOutcomeIssueComponent.getDetailsSimple());
                if (bl2) {
                    xhtmlNode4.addTag("td").addText(this.gen(operationOutcomeIssueComponent.getType()));
                }
                if (!bl) continue;
                xhtmlNode4.addTag("td").addText(this.gen(operationOutcomeIssueComponent.getExtension("http://hl7.org/fhir/Profile/tools-extensions#issue-source")));
            }
        }
        this.inject(operationOutcome, xhtmlNode, bl ? Narrative.NarrativeStatus.extensions : Narrative.NarrativeStatus.generated);
    }

    private String gen(Extension extension) throws Exception {
        if (extension.getValue() instanceof CodeType) {
            return ((CodeType)extension.getValue()).getValue();
        }
        if (extension.getValue() instanceof Coding) {
            return this.gen((Coding)extension.getValue());
        }
        throw new Exception("Unhandled type " + extension.getValue().getClass().getName());
    }

    private String gen(Coding coding) {
        if (coding == null) {
            return null;
        }
        if (coding.getDisplay() != null) {
            return coding.getDisplaySimple();
        }
        if (coding.getCode() != null) {
            return coding.getCodeSimple();
        }
        return null;
    }

    public void generate(Conformance conformance) {
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "div");
        xhtmlNode.addTag("h2").addText(conformance.getNameSimple());
        this.smartAddText(xhtmlNode.addTag("p"), conformance.getDescriptionSimple());
        Conformance.ConformanceRestComponent conformanceRestComponent = conformance.getRest().get(0);
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("table");
        this.addTableRow(xhtmlNode2, "Mode", conformanceRestComponent.getModeSimple().toString());
        this.addTableRow(xhtmlNode2, "Description", conformanceRestComponent.getDocumentationSimple());
        this.addTableRow(xhtmlNode2, "Transaction", this.showOp(conformanceRestComponent, Conformance.SystemRestfulOperation.transaction));
        this.addTableRow(xhtmlNode2, "System History", this.showOp(conformanceRestComponent, Conformance.SystemRestfulOperation.historysystem));
        this.addTableRow(xhtmlNode2, "System Search", this.showOp(conformanceRestComponent, Conformance.SystemRestfulOperation.searchsystem));
        xhtmlNode2 = xhtmlNode.addTag("table");
        XhtmlNode xhtmlNode3 = xhtmlNode2.addTag("tr");
        xhtmlNode3.addTag("th").addTag("b").addText("Resource Type");
        xhtmlNode3.addTag("th").addTag("b").addText("Profile");
        xhtmlNode3.addTag("th").addTag("b").addText("Read");
        xhtmlNode3.addTag("th").addTag("b").addText("V-Read");
        xhtmlNode3.addTag("th").addTag("b").addText("Search");
        xhtmlNode3.addTag("th").addTag("b").addText("Update");
        xhtmlNode3.addTag("th").addTag("b").addText("Updates");
        xhtmlNode3.addTag("th").addTag("b").addText("Create");
        xhtmlNode3.addTag("th").addTag("b").addText("Delete");
        xhtmlNode3.addTag("th").addTag("b").addText("History");
        for (Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent : conformanceRestComponent.getResource()) {
            xhtmlNode3 = xhtmlNode2.addTag("tr");
            xhtmlNode3.addTag("td").addText(conformanceRestResourceComponent.getTypeSimple());
            if (conformanceRestResourceComponent.getProfile() != null) {
                XhtmlNode xhtmlNode4 = xhtmlNode3.addTag("td").addTag("a");
                xhtmlNode4.addText(conformanceRestResourceComponent.getProfile().getReferenceSimple());
                xhtmlNode4.setAttribute("href", this.prefix + conformanceRestResourceComponent.getProfile().getReferenceSimple());
            }
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.read));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.vread));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.searchtype));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.update));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.historyinstance));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.create));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.delete));
            xhtmlNode3.addTag("td").addText(this.showOp(conformanceRestResourceComponent, Conformance.TypeRestfulOperation.historytype));
        }
        this.inject(conformance, xhtmlNode, Narrative.NarrativeStatus.generated);
    }

    private String showOp(Conformance.ConformanceRestResourceComponent conformanceRestResourceComponent, Conformance.TypeRestfulOperation typeRestfulOperation) {
        for (Conformance.ConformanceRestResourceOperationComponent conformanceRestResourceOperationComponent : conformanceRestResourceComponent.getOperation()) {
            if (conformanceRestResourceOperationComponent.getCodeSimple() != typeRestfulOperation) continue;
            return "y";
        }
        return "";
    }

    private String showOp(Conformance.ConformanceRestComponent conformanceRestComponent, Conformance.SystemRestfulOperation systemRestfulOperation) {
        for (Conformance.ConformanceRestOperationComponent conformanceRestOperationComponent : conformanceRestComponent.getOperation()) {
            if (conformanceRestOperationComponent.getCodeSimple() != systemRestfulOperation) continue;
            return "y";
        }
        return "";
    }

    private void addTableRow(XhtmlNode xhtmlNode, String string, String string2) {
        XhtmlNode xhtmlNode2 = xhtmlNode.addTag("tr");
        xhtmlNode2.addTag("td").addText(string);
        xhtmlNode2.addTag("td").addText(string2);
    }

    public XhtmlNode generateDocumentNarrative(AtomFeed atomFeed) {
        XhtmlNode xhtmlNode = new XhtmlNode(NodeType.Element, "div");
        Composition composition = (Composition)atomFeed.getEntryList().get(0).getResource();
        xhtmlNode.getChildNodes().add(composition.getText().getDiv());
        Resource resource = atomFeed.getById(composition.getSubject().getReferenceSimple()).getResource();
        if (resource != null) {
            xhtmlNode.addTag("hr");
            xhtmlNode.getChildNodes().add(resource.getText().getDiv());
        }
        List<Composition.SectionComponent> list = composition.getSection();
        this.renderSections(atomFeed, xhtmlNode, list, 1);
        return xhtmlNode;
    }

    private void renderSections(AtomFeed atomFeed, XhtmlNode xhtmlNode, List<Composition.SectionComponent> list, int n) {
        for (Composition.SectionComponent sectionComponent : list) {
            Resource resource;
            xhtmlNode.addTag("hr");
            if (sectionComponent.getTitle() != null) {
                xhtmlNode.addTag("h" + Integer.toString(n)).addText(sectionComponent.getTitleSimple());
            } else if (sectionComponent.getCode() != null) {
                xhtmlNode.addTag("h" + Integer.toString(n)).addText(this.displayCodeableConcept(sectionComponent.getCode()));
            }
            if (sectionComponent.getContent() != null && (resource = atomFeed.getById(sectionComponent.getContent().getReferenceSimple()).getResource()) != null) {
                xhtmlNode.getChildNodes().add(resource.getText().getDiv());
            }
            if (sectionComponent.getSection().isEmpty()) continue;
            this.renderSections(atomFeed, xhtmlNode.addTag("blockquote"), sectionComponent.getSection(), n + 1);
        }
    }

    public class ResourceWithReference {
        private String reference;
        private Resource resource;

        public ResourceWithReference(String string, Resource resource) {
            this.reference = string;
            this.resource = resource;
        }

        public String getReference() {
            return this.reference;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

