/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.utils;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.Element;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.Factory;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.validation.ValidationMessage;
import org.hl7.fhir.utilities.Utilities;

public class ToolingExtensions {
    public static final String EXT_COMMENT = "http://hl7.org/fhir/Profile/tools-extensions#comment";
    public static final String EXT_DISPLAY = "http://hl7.org/fhir/Profile/tools-extensions#display";
    public static final String EXT_DEFINITION = "http://hl7.org/fhir/Profile/tools-extensions#definition";
    public static final String EXT_DEPRECATED = "http://hl7.org/fhir/Profile/tools-extensions#deprecated";
    public static final String EXT_ISSUE_SOURCE = "http://hl7.org/fhir/Profile/tools-extensions#issue-source";
    public static final String EXT_SUBSUMES = "http://hl7.org/fhir/Profile/tools-extensions#subsumes";

    public static Extension makeIssueSource(ValidationMessage.Source source) {
        Extension extension = new Extension();
        extension.setUrlSimple(EXT_ISSUE_SOURCE);
        CodeType codeType = new CodeType();
        codeType.setValue(source.toString());
        extension.setValue(codeType);
        return extension;
    }

    public static void addComment(CodeType codeType, String string) throws Exception {
        if (!Utilities.noString(string)) {
            codeType.getExtensions().add(Factory.newExtension(EXT_COMMENT, Factory.newString(string), true));
        }
    }

    public static void markDeprecated(Element element) throws Exception {
        element.getExtensions().add(Factory.newExtension(EXT_DEPRECATED, Factory.newBoolean(true), true));
    }

    public static void addSubsumes(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent, String string) throws Exception {
        valueSetDefineConceptComponent.getModifierExtensions().add(Factory.newExtension(EXT_SUBSUMES, Factory.newCode(string), true));
    }

    public static void addDefinition(CodeType codeType, String string) throws Exception {
        if (!Utilities.noString(string)) {
            codeType.getExtensions().add(Factory.newExtension(EXT_DEFINITION, Factory.newString(string), true));
        }
    }

    public static String readStringExtension(Element element, String string) {
        Extension extension = element.getExtension(string);
        if (extension == null) {
            return null;
        }
        if (!(extension.getValue() instanceof StringType)) {
            return null;
        }
        return ((StringType)extension.getValue()).getValue();
    }

    public static boolean findStringExtension(Element element, String string) {
        Extension extension = element.getExtension(string);
        if (extension == null) {
            return false;
        }
        if (!(extension.getValue() instanceof StringType)) {
            return false;
        }
        return !Utilities.noString(((StringType)extension.getValue()).getValue());
    }

    public static String readBooleanExtension(Element element, String string) {
        Extension extension = element.getExtension(string);
        if (extension == null) {
            return null;
        }
        if (!(extension.getValue() instanceof BooleanType)) {
            return null;
        }
        return Boolean.toString(((BooleanType)extension.getValue()).getValue());
    }

    public static boolean findBooleanExtension(Element element, String string) {
        Extension extension = element.getExtension(string);
        if (extension == null) {
            return false;
        }
        return extension.getValue() instanceof BooleanType;
    }

    public static String getComment(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        return ToolingExtensions.readStringExtension(valueSetDefineConceptComponent, EXT_COMMENT);
    }

    public static String getDeprecated(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        return ToolingExtensions.readBooleanExtension(valueSetDefineConceptComponent, EXT_DEPRECATED);
    }

    public static boolean hasComment(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        return ToolingExtensions.findStringExtension(valueSetDefineConceptComponent, EXT_COMMENT);
    }

    public static boolean hasDeprecated(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        return ToolingExtensions.findBooleanExtension(valueSetDefineConceptComponent, EXT_DEPRECATED);
    }

    public static List<CodeType> getSubsumes(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        ArrayList<CodeType> arrayList = new ArrayList<CodeType>();
        for (Extension extension : valueSetDefineConceptComponent.getExtensions()) {
            if (!EXT_SUBSUMES.equals(extension.getUrlSimple())) continue;
            arrayList.add((CodeType)extension.getValue());
        }
        return arrayList;
    }
}

