/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.DateAndTime;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.ConceptLocator;
import org.hl7.fhir.instance.utils.ToolingExtensions;
import org.hl7.fhir.instance.utils.ValueSetExpander;
import org.hl7.fhir.instance.utils.ValueSetExpanderFactory;

public class ValueSetExpanderSimple
implements ValueSetExpander {
    private static final int UPPER_LIMIT = 10000;
    private Map<String, ValueSet> valuesets = new HashMap<String, ValueSet>();
    private Map<String, ValueSet> codesystems = new HashMap<String, ValueSet>();
    private List<ValueSet.ValueSetExpansionContainsComponent> codes = new ArrayList<ValueSet.ValueSetExpansionContainsComponent>();
    private Map<String, ValueSet.ValueSetExpansionContainsComponent> map = new HashMap<String, ValueSet.ValueSetExpansionContainsComponent>();
    private ValueSet focus;
    private ConceptLocator locator;
    private ValueSetExpanderFactory factory;

    public ValueSetExpanderSimple(Map<String, ValueSet> map, Map<String, ValueSet> map2, ValueSetExpanderFactory valueSetExpanderFactory, ConceptLocator conceptLocator) {
        this.valuesets = map;
        this.codesystems = map2;
        this.factory = valueSetExpanderFactory;
        this.locator = conceptLocator;
    }

    @Override
    public ValueSet expand(ValueSet valueSet) throws Exception {
        this.focus = valueSet.copy();
        this.focus.setExpansion(new ValueSet.ValueSetExpansionComponent());
        this.focus.getExpansion().setTimestampSimple(DateAndTime.now());
        this.handleDefine(valueSet);
        if (valueSet.getCompose() != null) {
            this.handleCompose(valueSet.getCompose());
        }
        if (this.map.size() > 10000) {
            throw new Exception("Value set size of " + Integer.toString(this.map.size()) + " exceeds upper limit of " + Integer.toString(10000));
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : this.codes) {
            if (!this.map.containsKey(this.key(valueSetExpansionContainsComponent))) continue;
            this.focus.getExpansion().getContains().add(valueSetExpansionContainsComponent);
        }
        return this.focus;
    }

    private void handleCompose(ValueSet.ValueSetComposeComponent valueSetComposeComponent) throws Exception {
        for (UriType element : valueSetComposeComponent.getImport()) {
            this.importValueSet(element.getValue());
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : valueSetComposeComponent.getInclude()) {
            this.includeCodes(conceptSetComponent);
        }
        for (ValueSet.ConceptSetComponent conceptSetComponent : valueSetComposeComponent.getExclude()) {
            this.excludeCodes(conceptSetComponent);
        }
    }

    private void importValueSet(String string) throws Exception {
        if (string == null) {
            throw new Exception("unable to find value set with no identity");
        }
        ValueSet valueSet = this.valuesets.get(string);
        if (valueSet == null) {
            throw new Exception("Unable to find imported value set " + string);
        }
        valueSet = this.factory.getExpander().expand(valueSet);
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : valueSet.getExpansion().getContains()) {
            this.addCode(valueSetExpansionContainsComponent.getSystemSimple(), valueSetExpansionContainsComponent.getCodeSimple(), valueSetExpansionContainsComponent.getDisplaySimple());
        }
    }

    private void includeCodes(ValueSet.ConceptSetComponent conceptSetComponent) throws Exception {
        if (conceptSetComponent.getSystemSimple().equals("http://snomed.info/sct")) {
            if (this.locator != null) {
                this.addCodes(this.locator.expand(conceptSetComponent));
                return;
            }
            throw new Exception("Snomed Expansion is not yet supported (which release?)");
        }
        if (conceptSetComponent.getSystemSimple().equals("http://loinc.org")) {
            if (this.locator != null) {
                this.addCodes(this.locator.expand(conceptSetComponent));
                return;
            }
            throw new Exception("LOINC Expansion is not yet supported (todo)");
        }
        ValueSet valueSet = this.codesystems.get(conceptSetComponent.getSystemSimple());
        if (valueSet == null) {
            throw new Exception("unable to find code system " + conceptSetComponent.getSystemSimple().toString());
        }
        if (conceptSetComponent.getCode().size() == 0 && conceptSetComponent.getFilter().size() == 0) {
            for (ValueSet.ValueSetDefineConceptComponent element : valueSet.getDefine().getConcept()) {
                this.addCodeAndDescendents(conceptSetComponent.getSystemSimple(), element);
            }
        }
        for (CodeType codeType : conceptSetComponent.getCode()) {
            this.addCode(conceptSetComponent.getSystemSimple(), codeType.getValue(), this.getCodeDisplay(valueSet, codeType.getValue()));
        }
        if (conceptSetComponent.getFilter().size() > 1) {
            throw new Exception("Multiple filters not handled yet");
        }
        if (conceptSetComponent.getFilter().size() == 1) {
            ValueSet.ConceptSetFilterComponent conceptSetFilterComponent = conceptSetComponent.getFilter().get(0);
            if ("concept".equals(conceptSetFilterComponent.getPropertySimple()) && conceptSetFilterComponent.getOpSimple() == ValueSet.FilterOperator.isa) {
                ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = this.getConceptForCode(valueSet.getDefine().getConcept(), conceptSetFilterComponent.getValueSimple());
                if (valueSetDefineConceptComponent == null) {
                    throw new Exception("Code '" + conceptSetFilterComponent.getValueSimple() + "' not found in system '" + conceptSetComponent.getSystemSimple() + "'");
                }
                this.addCodeAndDescendents(conceptSetComponent.getSystemSimple(), valueSetDefineConceptComponent);
            } else {
                throw new Exception("not done yet");
            }
        }
    }

    private void addCodes(List<ValueSet.ValueSetExpansionContainsComponent> list) throws Exception {
        if (list.size() > 500) {
            throw new Exception("Too many codes to display (>" + Integer.toString(list.size()) + ")");
        }
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : list) {
            this.addCode(valueSetExpansionContainsComponent.getSystemSimple(), valueSetExpansionContainsComponent.getCodeSimple(), valueSetExpansionContainsComponent.getDisplaySimple());
        }
    }

    private void addCodeAndDescendents(String string, ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        if (!ToolingExtensions.hasDeprecated(valueSetDefineConceptComponent)) {
            if (valueSetDefineConceptComponent.getAbstract() == null || !valueSetDefineConceptComponent.getAbstractSimple()) {
                this.addCode(string, valueSetDefineConceptComponent.getCodeSimple(), valueSetDefineConceptComponent.getDisplaySimple());
            }
            for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
                this.addCodeAndDescendents(string, valueSetDefineConceptComponent2);
            }
        }
    }

    private void excludeCodes(ValueSet.ConceptSetComponent conceptSetComponent) throws Exception {
        ValueSet valueSet = this.codesystems.get(conceptSetComponent.getSystemSimple().toString());
        if (valueSet == null) {
            throw new Exception("unable to find value set " + conceptSetComponent.getSystemSimple().toString());
        }
        if (conceptSetComponent.getCode().size() != 0 || conceptSetComponent.getFilter().size() == 0) {
            // empty if block
        }
        for (CodeType codeType : conceptSetComponent.getCode()) {
            this.map.remove(this.key(conceptSetComponent.getSystemSimple(), codeType.getValue()));
        }
        if (conceptSetComponent.getFilter().size() > 0) {
            throw new Exception("not done yet");
        }
    }

    private String getCodeDisplay(ValueSet valueSet, String string) throws Exception {
        ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent = this.getConceptForCode(valueSet.getDefine().getConcept(), string);
        if (valueSetDefineConceptComponent == null) {
            throw new Exception("Unable to find code '" + string + "' in code system " + valueSet.getDefine().getSystemSimple());
        }
        return valueSetDefineConceptComponent.getDisplaySimple();
    }

    private ValueSet.ValueSetDefineConceptComponent getConceptForCode(List<ValueSet.ValueSetDefineConceptComponent> list, String string) {
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : list) {
            if (string.equals(valueSetDefineConceptComponent.getCodeSimple())) {
                return valueSetDefineConceptComponent;
            }
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 = this.getConceptForCode(valueSetDefineConceptComponent.getConcept(), string);
            if (valueSetDefineConceptComponent2 == null) continue;
            return valueSetDefineConceptComponent2;
        }
        return null;
    }

    private void handleDefine(ValueSet valueSet) {
        if (valueSet.getDefine() != null) {
            for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSet.getDefine().getConcept()) {
                this.addDefinedCode(valueSet, valueSet.getDefine().getSystemSimple(), valueSetDefineConceptComponent);
            }
        }
    }

    private String key(ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent) {
        return this.key(valueSetExpansionContainsComponent.getSystemSimple(), valueSetExpansionContainsComponent.getCodeSimple());
    }

    private String key(String string, String string2) {
        return "{" + string + "}" + string2;
    }

    private void addDefinedCode(ValueSet valueSet, String string, ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent) {
        if (!ToolingExtensions.hasDeprecated(valueSetDefineConceptComponent)) {
            if (valueSetDefineConceptComponent.getAbstract() == null || !valueSetDefineConceptComponent.getAbstractSimple()) {
                this.addCode(string, valueSetDefineConceptComponent.getCodeSimple(), valueSetDefineConceptComponent.getDisplaySimple());
            }
            for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
                this.addDefinedCode(valueSet, valueSet.getDefine().getSystemSimple(), valueSetDefineConceptComponent2);
            }
        }
    }

    private void addCode(String string, String string2, String string3) {
        ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent = new ValueSet.ValueSetExpansionContainsComponent();
        valueSetExpansionContainsComponent.setSystemSimple(string);
        valueSetExpansionContainsComponent.setCodeSimple(string2);
        valueSetExpansionContainsComponent.setDisplaySimple(string3);
        String string4 = this.key(valueSetExpansionContainsComponent);
        if (!this.map.containsKey(string4)) {
            this.codes.add(valueSetExpansionContainsComponent);
            this.map.put(string4, valueSetExpansionContainsComponent);
        }
    }
}

