/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.utils;

import java.util.HashMap;
import java.util.Map;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.ConceptLocator;
import org.hl7.fhir.instance.utils.ValueSetExpander;
import org.hl7.fhir.instance.utils.ValueSetExpanderFactory;
import org.hl7.fhir.instance.utils.ValueSetExpanderSimple;

public class ValueSetExpansionCache
implements ValueSetExpanderFactory {
    private Map<String, ValueSet> valuesets;
    private Map<String, ValueSet> codesystems;
    private Map<String, ValueSet> expansions = new HashMap<String, ValueSet>();
    private ConceptLocator locator;

    public ValueSetExpansionCache(Map<String, ValueSet> map, Map<String, ValueSet> map2, ConceptLocator conceptLocator) {
        this.valuesets = map;
        this.codesystems = map2;
        this.locator = conceptLocator;
    }

    @Override
    public ValueSetExpander getExpander() {
        return new CacheAwareExpander();
    }

    public class CacheAwareExpander
    implements ValueSetExpander {
        @Override
        public ValueSet expand(ValueSet valueSet) throws Exception {
            if (ValueSetExpansionCache.this.expansions.containsKey(valueSet.getIdentifierSimple())) {
                return (ValueSet)ValueSetExpansionCache.this.expansions.get(valueSet.getIdentifierSimple());
            }
            ValueSetExpanderSimple valueSetExpanderSimple = new ValueSetExpanderSimple(ValueSetExpansionCache.this.valuesets, ValueSetExpansionCache.this.codesystems, ValueSetExpansionCache.this, ValueSetExpansionCache.this.locator);
            ValueSet valueSet2 = valueSetExpanderSimple.expand(valueSet);
            ValueSetExpansionCache.this.expansions.put(valueSet.getIdentifierSimple(), valueSet2);
            return valueSet2;
        }
    }
}

