/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.AtomEntry;
import org.hl7.fhir.instance.model.AtomFeed;
import org.hl7.fhir.instance.model.Attachment;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.BooleanType;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Contact;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DateType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.Extension;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.InstantType;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Ratio;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.ResourceReference;
import org.hl7.fhir.instance.model.SampledData;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.model.Type;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.ConceptLocator;
import org.hl7.fhir.instance.utils.ValueSetExpansionCache;
import org.hl7.fhir.instance.validation.BaseValidator;
import org.hl7.fhir.instance.validation.ExtensionLocatorService;
import org.hl7.fhir.instance.validation.ValidationMessage;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Element;

public class InstanceValidator
extends BaseValidator {
    private CheckDisplayOption checkDisplay;
    private static final String NS_FHIR = "http://hl7.org/fhir";
    private Map<String, Profile> types = new HashMap<String, Profile>();
    private Map<String, ValueSet> valuesets = new HashMap<String, ValueSet>();
    private Map<String, ValueSet> codesystems = new HashMap<String, ValueSet>();
    private ValueSetExpansionCache cache;
    private boolean suppressLoincSnomedMessages;
    private ExtensionLocatorService extensions;
    private ConceptLocator conceptLocator;

    public InstanceValidator(String string, ExtensionLocatorService extensionLocatorService, ConceptLocator conceptLocator) throws Exception {
        this.source = ValidationMessage.Source.InstanceValidator;
        this.loadValidationResources(string);
        this.extensions = extensionLocatorService == null ? new NullExtensionResolver() : extensionLocatorService;
        this.conceptLocator = conceptLocator;
        this.cache = new ValueSetExpansionCache(this.valuesets, this.codesystems, conceptLocator);
    }

    private void loadValidationResources(String string) throws Exception {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.getName().endsWith(".xml")) {
                this.readFile(zipInputStream, zipEntry.getName());
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }

    public InstanceValidator(Map<String, byte[]> map, ExtensionLocatorService extensionLocatorService) throws Exception {
        this.source = ValidationMessage.Source.InstanceValidator;
        this.extensions = extensionLocatorService == null ? new NullExtensionResolver() : extensionLocatorService;
        this.loadValidationResources(map);
    }

    private void loadValidationResources(Map<String, byte[]> map) throws Exception {
        for (String string : map.keySet()) {
            if (!string.endsWith(".xml")) continue;
            this.readFile(new ByteArrayInputStream(map.get(string)), string);
        }
    }

    private void readFile(InputStream inputStream, String string) throws Exception {
        XmlParser xmlParser = new XmlParser();
        AtomFeed atomFeed = xmlParser.parseGeneral(inputStream).getFeed();
        for (AtomEntry<? extends Resource> atomEntry : atomFeed.getEntryList()) {
            Resource resource;
            Resource resource2;
            if (atomEntry.getId() == null) {
                System.out.println("unidentified resource " + atomEntry.getLinks().get("self") + " in " + string);
            }
            if ((resource2 = atomEntry.getResource()) instanceof Profile) {
                resource = (Profile)resource2;
                if (((Profile)resource).getStructure().get(0).getName() != null) {
                    this.types.put(((Profile)resource).getStructure().get(0).getNameSimple().toLowerCase(), (Profile)resource);
                } else {
                    this.types.put(((Profile)resource).getStructure().get(0).getTypeSimple().toLowerCase(), (Profile)resource);
                }
            }
            if (!(resource2 instanceof ValueSet)) continue;
            resource = (ValueSet)resource2;
            this.valuesets.put(((ValueSet)resource).getIdentifierSimple(), (ValueSet)resource);
            if (((ValueSet)resource).getDefine() == null) continue;
            this.codesystems.put(((ValueSet)resource).getDefine().getSystemSimple().toString(), (ValueSet)resource);
        }
    }

    public void validateInstance(List<ValidationMessage> list, Element element, Profile profile, String string) throws Exception {
        boolean bl;
        boolean bl2 = bl = XMLUtil.getNamedChild(element, "author") != null;
        if (element.getLocalName().equals("feed")) {
            ChildIterator childIterator = new ChildIterator("", element);
            while (childIterator.next()) {
                if (childIterator.name().equals("category")) {
                    this.validateTag(childIterator.path(), childIterator.element(), false);
                    continue;
                }
                if (childIterator.name().equals("id")) {
                    this.validateId(list, childIterator.path(), childIterator.element(), true);
                    continue;
                }
                if (childIterator.name().equals("link")) {
                    this.validateLink(list, childIterator.path(), childIterator.element(), false);
                    continue;
                }
                if (!childIterator.name().equals("entry")) continue;
                this.validateAtomEntry(list, childIterator.path(), childIterator.element(), bl, profile, string);
            }
        } else {
            this.validate(list, "", element, profile, null);
        }
    }

    public List<ValidationMessage> validateInstance(Element element) throws Exception {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateInstance(arrayList, element, null, null);
        return arrayList;
    }

    public List<ValidationMessage> validateInstance(Element element, Profile profile, String string) throws Exception {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateInstance(arrayList, element, profile, string);
        return arrayList;
    }

    private void validateAtomEntry(List<ValidationMessage> list, String string, Element element, boolean bl, Profile profile, String string2) throws Exception {
        this.rule(list, "invalid", string, XMLUtil.getNamedChild(element, "title") != null, "Entry must have a title");
        this.rule(list, "invalid", string, XMLUtil.getNamedChild(element, "updated") != null, "Entry must have a last updated time");
        this.rule(list, "invalid", string, bl || XMLUtil.getNamedChild(element, "author") != null, "Entry must have an author because the feed doesn't");
        ChildIterator childIterator = new ChildIterator(string, element);
        while (childIterator.next()) {
            if (childIterator.name().equals("category")) {
                this.validateTag(childIterator.path(), childIterator.element(), true);
                continue;
            }
            if (childIterator.name().equals("id")) {
                this.validateId(list, childIterator.path(), childIterator.element(), true);
                continue;
            }
            if (childIterator.name().equals("link")) {
                this.validateLink(list, childIterator.path(), childIterator.element(), true);
                continue;
            }
            if (!childIterator.name().equals("content")) continue;
            String string3 = this.findProfileTag(element);
            Element element2 = XMLUtil.getFirstChild(childIterator.element());
            ProfileMatch profileMatch = this.findProfile(list, string, profile, string2, string3, element2);
            this.validate(list, childIterator.path() + "/f:" + element2.getLocalName(), element2, profileMatch.getProfile(), profileMatch.getStructure());
        }
    }

    private ProfileMatch findProfile(List<ValidationMessage> list, String string, Profile profile, String string2, String string3, Element element) {
        if (string3 == null) {
            if (profile != null) {
                for (Profile.ProfileStructureComponent profileStructureComponent : profile.getStructure()) {
                    if (!profileStructureComponent.getTypeSimple().equals(element.getLocalName())) continue;
                    return new ProfileMatch(profile, profileStructureComponent);
                }
            }
            this.warning(list, "not-found", string, false, "Resource '" + element.getLocalName() + "' not found in profile '" + string2 + "'");
            return new ProfileMatch();
        }
        if (profile != null && string3.startsWith(string2 + "#")) {
            String string4 = string3.substring(string3.indexOf("#") + 1);
            for (Profile.ProfileStructureComponent profileStructureComponent : profile.getStructure()) {
                if (!profileStructureComponent.getNameSimple().equals(string4)) continue;
                return new ProfileMatch(profile, profileStructureComponent);
            }
            this.rule(list, "not-found", string, false, "Unable to resolve profile URL '" + string3 + "'");
            return new ProfileMatch();
        }
        throw new Error("Not implemented yet");
    }

    private String findProfileTag(Element element) {
        String string = null;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(element, "category", arrayList);
        for (Element element2 : arrayList) {
            if (!"http://hl7.org/fhir/tag/profile".equals(element2.getAttribute("scheme"))) continue;
            string = element2.getAttribute("term");
        }
        return string;
    }

    private void validate(List<ValidationMessage> list, String string, Element element, Profile profile, Profile.ProfileStructureComponent profileStructureComponent) throws Exception {
        if (element.getLocalName().equals("Binary")) {
            this.validateBinary(element);
        } else {
            Profile profile2 = profile != null ? profile : this.getProfileForType(element.getLocalName());
            Profile.ProfileStructureComponent profileStructureComponent2 = profileStructureComponent != null ? profileStructureComponent : this.getStructureForType(profile2, element.getLocalName());
            if (this.rule(list, "invalid", element.getLocalName(), profileStructureComponent2 != null, "Unknown Resource Type " + element.getLocalName())) {
                this.validateElement(list, profile2, profileStructureComponent2, string + "/f:" + element.getLocalName(), profileStructureComponent2.getElement().get(0), null, null, element, element.getLocalName());
                if (element.getLocalName().equals("Query")) {
                    this.validateQuery(list, element);
                }
            }
        }
    }

    private void validateQuery(List<ValidationMessage> list, Element element) {
    }

    private Profile getProfileForType(String string) throws Exception {
        Profile profile = (Profile)this.getResource(string);
        if (profile == null) {
            return null;
        }
        if (profile.getStructure().size() != 1 || !profile.getStructure().get(0).getTypeSimple().equals(string) && !profile.getStructure().get(0).getNameSimple().equals(string)) {
            throw new Exception("unexpected profile contents");
        }
        Profile.ProfileStructureComponent profileStructureComponent = profile.getStructure().get(0);
        return profile;
    }

    private Profile.ProfileStructureComponent getStructureForType(Profile profile, String string) throws Exception {
        if (profile.getStructure().size() != 1 || !profile.getStructure().get(0).getTypeSimple().equals(string) && !profile.getStructure().get(0).getNameSimple().equals(string)) {
            throw new Exception("unexpected profile contents = expecting name = '" + string + "'");
        }
        Profile.ProfileStructureComponent profileStructureComponent = profile.getStructure().get(0);
        return profileStructureComponent;
    }

    private Resource getResource(String string) {
        return this.types.get(string.toLowerCase());
    }

    private void validateBinary(Element element) {
    }

    private void validateTag(String string, Element element, boolean bl) {
    }

    private void validateLink(List<ValidationMessage> list, String string, Element element, boolean bl) {
        String string2;
        if (this.rule(list, "invalid", string, element.hasAttribute("rel"), "Link element has no '@rel'") && this.rule(list, "invalid", string, !Utilities.noString(string2 = element.getAttribute("rel")), "Link/@rel is empty") && string2.equals("self") && this.rule(list, "invalid", string, element.hasAttribute("href"), "Link/@rel='self' has no href")) {
            this.rule(list, "invalid", string, this.isAbsoluteUrl(element.getAttribute("href")), "Link/@rel='self' '" + element.getAttribute("href") + "' is not an absolute URI (must start with http:, https:, urn:, cid:");
        }
    }

    private void validateId(List<ValidationMessage> list, String string, Element element, boolean bl) {
        if (this.rule(list, "invalid", string, !Utilities.noString(element.getTextContent()), "id is empty")) {
            this.rule(list, "invalid", string, this.isAbsoluteUrl(element.getTextContent()), "Id '" + element.getTextContent() + "' is not an absolute URI (must start with http:, https:, urn:, cid:");
        }
    }

    private boolean isAbsoluteUrl(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("http:")) {
            return true;
        }
        if (string.startsWith("https:")) {
            return true;
        }
        if (string.startsWith("urn:")) {
            return true;
        }
        return string.startsWith("cid:");
    }

    private void validateElement(List<ValidationMessage> list, Profile profile, Profile.ProfileStructureComponent profileStructureComponent, String string, Profile.ElementComponent elementComponent, Profile profile2, Profile.ElementComponent elementComponent2, Element element, String string2) throws Exception {
        Object object;
        if (NS_FHIR.equals(element.getNamespaceURI())) {
            this.rule(list, "invalid", string, !this.empty(element), "Elements must have some content (@value, @id, extensions, or children elements)");
        }
        Map<String, Profile.ElementComponent> map = this.getChildren(profileStructureComponent, elementComponent.getPathSimple());
        for (Profile.ElementComponent elementComponent3 : map.values()) {
            if (!elementComponent3.getRepresentation().isEmpty()) continue;
            object = new ArrayList<Element>();
            XMLUtil.getNamedChildrenWithWildcard(element, this.tail(elementComponent3.getPathSimple()), object);
            if (elementComponent3.getDefinition().getMinSimple() > 0) {
                this.rule(list, "structure", elementComponent3.getPathSimple(), object.size() > 0, "Element " + elementComponent3.getPathSimple() + " is required");
            }
            if (elementComponent3.getDefinition().getMaxSimple() == null || elementComponent3.getDefinition().getMaxSimple().equals("*")) continue;
            this.rule(list, "structure", elementComponent3.getPathSimple(), object.size() <= Integer.parseInt(elementComponent3.getDefinition().getMaxSimple()), "Element " + elementComponent3.getPathSimple() + " can only occur " + elementComponent3.getDefinition().getMaxSimple() + " time" + (elementComponent3.getDefinition().getMaxSimple().equals("1") ? "" : "s"));
        }
        ChildIterator childIterator = new ChildIterator(string, element);
        while (childIterator.next()) {
            BackboneElement backboneElement;
            Profile.ElementComponent elementComponent3;
            elementComponent3 = map.get(childIterator.name());
            object = null;
            if (childIterator.name().equals("extension")) {
                object = "Extension";
                elementComponent3 = elementComponent;
            } else if (elementComponent3 == null) {
                elementComponent3 = this.getDefinitionByTailNameChoice(map, childIterator.name());
                if (elementComponent3 != null) {
                    object = childIterator.name().substring(this.tail(elementComponent3.getPathSimple()).length() - 3);
                }
                if ("Resource".equals(object)) {
                    object = "ResourceReference";
                }
            } else {
                if (elementComponent3.getDefinition().getType().size() == 1) {
                    object = elementComponent3.getDefinition().getType().get(0).getCodeSimple();
                } else if (elementComponent3.getDefinition().getType().size() > 1) {
                    backboneElement = elementComponent3.getDefinition().getType().get(0);
                    if (backboneElement.getCodeSimple().equals("ResourceReference")) {
                        object = "ResourceReference";
                    } else {
                        throw new Exception("multiple types (" + this.describeTypes(elementComponent3.getDefinition().getType()) + ") @ " + string + "/f:" + childIterator.name());
                    }
                }
                if (object != null) {
                    if (((String)object).startsWith("Resource(")) {
                        object = "ResourceReference";
                    }
                    if (((String)object).startsWith("@")) {
                        elementComponent3 = this.findElement(profileStructureComponent, ((String)object).substring(1));
                        object = null;
                    }
                }
            }
            if (object != null) {
                if (this.typeIsPrimitive((String)object)) {
                    this.checkPrimitive(list, childIterator.path(), (String)object, elementComponent3, childIterator.element());
                    continue;
                }
                if (((String)object).equals("Identifier")) {
                    this.checkIdentifier(childIterator.path(), childIterator.element(), elementComponent3);
                } else if (((String)object).equals("Coding")) {
                    this.checkCoding(list, childIterator.path(), childIterator.element(), profile, elementComponent3);
                } else if (((String)object).equals("CodeableConcept")) {
                    this.checkCodeableConcept(list, childIterator.path(), childIterator.element(), profile, elementComponent3);
                } else if (((String)object).equals("Extension")) {
                    this.checkExtension(list, childIterator.path(), childIterator.element(), profile, elementComponent3, string2);
                }
                if (((String)object).equals("Resource")) {
                    this.validateContains(list, childIterator.path(), elementComponent3, elementComponent, childIterator.element());
                    continue;
                }
                backboneElement = this.getProfileForType((String)object);
                Profile.ProfileStructureComponent profileStructureComponent2 = this.getStructureForType((Profile)backboneElement, (String)object);
                if (!this.rule(list, "structure", childIterator.path(), profileStructureComponent2 != null, "Unknown type " + (String)object)) continue;
                this.validateElement(list, (Profile)backboneElement, profileStructureComponent2, childIterator.path(), profileStructureComponent2.getElement().get(0), profile, elementComponent3, childIterator.element(), (String)object);
                continue;
            }
            if (!this.rule(list, "structure", string, elementComponent3 != null, "Unrecognised Content " + childIterator.name())) continue;
            this.validateElement(list, profile, profileStructureComponent, childIterator.path(), elementComponent3, null, null, childIterator.element(), (String)object);
        }
    }

    private String describeTypes(List<Profile.TypeRefComponent> list) {
        CommaSeparatedStringBuilder commaSeparatedStringBuilder = new CommaSeparatedStringBuilder();
        for (Profile.TypeRefComponent typeRefComponent : list) {
            commaSeparatedStringBuilder.append(typeRefComponent.getCodeSimple());
        }
        return commaSeparatedStringBuilder.toString();
    }

    private void checkExtension(List<ValidationMessage> list, String string, Element element, Profile profile, Profile.ElementComponent elementComponent, String string2) throws Exception {
        String string3 = element.getAttribute("url");
        ExtensionLocatorService.ExtensionLocationResponse extensionLocationResponse = this.extensions.locateExtension(string3);
        if (extensionLocationResponse.getStatus() == ExtensionLocatorService.Status.NotAllowed) {
            this.rule(list, "structure", string + "[url='" + string3 + "']", false, "This extension cannot be used here (" + extensionLocationResponse.getMessage() + ")");
        } else if (extensionLocationResponse.getStatus() == ExtensionLocatorService.Status.Located) {
            this.checkExtensionContext(list, string + "[url='" + string3 + "']", extensionLocationResponse.getDefinition(), elementComponent, string2, ((Element)element.getParentNode()).getAttribute("url"));
            if (extensionLocationResponse.getDefinition().getDefinition().getType().size() > 0) {
                if (extensionLocationResponse.getDefinition().getDefinition().getType().size() > 1) {
                    throw new Error("exceptions with multiple types are not yet handled");
                }
                String string4 = extensionLocationResponse.getDefinition().getDefinition().getType().get(0).getCodeSimple();
                if (string4.contains("(")) {
                    string4 = string4.substring(0, string4.indexOf("("));
                }
                String string5 = "value" + Utilities.capitalize(string4);
                Element element2 = XMLUtil.getNamedChild(element, string5);
                if (this.rule(list, "structure", string + "[url='" + string3 + "']", element2 != null, "No Extension value found (looking for '" + string5 + "')")) {
                    Profile profile2 = this.types.get(string4);
                    Profile.ElementComponent elementComponent2 = new Profile.ElementComponent();
                    elementComponent2.setPathSimple(string + "[url='" + string3 + "']");
                    elementComponent2.setNameSimple(string5);
                    elementComponent2.setDefinition(extensionLocationResponse.getDefinition().getDefinition());
                    if (profile2 != null) {
                        this.validateElement(list, profile, null, string + "[url='" + string3 + "']." + string5, elementComponent2, null, null, element2, "Extension");
                    } else {
                        ValueSet valueSet;
                        Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent;
                        this.checkPrimitive(list, string + "[url='" + string3 + "']." + string5, string4, elementComponent2, element2);
                        if (string4.equals("code") && (elementDefinitionBindingComponent = extensionLocationResponse.getDefinition().getDefinition().getBinding()) != null && this.warning(list, "code-unknown", string, elementDefinitionBindingComponent.getReference() != null && elementDefinitionBindingComponent.getReference() instanceof ResourceReference, "Binding for " + string + " missing or cannot be processed") && elementDefinitionBindingComponent.getReference() != null && elementDefinitionBindingComponent.getReference() instanceof ResourceReference && this.warning(list, "code-unknown", string, (valueSet = this.resolveBindingReference(elementDefinitionBindingComponent.getReference())) != null, "ValueSet " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " not found")) {
                            try {
                                valueSet = this.cache.getExpander().expand(valueSet);
                                if (this.warning(list, "code-unknown", string, valueSet != null, "Unable to expand value set for " + this.describeReference(elementDefinitionBindingComponent.getReference()))) {
                                    this.warning(list, "code-unknown", string, this.codeInExpansion(valueSet, null, element2.getAttribute("value")), "Code " + element2.getAttribute("value") + " is not in value set " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " (" + valueSet.getIdentifierSimple() + ")");
                                }
                            }
                            catch (Exception exception) {
                                this.warning(list, "code-unknown", string, false, "Exception opening value set " + valueSet.getIdentifierSimple() + " for " + this.describeReference(elementDefinitionBindingComponent.getReference()) + ": " + exception.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }

    private void checkExtensionContext(List<ValidationMessage> list, String string, Profile.ProfileExtensionDefnComponent profileExtensionDefnComponent, Profile.ElementComponent elementComponent, String string2, String string3) {
        if (profileExtensionDefnComponent.getContextTypeSimple() == Profile.ExtensionContext.datatype) {
            boolean bl = false;
            for (StringType stringType : profileExtensionDefnComponent.getContext()) {
                if (!stringType.getValue().equals("*") && !stringType.getValue().equals(string2)) continue;
                bl = true;
            }
            this.rule(list, "structure", string, bl, "This extension is not allowed to be used with the type " + string2);
        } else if (profileExtensionDefnComponent.getContextTypeSimple() == Profile.ExtensionContext.extension) {
            boolean bl = false;
            for (StringType stringType : profileExtensionDefnComponent.getContext()) {
                if (!stringType.getValue().equals("*") && !stringType.getValue().equals(string3)) continue;
                bl = true;
            }
            this.rule(list, "structure", string, bl, "This extension is not allowed to be used with the extension '" + string3 + "'");
        } else {
            if (profileExtensionDefnComponent.getContextTypeSimple() == Profile.ExtensionContext.mapping) {
                throw new Error("Not handled yet");
            }
            if (profileExtensionDefnComponent.getContextTypeSimple() == Profile.ExtensionContext.resource) {
                boolean bl = false;
                String string4 = this.simplifyPath(string);
                CommaSeparatedStringBuilder commaSeparatedStringBuilder = new CommaSeparatedStringBuilder();
                for (StringType stringType : profileExtensionDefnComponent.getContext()) {
                    commaSeparatedStringBuilder.append(stringType.getValue());
                    if (!stringType.getValue().equals("*") && !stringType.getValue().equals(string2) && !string4.equals(stringType.getValue()) && !string4.endsWith("." + stringType.getValue())) continue;
                    bl = true;
                }
                this.rule(list, "structure", string, bl, "This extension is not allowed to be used with the resource " + (string2 == null ? string4 : string2) + " (allowed: " + commaSeparatedStringBuilder.toString() + ")");
            } else {
                throw new Error("Unknown context type");
            }
        }
    }

    private String simplifyPath(String string) {
        int n;
        int n2;
        String string2 = string.replace("/f:", ".");
        while (string2.contains("[")) {
            string2 = string2.substring(0, string2.indexOf("[")) + string2.substring(string2.indexOf("]") + 1);
        }
        String[] stringArray = string2.split("\\.");
        for (n2 = 0; n2 < stringArray.length && !this.types.containsKey(stringArray[n2].toLowerCase()); ++n2) {
        }
        if (n2 >= stringArray.length) {
            throw new Error("Unable to process part " + string);
        }
        for (n = stringArray.length - 1; n > 0 && (stringArray[n].equals("extension") || stringArray[n].equals("modifierExtension")); --n) {
        }
        while (n > 1 && stringArray[n].equals(stringArray[n - 1])) {
            --n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i <= n; ++i) {
            if (i > n2) {
                stringBuilder.append(".");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private boolean empty(Element element) {
        if (element.hasAttribute("value")) {
            return false;
        }
        if (element.hasAttribute("id")) {
            return false;
        }
        if (element.hasAttribute("xml:id")) {
            return false;
        }
        Element element2 = XMLUtil.getFirstChild(element);
        while (element2 != null) {
            if (!NS_FHIR.equals(element2.getNamespaceURI())) continue;
            return false;
        }
        return true;
    }

    private Profile.ElementComponent findElement(Profile.ProfileStructureComponent profileStructureComponent, String string) {
        for (Profile.ElementComponent elementComponent : profileStructureComponent.getElement()) {
            if (!elementComponent.getPathSimple().equals(string)) continue;
            return elementComponent;
        }
        return null;
    }

    private Map<String, Profile.ElementComponent> getChildren(Profile.ProfileStructureComponent profileStructureComponent, String string) {
        HashMap<String, Profile.ElementComponent> hashMap = new HashMap<String, Profile.ElementComponent>();
        for (Profile.ElementComponent elementComponent : profileStructureComponent.getElement()) {
            String string2;
            String string3 = elementComponent.getPathSimple();
            if (elementComponent.getDefinition() != null && !Utilities.noString(elementComponent.getDefinition().getNameReferenceSimple()) && string.startsWith(string3)) {
                if (string.length() > string3.length()) {
                    return this.getChildren(profileStructureComponent, elementComponent.getDefinition().getNameReferenceSimple() + "." + string.substring(string3.length() + 1));
                }
                return this.getChildren(profileStructureComponent, elementComponent.getDefinition().getNameReferenceSimple());
            }
            if (!string3.startsWith(string + ".") || string3.equals(string) || (string2 = string3.substring(string.length() + 1)).contains(".")) continue;
            hashMap.put(string2, elementComponent);
        }
        return hashMap;
    }

    private Profile.ElementComponent getDefinitionByTailNameChoice(Map<String, Profile.ElementComponent> map, String string) {
        for (String string2 : map.keySet()) {
            if (!string2.endsWith("[x]") || !string.startsWith(string2.substring(0, string2.length() - 3))) continue;
            return map.get(string2);
        }
        return null;
    }

    private String tail(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    private void validateContains(List<ValidationMessage> list, String string, Profile.ElementComponent elementComponent, Profile.ElementComponent elementComponent2, Element element) throws Exception {
        Element element2 = XMLUtil.getFirstChild(element);
        this.validate(list, string, element2, null, null);
    }

    private boolean typeIsPrimitive(String string) {
        if ("boolean".equalsIgnoreCase(string)) {
            return true;
        }
        if ("integer".equalsIgnoreCase(string)) {
            return true;
        }
        if ("decimal".equalsIgnoreCase(string)) {
            return true;
        }
        if ("base64Binary".equalsIgnoreCase(string)) {
            return true;
        }
        if ("instant".equalsIgnoreCase(string)) {
            return true;
        }
        if ("string".equalsIgnoreCase(string)) {
            return true;
        }
        if ("uri".equalsIgnoreCase(string)) {
            return true;
        }
        if ("date".equalsIgnoreCase(string)) {
            return true;
        }
        if ("dateTime".equalsIgnoreCase(string)) {
            return true;
        }
        if ("date".equalsIgnoreCase(string)) {
            return true;
        }
        if ("oid".equalsIgnoreCase(string)) {
            return true;
        }
        if ("uuid".equalsIgnoreCase(string)) {
            return true;
        }
        if ("code".equalsIgnoreCase(string)) {
            return true;
        }
        if ("id".equalsIgnoreCase(string)) {
            return true;
        }
        return "xhtml".equalsIgnoreCase(string);
    }

    private void checkPrimitive(List<ValidationMessage> list, String string, String string2, Profile.ElementComponent elementComponent, Element element) {
        if (string2.equals("uri")) {
            this.rule(list, "invalid", string, !element.getAttribute("value").startsWith("oid:"), "URI values cannot start with oid:");
            this.rule(list, "invalid", string, !element.getAttribute("value").startsWith("uuid:"), "URI values cannot start with uuid:");
        }
        if (!string2.equalsIgnoreCase("string") && element.hasAttribute("value") && this.rule(list, "invalid", string, element.getAttribute("value").length() > 0, "@value cannot be empty")) {
            this.warning(list, "invalid", string, element.getAttribute("value").trim().equals(element.getAttribute("value")), "value should not start or finish with whitespace");
        }
    }

    private void checkExtension(String string, Profile.ElementComponent elementComponent, Profile.ElementComponent elementComponent2, Element element) {
    }

    private void checkResourceReference(String string, Element element, Profile.ElementComponent elementComponent, boolean bl) {
    }

    private void checkIdentifier(String string, Element element, Profile.ElementComponent elementComponent) {
    }

    private void checkQuantity(List<ValidationMessage> list, String string, Element element, Profile.ElementComponent elementComponent, boolean bl) {
        String string2 = XMLUtil.getNamedChildValue(element, "code");
        String string3 = XMLUtil.getNamedChildValue(element, "system");
        String string4 = XMLUtil.getNamedChildValue(element, "units");
        if (string3 != null && string2 != null) {
            this.checkCode(list, string, string2, string3, string4);
        }
    }

    private void checkCoding(List<ValidationMessage> list, String string, Element element, Profile profile, Profile.ElementComponent elementComponent) {
        block10: {
            Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent;
            String string2 = XMLUtil.getNamedChildValue(element, "code");
            String string3 = XMLUtil.getNamedChildValue(element, "system");
            String string4 = XMLUtil.getNamedChildValue(element, "display");
            if (string3 != null && string2 != null && this.checkCode(list, string, string2, string3, string4) && elementComponent != null && elementComponent.getDefinition().getBinding() != null && this.warning(list, "code-unknown", string, (elementDefinitionBindingComponent = elementComponent.getDefinition().getBinding()) != null, "Binding for " + string + " missing")) {
                if (elementDefinitionBindingComponent.getReference() != null && elementDefinitionBindingComponent.getReference() instanceof ResourceReference) {
                    ValueSet valueSet = this.resolveBindingReference(elementDefinitionBindingComponent.getReference());
                    if (this.warning(list, "code-unknown", string, valueSet != null, "ValueSet " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " not found")) {
                        try {
                            valueSet = this.cache.getExpander().expand(valueSet);
                            if (this.warning(list, "code-unknown", string, valueSet != null, "Unable to expand value set for " + this.describeReference(elementDefinitionBindingComponent.getReference()))) {
                                this.warning(list, "code-unknown", string, this.codeInExpansion(valueSet, string3, string2), "Code {" + string3 + "}" + string2 + " is not in value set " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " (" + valueSet.getIdentifierSimple() + ")");
                            }
                        }
                        catch (Exception exception) {
                            if (exception.getMessage() == null) {
                                this.warning(list, "code-unknown", string, false, "Exception opening value set " + valueSet.getIdentifierSimple() + " for " + this.describeReference(elementDefinitionBindingComponent.getReference()) + ": --Null--");
                                break block10;
                            }
                            this.warning(list, "code-unknown", string, false, "Exception opening value set " + valueSet.getIdentifierSimple() + " for " + this.describeReference(elementDefinitionBindingComponent.getReference()) + ": " + exception.getMessage());
                        }
                    }
                } else if (elementDefinitionBindingComponent.getReference() != null) {
                    this.hint(list, "code-unknown", string, false, "Binding by URI reference cannot be checked");
                } else {
                    this.hint(list, "code-unknown", string, false, "Binding has no source, so can't be checked");
                }
            }
        }
    }

    private ValueSet resolveBindingReference(Type type) {
        if (type instanceof UriType) {
            return this.valuesets.get(((UriType)type).getValue().toString());
        }
        if (type instanceof ResourceReference) {
            return this.valuesets.get(((ResourceReference)type).getReferenceSimple());
        }
        return null;
    }

    private boolean codeInExpansion(ValueSet valueSet, String string, String string2) {
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent : valueSet.getExpansion().getContains()) {
            if (string2.equals(valueSetExpansionContainsComponent.getCodeSimple()) && (string == null || string.equals(valueSetExpansionContainsComponent.getSystemSimple()))) {
                return true;
            }
            if (!this.codeinExpansion(valueSetExpansionContainsComponent, string, string2)) continue;
            return true;
        }
        return false;
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent, String string, String string2) {
        for (ValueSet.ValueSetExpansionContainsComponent valueSetExpansionContainsComponent2 : valueSetExpansionContainsComponent.getContains()) {
            if (string2.equals(valueSetExpansionContainsComponent2.getCodeSimple()) && string.equals(valueSetExpansionContainsComponent2.getSystemSimple().toString())) {
                return true;
            }
            if (!this.codeinExpansion(valueSetExpansionContainsComponent2, string, string2)) continue;
            return true;
        }
        return false;
    }

    private void checkCodeableConcept(List<ValidationMessage> list, String string, Element element, Profile profile, Profile.ElementComponent elementComponent) {
        block14: {
            Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent;
            if (elementComponent != null && elementComponent.getDefinition().getBinding() != null && this.warning(list, "code-unknown", string, (elementDefinitionBindingComponent = elementComponent.getDefinition().getBinding()) != null, "Binding for " + string + " missing (cc)")) {
                if (elementDefinitionBindingComponent.getReference() != null && elementDefinitionBindingComponent.getReference() instanceof ResourceReference) {
                    ValueSet valueSet = this.resolveBindingReference(elementDefinitionBindingComponent.getReference());
                    if (this.warning(list, "code-unknown", string, valueSet != null, "ValueSet " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " not found")) {
                        try {
                            valueSet = this.cache.getExpander().expand(valueSet);
                            if (!this.warning(list, "code-unknown", string, elementDefinitionBindingComponent != null, "Unable to expand value set for " + this.describeReference(elementDefinitionBindingComponent.getReference()))) break block14;
                            boolean bl = false;
                            boolean bl2 = false;
                            Element element2 = XMLUtil.getFirstChild(element);
                            while (element2 != null) {
                                if (element2.getNodeName().equals("coding")) {
                                    bl2 = true;
                                    String string2 = XMLUtil.getNamedChildValue(element2, "system");
                                    String string3 = XMLUtil.getNamedChildValue(element2, "code");
                                    if (string2 != null && string3 != null) {
                                        bl = bl || this.codeInExpansion(valueSet, string2, string3);
                                    }
                                }
                                element2 = XMLUtil.getNextSibling(element2);
                            }
                            if (!bl2 && elementDefinitionBindingComponent.getConformanceSimple() == Profile.BindingConformance.required) {
                                this.warning(list, "code-unknown", string, bl, "No code provided, and value set " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " (" + valueSet.getIdentifierSimple() + ") is required");
                            }
                            if (!bl2) break block14;
                            if (elementDefinitionBindingComponent.getConformanceSimple() == Profile.BindingConformance.example) {
                                this.hint(list, "code-unknown", string, bl, "None of the codes are in the example value set " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " (" + valueSet.getIdentifierSimple() + ")");
                                break block14;
                            }
                            this.warning(list, "code-unknown", string, bl, "None of the codes are in the expected value set " + this.describeReference(elementDefinitionBindingComponent.getReference()) + " (" + valueSet.getIdentifierSimple() + ")");
                        }
                        catch (Exception exception) {
                            if (exception.getMessage() == null) {
                                this.warning(list, "code-unknown", string, false, "Exception opening value set " + valueSet.getIdentifierSimple() + " for " + this.describeReference(elementDefinitionBindingComponent.getReference()) + ": --Null--");
                                break block14;
                            }
                            this.warning(list, "code-unknown", string, false, "Exception opening value set " + valueSet.getIdentifierSimple() + " for " + this.describeReference(elementDefinitionBindingComponent.getReference()) + ": " + exception.getMessage());
                        }
                    }
                } else if (elementDefinitionBindingComponent.getReference() != null) {
                    this.hint(list, "code-unknown", string, false, "Binding by URI reference cannot be checked");
                } else {
                    this.hint(list, "code-unknown", string, false, "Binding has no source, so can't be checked");
                }
            }
        }
    }

    private String describeReference(Type type) {
        if (type == null) {
            return "null";
        }
        if (type instanceof UriType) {
            return ((UriType)type).getValue();
        }
        if (type instanceof ResourceReference) {
            return ((ResourceReference)type).getReference().getValue();
        }
        return "??";
    }

    private boolean checkCode(List<ValidationMessage> list, String string, String string2, String string3, String string4) {
        if (this.conceptLocator != null && this.conceptLocator.verifiesSystem(string3)) {
            ConceptLocator.ValidationResult validationResult = this.conceptLocator.validate(string3, string2, string4);
            if (validationResult == null) {
                return true;
            }
            if (validationResult.getSeverity() == OperationOutcome.IssueSeverity.information) {
                this.hint(list, "code-unknown", string, validationResult == null, validationResult.getMessage());
            } else if (validationResult.getSeverity() == OperationOutcome.IssueSeverity.warning) {
                this.warning(list, "code-unknown", string, validationResult == null, validationResult.getMessage());
            } else {
                return this.rule(list, "code-unknown", string, validationResult == null, validationResult.getMessage());
            }
            return true;
        }
        if (string3.startsWith(NS_FHIR)) {
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent;
            if (string3.equals("http://hl7.org/fhir/sid/icd-10")) {
                return true;
            }
            ValueSet valueSet = this.getValueSet(string3);
            if (this.warning(list, "code-unknown", string, valueSet != null, "Unknown Code System " + string3) && this.warning(list, "code-unknown", string, (valueSetDefineConceptComponent = this.getCodeDefinition(valueSet, string2)) != null, "Unknown Code (" + string3 + "#" + string2 + ")")) {
                return this.warning(list, "code-unknown", string, string4 == null || string4.equals(valueSetDefineConceptComponent.getDisplaySimple()), "Display should be '" + valueSetDefineConceptComponent.getDisplaySimple() + "'");
            }
            return false;
        }
        if (string3.startsWith("http://loinc.org")) {
            return true;
        }
        if (string3.startsWith("http://unitsofmeasure.org")) {
            return true;
        }
        return true;
    }

    private ValueSet.ValueSetDefineConceptComponent getCodeDefinition(ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent, String string) {
        if (string.equals(valueSetDefineConceptComponent.getCodeSimple())) {
            return valueSetDefineConceptComponent;
        }
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 : valueSetDefineConceptComponent.getConcept()) {
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent3 = this.getCodeDefinition(valueSetDefineConceptComponent2, string);
            if (valueSetDefineConceptComponent3 == null) continue;
            return valueSetDefineConceptComponent3;
        }
        return null;
    }

    private ValueSet.ValueSetDefineConceptComponent getCodeDefinition(ValueSet valueSet, String string) {
        for (ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent : valueSet.getDefine().getConcept()) {
            ValueSet.ValueSetDefineConceptComponent valueSetDefineConceptComponent2 = this.getCodeDefinition(valueSetDefineConceptComponent, string);
            if (valueSetDefineConceptComponent2 == null) continue;
            return valueSetDefineConceptComponent2;
        }
        return null;
    }

    private ValueSet getValueSet(String string) {
        return this.codesystems.get(string);
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    public void setSuppressLoincSnomedMessages(boolean bl) {
        this.suppressLoincSnomedMessages = bl;
    }

    public void validateInstanceByProfile(List<ValidationMessage> list, Element element, Profile profile) throws Exception {
        if (element.getLocalName().equals("feed")) {
            this.warning(list, "invalid", "feed", false, "Validating feeds is not done yet");
        } else {
            Profile.ProfileStructureComponent profileStructureComponent = null;
            for (Profile.ProfileStructureComponent profileStructureComponent2 : profile.getStructure()) {
                if (!element.getLocalName().equals(profileStructureComponent2.getTypeSimple())) continue;
                if (profileStructureComponent == null) {
                    profileStructureComponent = profileStructureComponent2;
                    continue;
                }
                throw new Exception("the profile contains multiple matches for the resource " + element.getLocalName() + " and the profile cannot be validated against");
            }
            if (this.rule(list, "invalid", element.getLocalName(), profileStructureComponent != null, "Profile does not allow for this resource")) {
                this.checkByProfile(list, element.getLocalName(), element, profile, profileStructureComponent, profileStructureComponent.getElement().get(0));
            }
        }
    }

    private void checkByProfile(List<ValidationMessage> list, String string, Element element, Profile profile, Profile.ProfileStructureComponent profileStructureComponent, Profile.ElementComponent elementComponent) throws Exception {
        String string2;
        Object object;
        if (elementComponent.getPathSimple().endsWith("[x]")) {
            object = elementComponent.getPathSimple().substring(elementComponent.getPathSimple().lastIndexOf(".") + 1, elementComponent.getPathSimple().length() - 3);
            string2 = element.getLocalName().substring(((String)object).length());
            this.rule(list, "structure", string, this.typeAllowed(string2, elementComponent.getDefinition().getType()), "The type '" + string2 + "' is not allowed at this point (must be one of '" + this.typeSummary(elementComponent) + ")");
        } else {
            string2 = this.rule(list, "struture", string, elementComponent.getDefinition().getType().size() == 1, "Error in profile: type count != 0, but only no type in instance") ? elementComponent.getDefinition().getType().get(0).getCodeSimple() : null;
        }
        for (Profile.ElementDefinitionConstraintComponent object2 : elementComponent.getDefinition().getConstraint()) {
            this.checkConstraint(list, string, element, object2);
        }
        if (elementComponent.getDefinition().getBinding() != null) {
            this.checkBinding(list, string, element, profile, elementComponent, string2);
        }
        if (string2 != null && this.typeIsPrimitive(string2)) {
            this.checkPrimitiveByProfile(list, string, element, elementComponent);
        } else {
            if (elementComponent.getDefinition().getValue() != null) {
                this.checkFixedValue(list, string, element, elementComponent.getDefinition().getValue(), "");
            }
            object = new ProfileStructureIterator(profile, profileStructureComponent, elementComponent);
            while (((ProfileStructureIterator)object).more()) {
                List<Profile.ElementComponent> list2 = ((ProfileStructureIterator)object).current();
                ArrayList<Element> arrayList = new ArrayList<Element>();
                XMLUtil.getNamedChildrenWithWildcard(element, ((ProfileStructureIterator)object).name(), arrayList);
                if (arrayList.size() == 0) {
                    for (Profile.ElementComponent elementComponent2 : list2) {
                        if (!this.rule(list, "required", string, elementComponent2.getDefinition().getMinSimple() == 0, "Required Element '" + ((ProfileStructureIterator)object).name() + "' missing")) break;
                    }
                    continue;
                }
                if (list2.size() != 1) continue;
                this.rule(list, "cardinality", string, list2.get(0).getDefinition().getMaxSimple() == "*" || Integer.parseInt(list2.get(0).getDefinition().getMaxSimple()) >= arrayList.size(), "Too many elements for '" + ((ProfileStructureIterator)object).name() + "'");
                for (Element element2 : arrayList) {
                    this.checkByProfile(list, string + "." + list2.get(0).getNameSimple(), element2, profile, profileStructureComponent, list2.get(0));
                }
            }
        }
    }

    private void checkBinding(List<ValidationMessage> list, String string, Element element, Profile profile, Profile.ElementComponent elementComponent, String string2) {
        Profile.ElementDefinitionBindingComponent elementDefinitionBindingComponent = elementComponent.getDefinition().getBinding();
        if (elementDefinitionBindingComponent != null && elementDefinitionBindingComponent.getReference() != null && elementDefinitionBindingComponent.getReference() instanceof ResourceReference) {
            ValueSet valueSet = this.resolveValueSetReference(profile, (ResourceReference)elementDefinitionBindingComponent.getReference());
            if (valueSet == null) {
                this.rule(list, "structure", string, false, "Cannot check binding on type '" + string2 + "' as the value set '" + ((ResourceReference)elementDefinitionBindingComponent.getReference()).getReferenceSimple() + "' could not be located");
            } else if (string2.equals("code")) {
                this.checkBindingCode(list, string, element, valueSet);
            } else if (string2.equals("Coding")) {
                this.checkBindingCoding(list, string, element, valueSet);
            } else if (string2.equals("CodeableConcept")) {
                this.checkBindingCodeableConcept(list, string, element, valueSet);
            } else {
                this.rule(list, "structure", string, false, "Cannot check binding on type '" + string2 + "'");
            }
        }
    }

    private ValueSet resolveValueSetReference(Profile profile, ResourceReference resourceReference) {
        if (resourceReference.getReferenceSimple().startsWith("#")) {
            for (Resource resource : profile.getContained()) {
                if (!(resource instanceof ValueSet) || !resource.getXmlId().equals(resourceReference.getReferenceSimple().substring(1))) continue;
                return (ValueSet)resource;
            }
            return null;
        }
        return this.resolveBindingReference(resourceReference);
    }

    private void checkBindingCode(List<ValidationMessage> list, String string, Element element, ValueSet valueSet) {
    }

    private void checkBindingCoding(List<ValidationMessage> list, String string, Element element, ValueSet valueSet) {
    }

    private void checkBindingCodeableConcept(List<ValidationMessage> list, String string, Element element, ValueSet valueSet) {
    }

    private String typeSummary(Profile.ElementComponent elementComponent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Profile.TypeRefComponent typeRefComponent : elementComponent.getDefinition().getType()) {
            stringBuilder.append("|" + typeRefComponent.getCodeSimple());
        }
        return stringBuilder.toString().substring(1);
    }

    private boolean typeAllowed(String string, List<Profile.TypeRefComponent> list) {
        for (Profile.TypeRefComponent typeRefComponent : list) {
            if (!string.equals(Utilities.capitalize(typeRefComponent.getCodeSimple()))) continue;
            return true;
        }
        return false;
    }

    private void checkConstraint(List<ValidationMessage> list, String string, Element element, Profile.ElementDefinitionConstraintComponent elementDefinitionConstraintComponent) throws Exception {
    }

    private void checkPrimitiveByProfile(List<ValidationMessage> list, String string, Element element, Profile.ElementComponent elementComponent) {
        String string2 = element.getAttribute("value");
        if (elementComponent.getDefinition().getMaxLength() != null) {
            this.rule(list, "too long", string, string2.length() <= elementComponent.getDefinition().getMaxLengthSimple(), "The value '" + string2 + "' exceeds the allow length limit of " + Integer.toString(elementComponent.getDefinition().getMaxLengthSimple()));
        }
        if (elementComponent.getDefinition().getValue() != null) {
            this.checkFixedValue(list, string, element, elementComponent.getDefinition().getValue(), "");
        }
    }

    private void checkFixedValue(List<ValidationMessage> list, String string, Element element, org.hl7.fhir.instance.model.Element element2, String string2) {
        if (element2 != null || element != null) {
            if (element2 == null && element != null) {
                this.rule(list, "value", string, false, "Unexpected element " + element.getNodeName());
            } else if (element2 != null && element == null) {
                this.rule(list, "value", string, false, "Mising element " + string2);
            } else {
                String string3 = element.getAttribute("value");
                if (element2 instanceof BooleanType) {
                    this.rule(list, "value", string, this.check(((BooleanType)element2).getStringValue(), string3), "Value is '" + string3 + "' but must be '" + ((BooleanType)element2).getStringValue() + "'");
                } else if (element2 instanceof IntegerType) {
                    this.rule(list, "value", string, this.check(((IntegerType)element2).getStringValue(), string3), "Value is '" + string3 + "' but must be '" + ((IntegerType)element2).getStringValue() + "'");
                } else if (element2 instanceof DecimalType) {
                    this.rule(list, "value", string, this.check(((DecimalType)element2).getStringValue(), string3), "Value is '" + string3 + "' but must be '" + ((DecimalType)element2).getStringValue() + "'");
                } else if (element2 instanceof Base64BinaryType) {
                    this.rule(list, "value", string, this.check(((Base64BinaryType)element2).getStringValue(), string3), "Value is '" + string3 + "' but must be '" + ((Base64BinaryType)element2).getStringValue() + "'");
                } else if (element2 instanceof InstantType) {
                    this.rule(list, "value", string, this.check(((InstantType)element2).getValue().toString(), string3), "Value is '" + string3 + "' but must be '" + ((InstantType)element2).getStringValue() + "'");
                } else if (element2 instanceof StringType) {
                    this.rule(list, "value", string, this.check(((StringType)element2).getValue(), string3), "Value is '" + string3 + "' but must be '" + ((StringType)element2).getValue() + "'");
                } else if (element2 instanceof UriType) {
                    this.rule(list, "value", string, this.check(((UriType)element2).getValue(), string3), "Value is '" + string3 + "' but must be '" + ((UriType)element2).getValue() + "'");
                } else if (element2 instanceof DateType) {
                    this.rule(list, "value", string, this.check(((DateType)element2).getValue().toString(), string3), "Value is '" + string3 + "' but must be '" + ((DateType)element2).getValue() + "'");
                } else if (element2 instanceof DateTimeType) {
                    this.rule(list, "value", string, this.check(((DateTimeType)element2).getValue().toString(), string3), "Value is '" + string3 + "' but must be '" + ((DateTimeType)element2).getValue() + "'");
                } else if (element2 instanceof OidType) {
                    this.rule(list, "value", string, this.check(((OidType)element2).getValue(), string3), "Value is '" + string3 + "' but must be '" + ((OidType)element2).getValue() + "'");
                } else if (element2 instanceof UuidType) {
                    this.rule(list, "value", string, this.check(((UuidType)element2).getValue(), string3), "Value is '" + string3 + "' but must be '" + ((UuidType)element2).getValue() + "'");
                } else if (element2 instanceof CodeType) {
                    this.rule(list, "value", string, this.check(((CodeType)element2).getValue(), string3), "Value is '" + string3 + "' but must be '" + ((CodeType)element2).getValue() + "'");
                } else if (element2 instanceof IdType) {
                    this.rule(list, "value", string, this.check(((IdType)element2).getValue(), string3), "Value is '" + string3 + "' but must be '" + ((IdType)element2).getValue() + "'");
                } else if (element2 instanceof Quantity) {
                    this.checkQuantity(list, string, element, (Quantity)element2);
                } else if (element2 instanceof Address) {
                    this.checkAddress(list, string, element, (Address)element2);
                } else if (element2 instanceof Contact) {
                    this.checkContact(list, string, element, (Contact)element2);
                } else if (element2 instanceof Attachment) {
                    this.checkAttachment(list, string, element, (Attachment)element2);
                } else if (element2 instanceof Identifier) {
                    this.checkIdentifier(list, string, element, (Identifier)element2);
                } else if (element2 instanceof Coding) {
                    this.checkCoding(list, string, element, (Coding)element2);
                } else if (element2 instanceof HumanName) {
                    this.checkHumanName(list, string, element, (HumanName)element2);
                } else if (element2 instanceof CodeableConcept) {
                    this.checkCodeableConcept(list, string, element, (CodeableConcept)element2);
                } else if (element2 instanceof Schedule) {
                    this.checkSchedule(list, string, element, (Schedule)element2);
                } else if (element2 instanceof Period) {
                    this.checkPeriod(list, string, element, (Period)element2);
                } else if (element2 instanceof Range) {
                    this.checkRange(list, string, element, (Range)element2);
                } else if (element2 instanceof Ratio) {
                    this.checkRatio(list, string, element, (Ratio)element2);
                } else if (element2 instanceof SampledData) {
                    this.checkSampledData(list, string, element, (SampledData)element2);
                } else {
                    this.rule(list, "exception", string, false, "Unhandled fixed value type " + element2.getClass().getName());
                }
                ArrayList<Element> arrayList = new ArrayList<Element>();
                XMLUtil.getNamedChildren(element, "extension", arrayList);
                if (element2.getExtensions().size() == 0) {
                    this.rule(list, "value", string, arrayList.size() == 0, "No extensions allowed");
                } else if (this.rule(list, "value", string, arrayList.size() == element2.getExtensions().size(), "Extensions count mismatch: expected " + Integer.toString(element2.getExtensions().size()) + " but found " + Integer.toString(arrayList.size()))) {
                    for (Extension extension : element2.getExtensions()) {
                        Element element3 = this.getExtensionByUrl(arrayList, extension.getUrlSimple());
                        if (!this.rule(list, "value", string, element3 != null, "Extension count mismatch: unable to find extension: " + extension.getUrlSimple())) continue;
                        this.checkFixedValue(list, string, XMLUtil.getNextSibling(XMLUtil.getFirstChild(element3)), extension.getValue(), "extension.value");
                    }
                }
            }
        }
    }

    private void checkAddress(List<ValidationMessage> list, String string, Element element, Address address) {
        this.checkFixedValue(list, string + ".use", XMLUtil.getNamedChild(element, "use"), address.getUse(), "use");
        this.checkFixedValue(list, string + ".text", XMLUtil.getNamedChild(element, "text"), address.getText(), "text");
        this.checkFixedValue(list, string + ".city", XMLUtil.getNamedChild(element, "city"), address.getCity(), "city");
        this.checkFixedValue(list, string + ".state", XMLUtil.getNamedChild(element, "state"), address.getState(), "state");
        this.checkFixedValue(list, string + ".country", XMLUtil.getNamedChild(element, "country"), address.getCountry(), "country");
        this.checkFixedValue(list, string + ".zip", XMLUtil.getNamedChild(element, "zip"), address.getZip(), "zip");
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(element, "line", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == address.getLine().size(), "Expected " + Integer.toString(address.getLine().size()) + " but found " + Integer.toString(arrayList.size()) + " line elements")) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.checkFixedValue(list, string + ".coding", (Element)arrayList.get(i), address.getLine().get(i), "coding");
            }
        }
    }

    private void checkContact(List<ValidationMessage> list, String string, Element element, Contact contact) {
        this.checkFixedValue(list, string + ".system", XMLUtil.getNamedChild(element, "system"), contact.getSystem(), "system");
        this.checkFixedValue(list, string + ".value", XMLUtil.getNamedChild(element, "value"), contact.getValue(), "value");
        this.checkFixedValue(list, string + ".use", XMLUtil.getNamedChild(element, "use"), contact.getUse(), "use");
        this.checkFixedValue(list, string + ".period", XMLUtil.getNamedChild(element, "period"), contact.getPeriod(), "period");
    }

    private void checkAttachment(List<ValidationMessage> list, String string, Element element, Attachment attachment) {
        this.checkFixedValue(list, string + ".contentType", XMLUtil.getNamedChild(element, "contentType"), attachment.getContentType(), "contentType");
        this.checkFixedValue(list, string + ".language", XMLUtil.getNamedChild(element, "language"), attachment.getLanguage(), "language");
        this.checkFixedValue(list, string + ".data", XMLUtil.getNamedChild(element, "data"), attachment.getData(), "data");
        this.checkFixedValue(list, string + ".url", XMLUtil.getNamedChild(element, "url"), attachment.getUrl(), "url");
        this.checkFixedValue(list, string + ".size", XMLUtil.getNamedChild(element, "size"), attachment.getSize(), "size");
        this.checkFixedValue(list, string + ".hash", XMLUtil.getNamedChild(element, "hash"), attachment.getHash(), "hash");
        this.checkFixedValue(list, string + ".title", XMLUtil.getNamedChild(element, "title"), attachment.getTitle(), "title");
    }

    private void checkIdentifier(List<ValidationMessage> list, String string, Element element, Identifier identifier) {
        this.checkFixedValue(list, string + ".use", XMLUtil.getNamedChild(element, "use"), identifier.getUse(), "use");
        this.checkFixedValue(list, string + ".label", XMLUtil.getNamedChild(element, "label"), identifier.getLabel(), "label");
        this.checkFixedValue(list, string + ".system", XMLUtil.getNamedChild(element, "system"), identifier.getSystem(), "system");
        this.checkFixedValue(list, string + ".value", XMLUtil.getNamedChild(element, "value"), identifier.getValue(), "value");
        this.checkFixedValue(list, string + ".period", XMLUtil.getNamedChild(element, "period"), identifier.getPeriod(), "period");
        this.checkFixedValue(list, string + ".assigner", XMLUtil.getNamedChild(element, "assigner"), identifier.getAssigner(), "assigner");
    }

    private void checkCoding(List<ValidationMessage> list, String string, Element element, Coding coding) {
        this.checkFixedValue(list, string + ".system", XMLUtil.getNamedChild(element, "system"), coding.getSystem(), "system");
        this.checkFixedValue(list, string + ".code", XMLUtil.getNamedChild(element, "code"), coding.getCode(), "code");
        this.checkFixedValue(list, string + ".display", XMLUtil.getNamedChild(element, "display"), coding.getDisplay(), "display");
        this.checkFixedValue(list, string + ".primary", XMLUtil.getNamedChild(element, "primary"), coding.getPrimary(), "primary");
    }

    private void checkHumanName(List<ValidationMessage> list, String string, Element element, HumanName humanName) {
        int n;
        this.checkFixedValue(list, string + ".use", XMLUtil.getNamedChild(element, "use"), humanName.getUse(), "use");
        this.checkFixedValue(list, string + ".text", XMLUtil.getNamedChild(element, "text"), humanName.getText(), "text");
        this.checkFixedValue(list, string + ".period", XMLUtil.getNamedChild(element, "period"), humanName.getPeriod(), "period");
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(element, "family", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == humanName.getFamily().size(), "Expected " + Integer.toString(humanName.getFamily().size()) + " but found " + Integer.toString(arrayList.size()) + " family elements")) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.checkFixedValue(list, string + ".family", (Element)arrayList.get(n), humanName.getFamily().get(n), "family");
            }
        }
        XMLUtil.getNamedChildren(element, "given", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == humanName.getFamily().size(), "Expected " + Integer.toString(humanName.getFamily().size()) + " but found " + Integer.toString(arrayList.size()) + " given elements")) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.checkFixedValue(list, string + ".given", (Element)arrayList.get(n), humanName.getFamily().get(n), "given");
            }
        }
        XMLUtil.getNamedChildren(element, "prefix", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == humanName.getFamily().size(), "Expected " + Integer.toString(humanName.getFamily().size()) + " but found " + Integer.toString(arrayList.size()) + " prefix elements")) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.checkFixedValue(list, string + ".prefix", (Element)arrayList.get(n), humanName.getFamily().get(n), "prefix");
            }
        }
        XMLUtil.getNamedChildren(element, "suffix", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == humanName.getFamily().size(), "Expected " + Integer.toString(humanName.getFamily().size()) + " but found " + Integer.toString(arrayList.size()) + " suffix elements")) {
            for (n = 0; n < arrayList.size(); ++n) {
                this.checkFixedValue(list, string + ".suffix", (Element)arrayList.get(n), humanName.getFamily().get(n), "suffix");
            }
        }
    }

    private void checkCodeableConcept(List<ValidationMessage> list, String string, Element element, CodeableConcept codeableConcept) {
        this.checkFixedValue(list, string + ".text", XMLUtil.getNamedChild(element, "text"), codeableConcept.getText(), "text");
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(element, "coding", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == codeableConcept.getCoding().size(), "Expected " + Integer.toString(codeableConcept.getCoding().size()) + " but found " + Integer.toString(arrayList.size()) + " coding elements")) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.checkFixedValue(list, string + ".coding", (Element)arrayList.get(i), codeableConcept.getCoding().get(i), "coding");
            }
        }
    }

    private void checkSchedule(List<ValidationMessage> list, String string, Element element, Schedule schedule) {
        this.checkFixedValue(list, string + ".repeat", XMLUtil.getNamedChild(element, "repeat"), schedule.getRepeat(), "value");
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(element, "event", arrayList);
        if (this.rule(list, "value", string, arrayList.size() == schedule.getEvent().size(), "Expected " + Integer.toString(schedule.getEvent().size()) + " but found " + Integer.toString(arrayList.size()) + " event elements")) {
            for (int i = 0; i < arrayList.size(); ++i) {
                this.checkFixedValue(list, string + ".event", (Element)arrayList.get(i), schedule.getEvent().get(i), "event");
            }
        }
    }

    private void checkPeriod(List<ValidationMessage> list, String string, Element element, Period period) {
        this.checkFixedValue(list, string + ".start", XMLUtil.getNamedChild(element, "start"), period.getStart(), "start");
        this.checkFixedValue(list, string + ".end", XMLUtil.getNamedChild(element, "end"), period.getEnd(), "end");
    }

    private void checkRange(List<ValidationMessage> list, String string, Element element, Range range) {
        this.checkFixedValue(list, string + ".low", XMLUtil.getNamedChild(element, "low"), range.getLow(), "low");
        this.checkFixedValue(list, string + ".high", XMLUtil.getNamedChild(element, "high"), range.getHigh(), "high");
    }

    private void checkRatio(List<ValidationMessage> list, String string, Element element, Ratio ratio) {
        this.checkFixedValue(list, string + ".numerator", XMLUtil.getNamedChild(element, "numerator"), ratio.getNumerator(), "numerator");
        this.checkFixedValue(list, string + ".denominator", XMLUtil.getNamedChild(element, "denominator"), ratio.getDenominator(), "denominator");
    }

    private void checkSampledData(List<ValidationMessage> list, String string, Element element, SampledData sampledData) {
        this.checkFixedValue(list, string + ".origin", XMLUtil.getNamedChild(element, "origin"), sampledData.getOrigin(), "origin");
        this.checkFixedValue(list, string + ".period", XMLUtil.getNamedChild(element, "period"), sampledData.getPeriod(), "period");
        this.checkFixedValue(list, string + ".factor", XMLUtil.getNamedChild(element, "factor"), sampledData.getFactor(), "factor");
        this.checkFixedValue(list, string + ".lowerLimit", XMLUtil.getNamedChild(element, "lowerLimit"), sampledData.getLowerLimit(), "lowerLimit");
        this.checkFixedValue(list, string + ".upperLimit", XMLUtil.getNamedChild(element, "upperLimit"), sampledData.getUpperLimit(), "upperLimit");
        this.checkFixedValue(list, string + ".dimensions", XMLUtil.getNamedChild(element, "dimensions"), sampledData.getDimensions(), "dimensions");
        this.checkFixedValue(list, string + ".data", XMLUtil.getNamedChild(element, "data"), sampledData.getData(), "data");
    }

    private void checkQuantity(List<ValidationMessage> list, String string, Element element, Quantity quantity) {
        this.checkFixedValue(list, string + ".value", XMLUtil.getNamedChild(element, "value"), quantity.getValue(), "value");
        this.checkFixedValue(list, string + ".comparator", XMLUtil.getNamedChild(element, "comparator"), quantity.getComparator(), "comparator");
        this.checkFixedValue(list, string + ".units", XMLUtil.getNamedChild(element, "units"), quantity.getUnits(), "units");
        this.checkFixedValue(list, string + ".system", XMLUtil.getNamedChild(element, "system"), quantity.getSystem(), "system");
        this.checkFixedValue(list, string + ".code", XMLUtil.getNamedChild(element, "code"), quantity.getCode(), "code");
    }

    private boolean check(String string, String string2) {
        return string == null ? Utilities.noString(string) : string.equals(string2);
    }

    private Element getExtensionByUrl(List<Element> list, String string) {
        for (Element element : list) {
            if (!string.equals(XMLUtil.getNamedChildValue(element, "url"))) continue;
            return element;
        }
        return null;
    }

    private String typeCode(List<Profile.TypeRefComponent> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Profile.TypeRefComponent typeRefComponent : list) {
            stringBuilder.append("|" + typeRefComponent.getCodeSimple());
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(1);
        }
        return null;
    }

    public class ProfileStructureIterator {
        private Profile.ProfileStructureComponent structure;
        private Profile.ElementComponent elementDefn;
        private List<String> names = new ArrayList<String>();
        private Map<String, List<Profile.ElementComponent>> children = new HashMap<String, List<Profile.ElementComponent>>();
        private int cursor;

        public ProfileStructureIterator(Profile profile, Profile.ProfileStructureComponent profileStructureComponent, Profile.ElementComponent elementComponent) {
            this.structure = profileStructureComponent;
            this.elementDefn = elementComponent;
            this.loadMap();
            this.cursor = -1;
        }

        private void loadMap() {
            String string = this.elementDefn.getPathSimple();
            for (int i = this.structure.getElement().indexOf(this.elementDefn) + 1; i < this.structure.getElement().size(); ++i) {
                String string2 = this.structure.getElement().get(i).getPathSimple();
                if (string2.length() <= string.length()) {
                    return;
                }
                String string3 = string2.substring(string.length() + 1);
                if (!Utilities.isToken(string3) || !string2.substring(0, string.length()).equals(string)) continue;
                List<Profile.ElementComponent> list = this.children.get(string3);
                if (list == null) {
                    list = new ArrayList<Profile.ElementComponent>();
                    this.names.add(string3);
                    this.children.put(string3, list);
                }
                list.add(this.structure.getElement().get(i));
            }
        }

        public boolean more() {
            ++this.cursor;
            return this.cursor < this.names.size();
        }

        public List<Profile.ElementComponent> current() {
            return this.children.get(this.name());
        }

        public String name() {
            return this.names.get(this.cursor);
        }
    }

    public class ChildIterator {
        private Element parent;
        private String basePath;
        private int lastCount;
        private Element child;

        public ChildIterator(String string, Element element) {
            this.parent = element;
            this.basePath = string;
        }

        public boolean next() {
            if (this.child == null) {
                this.child = XMLUtil.getFirstChild(this.parent);
                this.lastCount = 0;
            } else {
                String string = this.child.getLocalName();
                this.child = XMLUtil.getNextSibling(this.child);
                this.lastCount = this.child != null && this.child.getLocalName().equals(string) ? ++this.lastCount : 0;
            }
            return this.child != null;
        }

        public String name() {
            return this.child.getLocalName();
        }

        public Element element() {
            return this.child;
        }

        public String path() {
            String string = "";
            Element element = XMLUtil.getNextSibling(this.child);
            if (element != null && element.getLocalName().equals(this.child.getLocalName())) {
                string = "[" + Integer.toString(this.lastCount) + "]";
            }
            return this.basePath + "/f:" + this.name() + string;
        }
    }

    public static enum CheckDisplayOption {
        Ignore,
        Check,
        CheckCaseAndSpace,
        CheckCase,
        CheckSpace;

    }

    public class NullExtensionResolver
    implements ExtensionLocatorService {
        @Override
        public ExtensionLocatorService.ExtensionLocationResponse locateExtension(String string) {
            return new ExtensionLocatorService.ExtensionLocationResponse(ExtensionLocatorService.Status.Unknown, null, null);
        }
    }

    public class ProfileMatch {
        Profile profile;
        Profile.ProfileStructureComponent structure;

        public ProfileMatch() {
        }

        public ProfileMatch(Profile profile, Profile.ProfileStructureComponent profileStructureComponent) {
            this.profile = profile;
            this.structure = profileStructureComponent;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public Profile.ProfileStructureComponent getStructure() {
            return this.structure;
        }
    }
}

