/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.validation.InstanceValidator;
import org.hl7.fhir.instance.validation.ValidationMessage;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProfileValidatorTests {
    private File registry;
    private File pack;

    public ProfileValidatorTests(File file, File file2) {
        this.pack = file;
        this.registry = file2;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        if (!file.exists()) {
            throw new Exception("unable to find validation pack (1st argument)");
        }
        if (!file2.exists()) {
            throw new Exception("unable to find test case registry (2nd argument)");
        }
        ProfileValidatorTests profileValidatorTests = new ProfileValidatorTests(file, file2);
        profileValidatorTests.execute();
    }

    public void execute() throws Exception {
        InstanceValidator instanceValidator = new InstanceValidator(this.pack.getAbsolutePath(), null, null);
        Document document = this.parseXml(this.registry.getAbsolutePath());
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(document.getDocumentElement(), "test", arrayList);
        String string = Utilities.getDirectoryForFile(this.registry.getAbsolutePath()) + File.separator;
        for (Element element : arrayList) {
            this.executeCase(instanceValidator, string, element);
        }
    }

    private Document parseXml(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new CSFileInputStream(string));
        return document;
    }

    private void executeCase(InstanceValidator instanceValidator, String string, Element element) throws Exception {
        Element element2 = this.parseXml(string + XMLUtil.getNamedChildValue(element, "instance") + ".xml").getDocumentElement();
        Profile profile = (Profile)this.parseResource(string + XMLUtil.getNamedChildValue(element, "profile") + ".xml");
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        instanceValidator.validateInstanceByProfile(arrayList, element2, profile);
        String string2 = XMLUtil.getNamedChildValue(element, "outcome");
        boolean bl = "ok".equals(string2) ? arrayList.size() == 0 : arrayList.size() == Integer.parseInt(string2);
        System.out.println(element.getAttribute("name") + " : " + (bl ? " ok " : "FAIL"));
        if (!bl) {
            for (ValidationMessage validationMessage : arrayList) {
                System.out.println("  ..: " + validationMessage.summary());
            }
        }
    }

    private Resource parseResource(String string) throws Exception {
        XmlParser xmlParser = new XmlParser();
        return xmlParser.parse(new FileInputStream(string));
    }
}

