/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.utils.NarrativeGenerator;
import org.hl7.fhir.instance.validation.InstanceValidator;
import org.hl7.fhir.instance.validation.ValidationErrorHandler;
import org.hl7.fhir.instance.validation.ValidationMessage;
import org.hl7.fhir.utilities.SchemaInputSource;
import org.hl7.fhir.utilities.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidationEngine {
    private byte[] source;
    private Map<String, byte[]> definitions = new HashMap<String, byte[]>();
    private List<ValidationMessage> outputs;
    private OperationOutcome outcome;
    private boolean noSchematron;
    private Profile profile;
    private String profileURI;

    public String getProfileURI() {
        return this.profileURI;
    }

    public void setProfileURI(String string) {
        this.profileURI = string;
    }

    public void process() throws Exception {
        Object object;
        Object object2;
        Object object3;
        this.outputs = new ArrayList<ValidationMessage>();
        Schema schema = this.readSchema();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setSchema(schema);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ValidationErrorHandler(this.outputs));
        Document document = documentBuilder.parse(new ByteArrayInputStream(this.source));
        if (!this.noSchematron) {
            object3 = document.getDocumentElement().getNodeName().toLowerCase();
            if (((String)object3).equals("feed")) {
                object3 = "fhir-atom";
            }
            object2 = Utilities.saxonTransform(this.definitions, this.definitions.get((String)object3 + ".sch"), this.definitions.get("iso_svrl_for_xslt2.xsl"));
            object = Utilities.saxonTransform(this.definitions, this.source, (byte[])object2);
            this.processSchematronOutput((byte[])object);
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ValidationErrorHandler(this.outputs));
        document = documentBuilder.parse(new ByteArrayInputStream(this.source));
        this.outputs.addAll(new InstanceValidator(this.definitions, null).validateInstance(document.getDocumentElement(), this.profile, this.profileURI));
        new XmlParser().parseGeneral(new ByteArrayInputStream(this.source));
        object3 = new OperationOutcome();
        object2 = this.outputs.iterator();
        while (object2.hasNext()) {
            object = (ValidationMessage)object2.next();
            ((OperationOutcome)object3).getIssue().add(((ValidationMessage)object).asIssue((OperationOutcome)object3));
        }
        new NarrativeGenerator("", null, null, null, null, null, null).generate((OperationOutcome)object3);
        this.outcome = object3;
    }

    private Schema readSchema() throws SAXException {
        Source[] sourceArray = new StreamSource[]{new StreamSource(new ByteArrayInputStream(this.definitions.get("fhir-all.xsd"))), new StreamSource(new ByteArrayInputStream(this.definitions.get("fhir-atom.xsd")))};
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setErrorHandler(new ValidationErrorHandler(this.outputs));
        schemaFactory.setResourceResolver(new ValidatorResourceResolver(this.definitions));
        Schema schema = schemaFactory.newSchema(sourceArray);
        return schema;
    }

    private void processSchematronOutput(byte[] byArray) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
        NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS("http://purl.oclc.org/dsdl/svrl", "failed-assert");
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                ValidationMessage validationMessage = new ValidationMessage();
                validationMessage.setSource(ValidationMessage.Source.Schematron);
                validationMessage.setType("invariant");
                validationMessage.setLevel(OperationOutcome.IssueSeverity.error);
                validationMessage.setLocation(element.getAttribute("location"));
                validationMessage.setMessage(element.getTextContent());
                this.outputs.add(validationMessage);
            }
        }
    }

    public List<ValidationMessage> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ValidationMessage> list) {
        this.outputs = list;
    }

    public byte[] getSource() {
        return this.source;
    }

    public Map<String, byte[]> getDefinitions() {
        return this.definitions;
    }

    public OperationOutcome getOutcome() {
        return this.outcome;
    }

    public void setSource(byte[] byArray) {
        this.source = byArray;
    }

    public boolean isNoSchematron() {
        return this.noSchematron;
    }

    public void setNoSchematron(boolean bl) {
        this.noSchematron = bl;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public class ValidatorResourceResolver
    implements LSResourceResolver {
        private Map<String, byte[]> files;

        public ValidatorResourceResolver(Map<String, byte[]> map) {
            this.files = map;
        }

        @Override
        public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
            if (!this.files.containsKey(string4)) {
                return null;
            }
            return new SchemaInputSource(new ByteArrayInputStream(this.files.get(string4)), string3, string4, string2);
        }
    }
}

