/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.util.List;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.validation.ValidationMessage;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationErrorHandler
implements ErrorHandler {
    private List<ValidationMessage> outputs;

    public ValidationErrorHandler(List<ValidationMessage> list) {
        this.outputs = list;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        ValidationMessage validationMessage = new ValidationMessage();
        validationMessage.setType("invalid");
        validationMessage.setLevel(OperationOutcome.IssueSeverity.error);
        validationMessage.setLocation("line " + Integer.toString(sAXParseException.getLineNumber()) + ", column " + Integer.toString(sAXParseException.getColumnNumber()));
        validationMessage.setMessage(sAXParseException.getMessage());
        validationMessage.setSource(ValidationMessage.Source.Schema);
        this.outputs.add(validationMessage);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        ValidationMessage validationMessage = new ValidationMessage();
        validationMessage.setType("invalid");
        validationMessage.setLevel(OperationOutcome.IssueSeverity.fatal);
        validationMessage.setLocation("line " + Integer.toString(sAXParseException.getLineNumber()) + ", column " + Integer.toString(sAXParseException.getColumnNumber()));
        validationMessage.setMessage(sAXParseException.getMessage());
        validationMessage.setSource(ValidationMessage.Source.Schema);
        this.outputs.add(validationMessage);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        ValidationMessage validationMessage = new ValidationMessage();
        validationMessage.setType("invalid");
        validationMessage.setLevel(OperationOutcome.IssueSeverity.warning);
        validationMessage.setLocation("line " + Integer.toString(sAXParseException.getLineNumber()) + ", column " + Integer.toString(sAXParseException.getColumnNumber()));
        validationMessage.setMessage(sAXParseException.getMessage());
        validationMessage.setSource(ValidationMessage.Source.Schema);
        this.outputs.add(validationMessage);
    }
}

