/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.StringType;
import org.hl7.fhir.instance.utils.ToolingExtensions;

public class ValidationMessage {
    private Source source;
    private String location;
    private String message;
    private String type;
    private OperationOutcome.IssueSeverity level;

    public ValidationMessage(Source source, String string, String string2, String string3, OperationOutcome.IssueSeverity issueSeverity) {
        this.location = string2;
        this.message = string3;
        this.level = issueSeverity;
        this.source = source;
        this.type = string;
    }

    public ValidationMessage() {
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public OperationOutcome.IssueSeverity getLevel() {
        return this.level;
    }

    public void setLevel(OperationOutcome.IssueSeverity issueSeverity) {
        this.level = issueSeverity;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String summary() {
        return this.level.toString() + " @ " + this.location + ": " + this.message + (this.source != null ? " (src = " + (Object)((Object)this.source) + ")" : "");
    }

    public OperationOutcome.OperationOutcomeIssueComponent asIssue(OperationOutcome operationOutcome) throws Exception {
        OperationOutcome.OperationOutcomeIssueComponent operationOutcomeIssueComponent = new OperationOutcome.OperationOutcomeIssueComponent();
        if (this.type != null) {
            operationOutcomeIssueComponent.setType(new Coding());
            operationOutcomeIssueComponent.getType().setSystemSimple("http://hl7.org/fhir/issue-type");
            operationOutcomeIssueComponent.getType().setCodeSimple(this.type);
        }
        if (this.location != null) {
            StringType stringType = new StringType();
            stringType.setValue(this.location);
            operationOutcomeIssueComponent.getLocation().add(stringType);
        }
        operationOutcomeIssueComponent.setSeveritySimple(this.level);
        operationOutcomeIssueComponent.setDetailsSimple(this.message);
        if (this.source != null) {
            operationOutcomeIssueComponent.getExtensions().add(ToolingExtensions.makeIssueSource(this.source));
        }
        return operationOutcomeIssueComponent;
    }

    public static enum Source {
        ExampleValidator,
        ProfileValidator,
        ResourceValidator,
        InstanceValidator,
        Schema,
        Schematron;

    }
}

