/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.formats.XmlComposer;
import org.hl7.fhir.instance.formats.XmlParser;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Profile;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.validation.ProfileValidatorTests;
import org.hl7.fhir.instance.validation.ValidationEngine;
import org.hl7.fhir.instance.validation.ValidationMessage;
import org.hl7.fhir.utilities.Utilities;

public class Validator {
    private String definitions;
    private String profile;
    private String source;
    ValidationEngine engine = new ValidationEngine();
    static final String MASTER_SOURCE = "http://hl7.org/documentcenter/public/standards/FHIR/validator.zip";

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws Exception {
        String string = null;
        if (stringArray.length == 0) {
            System.out.println("FHIR Validation tool. ");
            System.out.println("");
            System.out.println("The FHIR validation tool validates a FHIR resource or bundle.");
            System.out.println("Schema and schematron checking is performed, then some additional checks are performed");
            System.out.println("");
            System.out.println("JSON is not supported at this time");
            System.out.println("");
            System.out.println("Usage: FHIRValidator.jar [source] (-defn [definitions]) (-profile [profile]) (-output [output]) (-noxslt) where: ");
            System.out.println("* [source] is a file name or url of the resource or bundle feed to validate");
            System.out.println("* [definitions] is the file name or url of the validation pack (validation.zip). Default: get it from hl7.org");
            System.out.println("* [profile] is an optional filename or URL for a specific profile to validate a resource");
            System.out.println("    against. In the absence of this parameter, the resource will be checked against the ");
            System.out.println("    base specification using the definitions.");
            System.out.println("* [output] is a filename for the results (OperationOutcome). Default: results are sent to the std out.");
            System.out.println("* -noxslt means not to run the schematrons (you really need to run these, but they need xslt2).");
            System.out.println("");
            System.out.println("Or: FHIRValidator.jar -profile-tests [registry] (-defn [definitions])");
            System.out.println("");
            System.out.println("Master Source for the validation pack: http://hl7.org/documentcenter/public/standards/FHIR/validator.zip");
        } else if (stringArray[0].equals("-profile-tests")) {
            void profileValidatorTests;
            String string2 = null;
            String string3 = null;
            boolean i = false;
            while (profileValidatorTests < stringArray.length - 1) {
                if (stringArray[profileValidatorTests].equals("-profile-tests")) {
                    string3 = stringArray[profileValidatorTests + true];
                }
                if (stringArray[profileValidatorTests].equals("-defn")) {
                    string2 = stringArray[profileValidatorTests + true];
                }
                ++profileValidatorTests;
            }
            ProfileValidatorTests object = new ProfileValidatorTests(new File(string2), new File(string3));
            object.execute();
        } else {
            Validator validator = new Validator();
            validator.setSource(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-defn")) {
                    validator.setDefinitions(stringArray[i + 1]);
                }
                if (stringArray[i].equals("-output")) {
                    string = stringArray[i + 1];
                }
                if (stringArray[i].equals("-profile")) {
                    validator.setProfile(stringArray[i + 1]);
                }
                if (!stringArray[i].equals("-noxslt")) continue;
                validator.engine.setNoSchematron(true);
            }
            validator.process();
            if (string == null) {
                System.out.println("Validating " + stringArray[0] + ": " + Integer.toString(validator.outputs().size()) + " messages");
                for (ValidationMessage validationMessage : validator.outputs()) {
                    System.out.println(validationMessage.summary());
                }
                int n = 0;
                for (ValidationMessage validationMessage : validator.outputs()) {
                    if (validationMessage.getLevel() != OperationOutcome.IssueSeverity.error && validationMessage.getLevel() != OperationOutcome.IssueSeverity.fatal) continue;
                    ++n;
                }
                if (n == 0) {
                    System.out.println(" ...success");
                } else {
                    System.out.println(" ...failure");
                }
            } else {
                new XmlComposer().compose((OutputStream)new FileOutputStream(string), (Resource)validator.engine.getOutcome(), true);
            }
        }
    }

    private void setProfile(String string) {
        this.profile = string;
    }

    private List<ValidationMessage> outputs() {
        return this.engine.getOutputs();
    }

    public void process() throws Exception {
        byte[] byArray = this.loadDefinitions();
        if (!Utilities.noString(this.profile)) {
            this.engine.setProfile(this.readProfile(this.loadProfile()));
        }
        this.readDefinitions(this.engine, byArray);
        this.engine.setSource(this.loadSource());
        this.engine.process();
    }

    private Profile readProfile(byte[] byArray) throws Exception {
        XmlParser xmlParser = new XmlParser(true);
        return (Profile)xmlParser.parse(new ByteArrayInputStream(byArray));
    }

    private byte[] loadProfile() throws Exception {
        if (Utilities.noString(this.profile)) {
            return null;
        }
        if (this.profile.startsWith("https:") || this.profile.startsWith("http:")) {
            return this.loadFromUrl(this.profile);
        }
        if (new File(this.profile).exists()) {
            return this.loadFromFile(this.profile);
        }
        throw new Exception("Unable to find named profile (source = " + this.profile + ")");
    }

    private void readDefinitions(ValidationEngine validationEngine, byte[] byArray) throws Exception {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().endsWith(".zip") && !zipEntry.getName().endsWith(".jar")) {
                int n;
                String string = zipEntry.getName();
                ZipInputStream zipInputStream2 = zipInputStream;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[1024];
                while ((n = ((InputStream)zipInputStream2).read(byArray2, 0, 1024)) > -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                validationEngine.getDefinitions().put(string, byteArrayOutputStream.toByteArray());
            }
            zipInputStream.closeEntry();
        }
        zipInputStream.close();
    }

    private byte[] loadDefinitions() throws Exception {
        byte[] byArray;
        if (Utilities.noString(this.definitions)) {
            byArray = this.loadFromUrl(MASTER_SOURCE);
        } else if (this.definitions.startsWith("https:") || this.definitions.startsWith("http:")) {
            byArray = this.loadFromUrl(this.definitions);
        } else if (new File(this.definitions).exists()) {
            byArray = this.loadFromFile(this.definitions);
        } else {
            throw new Exception("Unable to find FHIR validation Pack (source = " + this.definitions + ")");
        }
        return byArray;
    }

    private byte[] loadSource() throws Exception {
        byte[] byArray = new File(this.source).exists() ? this.loadFromFile(this.source) : (this.source.startsWith("https:") || this.source.startsWith("http:") ? this.loadFromUrl(this.source) : this.source.getBytes());
        String string = new String(byArray);
        System.out.println(string);
        return byArray;
    }

    private byte[] loadFromUrl(String string) throws Exception {
        URL uRL = new URL(string);
        byte[] byArray = IOUtils.toByteArray((InputStream)uRL.openStream());
        return byArray;
    }

    private byte[] loadFromFile(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getOutcome() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new XmlComposer().compose((OutputStream)byteArrayOutputStream, (Resource)this.engine.getOutcome(), true);
        return byteArrayOutputStream.toString();
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(String string) {
        this.definitions = string;
    }
}

