/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.utilities.CSVReader;

public class CSVProcessor {
    private InputStream source;
    private DataReader data;
    private OutputStreamWriter out;
    private String start;
    private String loop;
    private int count = 0;
    private String stop;
    private StringBuilder dest;

    public void setSource(InputStream inputStream) {
        this.source = inputStream;
    }

    public void setData(InputStream inputStream) {
        try {
            this.data = new DataReader(inputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.out = new OutputStreamWriter(outputStream);
    }

    public void process() throws Exception {
        this.buildTemplate(this.readSource());
        this.dest = new StringBuilder();
        this.dest.append(this.start);
        this.data.process();
        this.dest.append(this.stop);
        this.out.write(this.dest.toString());
        this.out.close();
    }

    private void buildTemplate(String string) throws Exception {
        int n = string.indexOf("[%loop");
        if (n < 0) {
            throw new Exception("Unable to process template - didn't find [%loop");
        }
        this.start = string.substring(0, n);
        if ((n = (string = string.substring(n + 6)).indexOf("%]")) < 0) {
            throw new Exception("Unable to process template - didn't find %] matching [%loop");
        }
        String string2 = string.substring(0, n);
        if (string2 != null && !string2.equals("")) {
            if (!string2.startsWith(" count=")) {
                throw new Exception("Unable to process template - unrecognised content on [%loop");
            }
            this.count = Integer.parseInt(string2.substring(7));
        }
        if ((n = (string = string.substring(n + 2)).indexOf("[%endloop%]")) < 0) {
            throw new Exception("Unable to process template - didn't find [%endloop%]");
        }
        this.loop = string.substring(0, n);
        this.stop = string.substring(n + 11);
    }

    private String readSource() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = new InputStreamReader(this.source, "UTF-8");
        while (inputStreamReader.ready()) {
            stringBuilder.append((char)inputStreamReader.read());
        }
        inputStreamReader.close();
        return stringBuilder.toString();
    }

    public class DataReader
    extends CSVReader {
        public DataReader(InputStream inputStream) throws UnsupportedEncodingException {
            super(inputStream);
        }

        public void process() throws Exception {
            String[] stringArray = this.parseLine();
            while (this.ready()) {
                String[] stringArray2 = this.parseLine();
                this.processLine(stringArray, stringArray2);
            }
            this.close();
        }

        private void processLine(String[] stringArray, String[] stringArray2) throws Exception {
            CSVProcessor.this.count++;
            String string = CSVProcessor.this.loop;
            while (string.contains("[%")) {
                int n = string.indexOf("[%");
                int n2 = string.indexOf("%]");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 2, n2).trim();
                String string4 = string.substring(n2 + 2);
                if ("count".equals(string3)) {
                    string = string2 + Integer.toString(CSVProcessor.this.count) + string4;
                    continue;
                }
                boolean bl = false;
                for (String string5 : stringArray) {
                    if (!string5.equals(string3)) continue;
                    string = string2 + DataReader.getColumn(stringArray, stringArray2, string3) + string4;
                    bl = true;
                }
                if (bl) continue;
                throw new Exception("unknown column: '" + string3 + "'");
            }
            CSVProcessor.this.dest.append(string);
        }
    }
}

