/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class CSVReader
extends InputStreamReader {
    private int state = 0;
    private char pc;

    public CSVReader(InputStream inputStream) throws UnsupportedEncodingException {
        super(inputStream, "UTF-8");
    }

    protected boolean parseBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1");
    }

    protected static String getColumn(String[] stringArray, String[] stringArray2, String string) throws Exception {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            n = i;
        }
        if (n == -1) {
            return "";
        }
        if (stringArray2.length <= n) {
            return "";
        }
        return stringArray2[n];
    }

    protected String[] parseLine() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (bl || this.peek() != '\r' && this.peek() != '\n') {
            char c = this.peek();
            this.next();
            if (c == '\"') {
                bl = !bl;
                continue;
            }
            if (!bl && c == ',') {
                arrayList.add(stringBuilder.toString().trim());
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString().trim());
        while (this.ready() && (this.peek() == '\r' || this.peek() == '\n')) {
            this.next();
        }
        String[] stringArray = new String[]{};
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private char peek() throws Exception {
        if (this.state == 0) {
            this.next();
        }
        if (this.state == 1) {
            return this.pc;
        }
        throw new Exception("read past end of source");
    }

    private void next() throws Exception {
        if (this.state == 2) {
            throw new Exception("read past end of source");
        }
        this.state = 1;
        int n = this.read();
        if (n == -1) {
            this.state = 2;
        } else {
            this.pc = (char)n;
        }
    }
}

