/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.hl7.fhir.utilities.CSFile;

public final class IniFile {
    private String mstrDateFmt = "yyyy-MM-dd";
    private String mstrTimeStampFmt = "yyyy-MM-dd HH:mm:ss";
    private boolean mblnLoaded = false;
    private String mstrFile;
    private LinkedHashMap<String, INISection> mhmapSections;
    private Properties mpropEnv = this.getEnvVars();

    public IniFile(String string) {
        this.mhmapSections = new LinkedHashMap();
        this.mstrFile = string;
        if (this.checkFile(string)) {
            this.loadFile();
        }
    }

    public String getFileName() {
        return this.mstrFile;
    }

    public String getStringProperty(String string, String string2) {
        String string3 = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            if (iNIProperty != null) {
                string3 = iNIProperty.getPropValue();
                iNIProperty = null;
            }
            iNISection = null;
        }
        return string3;
    }

    public Boolean getBooleanProperty(String string, String string2) {
        boolean bl = false;
        String string3 = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            if (iNIProperty != null) {
                string3 = iNIProperty.getPropValue().toUpperCase();
                if (string3.equals("YES") || string3.equals("TRUE") || string3.equals("1")) {
                    bl = true;
                }
                iNIProperty = null;
            }
            iNISection = null;
        }
        return new Boolean(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIntegerProperty(String string, String string2) {
        Integer n = null;
        String string3 = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            try {
                if (iNIProperty != null && (string3 = iNIProperty.getPropValue()) != null) {
                    n = new Integer(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (iNIProperty != null) {
                    iNIProperty = null;
                }
            }
            iNISection = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLongProperty(String string, String string2) {
        Long l = null;
        String string3 = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            try {
                if (iNIProperty != null && (string3 = iNIProperty.getPropValue()) != null) {
                    l = new Long(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (iNIProperty != null) {
                    iNIProperty = null;
                }
            }
            iNISection = null;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDoubleProperty(String string, String string2) {
        Double d = null;
        String string3 = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            try {
                if (iNIProperty != null && (string3 = iNIProperty.getPropValue()) != null) {
                    d = new Double(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (iNIProperty != null) {
                    iNIProperty = null;
                }
            }
            iNISection = null;
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDateProperty(String string, String string2) {
        Date date = null;
        String string3 = null;
        SimpleDateFormat simpleDateFormat = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            try {
                if (iNIProperty != null) {
                    string3 = iNIProperty.getPropValue();
                }
                if (string3 != null) {
                    simpleDateFormat = new SimpleDateFormat(this.mstrDateFmt);
                    date = simpleDateFormat.parse(string3);
                }
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (iNIProperty != null) {
                    iNIProperty = null;
                }
            }
            iNISection = null;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getTimestampProperty(String string, String string2) {
        Timestamp timestamp = null;
        Date date = null;
        String string3 = null;
        SimpleDateFormat simpleDateFormat = null;
        INIProperty iNIProperty = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNIProperty = iNISection.getProperty(string2);
            try {
                if (iNIProperty != null) {
                    string3 = iNIProperty.getPropValue();
                }
                if (string3 != null) {
                    simpleDateFormat = new SimpleDateFormat(this.mstrDateFmt);
                    date = simpleDateFormat.parse(string3);
                    timestamp = new Timestamp(date.getTime());
                }
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (iNIProperty != null) {
                    iNIProperty = null;
                }
            }
            iNISection = null;
        }
        return timestamp;
    }

    public void addSection(String string, String string2) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setSecComments(this.delRemChars(string2));
        iNISection = null;
    }

    public void setStringProperty(String string, String string2, String string3, String string4) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setProperty(string2, string3, string4);
    }

    public void setBooleanProperty(String string, String string2, boolean bl, String string3) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        if (bl) {
            iNISection.setProperty(string2, "TRUE", string3);
        } else {
            iNISection.setProperty(string2, "FALSE", string3);
        }
    }

    public void setIntegerProperty(String string, String string2, int n, String string3) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setProperty(string2, Integer.toString(n), string3);
    }

    public void setLongProperty(String string, String string2, long l, String string3) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setProperty(string2, Long.toString(l), string3);
    }

    public void setDoubleProperty(String string, String string2, double d, String string3) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setProperty(string2, Double.toString(d), string3);
    }

    public void setDateProperty(String string, String string2, Date date, String string3) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setProperty(string2, this.utilDateToStr(date, this.mstrDateFmt), string3);
    }

    public void setTimestampProperty(String string, String string2, Timestamp timestamp, String string3) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection == null) {
            iNISection = new INISection(string);
            this.mhmapSections.put(string, iNISection);
        }
        iNISection.setProperty(string2, this.timeToStr(timestamp, this.mstrTimeStampFmt), string3);
    }

    public void setDateFormat(String string) throws IllegalArgumentException {
        if (!this.checkDateTimeFormat(string)) {
            throw new IllegalArgumentException("The specified date pattern is invalid!");
        }
        this.mstrDateFmt = string;
    }

    public void setTimeStampFormat(String string) {
        if (!this.checkDateTimeFormat(string)) {
            throw new IllegalArgumentException("The specified timestamp pattern is invalid!");
        }
        this.mstrTimeStampFmt = string;
    }

    public int getTotalSections() {
        return this.mhmapSections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllSectionNames() {
        int n = 0;
        Iterator<String> iterator = null;
        String[] stringArray = null;
        try {
            if (this.mhmapSections.size() > 0) {
                stringArray = new String[this.mhmapSections.size()];
                iterator = this.mhmapSections.keySet().iterator();
                while (true) {
                    stringArray[n] = iterator.next();
                    ++n;
                    iterator.hasNext();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            if (iterator != null) {
                iterator = null;
            }
        }
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            stringArray = iNISection.getPropNames();
            iNISection = null;
        }
        return stringArray;
    }

    public Map<String, INIProperty> getProperties(String string) {
        Map<String, INIProperty> map = null;
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            map = iNISection.getProperties();
            iNISection = null;
        }
        return map;
    }

    public void removeProperty(String string, String string2) {
        INISection iNISection = null;
        iNISection = this.mhmapSections.get(string);
        if (iNISection != null) {
            iNISection.removeProperty(string2);
            iNISection = null;
        }
    }

    public void removeSection(String string) {
        if (this.mhmapSections.containsKey(string)) {
            this.mhmapSections.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean save() {
        boolean bl;
        block20: {
            FileWriter fileWriter;
            INISection iNISection;
            Iterator<String> iterator;
            String string;
            String string2;
            CSFile cSFile;
            block19: {
                bl = false;
                cSFile = null;
                string2 = null;
                string = null;
                iterator = null;
                iNISection = null;
                fileWriter = null;
                if (this.mhmapSections.size() != 0) break block19;
                boolean bl2 = false;
                if (fileWriter != null) {
                    this.closeWriter(fileWriter);
                    fileWriter = null;
                }
                if (cSFile != null) {
                    cSFile = null;
                }
                if (iterator != null) {
                    iterator = null;
                }
                return bl2;
            }
            try {
                cSFile = new CSFile(this.mstrFile);
                if (cSFile.exists()) {
                    cSFile.delete();
                }
                fileWriter = new FileWriter(cSFile);
                iterator = this.mhmapSections.keySet().iterator();
                while (iterator.hasNext()) {
                    string2 = iterator.next();
                    iNISection = this.mhmapSections.get(string2);
                    string = iNISection.toString();
                    fileWriter.write(string);
                    fileWriter.write("\r\n");
                    iNISection = null;
                }
                bl = true;
                if (fileWriter != null) {
                    this.closeWriter(fileWriter);
                    fileWriter = null;
                }
                if (cSFile != null) {
                    cSFile = null;
                }
                if (iterator != null) {
                    iterator = null;
                }
            }
            catch (IOException iOException) {
                if (fileWriter != null) {
                    this.closeWriter(fileWriter);
                    fileWriter = null;
                }
                if (cSFile != null) {
                    cSFile = null;
                }
                if (iterator != null) {
                    iterator = null;
                }
                break block20;
                catch (Throwable throwable) {
                    if (fileWriter != null) {
                        this.closeWriter(fileWriter);
                        fileWriter = null;
                    }
                    if (cSFile != null) {
                        cSFile = null;
                    }
                    if (iterator != null) {
                        iterator = null;
                    }
                    throw throwable;
                }
            }
        }
        return bl;
    }

    private Properties getEnvVars() {
        Process process = null;
        Properties properties = new Properties();
        try {
            String string;
            Runtime runtime = Runtime.getRuntime();
            String string2 = System.getProperty("os.name").toLowerCase();
            process = string2.indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : (string2.indexOf("nt") > -1 || string2.indexOf("windows 2000") > -1 || string2.indexOf("windows xp") > -1 ? runtime.exec("cmd.exe /c set") : runtime.exec("env"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(61);
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + 1);
                properties.setProperty(string3, string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDateTimeFormat(String string) {
        boolean bl = false;
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string);
            bl = true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (simpleDateFormat != null) {
                simpleDateFormat = null;
            }
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private void loadFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeReader(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeWriter(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFile(String string) {
        boolean bl = false;
        CSFile cSFile = null;
        try {
            cSFile = new CSFile(string);
            bl = cSFile.exists() && cSFile.isFile();
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (cSFile != null) {
                cSFile = null;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String utilDateToStr(Date date, String string) {
        String string2 = null;
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string);
            string2 = simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            string2 = null;
        }
        finally {
            if (simpleDateFormat != null) {
                simpleDateFormat = null;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String timeToStr(Timestamp timestamp, String string) {
        String string2 = null;
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(string);
            string2 = simpleDateFormat.format(timestamp);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string2 = "";
        }
        catch (NullPointerException nullPointerException) {
            string2 = "";
        }
        finally {
            if (simpleDateFormat != null) {
                simpleDateFormat = null;
            }
        }
        return string2;
    }

    private String delRemChars(String string) {
        int n = 0;
        if (string == null) {
            return null;
        }
        while ((n = string.indexOf(";")) >= 0) {
            if (n == 0) {
                string = string.substring(n + 1);
                continue;
            }
            if (n <= 0) continue;
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    private String addRemChars(String string) {
        int n = 2;
        int n2 = 0;
        int n3 = 0;
        String string2 = null;
        String string3 = null;
        if (string == null) {
            return null;
        }
        while (n2 >= 0) {
            n = 2;
            n2 = string.indexOf("\r\n", n3);
            if (n2 < 0) {
                n = 1;
                n2 = string.indexOf("\n", n3);
                if (n2 < 0) {
                    n2 = string.indexOf("\r", n3);
                }
            }
            if (n2 == 0) {
                string = ";\r\n" + string.substring(n2 + n);
                n3 = n2 + n + 1;
                continue;
            }
            if (n2 <= 0) continue;
            string2 = string.substring(0, n2);
            string3 = string.substring(n2 + n);
            string = string3 == null ? string2 : (string3.length() == 0 ? string2 : string2 + "\r\n;" + string3);
            n3 = n2 + n + 1;
        }
        if (!string.substring(0, 1).equals(";")) {
            string = ";" + string;
        }
        string = string + "\r\n";
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        IniFile iniFile = null;
        String string = null;
        if (stringArray.length == 0) {
            return;
        }
        string = stringArray[0];
        iniFile = new IniFile(string);
        iniFile.setStringProperty("Folders", "folder1", "G:\\Temp", null);
        iniFile.setStringProperty("Folders", "folder2", "G:\\Temp\\Backup", null);
        iniFile.save();
        iniFile = null;
    }

    private class INIProperty {
        private String mstrName;
        private String mstrValue;
        private String mstrComments;

        public INIProperty(String string, String string2, String string3) {
            this.mstrName = string;
            this.mstrValue = string2;
            this.mstrComments = IniFile.this.delRemChars(string3);
        }

        public String getPropValue() {
            int n = 0;
            int n2 = 0;
            String string = null;
            String string2 = null;
            String string3 = null;
            string3 = this.mstrValue;
            n = string3.indexOf("%");
            if (n >= 0) {
                n2 = string3.indexOf("%", n + 1);
                string2 = string3.substring(n + 1, n2);
                string = IniFile.this.mpropEnv.getProperty(string2);
                if (string != null) {
                    string3 = string3.substring(0, n) + string + string3.substring(n2 + 1);
                }
            }
            return string3;
        }

        public String toString() {
            String string = "";
            if (this.mstrComments != null) {
                string = IniFile.this.addRemChars(this.mstrComments);
            }
            string = string + this.mstrName + " = " + this.mstrValue;
            return string;
        }
    }

    private class INISection {
        private String mstrComment;
        private String mstrName;
        private LinkedHashMap<String, INIProperty> mhmapProps;

        public INISection(String string) {
            this.mstrName = string;
            this.mhmapProps = new LinkedHashMap();
        }

        public INISection(String string, String string2) {
            this.mstrName = string;
            this.mstrComment = IniFile.this.delRemChars(string2);
            this.mhmapProps = new LinkedHashMap();
        }

        public void setSecComments(String string) {
            this.mstrComment = IniFile.this.delRemChars(string);
        }

        public void removeProperty(String string) {
            if (this.mhmapProps.containsKey(string)) {
                this.mhmapProps.remove(string);
            }
        }

        public void setProperty(String string, String string2, String string3) {
            this.mhmapProps.put(string, new INIProperty(string, string2, string3));
        }

        public Map<String, INIProperty> getProperties() {
            return Collections.unmodifiableMap(this.mhmapProps);
        }

        public String[] getPropNames() {
            int n = 0;
            String[] stringArray = null;
            Iterator<String> iterator = null;
            try {
                if (this.mhmapProps.size() > 0) {
                    stringArray = new String[this.mhmapProps.size()];
                    iterator = this.mhmapProps.keySet().iterator();
                    while (iterator.hasNext()) {
                        stringArray[n] = iterator.next();
                        ++n;
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                stringArray = null;
            }
            return stringArray;
        }

        public INIProperty getProperty(String string) {
            INIProperty iNIProperty = null;
            if (this.mhmapProps.containsKey(string)) {
                iNIProperty = this.mhmapProps.get(string);
            }
            return iNIProperty;
        }

        public String toString() {
            Set<String> set = null;
            String string = "";
            Iterator<String> iterator = null;
            INIProperty iNIProperty = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.mstrComment != null) {
                stringBuffer.append(IniFile.this.addRemChars(this.mstrComment));
            }
            stringBuffer.append("[" + this.mstrName + "]\r\n");
            set = this.mhmapProps.keySet();
            if (set != null && (iterator = set.iterator()) != null) {
                while (iterator.hasNext()) {
                    iNIProperty = this.mhmapProps.get(iterator.next());
                    stringBuffer.append(iNIProperty.toString());
                    stringBuffer.append("\r\n");
                    iNIProperty = null;
                }
            }
            string = stringBuffer.toString();
            stringBuffer = null;
            iterator = null;
            set = null;
            return string;
        }
    }
}

