/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.FileNotifier;
import org.hl7.fhir.utilities.Inflector;
import org.hl7.fhir.utilities.MyURIResolver;
import org.hl7.fhir.utilities.ZipURIResolver;

public class Utilities {
    public static String pluralizeMe(String string) {
        Inflector inflector = new Inflector();
        return inflector.pluralize(string);
    }

    public static boolean IsInteger(String string) {
        try {
            int n = Integer.parseInt(string);
            return n != n + 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean IsDecimal(String string) {
        try {
            float f = Float.parseFloat(string);
            return f != f + 1.0f;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String camelCase(String string) {
        return new Inflector().camelCase(string.trim().replace(" ", "_"), false, new char[0]);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        if (string.length() == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static void copyDirectory(String string, String string2, FileNotifier fileNotifier) throws Exception {
        String[] stringArray;
        CSFile cSFile = new CSFile(string);
        if (!cSFile.exists()) {
            throw new Exception("Folder " + string + " not found");
        }
        Utilities.createDirectory(string2);
        for (String string3 : stringArray = cSFile.list()) {
            if (new CSFile(string + File.separator + string3).isDirectory()) {
                if (string3.startsWith(".")) continue;
                Utilities.copyDirectory(string + File.separator + string3, string2 + File.separator + string3, fileNotifier);
                continue;
            }
            if (fileNotifier != null) {
                fileNotifier.copyFile(string + File.separator + string3, string2 + File.separator + string3);
            }
            Utilities.copyFile(new CSFile(string + File.separator + string3), new CSFile(string2 + File.separator + string3));
        }
    }

    public static void copyFile(String string, String string2) throws IOException {
        Utilities.copyFile(new File(string), new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            if (!new CSFile(file2.getParent()).exists()) {
                Utilities.createDirectory(file2.getParent());
            }
            file2.createNewFile();
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public static boolean checkFolder(String string, List<String> list) throws IOException {
        if (!new CSFile(string).exists()) {
            list.add("Unable to find directory " + string);
            return false;
        }
        return true;
    }

    public static boolean checkFile(String string, String string2, String string3, List<String> list) throws IOException {
        if (!new CSFile(string2 + string3).exists()) {
            list.add("Unable to find " + string + " file " + string3 + " in " + string2);
            return false;
        }
        return true;
    }

    public static String asCSV(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : list) {
            if (!bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static String asHtmlBr(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuilder.append("<br/>");
            }
            stringBuilder.append(string);
            stringBuilder.append(string2);
            bl = false;
        }
        return stringBuilder.toString();
    }

    public static void clearDirectory(String string) throws IOException {
        String[] stringArray = new CSFile(string).list();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CSFile cSFile = new CSFile(string + File.separatorChar + string2);
                if (cSFile.isDirectory()) {
                    Utilities.clearDirectory(cSFile.getAbsolutePath());
                }
                cSFile.delete();
            }
        }
    }

    public static void createDirectory(String string) throws IOException {
        new CSFile(string).mkdirs();
    }

    public static String changeFileExt(String string, String string2) {
        if (string.lastIndexOf(46) > -1) {
            return string.substring(0, string.lastIndexOf(46)) + string2;
        }
        return string + string2;
    }

    public static String cleanupTextString(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        return string.trim();
    }

    public static boolean noString(String string) {
        return string == null || string.equals("");
    }

    public static byte[] transform(Map<String, byte[]> map, byte[] byArray, byte[] byArray2) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray2));
        transformerFactory.setURIResolver(new ZipURIResolver(map));
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setURIResolver(new ZipURIResolver(map));
        StreamSource streamSource2 = new StreamSource(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(streamSource2, streamResult);
        return byteArrayOutputStream.toByteArray();
    }

    public static void bytesToFile(byte[] byArray, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public static byte[] saxonTransform(Map<String, byte[]> map, byte[] byArray, byte[] byArray2) throws Exception {
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        StreamSource streamSource = new StreamSource(new ByteArrayInputStream(byArray2));
        transformerFactoryImpl.setURIResolver(new ZipURIResolver(map));
        Transformer transformer = transformerFactoryImpl.newTransformer(streamSource);
        transformer.setURIResolver(new ZipURIResolver(map));
        StreamSource streamSource2 = new StreamSource(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        transformer.transform(streamSource2, streamResult);
        return byteArrayOutputStream.toByteArray();
    }

    public static void saxonTransform(String string, String string2, String string3, String string4) throws Exception {
        TransformerFactoryImpl transformerFactoryImpl = new TransformerFactoryImpl();
        StreamSource streamSource = new StreamSource(new FileInputStream(string3));
        transformerFactoryImpl.setURIResolver((URIResolver)new MyURIResolver(string));
        Transformer transformer = transformerFactoryImpl.newTransformer((Source)streamSource);
        transformer.setURIResolver(new MyURIResolver(string));
        StreamSource streamSource2 = new StreamSource(new FileInputStream(string2));
        StreamResult streamResult = new StreamResult(new FileOutputStream(string4));
        transformer.transform(streamSource2, streamResult);
    }

    public static void transform(String string, String string2, String string3, String string4) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource streamSource = new StreamSource(new FileInputStream(string3));
        transformerFactory.setURIResolver(new MyURIResolver(string));
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setURIResolver(new MyURIResolver(string));
        StreamSource streamSource2 = new StreamSource(new FileInputStream(string2));
        StreamResult streamResult = new StreamResult(new FileOutputStream(string4));
        transformer.transform(streamSource2, streamResult);
    }

    public static String appendSlash(String string) {
        return string.endsWith(File.separator) ? string : string + File.separator;
    }

    public static String fileTitle(String string) {
        String string2 = new File(string).getName();
        return string2.indexOf(".") == -1 ? string2 : string2.substring(0, string2.indexOf("."));
    }

    public static String systemEol() {
        return System.getProperty("line.separator");
    }

    public static String normaliseEolns(String string) {
        return string.replace("\r\n", "\r").replace("\n", "\r").replace("\r", "\r\n");
    }

    public static String unescapeXml(String string) throws Exception {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                StringBuilder stringBuilder2 = new StringBuilder();
                ++i;
                while (string.charAt(i) != ';') {
                    stringBuilder2.append(string.charAt(i));
                    ++i;
                }
                if (stringBuilder2.toString().equals("lt")) {
                    stringBuilder.append("<");
                    continue;
                }
                if (stringBuilder2.toString().equals("gt")) {
                    stringBuilder.append(">");
                    continue;
                }
                if (stringBuilder2.toString().equals("amp")) {
                    stringBuilder.append("&");
                    continue;
                }
                if (stringBuilder2.toString().equals("quot")) {
                    stringBuilder.append("\"");
                    continue;
                }
                if (stringBuilder2.toString().equals("mu")) {
                    stringBuilder.append('\u03bc');
                    continue;
                }
                throw new Exception("unknown XML entity \"" + stringBuilder2.toString() + "\"");
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static boolean isPlural(String string) {
        if ("restricts".equals(string = string.toLowerCase()) || "contains".equals(string) || "data".equals(string) || "specimen".equals(string)) {
            return false;
        }
        Inflector inflector = new Inflector();
        return !inflector.singularize(string).equals(string);
    }

    public static String padLeft(String string, char c, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String path(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String string : stringArray) {
            if (!bl) {
                bl = true;
            } else if (!stringBuilder.toString().endsWith(File.separator)) {
                stringBuilder.append(File.separator);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String nmtokenize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') {
                stringBuilder.append(c);
                continue;
            }
            if (c == ' ') continue;
            stringBuilder.append("." + Integer.toString(c));
        }
        return stringBuilder.toString();
    }

    public static boolean isToken(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = Utilities.isAlphabetic(string.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            bl = bl && (Utilities.isAlphabetic(string.charAt(i)) || Utilities.isDigit(string.charAt(i)) || string.charAt(i) == '_' || string.charAt(i) == '[' || string.charAt(i) == ']');
        }
        return bl;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isAlphabetic(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String getDirectoryForFile(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String appendPeriod(String string) {
        if (Utilities.noString(string)) {
            return string;
        }
        if (string.endsWith(".")) {
            return string;
        }
        return string.trim() + ".";
    }

    public static String removePeriod(String string) {
        if (Utilities.noString(string)) {
            return string;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String stripBOM(String string) {
        return string.replace("\ufeff", "");
    }

    public static String oidTail(String string) {
        if (string == null || !string.contains(".")) {
            return string;
        }
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static String escapeJava(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("'");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String[] splitByCamelCase(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (i > 0 && Character.isUpperCase(string.charAt(i))) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(Character.toLowerCase(string.charAt(i)));
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[0]);
    }

    public static String encodeUri(String string) {
        return string.replace(" ", "%20");
    }

    public static String genMarkdown(String string) {
        string = Utilities.escapeXml(string);
        while (string.contains("[[")) {
            String string2 = string.substring(0, string.indexOf("[["));
            String string3 = string.substring(string.indexOf("[[") + 2, string.indexOf("]]"));
            String string4 = string.substring(string.indexOf("]]") + 2);
            string = string2 + "<a href=\"" + string3 + "\">" + string3 + "</a>" + string4;
        }
        return string;
    }

    public static String normalize(String string) {
        if (Utilities.noString(string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                stringBuilder.append(Character.toLowerCase(c));
                bl = false;
                continue;
            }
            if (bl) continue;
            stringBuilder.append(' ');
            bl = true;
        }
        return stringBuilder.toString().trim();
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        Utilities.copyFile(file, new File(Utilities.path(file2.getAbsolutePath(), file.getName())));
    }

    public static boolean isWhitespace(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            bl = bl && Character.isWhitespace(string.charAt(i));
        }
        return bl;
    }

    public static String URLEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException.getMessage());
        }
    }

    public static boolean existsInList(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String getFileNameForName(String string) {
        return string.toLowerCase();
    }

    public static void deleteTempFiles() throws IOException {
        File file = Utilities.createTempFile("test", "test");
        String string = Utilities.getDirectoryForFile(file.getAbsolutePath());
        String[] stringArray = new File(string).list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith("ohfu-");
            }
        });
        if (stringArray != null) {
            for (String string2 : stringArray) {
                new File(Utilities.path(string, string2)).delete();
            }
        }
    }

    public static File createTempFile(String string, String string2) throws IOException {
        File file = File.createTempFile("ohfu-" + string, string2);
        file.deleteOnExit();
        return file;
    }

    public static boolean isAsciiChar(char c) {
        return c >= ' ' && c <= '~';
    }

    public static String makeUuidUrn() {
        return "urn:uuid:" + UUID.randomUUID().toString().toLowerCase();
    }
}

