/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.xml.XMLWriter;

public class XLSXmlGenerator {
    private XMLWriter source;

    public XLSXmlGenerator(String string, String string2, String string3) throws Exception {
        this.source = new XMLWriter((OutputStream)new FileOutputStream(string), "UTF-8");
        this.start(string2, string3);
    }

    private void start(String string, String string2) throws IOException {
        this.source.setPretty(true);
        this.source.setPrettyHeader(true);
        this.source.setXmlHeader(true);
        this.source.start();
        this.source.processingInstruction("mso-application progid=\"Excel.Sheet\"");
        this.source.setDefaultNamespace("urn:schemas-microsoft-com:office:spreadsheet");
        this.source.namespace("urn:schemas-microsoft-com:office:office", "o");
        this.source.namespace("urn:schemas-microsoft-com:office:excel", "x");
        this.source.namespace("urn:schemas-microsoft-com:office:spreadsheet", "ss");
        this.source.namespace("http://www.w3.org/TR/REC-html40", "html");
        this.source.open("urn:schemas-microsoft-com:office:spreadsheet", "Workbook");
        this.source.open("urn:schemas-microsoft-com:office:office", "DocumentProperties");
        this.source.element("urn:schemas-microsoft-com:office:office", "Author", string);
        this.source.element("urn:schemas-microsoft-com:office:office", "Created", string2);
        this.source.close();
    }

    public void addSimpleSheet(String string, List<List<String>> list) throws IOException {
        this.source.attribute("ss:Name", string);
        this.source.open("Worksheet");
        this.source.open("Table");
        for (List<String> list2 : list) {
            this.source.open("Row");
            for (String string2 : list2) {
                this.source.open("Cell");
                this.source.attribute("ss:Type", "String");
                this.source.element("Data", string2);
                this.source.close("Cell");
            }
            this.source.close("Row");
        }
        this.source.close("Table");
        this.source.close("Worksheet");
    }

    public void finish() throws IOException {
        this.source.close();
        this.source.close();
    }

    public class SimpleSheet
    extends ArrayList<List<String>> {
        public void addRow(String ... stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                arrayList.add(string);
            }
            this.add(arrayList);
        }
    }
}

