/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XLSXmlParser {
    private static final String XLS_NS = "urn:schemas-microsoft-com:office:spreadsheet";
    private Map<String, Sheet> sheets;
    private Document xml;
    private String name;
    private Integer rowIndex;

    public XLSXmlParser(InputStream inputStream, String string) throws Exception {
        this.name = string;
        this.xml = this.parseXml(inputStream);
        this.sheets = new HashMap<String, Sheet>();
        this.readXml();
    }

    private Document parseXml(InputStream inputStream) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            throw new Exception("Error processing " + this.name + ": " + exception.getMessage(), exception);
        }
    }

    private void readXml() throws Exception {
        Element element = this.xml.getDocumentElement();
        this.check(element.getNamespaceURI().equals(XLS_NS), "Spreadsheet namespace incorrect");
        this.check(element.getNodeName().equals("Workbook"), "Spreadsheet element name incorrect");
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals("Worksheet")) continue;
            this.processWorksheet((Element)node);
        }
    }

    private void processWorksheet(Element element) throws Exception {
        Sheet sheet = new Sheet();
        sheet.title = element.getAttributeNS(XLS_NS, "Name");
        this.sheets.put(element.getAttributeNS(XLS_NS, "Name"), sheet);
        NodeList nodeList = element.getElementsByTagNameNS(XLS_NS, "Table");
        this.check(nodeList.getLength() == 1, "multiple table elements");
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagNameNS(XLS_NS, "Row");
        if (nodeList2.getLength() == 0) {
            return;
        }
        this.rowIndex = 1;
        sheet.columns = this.readRow((Element)nodeList2.item(0));
        for (int i = 1; i < nodeList2.getLength(); ++i) {
            Integer n = this.rowIndex;
            Integer n2 = this.rowIndex = Integer.valueOf(this.rowIndex + 1);
            sheet.rows.add(this.readRow((Element)nodeList2.item(i)));
        }
        while (sheet.rows.size() != 0 && this.isEmptyRow(sheet.rows.get(sheet.rows.size() - 1))) {
            sheet.rows.remove(sheet.rows.size() - 1);
        }
    }

    private boolean isEmptyRow(Row row) {
        for (int i = 0; i < row.size(); ++i) {
            if (((String)row.get(i)).trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private Row readRow(Element element) throws Exception {
        Row row = new Row();
        int n = 1;
        NodeList nodeList = element.getElementsByTagNameNS(XLS_NS, "Cell");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.hasAttributeNS(XLS_NS, "Index")) {
                int n2 = Integer.parseInt(element2.getAttributeNS(XLS_NS, "Index"));
                while (n < n2) {
                    row.add("");
                    ++n;
                }
            }
            row.add(this.readData(element2, n, row.size() > 0 ? (String)row.get(0) : "?"));
            ++n;
        }
        return row;
    }

    private String readData(Element element, int n, String string) throws Exception {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XMLUtil.getNamedChildren(element, "Data", arrayList);
        if (arrayList.size() == 0) {
            return "";
        }
        this.check(arrayList.size() == 1, "Multiple Data encountered (" + Integer.toString(arrayList.size()) + " @ col " + Integer.toString(n) + " - " + element.getTextContent() + " (" + string + "))");
        Element element2 = (Element)arrayList.get(0);
        String string2 = element2.getAttributeNS(XLS_NS, "Type");
        if ("Boolean".equals(string2)) {
            if (element2.getTextContent().equals("1")) {
                return "True";
            }
            return "False";
        }
        if ("String".equals(string2)) {
            return element2.getTextContent();
        }
        if ("Number".equals(string2)) {
            return element2.getTextContent();
        }
        if ("DateTime".equals(string2)) {
            return element2.getTextContent();
        }
        if ("Error".equals(string2)) {
            return null;
        }
        throw new Exception("Cell Type is not known (" + element2.getAttributeNodeNS(XLS_NS, "Type") + ") in " + this.getLocation());
    }

    private void check(boolean bl, String string) throws Exception {
        if (!bl) {
            throw new Exception(string + " in " + this.getLocation());
        }
    }

    private String getLocation() {
        return this.name + ", row " + this.rowIndex.toString();
    }

    public Map<String, Sheet> getSheets() {
        return this.sheets;
    }

    public class Sheet {
        public String title;
        public Row columns;
        public List<Row> rows = new ArrayList<Row>();

        public boolean hasColumn(int n, String string) throws Exception {
            String string2 = this.getColumn(n, string);
            return string2 != null && !string2.equals("");
        }

        public String getColumn(int n, String string) throws Exception {
            int n2 = -1;
            String string2 = "";
            for (int i = 0; i < this.columns.size(); ++i) {
                string2 = string2 + "," + (String)this.columns.get(i);
                if (!((String)this.columns.get(i)).equalsIgnoreCase(string)) continue;
                n2 = i;
            }
            if (n2 == -1) {
                return "";
            }
            if (this.rows.get(n).size() <= n2) {
                return "";
            }
            return ((String)this.rows.get(n).get(n2)).trim();
        }

        public List<Row> getRows() {
            return this.rows;
        }
    }

    public class Row
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;
    }
}

