/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.hl7.fhir.utilities.CSFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;

public class ZipGenerator {
    private Set<String> names = new HashSet<String>();
    FileOutputStream dest;
    ZipOutputStream out;
    static final int BUFFER = 2048;

    public ZipGenerator(String string) throws Exception {
        this.dest = new FileOutputStream(string);
        this.out = new ZipOutputStream(new BufferedOutputStream(this.dest));
        this.out.setLevel(9);
    }

    public void close() throws Exception {
        this.out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFromZip(String string) throws IOException {
        byte[] byArray = new byte[1024];
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                int n;
                String string2 = zipEntry.getName();
                this.names.add(string2);
                this.out.putNextEntry(new ZipEntry(string2));
                while ((n = zipInputStream.read(byArray)) > 0) {
                    this.out.write(byArray, 0, n);
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    public void addFolder(String string, String string2, boolean bl) throws Exception {
        String[] stringArray;
        CSFile cSFile = new CSFile(string);
        for (String string3 : stringArray = cSFile.list()) {
            if (new CSFile(Utilities.path(string, string3)).isDirectory()) {
                this.addFolder(Utilities.path(string, string3), Utilities.path(string2, string3), bl);
                continue;
            }
            this.addFileName(Utilities.path(string2, string3), Utilities.path(string, string3), bl);
        }
    }

    public void addFiles(String string, String string2, String string3, String string4) throws Exception {
        byte[] byArray = new byte[2048];
        string2.replace("\\", "/");
        CSFile cSFile = new CSFile(string);
        String[] stringArray = cSFile.list();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (!new CSFile(string + stringArray[i]).isFile() || string3 != null && !stringArray[i].endsWith(string3) || string4 != null && stringArray[i].endsWith(string4)) continue;
            FileInputStream fileInputStream = new FileInputStream(string + stringArray[i]);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(string2 + stringArray[i]);
            this.names.add(string2 + stringArray[i]);
            this.out.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                this.out.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
    }

    public void addFileSource(String string, String string2, boolean bl) throws Exception {
        File file = Utilities.createTempFile("tmp", ".tmp");
        TextFile.stringToFile(string2, file.getAbsolutePath());
        this.addFileName(string, file.getAbsolutePath(), bl);
        file.delete();
    }

    public void addFileName(String string, String string2, boolean bl) throws Exception {
        if (!bl || !this.names.contains(string)) {
            int n;
            byte[] byArray = new byte[2048];
            FileInputStream fileInputStream = new FileInputStream(string2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(string);
            this.names.add(string);
            this.out.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                this.out.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
    }

    public void addBytes(String string, byte[] byArray, boolean bl) throws Exception {
        if (!bl || !this.names.contains(string)) {
            int n;
            byte[] byArray2 = new byte[2048];
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(byteArrayInputStream, 2048);
            ZipEntry zipEntry = new ZipEntry(string);
            this.names.add(string);
            this.out.putNextEntry(zipEntry);
            while ((n = bufferedInputStream.read(byArray2, 0, 2048)) != -1) {
                this.out.write(byArray2, 0, n);
            }
            bufferedInputStream.close();
        }
    }

    public void addMimeTypeFile(String string, String string2) throws Exception {
        CRC32 cRC32 = new CRC32();
        this.out.setLevel(0);
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setExtra(null);
        this.names.add(string);
        String string3 = "application/epub+zip";
        cRC32.update(string3.getBytes());
        zipEntry.setCompressedSize(string3.length());
        zipEntry.setSize(string3.length());
        zipEntry.setCrc(cRC32.getValue());
        zipEntry.setMethod(0);
        this.out.putNextEntry(zipEntry);
        this.out.write(string3.getBytes(), 0, string3.length());
        this.out.setLevel(9);
    }
}

