/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Decimal;

public class Canonical {
    private Decimal value;
    private List<CanonicalUnit> units = new ArrayList<CanonicalUnit>();

    public Canonical(Decimal decimal) {
        this.value = decimal;
    }

    public Decimal getValue() {
        return this.value;
    }

    public List<CanonicalUnit> getUnits() {
        return this.units;
    }

    public void setValue(Decimal decimal) {
        this.value = decimal;
    }

    public void multiplyValue(Decimal decimal) {
        this.value = this.value.multiply(decimal);
    }

    public void multiplyValue(int n) {
        this.value = this.value.multiply(new Decimal(n));
    }

    public void divideValue(Decimal decimal) throws Exception {
        this.value = this.value.divide(decimal);
    }

    public void divideValue(int n) throws Exception {
        this.value = this.value.divide(new Decimal(n));
    }

    public static class CanonicalUnit {
        private BaseUnit base;
        private int exponent;

        protected CanonicalUnit(BaseUnit baseUnit, int n) {
            this.base = baseUnit;
            this.exponent = n;
        }

        public BaseUnit getBase() {
            return this.base;
        }

        public int getExponent() {
            return this.exponent;
        }

        public void setExponent(int n) {
            this.exponent = n;
        }
    }
}

