/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.Collections;
import java.util.Comparator;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Canonical;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.ExpressionParser;
import org.hl7.fhir.utilities.ucum.Factor;
import org.hl7.fhir.utilities.ucum.Operator;
import org.hl7.fhir.utilities.ucum.Symbol;
import org.hl7.fhir.utilities.ucum.Term;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.special.Registry;

public class Converter {
    private UcumModel model;
    private Registry handlers;

    public Converter(UcumModel ucumModel, Registry registry) {
        this.model = ucumModel;
        this.handlers = registry;
    }

    public Canonical convert(Term term) throws Exception {
        return this.normalise("  ", term);
    }

    private Canonical normalise(String string, Term term) throws Exception {
        int n;
        Object object;
        Canonical canonical = new Canonical(new Decimal(1));
        this.debug(string, "canonicalise", term);
        boolean bl = false;
        for (Term term2 = term; term2 != null; term2 = term2.getTerm()) {
            Object object2;
            if (term2.getComp() instanceof Term) {
                object2 = this.normalise(string + "  ", (Term)term2.getComp());
                if (bl) {
                    canonical.divideValue(((Canonical)object2).getValue());
                    for (Canonical.CanonicalUnit canonicalUnit : ((Canonical)object2).getUnits()) {
                        canonicalUnit.setExponent(0 - canonicalUnit.getExponent());
                    }
                } else {
                    canonical.multiplyValue(((Canonical)object2).getValue());
                }
                canonical.getUnits().addAll(((Canonical)object2).getUnits());
            } else if (term2.getComp() instanceof Factor) {
                if (bl) {
                    canonical.divideValue(((Factor)term2.getComp()).getValue());
                } else {
                    canonical.multiplyValue(((Factor)term2.getComp()).getValue());
                }
            } else if (term2.getComp() instanceof Symbol) {
                object2 = (Symbol)term2.getComp();
                object = this.normalise(string, (Symbol)object2);
                if (bl) {
                    canonical.divideValue(((Canonical)object).getValue());
                    for (Canonical.CanonicalUnit canonicalUnit : ((Canonical)object).getUnits()) {
                        canonicalUnit.setExponent(0 - canonicalUnit.getExponent());
                    }
                } else {
                    canonical.multiplyValue(((Canonical)object).getValue());
                }
                canonical.getUnits().addAll(((Canonical)object).getUnits());
            }
            bl = term2.getOp() == Operator.DIVISION;
        }
        this.debug(string, "collate", canonical);
        block3: for (n = canonical.getUnits().size() - 1; n >= 0; --n) {
            object = canonical.getUnits().get(n);
            for (int i = n - 1; i >= 0; --i) {
                Canonical.CanonicalUnit canonicalUnit;
                canonicalUnit = canonical.getUnits().get(i);
                if (canonicalUnit.getBase() != ((Canonical.CanonicalUnit)object).getBase()) continue;
                canonicalUnit.setExponent(((Canonical.CanonicalUnit)object).getExponent() + canonicalUnit.getExponent());
                canonical.getUnits().remove(n);
                continue block3;
            }
        }
        for (n = canonical.getUnits().size() - 1; n >= 0; --n) {
            object = canonical.getUnits().get(n);
            if (((Canonical.CanonicalUnit)object).getExponent() != 0) continue;
            canonical.getUnits().remove(n);
        }
        this.debug(string, "sort", canonical);
        Collections.sort(canonical.getUnits(), new Comparator<Canonical.CanonicalUnit>(){

            @Override
            public int compare(Canonical.CanonicalUnit canonicalUnit, Canonical.CanonicalUnit canonicalUnit2) {
                return canonicalUnit.getBase().getCode().compareTo(canonicalUnit2.getBase().getCode());
            }
        });
        this.debug(string, "done", canonical);
        return canonical;
    }

    private Canonical normalise(String string, Symbol symbol) throws Exception {
        Canonical canonical;
        block11: {
            canonical = new Canonical(new Decimal(1));
            if (symbol.getUnit() instanceof BaseUnit) {
                canonical.getUnits().add(new Canonical.CanonicalUnit((BaseUnit)symbol.getUnit(), symbol.getExponent()));
            } else {
                int n;
                Canonical canonical2 = this.expandDefinedUnit(string, (DefinedUnit)symbol.getUnit());
                for (Canonical.CanonicalUnit canonicalUnit : canonical2.getUnits()) {
                    canonicalUnit.setExponent(canonicalUnit.getExponent() * symbol.getExponent());
                }
                canonical.getUnits().addAll(canonical2.getUnits());
                if (symbol.getExponent() > 0) {
                    for (n = 0; n < symbol.getExponent(); ++n) {
                        canonical.multiplyValue(canonical2.getValue());
                    }
                } else {
                    for (n = 0; n > symbol.getExponent(); --n) {
                        canonical.divideValue(canonical2.getValue());
                    }
                }
            }
            if (symbol.getPrefix() == null) break block11;
            if (symbol.getExponent() > 0) {
                for (int i = 0; i < symbol.getExponent(); ++i) {
                    canonical.multiplyValue(symbol.getPrefix().getValue());
                }
            } else {
                for (int i = 0; i > symbol.getExponent(); --i) {
                    canonical.divideValue(symbol.getPrefix().getValue());
                }
            }
        }
        return canonical;
    }

    private Canonical expandDefinedUnit(String string, DefinedUnit definedUnit) throws Exception {
        String string2 = definedUnit.getValue().getUnit();
        if (definedUnit.isSpecial()) {
            if (!this.handlers.exists(definedUnit.getCode())) {
                throw new Exception("Not handled yet (special unit)");
            }
            string2 = this.handlers.get(definedUnit.getCode()).getUnits();
        }
        Term term = new ExpressionParser(this.model).parse(string2);
        this.debug(string, "now handle", term);
        Canonical canonical = this.normalise(string + "  ", term);
        canonical.multiplyValue(definedUnit.getValue().getValue());
        return canonical;
    }

    private void debug(String string, String string2, Term term) {
    }

    private void debug(String string, String string2, Canonical canonical) {
    }
}

