/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import org.hl7.fhir.utilities.Utilities;

public class Decimal {
    private int precision;
    private boolean scientific;
    private boolean negative;
    private String digits;
    private int decimal;

    private Decimal() {
    }

    public Decimal(String string) throws Exception {
        string = string.toLowerCase();
        if (string.contains("e")) {
            this.setValueScientific(string);
        } else {
            this.setValueDecimal(string);
        }
    }

    public Decimal(String string, int n) throws Exception {
        string = string.toLowerCase();
        if (string.contains("e")) {
            this.setValueScientific(string);
        } else {
            this.setValueDecimal(string);
        }
        this.precision = n;
    }

    public Decimal(int n) {
        try {
            this.setValueDecimal(Integer.toString(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setValueDecimal(String string) throws Exception {
        this.scientific = false;
        int n = -1;
        this.negative = string.startsWith("-");
        if (this.negative) {
            string = string.substring(1);
        }
        while (string.startsWith("0") && string.length() > 1) {
            string = string.substring(1);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '.' && n == -1) {
                n = i;
                continue;
            }
            if (Character.isDigit(string.charAt(i))) continue;
            throw new Exception("'" + string + "' is not a valid decimal");
        }
        if (n == -1) {
            this.precision = string.length();
            this.decimal = string.length();
            this.digits = string;
        } else {
            if (n == string.length() - 1) {
                throw new Exception("'" + string + "' is not a valid decimal");
            }
            this.decimal = n;
            this.precision = this.allZeros(string, 1) ? string.length() - 1 : this.countSignificants(string);
            this.digits = this.delete(string, this.decimal, 1);
            if (this.allZeros(this.digits, 0)) {
                ++this.precision;
            } else {
                while (this.digits.charAt(0) == '0') {
                    this.digits = this.digits.substring(1);
                    --this.decimal;
                }
            }
        }
    }

    private boolean allZeros(String string, int n) {
        boolean bl = true;
        for (int i = n; i < string.length(); ++i) {
            if (string.charAt(i) == '0') continue;
            bl = false;
        }
        return bl;
    }

    private int countSignificants(String string) {
        int n = string.indexOf(".");
        if (n > -1) {
            string = this.delete(string, n, 1);
        }
        while (string.charAt(0) == '0') {
            string = string.substring(1);
        }
        return string.length();
    }

    private String delete(String string, int n, int n2) {
        if (n == 0) {
            return string.substring(n2);
        }
        return string.substring(0, n) + string.substring(n + n2);
    }

    private void setValueScientific(String string) throws Exception {
        int n = string.indexOf("e");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (Utilities.noString(string2) || string2.equals("-") || !Utilities.IsDecimal(string2)) {
            throw new Exception("'" + string + "' is not a valid decimal (numeric)");
        }
        if (Utilities.noString(string3) || string3.equals("-") || !Utilities.IsInteger(string3)) {
            throw new Exception("'" + string + "' is not a valid decimal (exponent)");
        }
        this.setValueDecimal(string2);
        this.scientific = true;
        for (n = string3.charAt(0) == '-' ? 1 : 0; n < string3.length(); ++n) {
            if (Character.isDigit(string3.charAt(n))) continue;
            throw new Exception("" + string + "' is not a valid decimal");
        }
        n = Integer.parseInt(string3);
        this.decimal += n;
    }

    private String stringMultiply(char c, int n) {
        return Utilities.padLeft("", c, n);
    }

    private String insert(String string, String string2, int n) {
        if (n == 0) {
            return string + string2;
        }
        return string2.substring(0, n) + string + string2.substring(n);
    }

    public String toString() {
        return this.asDecimal();
    }

    public Decimal copy() {
        Decimal decimal = new Decimal();
        decimal.precision = this.precision;
        decimal.scientific = this.scientific;
        decimal.negative = this.negative;
        decimal.digits = this.digits;
        decimal.decimal = this.decimal;
        return decimal;
    }

    public static Decimal zero() {
        try {
            return new Decimal("0");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isZero() {
        return this.allZeros(this.digits, 0);
    }

    public static Decimal one() {
        try {
            return new Decimal("1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isOne() {
        Decimal decimal = Decimal.one();
        return this.comparesTo(decimal) == 0;
    }

    public boolean equals(Decimal decimal) {
        return this.comparesTo(decimal) == 0;
    }

    public int comparesTo(Decimal decimal) {
        if (decimal == null) {
            return 0;
        }
        if (this.negative && !decimal.negative) {
            return -1;
        }
        if (!this.negative && decimal.negative) {
            return 1;
        }
        int n = Math.max(this.decimal, decimal.decimal);
        String string = this.stringMultiply('0', n - this.decimal + 1) + this.digits;
        String string2 = this.stringMultiply('0', n - decimal.decimal + 1) + decimal.digits;
        if (string.length() < string2.length()) {
            string = string + this.stringMultiply('0', string2.length() - string.length());
        } else if (string2.length() < string.length()) {
            string2 = string2 + this.stringMultiply('0', string.length() - string2.length());
        }
        int n2 = string.compareTo(string2);
        if (this.negative) {
            n2 = -n2;
        }
        return n2;
    }

    public boolean isWholeNumber() {
        return !this.asDecimal().contains(".");
    }

    public String asDecimal() {
        String string = this.digits;
        if (this.decimal != this.digits.length()) {
            string = this.decimal < 0 ? "0." + this.stringMultiply('0', 0 - this.decimal) + this.digits : (this.decimal < string.length() ? (this.decimal == 0 ? "0." + string : this.insert(".", string, this.decimal)) : string + this.stringMultiply('0', this.decimal - string.length()));
        }
        if (this.negative && !this.allZeros(string, 0)) {
            string = "-" + string;
        }
        return string;
    }

    public int asInteger() throws Exception {
        if (!this.isWholeNumber()) {
            throw new Exception("Unable to represent " + this.toString() + " as an integer");
        }
        if (this.comparesTo(new Decimal(Integer.MIN_VALUE)) < 0) {
            throw new Exception("Unable to represent " + this.toString() + " as a signed 8 byte integer");
        }
        if (this.comparesTo(new Decimal(Integer.MAX_VALUE)) > 0) {
            throw new Exception("Unable to represent " + this.toString() + " as a signed 8 byte integer");
        }
        return Integer.parseInt(this.asDecimal());
    }

    public String asScientific() {
        String string = this.digits;
        boolean bl = this.allZeros(string, 0);
        if (bl) {
            string = this.precision < 2 ? "0e0" : "0." + this.stringMultiply('0', this.precision - 1) + "e0";
        } else {
            if (this.digits.length() > 1) {
                string = this.insert(".", string, 1);
            }
            string = string + 'e' + Integer.toString(this.decimal - 1);
        }
        if (this.negative && !bl) {
            string = '-' + string;
        }
        return string;
    }

    public Decimal trunc() {
        if (this.decimal < 0) {
            return Decimal.zero();
        }
        Decimal decimal = this.copy();
        if (decimal.digits.length() >= decimal.decimal) {
            decimal.digits = decimal.digits.substring(0, decimal.decimal);
        }
        if (Utilities.noString(decimal.digits)) {
            decimal.digits = "0";
            decimal.decimal = 1;
            decimal.negative = false;
        }
        return decimal;
    }

    public Decimal add(Decimal decimal) {
        if (decimal == null) {
            return null;
        }
        if (this.negative == decimal.negative) {
            Decimal decimal2 = this.doAdd(decimal);
            decimal2.negative = this.negative;
            return decimal2;
        }
        if (this.negative) {
            return decimal.doSubtract(this);
        }
        return this.doSubtract(decimal);
    }

    public Decimal subtract(Decimal decimal) {
        Decimal decimal2;
        if (decimal == null) {
            return null;
        }
        if (this.negative && !decimal.negative) {
            decimal2 = this.doAdd(decimal);
            decimal2.negative = true;
        } else if (!this.negative && decimal.negative) {
            decimal2 = this.doAdd(decimal);
        } else if (this.negative && decimal.negative) {
            decimal2 = this.doSubtract(decimal);
            decimal2.negative = !decimal2.negative;
        } else {
            decimal2 = decimal.doSubtract(this);
            decimal2.negative = !decimal2.negative;
        }
        return decimal2;
    }

    private Decimal doAdd(Decimal decimal) {
        int n = Math.max(this.decimal, decimal.decimal);
        String string = this.stringMultiply('0', n - this.decimal + 1) + this.digits;
        String string2 = this.stringMultiply('0', n - decimal.decimal + 1) + decimal.digits;
        if (string.length() < string2.length()) {
            string = string + this.stringMultiply('0', string2.length() - string.length());
        } else if (string2.length() < string.length()) {
            string2 = string2 + this.stringMultiply('0', string.length() - string2.length());
        }
        String string3 = this.stringAddition(string, string2);
        if (string3.charAt(0) == '1') {
            ++n;
        } else {
            string3 = this.delete(string3, 0, 1);
        }
        if (n != string3.length()) {
            if (n < 0) {
                throw new Error("Unhandled");
            }
            if (n < string3.length()) {
                string3 = this.insert(".", string3, n);
            } else {
                throw new Error("Unhandled");
            }
        }
        Decimal decimal2 = new Decimal();
        try {
            decimal2.setValueDecimal(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = decimal2.scientific = this.scientific || decimal.scientific;
        decimal2.precision = this.decimal < decimal.decimal ? this.precision : (decimal.decimal < this.decimal ? decimal.precision : Math.min(this.precision, decimal.precision));
        return decimal2;
    }

    private int dig(char c) {
        return c - 48;
    }

    private char cdig(int n) {
        return (char)(n + 48);
    }

    private Decimal doSubtract(Decimal decimal) {
        String string;
        boolean bl;
        int n = Math.max(this.decimal, decimal.decimal);
        String string2 = this.stringMultiply('0', n - this.decimal + 1) + this.digits;
        String string3 = this.stringMultiply('0', n - decimal.decimal + 1) + decimal.digits;
        if (string2.length() < string3.length()) {
            string2 = string2 + this.stringMultiply('0', string3.length() - string2.length());
        } else if (string3.length() < string2.length()) {
            string3 = string3 + this.stringMultiply('0', string2.length() - string3.length());
        }
        boolean bl2 = bl = string2.compareTo(string3) < 0;
        if (bl) {
            string = string3;
            string3 = string2;
            string2 = string;
        }
        if ((string = this.stringSubtraction(string2, string3)).charAt(0) == '1') {
            ++n;
        } else {
            string = this.delete(string, 0, 1);
        }
        if (n != string.length()) {
            if (n < 0) {
                throw new Error("Unhandled");
            }
            if (n < string.length()) {
                string = this.insert(".", string, n);
            } else {
                throw new Error("Unhandled");
            }
        }
        Decimal decimal2 = new Decimal();
        try {
            decimal2.setValueDecimal(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        decimal2.negative = bl;
        boolean bl3 = decimal2.scientific = this.scientific || decimal.scientific;
        decimal2.precision = this.decimal < decimal.decimal ? this.precision : (decimal.decimal < this.decimal ? decimal.precision : Math.min(this.precision, decimal.precision));
        return decimal2;
    }

    private String stringAddition(String string, String string2) {
        int n;
        assert (string.length() == string2.length());
        char[] cArray = new char[string2.length()];
        for (n = 0; n < string2.length(); ++n) {
            cArray[n] = 48;
        }
        n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            int n2 = n + this.dig(string.charAt(i)) + this.dig(string2.charAt(i));
            cArray[i] = this.cdig(n2 % 10);
            n = n2 / 10;
        }
        assert (n == 0);
        return new String(cArray);
    }

    private String stringSubtraction(String string, String string2) {
        int n;
        assert (string.length() == string2.length());
        char[] cArray = new char[string2.length()];
        for (n = 0; n < string2.length(); ++n) {
            cArray[n] = 48;
        }
        n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            int n2 = n + (this.dig(string.charAt(i)) - this.dig(string2.charAt(i)));
            if (n2 < 0) {
                n2 += 10;
                if (i == 0) {
                    throw new Error("internal logic error");
                }
                string = this.replaceChar(string, i - 1, this.cdig(this.dig(string.charAt(i - 1)) - 1));
            }
            cArray[i] = this.cdig(n2);
        }
        assert (n == 0);
        return new String(cArray);
    }

    private String replaceChar(String string, int n, char c) {
        if (n == 0) {
            return String.valueOf(c) + string.substring(1);
        }
        return string.substring(0, n) + c + string.substring(n + 1);
    }

    public Decimal multiply(Decimal decimal) {
        int n;
        int n2;
        String[] stringArray;
        if (decimal == null) {
            return null;
        }
        if (this.isZero() || decimal.isZero()) {
            return Decimal.zero();
        }
        int n3 = Math.max(this.decimal, decimal.decimal);
        Object object = this.stringMultiply('0', n3 - this.decimal + 1) + this.digits;
        Object object2 = this.stringMultiply('0', n3 - decimal.decimal + 1) + decimal.digits;
        if (((String)object).length() < ((String)object2).length()) {
            object = (String)object + this.stringMultiply('0', ((String)object2).length() - ((String)object).length());
        } else if (((String)object2).length() < ((String)object).length()) {
            object2 = (String)object2 + this.stringMultiply('0', ((String)object).length() - ((String)object2).length());
        }
        if (((String)object2).compareTo((String)object) > 0) {
            stringArray = object;
            object = object2;
            object2 = stringArray;
        }
        stringArray = new String[((String)object2).length()];
        int n4 = 0;
        for (int i = ((String)object2).length() - 1; i >= 0; --i) {
            stringArray[i] = this.stringMultiply('0', ((String)object2).length() - (i + 1));
            n2 = 0;
            for (n = ((String)object).length() - 1; n >= 0; --n) {
                n4 = n2 + this.dig(((String)object).charAt(n)) * this.dig(((String)object2).charAt(i));
                stringArray[i] = this.insert(String.valueOf(this.cdig(n4 % 10)), stringArray[i], 0);
                n2 = n4 / 10;
            }
            while (n2 > 0) {
                stringArray[i] = this.insert(String.valueOf(this.cdig(n4 % 10)), stringArray[i], 0);
                n2 = n4 / 10;
            }
        }
        n4 = 0;
        for (String string : stringArray) {
            n4 = Math.max(n4, string.length());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.stringMultiply('0', n4 - stringArray[i].length()) + stringArray[i];
        }
        String string = "";
        n2 = 0;
        for (n = n4 - 1; n >= 0; --n) {
            for (int i = 0; i < stringArray.length; ++i) {
                n2 += this.dig(stringArray[i].charAt(n));
            }
            string = this.insert(String.valueOf(this.cdig(n2 % 10)), string, 0);
            n2 /= 10;
        }
        if (n2 > 0) {
            throw new Error("internal logic error");
        }
        n = string.length() - (((String)object).length() - (n3 + 1)) * 2;
        while (!Utilities.noString(string) && !string.equals("0") && string.startsWith("0")) {
            string = string.substring(1);
            --n;
        }
        int n5 = 0;
        n5 = this.isWholeNumber() && decimal.isWholeNumber() ? Math.max(Math.max(this.digits.length(), decimal.digits.length()), Math.min(this.precision, decimal.precision)) : (this.isWholeNumber() ? decimal.precision : (decimal.isWholeNumber() ? this.precision : Math.min(this.precision, decimal.precision)));
        while (string.length() > n5 && string.charAt(string.length() - 1) == '0') {
            string = this.delete(string, string.length() - 1, 1);
        }
        Decimal decimal2 = new Decimal();
        try {
            decimal2.setValueDecimal(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        decimal2.precision = n5;
        decimal2.decimal = n;
        decimal2.negative = this.negative != decimal.negative;
        decimal2.scientific = this.scientific || decimal.scientific;
        return decimal2;
    }

    public Decimal divide(Decimal decimal) throws Exception {
        int n;
        int n2;
        int n3;
        String string;
        if (decimal == null) {
            return null;
        }
        if (this.isZero()) {
            return Decimal.zero();
        }
        if (decimal.isZero()) {
            throw new Exception("Attempt to divide " + this.toString() + " by zero");
        }
        String string2 = "0" + decimal.digits;
        int n4 = Math.max(this.digits.length(), decimal.digits.length()) + 40;
        String[] stringArray = new String[10];
        stringArray[0] = this.stringAddition(this.stringMultiply('0', string2.length()), string2);
        for (int i = 1; i < 10; ++i) {
            stringArray[i] = this.stringAddition(stringArray[i - 1], string2);
        }
        String string3 = this.digits;
        String string4 = "";
        int n5 = 0;
        int n6 = this.digits.length() - this.decimal + 1 - (decimal.digits.length() - decimal.decimal + 1);
        while (string3.length() < stringArray[0].length()) {
            string3 = string3 + "0";
            ++n6;
        }
        if (string3.substring(0, decimal.digits.length()).compareTo(decimal.digits) < 0) {
            if (string3.length() == stringArray[0].length()) {
                string3 = string3 + '0';
                ++n6;
            }
            string = string3.substring(0, decimal.digits.length() + 1);
            n3 = string.length();
        } else {
            string = "0" + string3.substring(0, decimal.digits.length());
            n3 = string.length() - 1;
        }
        boolean bl = false;
        while (!bl || n5 <= n4 && (n3 < string3.length() || !Utilities.noString(string) && !this.allZeros(string, 0))) {
            ++n5;
            bl = true;
            boolean bl2 = false;
            for (n2 = 8; n2 >= 0; --n2) {
                if (stringArray[n2].compareTo(string) > 0) continue;
                bl2 = true;
                string4 = string4 + this.cdig(n2 + 1);
                string = this.trimLeadingZeros(this.stringSubtraction(string, stringArray[n2]));
                if (bl && (n5 > n4 || n3 >= string3.length() && (Utilities.noString(string) || this.allZeros(string, 0)))) break;
                if (n3 < string3.length()) {
                    string = string + string3.charAt(n3);
                    ++n3;
                    bl = false;
                } else {
                    string = string + '0';
                    ++n6;
                }
                while (string.length() < stringArray[0].length()) {
                    string = '0' + string;
                }
                break;
            }
            if (bl2) continue;
            assert (string.charAt(0) == '0');
            string = this.delete(string, 0, 1);
            string4 = string4 + "0";
            if (bl && (n5 > n4 || n3 >= string3.length() && (Utilities.noString(string) || this.allZeros(string, 0)))) continue;
            if (n3 < string3.length()) {
                string = string + string3.charAt(n3);
                ++n3;
                bl = false;
            } else {
                string = string + '0';
                ++n6;
            }
            while (string.length() < stringArray[0].length()) {
                string = '0' + string;
            }
        }
        if (this.isWholeNumber() && decimal.isWholeNumber() && n5 < n4) {
            for (n = 0; n < n6; ++n) {
                if (string4.charAt(string4.length() - 1) != '0') continue;
                string4 = this.delete(string4, string4.length() - 1, 1);
                --n6;
            }
            n2 = 100;
        } else {
            n2 = this.isWholeNumber() && decimal.isWholeNumber() ? Math.max(this.digits.length(), decimal.digits.length()) : (this.isWholeNumber() ? Math.max(decimal.precision, string4.length() - n6) : (decimal.isWholeNumber() ? Math.max(this.precision, string4.length() - n6) : Math.max(Math.min(this.precision, decimal.precision), string4.length() - n6)));
            while (string4.length() > n2) {
                n = string4.charAt(string4.length() - 1) > '5' ? 1 : 0;
                string4 = this.delete(string4, string4.length() - 1, 1);
                if (n != 0) {
                    char[] cArray = string4.toCharArray();
                    for (int i = string4.length() - 1; n != 0 && i > 0; --i) {
                        n = cArray[i] == '9' ? 1 : 0;
                        cArray[i] = n != 0 ? 48 : this.cdig(this.dig(cArray[i]) + 1);
                    }
                    if (n != 0) {
                        string4 = '1' + new String(cArray);
                        ++n6;
                    } else {
                        string4 = new String(cArray);
                    }
                }
                --n6;
            }
        }
        Decimal decimal2 = new Decimal();
        decimal2.setValueDecimal(string4);
        decimal2.decimal = string4.length() - n6;
        decimal2.negative = this.negative != decimal.negative;
        decimal2.precision = n2;
        decimal2.scientific = this.scientific || decimal.scientific;
        return decimal2;
    }

    private String trimLeadingZeros(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && string.charAt(n) == '0'; ++n) {
        }
        if (n == string.length()) {
            return "0";
        }
        return string.substring(n);
    }

    public Decimal divInt(Decimal decimal) throws Exception {
        if (decimal == null) {
            return null;
        }
        Decimal decimal2 = this.divide(decimal);
        return decimal2.trunc();
    }

    public Decimal modulo(Decimal decimal) throws Exception {
        if (decimal == null) {
            return null;
        }
        Decimal decimal2 = this.divInt(decimal);
        Decimal decimal3 = decimal2.multiply(decimal);
        return this.subtract(decimal3);
    }

    public boolean equals(Decimal decimal, Decimal decimal2) {
        Decimal decimal3 = this.subtract(decimal).absolute();
        return decimal3.comparesTo(decimal2) <= 0;
    }

    private Decimal absolute() {
        Decimal decimal = this.copy();
        decimal.negative = false;
        return decimal;
    }
}

