/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.Prefix;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.Value;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DefinitionParser {
    public UcumModel parse(String string) throws Exception {
        return this.parse(new FileInputStream(new File(string)));
    }

    public UcumModel parse(InputStream inputStream) throws Exception {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setNamespaceAware(true);
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        xmlPullParser.setInput(inputStream, null);
        int n = xmlPullParser.next();
        if (n != 2) {
            throw new XmlPullParserException("Unable to process XML document");
        }
        if (!xmlPullParser.getName().equals("root")) {
            throw new XmlPullParserException("Unable to process XML document: expected 'root' but found '" + xmlPullParser.getName() + "'");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'Z");
        Date date = simpleDateFormat.parse(xmlPullParser.getAttributeValue(null, "revision-date").substring(7, 32));
        UcumModel ucumModel = new UcumModel(xmlPullParser.getAttributeValue(null, "version"), xmlPullParser.getAttributeValue(null, "revision"), date);
        xmlPullParser.next();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                if (Utilities.isWhitespace(xmlPullParser.getText())) {
                    xmlPullParser.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xmlPullParser.getText());
            }
            if (xmlPullParser.getName().equals("prefix")) {
                ucumModel.getPrefixes().add(this.parsePrefix(xmlPullParser));
                continue;
            }
            if (xmlPullParser.getName().equals("base-unit")) {
                ucumModel.getBaseUnits().add(this.parseBaseUnit(xmlPullParser));
                continue;
            }
            if (xmlPullParser.getName().equals("unit")) {
                ucumModel.getDefinedUnits().add(this.parseUnit(xmlPullParser));
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xmlPullParser.getName());
        }
        return ucumModel;
    }

    private DefinedUnit parseUnit(XmlPullParser xmlPullParser) throws Exception {
        DefinedUnit definedUnit = new DefinedUnit(xmlPullParser.getAttributeValue(null, "Code"), xmlPullParser.getAttributeValue(null, "CODE"));
        definedUnit.setMetric("yes".equals(xmlPullParser.getAttributeValue(null, "isMetric")));
        definedUnit.setSpecial("yes".equals(xmlPullParser.getAttributeValue(null, "isSpecial")));
        definedUnit.setClass_(xmlPullParser.getAttributeValue(null, "class"));
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        while (xmlPullParser.getEventType() == 2 && "name".equals(xmlPullParser.getName())) {
            definedUnit.getNames().add(this.readElement(xmlPullParser, "name", "unit " + definedUnit.getCode(), false));
        }
        if (xmlPullParser.getEventType() == 2 && "printSymbol".equals(xmlPullParser.getName())) {
            definedUnit.setPrintSymbol(this.readElement(xmlPullParser, "printSymbol", "unit " + definedUnit.getCode(), true));
        }
        definedUnit.setProperty(this.readElement(xmlPullParser, "property", "unit " + definedUnit.getCode(), false));
        definedUnit.setValue(this.parseValue(xmlPullParser, "unit " + definedUnit.getCode()));
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        return definedUnit;
    }

    private Value parseValue(XmlPullParser xmlPullParser, String string) throws Exception {
        this.checkAtElement(xmlPullParser, "value", string);
        Decimal decimal = null;
        if (xmlPullParser.getAttributeValue(null, "value") != null) {
            try {
                decimal = xmlPullParser.getAttributeValue(null, "value").contains(".") ? new Decimal(xmlPullParser.getAttributeValue(null, "value"), 24) : new Decimal(xmlPullParser.getAttributeValue(null, "value"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlPullParserException("Error reading " + string + ": " + numberFormatException.getMessage());
            }
        }
        Value value = new Value(xmlPullParser.getAttributeValue(null, "Unit"), xmlPullParser.getAttributeValue(null, "UNIT"), decimal);
        value.setText(this.readElement(xmlPullParser, "value", string, true));
        return value;
    }

    private BaseUnit parseBaseUnit(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        BaseUnit baseUnit = new BaseUnit(xmlPullParser.getAttributeValue(null, "Code"), xmlPullParser.getAttributeValue(null, "CODE"));
        baseUnit.setDim(xmlPullParser.getAttributeValue(null, "dim").charAt(0));
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        baseUnit.getNames().add(this.readElement(xmlPullParser, "name", "base-unit " + baseUnit.getCode(), false));
        baseUnit.setPrintSymbol(this.readElement(xmlPullParser, "printSymbol", "base-unit " + baseUnit.getCode(), false));
        baseUnit.setProperty(this.readElement(xmlPullParser, "property", "base-unit " + baseUnit.getCode(), false));
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        return baseUnit;
    }

    private Prefix parsePrefix(XmlPullParser xmlPullParser) throws Exception {
        Prefix prefix = new Prefix(xmlPullParser.getAttributeValue(null, "Code"), xmlPullParser.getAttributeValue(null, "CODE"));
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        prefix.getNames().add(this.readElement(xmlPullParser, "name", "prefix " + prefix.getCode(), false));
        prefix.setPrintSymbol(this.readElement(xmlPullParser, "printSymbol", "prefix " + prefix.getCode(), false));
        this.checkAtElement(xmlPullParser, "value", "prefix " + prefix.getCode());
        prefix.setValue(new Decimal(xmlPullParser.getAttributeValue(null, "value"), 24));
        this.readElement(xmlPullParser, "value", "prefix " + prefix.getCode(), true);
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        return prefix;
    }

    private String readElement(XmlPullParser xmlPullParser, String string, String string2, boolean bl) throws XmlPullParserException, IOException {
        this.checkAtElement(xmlPullParser, string, string2);
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        String string3 = null;
        if (bl) {
            string3 = this.readText(xmlPullParser);
        } else if (xmlPullParser.getEventType() == 4) {
            string3 = xmlPullParser.getText();
            xmlPullParser.next();
            this.skipWhitespace(xmlPullParser);
        }
        if (xmlPullParser.getEventType() != 3) {
            throw new XmlPullParserException("Unexpected content reading " + string2);
        }
        xmlPullParser.next();
        this.skipWhitespace(xmlPullParser);
        return string3;
    }

    private String readText(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        while (xmlPullParser.getEventType() != 3) {
            if (xmlPullParser.getEventType() == 4) {
                stringBuilder.append(xmlPullParser.getText());
                xmlPullParser.next();
                continue;
            }
            xmlPullParser.next();
            stringBuilder.append(this.readText(xmlPullParser));
            xmlPullParser.next();
            this.skipWhitespace(xmlPullParser);
        }
        return stringBuilder.toString();
    }

    private void skipWhitespace(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        while (xmlPullParser.getEventType() == 4 && Utilities.isWhitespace(xmlPullParser.getText())) {
            xmlPullParser.next();
        }
    }

    private void checkAtElement(XmlPullParser xmlPullParser, String string, String string2) throws XmlPullParserException {
        if (xmlPullParser.getEventType() != 2) {
            throw new XmlPullParserException("Unexpected state looking for " + string + ": at " + Integer.toString(xmlPullParser.getEventType()) + "  reading " + string2);
        }
        if (!xmlPullParser.getName().equals(string)) {
            throw new XmlPullParserException("Unexpected element looking for " + string + ": found " + xmlPullParser.getName() + "  reading " + string2);
        }
    }
}

